#!/bin/sh
#echo "start script $$ 0 time $(date)" > /ram/nat_trace.txt
if [ $# -ne 2 ]
then
	echo "Usage $0 dst-port rmt-ip"
	echo "this will get the src port to send rtp packets back to"
	exit 1
fi

dstPort=$1
srcIP=$2
#how many seconds after an incoming call
TIMEOUT=10
#log port to this file for awk to run against when done
FILE="/ram/tcpdump.${dstPort}.${srcIP}"

KillSubProcess() {
    kill ${CHPROCIDS:-$!}
}

AlarmHandler() {
    KillSubProcess
    exit 1
}

SetTimer() {
    export CHPROCIDS="$2 $TIMERPROC"
    sleep $1 && kill -9 ${CHPROCIDS} > /dev/null 2>&1 &
    TIMERPROC=$!
}

UnsetTimer() {
    nohup kill $TIMERPROC &
}

#main portion
#echo "before script killer $$ 0 time $(date)" >> /ram/nat_trace.txt

#if waiting for the last connection kill them all
if [ -e ${FILE} ]
then
	for process in `ps |grep ${dstPort} | awk '{print $1}'`
	do
		if [ $$ -ne ${process} ] # don't kill our selves
		then
			kill -9 ${process} > /dev/null 2>&1
		fi
	done
fi
touch ${FILE} &

#echo "before tcpdump $$ 0 time $(date)" >> /ram/nat_trace.txt
trap AlarmHandler 14
tcpdump -i eth0 -c 1 -t -n udp dst port ${dstPort} and ip src ${srcIP}  > ${FILE} 2> /dev/null &
tcpdumpPID=$!
SetTimer ${TIMEOUT} ${tcpdumpPID}
wait ${tcpdumpPID}
#echo "after tcpdump $$ 0 time $(date)" >> /ram/nat_trace.txt
if [ -s ${FILE} ]
then
	#DUMP=`cat ${FILE}`
	#port=`printcol "\`printcol \"$DUMP\" \" \" 1\`" "." 5`
	#echo "$port"
	LC_ALL="C" awk '{print $1}' ${FILE} |LC_ALL="C" awk 'BEGIN{FS="."} {print $5}'
#echo "end $$ normal time $(date)" >> /ram/nat_trace.txt
else
    #return back 0 if you can't find anything
	echo "0"
fi
nohup rm -f ${FILE} &
#echo "before unset end $$ 0 time $(date)" >> /ram/nat_trace.txt
UnsetTimer
#echo "after unset end $$ 0 time $(date)" >> /ram/nat_trace.txt
exit 0
