#!/bin/sh
if [ $# -ne 6 ]
then
	echo "Usage $0 (start|stop) CUST_ID(voip license is good) host user ftp_upload_dir password"
	echo "this will caputre a wire shark trace"
	exit 1
fi

#how many seconds after an incoming call
TIMEOUT=180
CMD=$1
CUST_ID=$2
HOST=$3
USER=$4
DIR=$5
PW=$6
#log port to this file for awk to run against when done
FILE="tcpdump.wireshark.${CUST_ID}.pcap"
TDIR="/ram"
if [ ${CMD} = "start" ]
then
	rm -f ${TDIR}/${FILE}
fi

AlarmHandler() {
    KillSubProcess
    exit 1
}

KillSubProcess() {
    kill ${CHPROCIDS:-$!}
}

SetTimer() {
    DEF_TOUT=${1};
    if [ $DEF_TOUT -ne 0 ]
    then
        sleep $DEF_TOUT && kill -9 ${CHPROCIDS} > /dev/null 2>&1 &
        CHPROCIDS="$CHPROCIDS $!"
        TIMERPROC=$$
    fi
}

UnsetTimer() {
    kill $TIMERPROC
}

#main portion

#only run one wireshark at a time
KillOtherProcess () {
	for process in `ps |grep ${CUST_ID} |awk '{print $1}'`
	do
		if [ $$ -ne ${process} ] # don't kill our selves
		then
			kill ${process} > /dev/null 2>&1
		fi
	done
	for process in `ps |grep tcpdump |grep 65535 |awk '{print $1}'`
	do
		if [ $$ -ne ${process} ] # don't kill our selves
		then
			kill ${process} > /dev/null 2>&1
		fi
	done
}
#passed in host user ftp_upload_dir password
UpLoadFile () {
	upload_file.sh $1 $2 $3 ${FILE} ${TDIR} $4
}
KillOtherProcess

if [ "${CMD}" = "start" ]
then
	trap AlarmHandler 14
	ipaddr=`ifconfig eth0 |grep inet |awk '{print $2}' |awk 'BEGIN{FS=":"} {print $2}'`
	tcpdump -i eth0 -s 65535 -c 5000 host ${ipaddr} and udp and ! udp port 8000 and ! udp port 1000 -w ${TDIR}/${FILE} &
	tcpdumpPID=$!
	export CHPROCIDS=${tcpdumpPID}
	SetTimer ${TIMEOUT}
	wait ${tcpdumpPID}
	UnsetTimer
	if [ -e ${TDIR}/${FILE} ]
	then
		echo "upload file"
		UpLoadFile ${HOST} ${USER} ${DIR} ${PW}
		rm -f ${TDIR}/${FILE}
	fi
	exit 0
elif [ "${CMD}" = "stop" ]
then
	KillOtherProcess
	if [ -e ${TDIR}/${FILE} ]
	then
		echo "upload file"
		UpLoadFile ${HOST} ${USER} ${DIR} ${PW}
		rm -f ${TDIR}/${FILE}
	else
		echo "no file either already sent or nothing caputured"
	fi
fi
