#!/bin/sh
#exit codes
NO_FILE=1
NO_ACCESS=2
NO_CONN=3
NO_ROUTE=4
NO_MOUNT=6
NO_ERASE=7
NO_VERIFICATION=8

FAIL_FILE="/tmp/send_dbg_fail.txt"
DONE_FILE="/tmp/send_dbg_done.txt"


#base name for temp files
OUT_FILE=test

#parameter assignments
HOST=$1
USER=$2
PASSWD=$6
LIC_CODE=$7
DIR=$3
FILE=$4
TDIR=$5
rm -f ${FAIL_FILE} ${DONE_FILE}
#passed the exit code        
clean_exit () {                                                   
	if [ "$1" != "0" ]
	then                                                      
		touch ${FAIL_FILE}
		echo "-$1"                                        
	else
		touch ${DONE_FILE}
	fi                                                        
	rm -f ${OUT_FILE}.txt > /dev/null 2>&1                    
	rm -f ${OUT_FILE}1.txt > /dev/null 2>&1                   
	exit $1                                                   
}
check_host () {
	grep "Connection refused" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_CONN}
	fi
	grep "No route to host" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -eq 0 ]
	then
		clean_exit ${NO_ROUTE}
	fi
}
check_file_put () {
	grep "^226" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -ne 0 ]
	then
		clean_exit ${NO_FILE}
	else
		clean_exit 0
	fi
}
check_user () {
	grep "^230" ${OUT_FILE}.txt > /dev/null 2>&1
	if [ $? -ne 0 ]
	then
		clean_exit ${NO_ACCESS}
	fi
}
rm -f ${TDIR}/${FILE}-${LIC_CODE}
ps >> ${TDIR}/${FILE}-${LIC_CODE}
uptime >> ${TDIR}/${FILE}-${LIC_CODE}
top -b -n 1 >> ${TDIR}/${FILE}-${LIC_CODE}
ifconfig >> ${TDIR}/${FILE}-${LIC_CODE}
ebtables -t nat -L >> ${TDIR}/${FILE}-${LIC_CODE}
ebtables -t broute -L >> ${TDIR}/${FILE}-${LIC_CODE}
cat /ram/dsxdb.xml >> ${TDIR}/${FILE}-${LIC_CODE}
/DSX/sipw registry >> ${TDIR}/${FILE}-${LIC_CODE}

cd ${TDIR}
ftp -vn ${HOST} > ${OUT_FILE}.txt 2>&1 <<END_SCRIPT
quote USER ${USER}
quote PASS ${PASSWD}
cd ${DIR}
bin
hash
put ${FILE}-${LIC_CODE}
quit
END_SCRIPT
check_host
check_user
check_file_put
echo "Succesfully sent file to tech services"
