#!/bin/sh
RAMCOPY="/ram/boa.conf"
FLASHCOPY="/etc/boa/boa.conf"
if [ $# -eq 2 ] && [ "$1" -lt 0 ] || [ "$1" -gt 65535 ]
then
	echo "Usage: $0 new_boa_port [0-65535] [voip|novoip]"
	echo "or $0 to get the current port"
	exit 1
fi
if [ $# -eq 2 ]
then
	sed "s/^Port .*$/Port $1/" ${FLASHCOPY} > ${RAMCOPY}
	if [ -s ${RAMCOPY} ]
	then
		cp ${RAMCOPY} ${FLASHCOPY}
		killall boa
		if [ "$2" = "voip" ]
		then
			nice -n -10 boa
		else
			boa
		fi
		exit 0
	fi
	exit 2
elif [ $# -eq 0 ]
then
	grep "^Port" ${FLASHCOPY} |awk '{print $2}'
	exit 0
fi
exit 1
