/*
	Developed by Robert Nyman, http://www.robertnyman.com
	Code/licensing: http://code.google.com/p/getelementsbyclassname/
	getElementsByClassName-1.0.1.js
*/	
//
/*Call examples
	To get all elements in the document with a info-links class.
		getElementsByClassName("info-links");
	To get all div elements within the element named container, with a col class.
		getElementsByClassName("col", "div", document.getElementById("container")); 
	To get all elements within in the document with a click-me and a sure-thang class.
		getElementsByClassName("click-me sure-thang");*/
//
var getElementsByClassName = function (className, tag, elm){
	if (document.getElementsByClassName) {
		getElementsByClassName = function (className, tag, elm) {
			elm = elm || document;
			var elements = elm.getElementsByClassName(className),
				nodeName = (tag)? new RegExp("\\b" + tag + "\\b", "i") : null,
				returnElements = [],
				current;
			for(var i=0, il=elements.length; i<il; i+=1){
				current = elements[i];
				if(!nodeName || nodeName.test(current.nodeName)) {
					returnElements.push(current);
				}
			}
			return returnElements;
		};
	}
	else if (document.evaluate) {
		getElementsByClassName = function (className, tag, elm) {
			tag = tag || "*";
			elm = elm || document;
			var classes = className.split(" "),
				classesToCheck = "",
				xhtmlNamespace = "http://www.w3.org/1999/xhtml",
				namespaceResolver = (document.documentElement.namespaceURI === xhtmlNamespace)? xhtmlNamespace : null,
				returnElements = [],
				elements,
				node;
			for(var j=0, jl=classes.length; j<jl; j+=1){
				classesToCheck += "[contains(concat(' ', @class, ' '), ' " + classes[j] + " ')]";
			}
			try	{
				elements = document.evaluate(".//" + tag + classesToCheck, elm, namespaceResolver, 0, null);
			}
			catch (e) {
				elements = document.evaluate(".//" + tag + classesToCheck, elm, null, 0, null);
			}
			while ((node = elements.iterateNext())) {
				returnElements.push(node);
			}
			return returnElements;
		};
	}
	else {
		getElementsByClassName = function (className, tag, elm) {
			tag = tag || "*";
			elm = elm || document;
			var classes = className.split(" "),
				classesToCheck = [],
				elements = (tag === "*" && elm.all)? elm.all : elm.getElementsByTagName(tag),
				current,
				returnElements = [],
				match;
			for(var k=0, kl=classes.length; k<kl; k+=1){
				classesToCheck.push(new RegExp("(^|\\s)" + classes[k] + "(\\s|$)"));
			}
			for(var l=0, ll=elements.length; l<ll; l+=1){
				current = elements[l];
				match = false;
				for(var m=0, ml=classesToCheck.length; m<ml; m+=1){
					match = classesToCheck[m].test(current.className);
					if (!match) {
						break;
					}
				}
				if (match) {
					returnElements.push(current);
				}
			}
			return returnElements;
		};
	}
	return getElementsByClassName(className, tag, elm);
};
//
//Shows and hides the popup without removing it from the page. It is called by popupHandler.
function MM_showHideLayers() { //v9.0
  var i,p,v,obj,args=MM_showHideLayers.arguments;
  for (i=0; i<(args.length-2); i+=3) 
  with (document) if (getElementById && ((obj=getElementById(args[i]))!=null)) { v=args[i+2];
    if (obj.style) { obj=obj.style; v=(v=='show')?'visible':(v=='hide')?'hidden':v; }
    obj.visibility=v; }
};
//Formats the phone number display as the user enters data and after the page loads
function formatPhoneNumber()
{ 
  var num=document.getElementById('testnum').value;
  var numParent=document.getElementById('testnum');
  var phoneNumberDb=document.getElementById('miniDb1');
  var phoneNumber2Db=document.getElementById('miniDb2');
  
  if(num.length == 7)
   {
	 var nxx=num.substring(0,3);
	 var dest=num.substring(3);
	phoneNumberDb.setAttribute("value", nxx + " " + dest);
	var numConvertedDb=document.getElementById('miniDb1').value;
	phoneNumber2Db.setAttribute("value", numConvertedDb);
	numParent.setAttribute("value",numConvertedDb);
	
  }
   else if(num.length == 10)
   {
	 var npa=num.substring(0,3);
	 var nxx=num.substring(3,6);
	 var dest=num.substring(6);
	phoneNumberDb.setAttribute("value", "(" + npa + ") " + nxx + " " + dest);
  }
  else if(num.length == 11)
   {
	 var accCode=num.substring(0,1);  
	 var npa=num.substring(1,4);
	 var nxx=num.substring(4,7);
	 var dest=num.substring(7);
	phoneNumberDb.setAttribute("value", accCode + " " + "(" + npa + ") " + nxx + " " + dest);
  }
  else{
	  var allDigits=num.substring(0);
	 phoneNumberDb.setAttribute("value", allDigits);
	  }
  //{alert('Not 10');}
};