#!/bin/sh
#if this is the first time return 0 unless it isn't main_extension then return 1
#if we are under the time out return 0
#else return 1 to indicate we have timed out
#passed ext to check and number of seconds for the timeout and the passed in time
CheckTimeout () {
    if [ ! -e /ram/$1.time ]
    then
        #first time through
        date +%s > /ram/$1.time
        now=`cat /ram/$1.time`
        return 0
    else
        last=`cat /ram/$1.time`
        date +%s > /ram/$1.time
        now=`cat /ram/$1.time`
        delta=$((${now}-${last}))
        if [ ${delta} -lt ${2} ]
        then
            return 0
        else
            rm /ram/$1.time
            return 1
        fi
    fi
}
PrintCGIHeader () {
echo "Content-type: text/html"
    echo
}
PrintRealLogin () {
    cat index.html
}
PrintInvalidLogin () {
    cat login_error.html
}
#move the above down below to turn off book marking
if [ "${QUERY_STRING}" != "" ] && [ "${HTTP_REFERER}" != "" ]
then
    #there was a submission or a navigation click
    #these are in each page
    PrintCGIHeader
    ext=`getvalue ext "${QUERY_STRING}"`
    if [ "${ext}" = "" ]
    then
        PrintInvalidLogin
        exit
    fi
    page=`getvalue navPage "${QUERY_STRING}"`
    adminExt=`getvalue adminExt "${QUERY_STRING}"`
    if [ "${page}" = "" ]                                                              
    then                   
        page=`getvalue pageName_ "${QUERY_STRING}"`
    elif [ "${page}" = "index.html" ]
    then
        #logout was clicked
        if [ "${adminExt}" != "" ]
        then
            rm -f /ram/${adminExt}.*
        else
            rm -f /ram/${ext}.*
        fi
        PrintRealLogin
        exit
    fi
    if [ "${adminExt}" != "" ]
    then
        pinExt=${adminExt}
        navAction=`getvalue arrowAction "${QUERY_STRING}"`
    else
        pinExt=${ext}
    fi

    #remove the time stamp if present if we are logging in for the first time
    if [ "${page}" = "welcome.html" ] && [ "${adminExt}" = "" ]
    then
        rm -f /ram/${pinExt}.time
    fi
    CheckTimeout ${pinExt} 900
    if [ $? -ne 0 ]
    then
        cat timeout_error.html
        exit
    fi
    #first time log in
    #else if a regular page get the saved pin
    #else we are logging in with a pin make sure to use the new one
    if [ "${page}" = "welcome.html" ] && [ "${adminExt}" = "" ]
    then
        webPin=`getvalue pin "${QUERY_STRING}"`
        if [ "${webPin}" != "" ]
        then
            webPin=`echo "${webPin}" |sed 's/%23/#/g'`
        fi
        pin=${webPin}
        echo "${pin}" > /ram/${pinExt}.pin
    else 
        pin=`cat /ram/${pinExt}.pin`
    fi

    if [ "${navAction}" != "" ]
    then
        ext=`/sbin/officeadmin "${pinExt}" "${pin}" 5 2102 ${navAction} ${ext}`
    fi
    Login=`/sbin/officeadmin "${pinExt}" "${pin}" 5 2102 login ${ext}`
    if [ "${Login}" = "pin failed" ] || [ "${Login}" = "admin ext failed" ]
    then
        lookingAtExt=`getvalue realExtension "${QUERY_STRING}"`
        if [ "${lookingAtExt}" != "" ]
        then
            Login=`/sbin/officeadmin "${pinExt}" "${pin}" 5 2102 login ${lookingAtExt}`
        fi
        if [ "${Login}" = "pin failed" ]
        then
            rm -f /ram/${pinExt}.*
            PrintInvalidLogin
            exit
        fi
        ext=${lookingAtExt}
    fi
        
    sysPin=`printcol "${Login}" "=" 1`
    accessLevel=`printcol "${Login}" "=" 2`
    if [ ${accessLevel} -ge 4 ] && [ "${adminExt}" = "" ]
    then
        adminExt=${ext}
    fi
    if [ ${accessLevel} -lt 3 ]
    then
        cat login_error.html
        exit
    fi

    #these are only for submissions
    submission=`getvalue actionType "${QUERY_STRING}"`
    
    #these are in selected pages repopulate with user data or from system
    if [ "${pin}" = "${sysPin}" ]
    then
        allPages=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "1=2101=0=&2=2101=0=" 0 ${adminExt}`
        cirType=`getitem "${allPages}" 1=2101`
        extName=`getitem "${allPages}" 2=2101`
        allPages=`/sbin/officeadmin "${pinExt}" "${pin}" 5 2102 get "1=4101=0=&4=4200=0=&1=9999=0=&1=1406=0=&2=1406=0=&1=2141=0=&1=2311=0=" 0 ${adminExt}`
        if [ "${adminExt}" != "" ]
        then
            adminPages=`/sbin/officeadmin "${adminExt}" "${pin}" 5 2102 get "2=2101=0=" 0 ${adminExt}`
            adminName=`getitem "${adminPages}" 2=2101`
            vmailType=`getitem "${allPages}" 1=4101`
            vmailHWVer=`getitem "${allPages}" 4=4200`
        else
            mboxType=`getitem "${allPages}" 1=2141`
            grpMBoxType=`getitem "${allPages}" 1=2311`
            if [ "${mboxType}" -eq 0 ] 
            then
                vmailType=0
                vmailHWVer=0
            elif [ "${mboxType}" -eq 2 ] && [ "${grpMBoxType}" -eq 2 ]
            then
                vmailType=0
                vmailHWVer=0
            else
                vmailType=`getitem "${allPages}" 1=4101`
                vmailHWVer=`getitem "${allPages}" 4=4200`
            fi
        fi
        if [ "${page}" = "forward.html" ]
        then
            offPremis=`getitem "${allPages}" 1=1406`
            callFwrd=`getitem "${allPages}" 2=1406`
        else
            offPremis=" "
            callFwrd=" "
        fi
        lastTrunk=`getitem "${allPages}" 1=9999`
        name=${extName}
        #page specifics down below
        if [ "${page}" = "welcome.html" ]
        then
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "name|text|${name}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "extension_name.html" ]
        then
            #for each field get the pcProgNum
            pcProgNum1="2=2101"
            pcProgNum2="5=2102"
            pcProgNum3="4=2102"
            pcProgNum4="3=2101"

            pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=" "" ${adminExt}`
            pcAdminResp=`charreplace "${pcAdminResp}" " " "%"` # transform any strings that might have spaces

            #for each field get the value
            oldPin=`getitem ${pcAdminResp} 5=2102`
            name=`getitemsvalue name_2_2101 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1}` 
            newPin=`getitemsvalue pin_5_2102 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2}` 
            staLang=`getitemsvalue staLang_3_2101 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4}` 
            oldAccess=`getitem ${pcAdminResp} 4=2102`
            newAccess=`getitemsvalue programLevel_4_2102 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3}` 
            name=`charreplace "${name}" "%" " "` #undo the space trick
            name=`printenctext "${name}"`
            newPin=`printenctext "${newPin}"`

            if [ "${submission}" = "yes" ]
            then
                if [ "${name}" = "\"\"" ]
                then
                    updatedName=""
                else
                    updatedName="${name}"
                fi
                case "${newAccess}" in
                    0) newAccess=1;;
                    1) newAccess=3;;
                    2)
                        if [ "${oldAccess}" -eq 4 ]
                        then
                            newAccess=4
                        else
                            newAccess=5
                        fi
                        ;;
                esac
                nameCount=`strlen "${updatedName}"`
                if [ "${newPin}" = "\"\"" ]
                then
                    newPinLen=0
                    newPin=""
                else
                    newPinLen=4
                fi
                ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "2=1311=${nameCount}=${updatedName}&5=2102=${newPinLen}=${newPin}&4=2102=1=${newAccess}&3=2101=1=${staLang}" "" ${adminExt}`
                if [ "${oldPin}" != "${newPin}" ] && [ "${adminExt}" = "${ext}" ]
                then
                    PrintRealLogin
                    exit
                fi
                if [ "${oldPin}" != "${newPin}" ] && [ "${adminExt}" = "" ]
                then
                    PrintRealLogin
                    exit
                fi
            fi
            case "${newAccess}" in
                1) newAccess=0;;
                2) newAccess=0;;
                3) newAccess=1;;
                4) newAccess=2;;
                5) newAccess=2;;
            esac

            #for each field substitute all the data in the web page
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "name|text|${name}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999" "pin|text|${newPin}|5_2102" "programLevel|DropDown|${newAccess}|4_2102" "staLang|DropDown|${staLang}|3_2101"
        elif [ "${page}" = "notify_email.html" ]
        then
            #for each field get the pcProgNum
            pcProgNum1="1=2146"
            pcProgNum2="4=2146"
            pcProgNum3="3=2146"
            pcProgNum4="2=2146"
            #echo "pcProgNum1=${pcProgNum1} pcProgNum2=${pcProgNum2} pcProgNum3=${pcProgNum3} pcProgNum4=${pcProgNum4} " >&2

            #for each field get all the data values from the system
            pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=" "" ${adminExt}`
            #echo "pcAdminResp=${pcAdminResp}" >&2

            #for each field get the value
            EmailEnable=`getitemsvalue EmailEnable_1_2146 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1}`
            EmailAttach=`getitemsvalue EmailAttach_3_2146 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3}`
            EmailFormat=`getitemsvalue EmailFormat_4_2146 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2}`
            EmailAddress=`getitemsvalue EmailAddress_2_2146 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4}`
            #echo "EmailEnable=${EmailEnable} EmailAttach=${EmailAttach} EmailFormat=${EmailFormat} EmailAddress=${EmailAddress} " >&2

            #if we are doing a submission then set all the data (we should be able to just figure out what changed though
            if [ "${submission}" = "yes" ]
            then
                   addrLen=`strlen "${EmailAddress}"`
                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=1=${EmailEnable}&${pcProgNum3}=1=${EmailAttach}&${pcProgNum2}=1=${EmailFormat}&${pcProgNum4}=${addrLen}=${EmailAddress}" "" ${adminExt}`
            fi

            #for each field substitute all the data in the web page
            #echo "sub ${page} $$ ${ext} ${pin} \"${adminExt}\" \"EmailEnable|RadioBox|${EmailEnable}|1_2146\" \"EmailAttach|RadioBox|${EmailAttach}|4_2146\" \"EmailFormat|RadioBox|${EmailFormat}|3_2146\" \"EmailAddress|text|${EmailAddress}|2_2146\" \"name|text|${extName}|2_2101\" \"cirType|hidden|${cirType}|1_2101\" \"vmailType|hidden|${vmailType}|1_4101\" \"vmailHWVer|hidden|${vmailHWVer}|4_4200\" \"useraccesslevel|hidden|${accessLevel}|5_2102\" \"offPremis|hidden|${offPremis}|1_1406\" \"callFwrd|hidden|${callFwrd}|2_1406\"" >&2
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "EmailEnable|RadioBox|${EmailEnable}|1_2146" "EmailAttach|RadioBox|${EmailAttach}|3_2146" "EmailFormat|RadioBox|${EmailFormat}|4_2146" "EmailAddress|text|${EmailAddress}|2_2146" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "forward.html" ]
        then
            #for each field get the pcProgNum
            pcProgNum1="1=2118"

            #for each field get all the data values from the system
            pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=" "" ${adminExt}`
#echo "pcAdminResp=${pcAdminResp}" > /ram/web.log

            #for each field get the value
            callForward=`getitem ${pcAdminResp} 1=2118`
            cfovrType=`printcol ${callForward} "|" 1`
            cfovrMode=`printcol ${callForward} "|" 2`
            cfonpDest=`printcol ${callForward} "|" 3`
            #this should move to the DSX app
            if [ "${cfonpDest}" = "65535" ]
            then
                cfonpDest="\"\""
            fi
            cfoffpMethod=`printcol ${callForward} "|" 4`
            cfoffpAccessType=`printcol ${callForward} "|" 5`
            cfoffpNumber=`printcol ${callForward} "|" 6`
            cfoffpLines=`printcol ${callForward} "|" 7`
            cfoffpBin=`printcol ${callForward} "|" 8`
            cfEnable=`printcol ${callForward} "|" 9`
#echo "callForward=${callForward} cfovrType=${cfovrType} cfovrMode=${cfovrMode} cfonpDest=${cfonpDest} cfoffpMethod=${cfoffpMethod} cfoffpAccessType=${cfoffpAccessType} cfoffpNumber=${cfoffpNumber} cfoffpLines=${cfoffpLines} cfoffpBin=${cfoffpBin} cfEnable=${cfEnable}" >> /ram/web.log
 
            #if we are doing a submission then set all the data (we should be able to just figure out what changed though
            if [ "${submission}" = "yes" ]
            then
                cfovrType=`getitemsvalue cfovrType_1_2118 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 1`
                cfovrMode=`getitemsvalue cfovrMode_1_2118 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 2`
                cfonpDest=`getitemsvalue cfonpDest_1_2118 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 3`
                cfoffpMethod=`getitemsvalue cfoffpMethod_1_2118 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 4`
                cfoffpAccessType=`getitemsvalue cfoffpAccessType_1_2118 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 5`
                cfoffpNumber=`getitemsvalue cfoffpNumber_1_2118 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 6`
                cfoffpLines=`getitemsvalue cfoffpLines_1_2118 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 7`
                cfoffpBin=`getitemsvalue cfoffpBin_1_2118 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 8`
                cfEnable=`getitemsvalue cfEnable_1_2118 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 9`
                data="${cfovrType}|${cfovrMode}|${cfonpDest}|${cfoffpMethod}|${cfoffpAccessType}|${cfoffpNumber}|${cfoffpLines}|${cfoffpBin}|${cfEnable}"
                dataLen=`strlen "${data}"`
                setStr="${pcProgNum1}=${dataLen}=${data}"
#echo "\`/sbin/officeadmin ${ext} ${pin} 5 2102 set \"${setStr}\" \"\" ${adminExt}\`" >> /ram/web.log
                ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${setStr}" "" ${adminExt}`
#echo "ret=${ret}" >> /ram/web.log
                 pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=" "" ${adminExt}`

                 #for each field get the value
                 callForward=`getitem ${pcAdminResp} 1=2118`
                 cfovrType=`printcol ${callForward} "|" 1`
                 cfovrMode=`printcol ${callForward} "|" 2`
                 cfonpDest=`printcol ${callForward} "|" 3`
                 #this should move to the DSX app
                 if [ "${cfonpDest}" = "65535" ]
                 then
                     cfonpDest="\"\""
                 fi
                 cfoffpMethod=`printcol ${callForward} "|" 4`
                 cfoffpAccessType=`printcol ${callForward} "|" 5`
                 cfoffpNumber=`printcol ${callForward} "|" 6`
                 cfoffpLines=`printcol ${callForward} "|" 7`
                 cfoffpBin=`printcol ${callForward} "|" 8`
                 cfEnable=`printcol ${callForward} "|" 9`
            fi

            #for each field substitute all the data in the web page
#echo "sub ${page} $$ ${ext} ${pin} \"${adminExt}\" \"cfovrType|RadioBox|${cfovrType}|1_2118\" \"cfovrMode|DropDown|${cfovrMode}|1_2118\" \"cfonpDest|text|${cfonpDest}|1_2118\" \"cfoffpMethod|RadioBox|${cfoffpMethod}|1_2118\" \"cfoffpAccessType|RadioBox|${cfoffpAccessType}|1_2118\" \"cfoffpLines|DropDown|${cfoffpLines}|1_2118\" \"cfoffpNumber|text|${cfoffpNumber}|1_2118\" \"cfoffpBin|DropDown|${cfoffpBin}|1_2118\" \"cfEnable|RadioBox|${cfEnable}|1_2118\" \"name|text|${extName}|2_2101\" \"cirType|hidden|${cirType}|1_2101\" \"vmailType|hidden|${vmailType}|1_4101\" \"vmailHWVer|hidden|${vmailHWVer}|4_4200\" \"useraccesslevel|hidden|${accessLevel}|5_2102\" \"offPremis|hidden|${offPremis}|1_1406\" \"callFwrd|hidden|${callFwrd}|2_1406\"" >> /ram/web.log
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "cfovrType|RadioBox|${cfovrType}|1_2118" "cfovrMode|DropDown|${cfovrMode}|1_2118" "cfonpDest|text|${cfonpDest}|1_2118" "cfoffpMethod|RadioBox|${cfoffpMethod}|1_2118" "cfoffpAccessType|RadioBox|${cfoffpAccessType}|1_2118" "cfoffpLines|DropDown|${cfoffpLines}|1_2118" "cfoffpNumber|text|${cfoffpNumber}|1_2118" "cfoffpBin|DropDown|${cfoffpBin}|1_2118" "cfEnable|RadioBox|${cfEnable}|1_2118" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "headset_and_dialing_options.html" ]
        then
            #for each field get the pcProgNum
            pcProgNum1="2=2112"
            pcProgNum2="4=2112"
            pcProgNum3="11=2111"
            pcProgNum4="10=2111"
            #echo "pcProgNum1=${pcProgNum1} pcProgNum2=${pcProgNum2} pcProgNum3=${pcProgNum3} pcProgNum4=${pcProgNum4} " >&2

            #for each field get all the data values from the system
            pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=" "" ${adminExt}`
            #echo "pcAdminResp=${pcAdminResp}" >&2

            #for each field get the value
            ooHdstMd=`getitemsvalue ooHdstMd_2_2112 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1}`
            ooHdstVa=`getitemsvalue ooHdstVa_4_2112 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2}`
            ooHotDp=`getitemsvalue ooHotDp_11_2111 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3}`
            ooAutoTmr=`getitemsvalue ooAutoTmr_10_2111 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4}`
            #echo "ooHdstMd=${ooHdstMd} ooHdstVa=${ooHdstVa} ooHotDp=${ooHotDp} ooAutoTmr=${ooAutoTmr} " >&2

            #if we are doing a submission then set all the data (we should be able to just figure out what changed though
            if [ "${submission}" = "yes" ]
            then
                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=1=${ooHdstMd}&${pcProgNum2}=1=${ooHdstVa}&${pcProgNum3}=1=${ooHotDp}&${pcProgNum4}=1=${ooAutoTmr}" "" ${adminExt}`
            fi

            #for each field substitute all the data in the web page
            #echo "sub ${page} $$ ${ext} ${pin} \"${adminExt}\" \"ooHdstMd|DropDown|${ooHdstMd}|2_2112\" \"ooHdstVa|DropDown|${ooHdstVa}|4_2112\" \"ooHotDp|RadioBox|${ooHotDp}|11_2111\" \"ooAutoTmr|DropDown|${ooAutoTmr}|10_2111\" \"name|text|${extName}|2_2101\" \"cirType|hidden|${cirType}|1_2101\" \"vmailType|hidden|${vmailType}|1_4101\" \"vmailHWVer|hidden|${vmailHWVer}|4_4200\" \"useraccesslevel|hidden|${accessLevel}|5_2102\" \"offPremis|hidden|${offPremis}|1_1406\" \"callFwrd|hidden|${callFwrd}|2_1406\"" >&2
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "ooHdstMd|DropDown|${ooHdstMd}|2_2112" "ooHdstVa|DropDown|${ooHdstVa}|4_2112" "ooHotDp|DropDown|${ooHotDp}|11_2111" "ooAutoTmr|DropDown|${ooAutoTmr}|10_2111" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "speaker_options.html" ]
        then
            #for each field get the pcProgNum
            pcProgNum1="1=2112"
            pcProgNum2="3=2112"
            pcProgNum3="5=2112"
            pcProgNum4="6=2112"
            pcProgNum5="7=2112"
            #echo "pcProgNum1=${pcProgNum1} pcProgNum2=${pcProgNum2} pcProgNum3=${pcProgNum3} pcProgNum4=${pcProgNum4} pcProgNum5=${pcProgNum5} " >&2

            #for each field get all the data values from the system
            pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=&${pcProgNum5}=0=" "" ${adminExt}`
            #echo "pcAdminResp=${pcAdminResp}" >&2

            #for each field get the value
            spAutoHan=`getitemsvalue spAutoHan_1_2112 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1}`
            spVoiceAnn=`getitemsvalue spVoiceAnn_3_2112 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2}`
            spHandRep=`getitemsvalue spHandRep_5_2112 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3}`
            spPageAnn=`getitemsvalue spPageAnn_6_2112 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4}`
            spFdCtl=`getitemsvalue spFdCtl_7_2112 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5}`
            #echo "spAutoHan=${spAutoHan} spVoiceAnn=${spVoiceAnn} spHandRep=${spHandRep} spPageAnn=${spPageAnn} spFdCtl=${spFdCtl} " >&2

            #if we are doing a submission then set all the data (we should be able to just figure out what changed though
            if [ "${submission}" = "yes" ]
            then
                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=1=${spAutoHan}&${pcProgNum2}=1=${spVoiceAnn}&${pcProgNum3}=1=${spHandRep}&${pcProgNum4}=1=${spPageAnn}&${pcProgNum5}=1=${spFdCtl}" "" ${adminExt}`
            fi

            #for each field substitute all the data in the web page
            #echo "sub ${page} $$ ${ext} ${pin} \"${adminExt}\" \"spAutoHan|DropDown|${spAutoHan}|1_2112\" \"spVoiceAnn|DropDown|${spVoiceAnn}|3_2112\" \"spHandRep|DropDown|${spHandRep}|5_2112\" \"spPageAnn|DropDown|${spPageAnn}|6_2112\" \"spFdCtl|DropDown|${spFdCtl}|7_2112\" \"name|text|${extName}|2_2101\" \"cirType|hidden|${cirType}|1_2101\" \"vmailType|hidden|${vmailType}|1_4101\" \"vmailHWVer|hidden|${vmailHWVer}|4_4200\" \"useraccesslevel|hidden|${accessLevel}|5_2102\" \"offPremis|hidden|${offPremis}|1_1406\" \"callFwrd|hidden|${callFwrd}|2_1406\"" >&2
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "spAutoHan|DropDown|${spAutoHan}|1_2112" "spVoiceAnn|DropDown|${spVoiceAnn}|3_2112" "spHandRep|DropDown|${spHandRep}|5_2112" "spPageAnn|DropDown|${spPageAnn}|6_2112" "spFdCtl|DropDown|${spFdCtl}|7_2112" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "when_you_are_busy.html" ]
        then
            #for each field get the pcProgNum
            pcProgNum1="3=2116"
            pcProgNum2="1=2116"
            pcProgNum3="2=2116"
            #echo "pcProgNum1=${pcProgNum1} pcProgNum2=${pcProgNum2} pcProgNum3=${pcProgNum3} " >&2

            #for each field get all the data values from the system
            pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=" "" ${adminExt}`
            #echo "pcAdminResp=${pcAdminResp}" >&2

            #for each field get the value
            ohCoLine=`getitemsvalue ohCoLine_3_2116 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1}`
            ohIcm=`getitemsvalue ohIcm_1_2116 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2}`
            ohHotline=`getitemsvalue ohHotline_2_2116 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3}`
            #echo "ohCoLine=${ohCoLine} ohIcm=${ohIcm} ohHotline=${ohHotline} " >&2

            #if we are doing a submission then set all the data (we should be able to just figure out what changed though
            if [ "${submission}" = "yes" ]
            then
                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=1=${ohCoLine}&${pcProgNum2}=1=${ohIcm}&${pcProgNum3}=1=${ohHotline}" "" ${adminExt}`
            fi

            #for each field substitute all the data in the web page
            #echo "sub ${page} $$ ${ext} ${pin} \"${adminExt}\" \"ohCoLine|DropDown|${ohCoLine}|3_2116\" \"ohIcm|DropDown|${ohIcm}|1_2116\" \"ohHotline|DropDown|${ohHotline}|1_2116\" \"name|text|${extName}|2_2101\" \"cirType|hidden|${cirType}|1_2101\" \"vmailType|hidden|${vmailType}|1_4101\" \"vmailHWVer|hidden|${vmailHWVer}|4_4200\" \"useraccesslevel|hidden|${accessLevel}|5_2102\" \"offPremis|hidden|${offPremis}|1_1406\" \"callFwrd|hidden|${callFwrd}|2_1406\"" >&2
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "ohCoLine|DropDown|${ohCoLine}|3_2116" "ohIcm|DropDown|${ohIcm}|1_2116" "ohHotline|DropDown|${ohHotline}|2_2116" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "notify_find_me.html" ]
        then
           #for each field get the pcProgNum
           pcProgNum1="1=2147"
           pcProgNum2="2=2147"
           pcProgNum3="3=2147"
           pcProgNum4="4=2147"
           #echo "pcProgNum1=${pcProgNum1} pcProgNum2=${pcProgNum2} pcProgNum3=${pcProgNum3} pcProgNum4=${pcProgNum4}" >&2

           #for each field get all the data values from the system
           pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=" "" ${adminExt}`
           #echo "pcAdminResp=${pcAdminResp}" >&2

           #take the pcAdminResp and expand it into variables
           #on structures get the entire item into a string format item1|item2|item[n-1]
           FMFM1=`getitem ${pcAdminResp} 1=2147`
           FMFM2=`getitem ${pcAdminResp} 2=2147`
           FMFM3=`getitem ${pcAdminResp} 3=2147`

           #on structures expand it out into inblockDividual variables
           fmfm1Enb=`printcol ${FMFM1} "|" 1`
           fmfm1StartTime=`printcol ${FMFM1} "|" 2`
           fmfm1EndTime=`printcol ${FMFM1} "|" 3`
           fmfm1Num=`printcol ${FMFM1} "|" 4`
           fmfm2Enb=`printcol ${FMFM2} "|" 1`
           fmfm2StartTime=`printcol ${FMFM2} "|" 2`
           fmfm2EndTime=`printcol ${FMFM2} "|" 3`
           fmfm2Num=`printcol ${FMFM2} "|" 4`
           fmfm3Enb=`printcol ${FMFM3} "|" 1`
           fmfm3StartTime=`printcol ${FMFM3} "|" 2`
           fmfm3EndTime=`printcol ${FMFM3} "|" 3`
           fmfm3Num=`printcol ${FMFM3} "|" 4`

           allNotify=`getitem ${pcAdminResp} 4=2147`

           #if we are doing a submission then set all the data (we should be able to just figure out what changed though
           if [ "${submission}" = "yes" ]
           then
                   #varName=                varInWeb_field_prgNum
                   #varName is your choosing varInWeb is the name from the web page followed by the field and program number
                   fmfm1Enb=`getitemsvalue FindMe1Enable_1_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 1`
                   fmfm2Enb=`getitemsvalue FindMe2Enable_2_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 1`
                   fmfm3Enb=`getitemsvalue FindMe3Enable_3_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 1`
                   fmfm1StartTime=`getitemsvalue FindMe1Start_1_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 2`
                   fmfm2StartTime=`getitemsvalue FindMe2Start_2_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 2`
                   fmfm3StartTime=`getitemsvalue FindMe3Start_3_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 2`
                   fmfm1EndTime=`getitemsvalue FindMe1End_1_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 3`
                   fmfm2EndTime=`getitemsvalue FindMe2End_2_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 3`
                   fmfm3EndTime=`getitemsvalue FindMe3End_3_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 3`
                   fmfm1Num=`getitemsvalue FindMe1Number_1_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 4`
                   fmfm2Num=`getitemsvalue FindMe2Number_2_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 4`
                   fmfm3Num=`getitemsvalue FindMe3Number_3_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 4`

                   allNotify=`getitemsvalue FindMeFollowMeEnable_4_2147 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4}`
                   #structures have the form pcProgNum1=var1Name1|var1Name2|var1Name3&pcProgNum2=var2Name1|var2Name2|var3Name2...
                   #up to and including the set is the same followed by ${pcProgNum1}=${varName1}|${varName2}|${varName[n-1]}&rest
                   fmfm1Data="${fmfm1Enb}|${fmfm1StartTime}|${fmfm1EndTime}|${fmfm1Num}"
                   fmfm2Data="${fmfm2Enb}|${fmfm2StartTime}|${fmfm2EndTime}|${fmfm2Num}"
                   fmfm3Data="${fmfm3Enb}|${fmfm3StartTime}|${fmfm3EndTime}|${fmfm3Num}"
                   fmfm1DataLen=`strlen "${fmfm1Data}"`
                   fmfm2DataLen=`strlen "${fmfm2Data}"`
                   fmfm3DataLen=`strlen "${fmfm3Data}"`
                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=${fmfm1DataLen}=${fmfm1Data}&${pcProgNum2}=${fmfm2DataLen}=${fmfm2Data}&${pcProgNum3}=${fmfm3DataLen}=${fmfm3Data}&${pcProgNum4}=1=${allNotify}" "" ${adminExt}`
           fi

           #for each field substitute all the data in the web page
           #the strings are always varInWeb|UI|varName|field_pgnum
           /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "FindMeFollowMeEnable|RadioBox|${allNotify}|4_2147" "FindMe1Enable|DropDown|${fmfm1Enb}|1_2147" "FindMe1Start|DropDown|${fmfm1StartTime}|1_2147" "FindMe1End|DropDown|${fmfm1EndTime}|1_2147" "FindMe1Number|text|${fmfm1Num}|1_2147" "FindMe2Enable|DropDown|${fmfm2Enb}|2_2147" "FindMe2Start|DropDown|${fmfm2StartTime}|2_2147" "FindMe2End|DropDown|${fmfm2EndTime}|2_2147" "FindMe2Number|text|${fmfm2Num}|2_2147" "FindMe3Enable|DropDown|${fmfm3Enb}|3_2147" "FindMe3Start|DropDown|${fmfm3StartTime}|3_2147" "FindMe3End|DropDown|${fmfm3EndTime}|3_2147" "FindMe3Number|text|${fmfm3Num}|3_2147" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "keys_telephone.html" ]
        then
           #for each field get the pcProgNum
           if [ "${submission}" = "yes" ]
           then
               pcAdminResp=`/bin/break_out_query_string "${page}" "${ext}" "${pin}" "${adminExt}" "${QUERY_STRING}"`
           fi
           pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "1=2121=0=" "" "${adminExt}"`
           /bin/break_out_pcresp "${page}" $$ "${ext}" "${pin}" "${adminExt}" "${extName}" "${cirType}" "${vmailType}" "${vmailHWVer}" "${accessLevel}" "${offPremis}" "${callFwrd}" "${adminName}" "${lastTrunk}" "${pcAdminResp}"
        elif [ "${page}" = "notify_message.html" ]
        then
           #for each field get the pcProgNum
           pcProgNum1="1=2145"
           pcProgNum2="2=2145"
           pcProgNum3="3=2145"
           pcProgNum4="4=2145"
           pcProgNum5="5=2145"
           pcProgNum6="6=2145"
           #echo "pcProgNum1=${pcProgNum1} pcProgNum2=${pcProgNum2} pcProgNum3=${pcProgNum3} pcProgNum4=${pcProgNum4} pcProgNum5=${pcProgNum5} pcProgNum6=${pcProgNum6}" >&2

           #for each field get all the data values from the system
           pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=&${pcProgNum5}=0=&${pcProgNum6}=0=" "" ${adminExt}`
           #echo "pcAdminResp=${pcAdminResp}" >&2

           #take the pcAdminResp and expand it into variables
           #on structures get the entire item into a string format item1|item2|item[n-1]
           i=0
           for value in `charreplace ${pcAdminResp} "=|&" " "`
           do
               eval arr$i=\"$value\"
               i=$(($i+1))
           done

           allNotify=`getitem ${pcAdminResp} 6=2145`

           #if we are doing a submission then set all the data (we should be able to just figure out what changed though
           if [ "${submission}" = "yes" ]
           then
                   #varName=                varInWeb_field_prgNum
                   #varName is your choosing varInWeb is the name from the web page followed by the field and program number
                   arr4=`getitemsvalue N1Enable_1_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 1`
                   arr16=`getitemsvalue N2Enable_2_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 1`
                   arr28=`getitemsvalue N3Enable_3_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 1`
                   arr40=`getitemsvalue N4Enable_4_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4} 1`
                   arr52=`getitemsvalue N5Enable_5_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5} 1`
                   arr5=`getitemsvalue N1Type_1_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 2`
                   arr17=`getitemsvalue N2Type_2_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 2`
                   arr29=`getitemsvalue N3Type_3_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 2`
                   arr41=`getitemsvalue N4Type_4_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4} 2`
                   arr53=`getitemsvalue N5Type_5_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5} 2`
                   arr6=`getitemsvalue N1Start_1_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 3`
                   arr18=`getitemsvalue N2Start_2_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 3`
                   arr30=`getitemsvalue N3Start_3_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 3`
                   arr42=`getitemsvalue N4Start_4_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4} 3`
                   arr54=`getitemsvalue N5Start_5_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5} 3`
                   arr7=`getitemsvalue N1End_1_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 4`
                   arr19=`getitemsvalue N2End_2_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 4`
                   arr31=`getitemsvalue N3End_3_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 4`
                   arr43=`getitemsvalue N4End_4_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4} 4`
                   arr55=`getitemsvalue N5End_5_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5} 4`
                   arr8=`getitemsvalue N1Number_1_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 5`
                   arr20=`getitemsvalue N2Number_2_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 5`
                   arr32=`getitemsvalue N3Number_3_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 5`
                   arr44=`getitemsvalue N4Number_4_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4} 5`
                   arr56=`getitemsvalue N5Number_5_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5} 5`
                   arr9=`getitemsvalue N1Busy_1_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 6`
                   arr21=`getitemsvalue N2Busy_2_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 6`
                   arr33=`getitemsvalue N3Busy_3_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 6`
                   arr45=`getitemsvalue N4Busy_4_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4} 6`
                   arr57=`getitemsvalue N5Busy_5_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5} 6`
                   arr10=`getitemsvalue N1Rna_1_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 7`
                   arr22=`getitemsvalue N2Rna_2_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 7`
                   arr34=`getitemsvalue N3Rna_3_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 7`
                   arr46=`getitemsvalue N4Rna_4_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4} 7`
                   arr58=`getitemsvalue N5Rna_5_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5} 7`
                   arr11=`getitemsvalue N1Security_1_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1} 8`
                   arr23=`getitemsvalue N2Security_2_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2} 8`
                   arr35=`getitemsvalue N3Security_3_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3} 8`
                   arr47=`getitemsvalue N4Security_4_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4} 8`
                   arr59=`getitemsvalue N5Security_5_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5} 8`

                   allNotify=`getitemsvalue MessageNotifyEnable_6_2145 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum6}`
                   #structures have the form pcProgNum1=var1Name1|var1Name2|var1Name3&pcProgNum2=var2Name1|var2Name2|var3Name2...
                   #up to and including the set is the same followed by ${pcProgNum1}=${varName1}|${varName2}|${varName[n-1]}&rest
                   data1="${arr4}|${arr5}|${arr6}|${arr7}|${arr8}|${arr9}|${arr10}|${arr11}"
                   data2="${arr16}|${arr17}|${arr18}|${arr19}|${arr20}|${arr21}|${arr22}|${arr23}"
                   data3="${arr28}|${arr29}|${arr30}|${arr31}|${arr32}|${arr33}|${arr34}|${arr35}"
                   data4="${arr40}|${arr41}|${arr42}|${arr43}|${arr44}|${arr45}|${arr46}|${arr47}"
                   data5="${arr52}|${arr53}|${arr54}|${arr55}|${arr56}|${arr57}|${arr58}|${arr59}"
                   data1Len=`strlen "${data1}"`
                   data2Len=`strlen "${data2}"`
                   data3Len=`strlen "${data3}"`
                   data4Len=`strlen "${data4}"`
                   data5Len=`strlen "${data5}"`

                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=${data1Len}=${data1}&${pcProgNum2}=${data2Len}=${data2}&${pcProgNum3}=${data3Len}=${data3}&${pcProgNum4}=${data4Len}=${data4}&${pcProgNum5}=${data5Len}=${data5}&${pcProgNum6}=1=${allNotify}" "" ${adminExt}`
           fi

           #for each field substitute all the data in the web page
           #the strings are always varInWeb|UI|varName|field_pgnum
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "MessageNotifyEnable|RadioBox|${allNotify}|6_2145" "N1Enable|DropDown|${arr4}|1_2145" "N1Type|DropDown|${arr5}|1_2145" "N1Start|DropDown|${arr6}|1_2145" "N1End|DropDown|${arr7}|1_2145" "N1Number|text|${arr8}|1_2145" "N1Busy|text|${arr9}|1_2145" "N1Rna|text|${arr10}|1_2145" "N1Security|DropDown|${arr11}|1_2145" "N2Enable|DropDown|${arr16}|2_2145" "N2Type|DropDown|${arr17}|2_2145" "N2Start|DropDown|${arr18}|2_2145" "N2End|DropDown|${arr19}|2_2145" "N2Number|text|${arr20}|2_2145" "N2Busy|text|${arr21}|2_2145" "N2Rna|text|${arr22}|2_2145" "N2Security|DropDown|${arr23}|2_2145" "N3Enable|DropDown|${arr28}|3_2145" "N3Type|DropDown|${arr29}|3_2145" "N3Start|DropDown|${arr30}|3_2145" "N3End|DropDown|${arr31}|3_2145" "N3Number|text|${arr32}|3_2145" "N3Busy|text|${arr33}|3_2145" "N3Rna|text|${arr34}|3_2145" "N3Security|DropDown|${arr35}|3_2145" "N4Enable|DropDown|${arr40}|4_2145" "N4Type|DropDown|${arr41}|4_2145" "N4Start|DropDown|${arr42}|4_2145" "N4End|DropDown|${arr43}|4_2145" "N4Number|text|${arr44}|4_2145" "N4Busy|text|${arr45}|4_2145" "N4Rna|text|${arr46}|4_2145" "N4Security|DropDown|${arr47}|4_2145" "N5Enable|DropDown|${arr52}|5_2145" "N5Type|DropDown|${arr53}|5_2145" "N5Start|DropDown|${arr54}|5_2145" "N5End|DropDown|${arr55}|5_2145" "N5Number|text|${arr56}|5_2145" "N5Busy|text|${arr57}|5_2145" "N5Rna|text|${arr58}|5_2145" "N5Security|DropDown|${arr59}|5_2145" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "spdialsys.html" ]
        then
            perRange=`getvalue sysbin__ ${QUERY_STRING}`
            sysSRange=`getvalue sysSRange__ ${QUERY_STRING}`
            if [ "${perRange}" -lt 1 ]
            then
                perRange=1
            fi
            if [ "${sysSRange}" != "" ]
            then
                #there was a submission keep the current enties we are on when we display again
                perRange=${sysSRange}
            fi
            if [ "${perRange}" = "" ]
            then
                #first time load make the entry 1
                perRange=1
            fi
            endRange=$((${perRange}+9))
            if [ "${endRange}" -gt 999 ]
            then
                perRange=991
            fi
            #start range is for pcprogramming numbers perRange is for renumbering elements
            blockMod=$((${perRange}%20))
            blockDiv=$((${perRange}/20))
            pmod=$((${perRange}%10))
            pdiv=$((${perRange}/10))
            even=$((${pdiv}%2))
            if [ "${blockMod}" -gt 10 ]
            then
                startRange=11
            elif [ "${blockMod}" -eq 0 ] && [ "${even}" -eq 0 ]
            then
                #handle 20 40 and the likes
                startRange=11
            else
                startRange=1
            fi
            if [ "${blockMod}" -eq 0 ] && [ "${blockDiv}" -ne 0 ]
            then
                block=$((${blockDiv}-1))
            else
                block=${blockDiv}
            fi
            if [ "${pmod}" -eq 0 ] && [ "${pdiv}" -ne 0 ]
            then
                newpdiv=$((${pdiv}-1))
                perRange=$((${newpdiv}*10+1))
            else
                perRange=$((${pdiv}*10+1))
            fi
            endPerRange=$((${startRange}+9))
            pcProgNumber=1
            for i in `seq ${startRange} ${endPerRange}`
            do
                eval pcProgNum${pcProgNumber}=\"$i=1702\"
                pcProgNumber=$((${pcProgNumber}+1)) 
            done

           #for each field get all the data values from the system
                pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=&${pcProgNum5}=0=&${pcProgNum6}=0=&${pcProgNum7}=0=&${pcProgNum8}=0=&${pcProgNum9}=0=&${pcProgNum10}=0=" ${block} ${adminExt}`
#echo "pcAdminResp=${pcAdminResp}" > /ram/web.log
#echo "startRange=${startRange} endPerRange=${endPerRange} perRange=${perRange}" >> /ram/web.log
#echo "pcAdminResp=\`/sbin/officeadmin ${ext} ${pin} 5 2102 get \"${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=&${pcProgNum5}=0=&${pcProgNum6}=0=&${pcProgNum7}=0=&${pcProgNum8}=0=&${pcProgNum9}=0=&${pcProgNum10}=0=\" \"${block}\" ${adminExt}\`" >> /ram/web.log

           #take the pcAdminResp and expand it into variables
           #on structures get the entire item into a string format item1|item2|item[n-1]
           i=0
           IFS='	'
           for value in `charreplace "${pcAdminResp}" "=|&" "	"`
           do
               case $i in
                7) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                16) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                25) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                34) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                43) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                52) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                61) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                70) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                79) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                88) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                *)
                    eval arr$i=\"$value\"
#echo "arr$i=$value" >> /ram/web.log
                    ;;
                esac
               i=$(($i+1))
           done
           IFS=' '

           #if we are doing a submission then set all the data (we should be able to just figure out what changed though
           if [ "${submission}" = "yes" ]
           then
                   #varName=                varInWeb_field_prgNum
                   #varName is your choosing varInWeb is the name from the web page followed by the field and program number
                   arr4=`getitemsvalue s1Ty_1_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1} 1`
                   arr5=`getitemsvalue s1Li_1_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1} 2`
                   arr6=`getitemsvalue s1Nu_1_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1} 3`
                   arr7=`getitemsvalue s1Na_1_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1} 4`
                   arr8=`getitemsvalue s1Gr_1_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1} 5`
                   arr13=`getitemsvalue s2Ty_2_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2} 1`
                   arr14=`getitemsvalue s2Li_2_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2} 2`
                   arr15=`getitemsvalue s2Nu_2_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2} 3`
                   arr16=`getitemsvalue s2Na_2_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2} 4`
                   arr17=`getitemsvalue s2Gr_2_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2} 5`
                   arr22=`getitemsvalue s3Ty_3_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3} 1`
                   arr23=`getitemsvalue s3Li_3_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3} 2`
                   arr24=`getitemsvalue s3Nu_3_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3} 3`
                   arr25=`getitemsvalue s3Na_3_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3} 4`
                   arr26=`getitemsvalue s3Gr_3_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3} 5`
                   arr31=`getitemsvalue s4Ty_4_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4} 1`
                   arr32=`getitemsvalue s4Li_4_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4} 2`
                   arr33=`getitemsvalue s4Nu_4_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4} 3`
                   arr34=`getitemsvalue s4Na_4_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4} 4`
                   arr35=`getitemsvalue s4Gr_4_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4} 5`
                   arr40=`getitemsvalue s5Ty_5_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum5} 1`
                   arr41=`getitemsvalue s5Li_5_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum5} 2`
                   arr42=`getitemsvalue s5Nu_5_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum5} 3`
                   arr43=`getitemsvalue s5Na_5_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum5} 4`
                   arr44=`getitemsvalue s5Gr_5_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum5} 5`
                   arr49=`getitemsvalue s6Ty_6_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum6} 1`
                   arr50=`getitemsvalue s6Li_6_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum6} 2`
                   arr51=`getitemsvalue s6Nu_6_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum6} 3`
                   arr52=`getitemsvalue s6Na_6_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum6} 4`
                   arr53=`getitemsvalue s6Gr_6_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum6} 5`
                   arr58=`getitemsvalue s7Ty_7_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum7} 1`
                   arr59=`getitemsvalue s7Li_7_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum7} 2`
                   arr60=`getitemsvalue s7Nu_7_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum7} 3`
                   arr61=`getitemsvalue s7Na_7_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum7} 4`
                   arr62=`getitemsvalue s7Gr_7_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum7} 5`
                   arr67=`getitemsvalue s8Ty_8_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum8} 1`
                   arr68=`getitemsvalue s8Li_8_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum8} 2`
                   arr69=`getitemsvalue s8Nu_8_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum8} 3`
                   arr70=`getitemsvalue s8Na_8_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum8} 4`
                   arr71=`getitemsvalue s8Gr_8_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum8} 5`
                   arr76=`getitemsvalue s9Ty_9_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum9} 1`
                   arr77=`getitemsvalue s9Li_9_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum9} 2`
                   arr78=`getitemsvalue s9Nu_9_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum9} 3`
                   arr79=`getitemsvalue s9Na_9_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum9} 4`
                   arr80=`getitemsvalue s9Gr_9_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum9} 5`
                   arr85=`getitemsvalue s10Ty_10_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum10} 1`
                   arr86=`getitemsvalue s10Li_10_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum10} 2`
                   arr87=`getitemsvalue s10Nu_10_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum10} 3`
                   arr88=`getitemsvalue s10Na_10_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum10} 4`
                   arr89=`getitemsvalue s10Gr_10_1702 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum10} 5`
                   data1="${arr4}|${arr5}|${arr6}|${arr7}|${arr8}"
                   dataLen1=`strlen "${data1}"`
                   data2="${arr13}|${arr14}|${arr15}|${arr16}|${arr17}"
                   dataLen2=`strlen "${data2}"`
                   data3="${arr22}|${arr23}|${arr24}|${arr25}|${arr26}"
                   dataLen3=`strlen "${data3}"`
                   data4="${arr31}|${arr32}|${arr33}|${arr34}|${arr35}"
                   dataLen4=`strlen "${data4}"`
                   data5="${arr40}|${arr41}|${arr42}|${arr43}|${arr44}"
                   dataLen5=`strlen "${data5}"`
                   data6="${arr49}|${arr50}|${arr51}|${arr52}|${arr53}"
                   dataLen6=`strlen "${data6}"`
                   data7="${arr58}|${arr59}|${arr60}|${arr61}|${arr62}"
                   dataLen7=`strlen "${data7}"`
                   data8="${arr67}|${arr68}|${arr69}|${arr70}|${arr71}"
                   dataLen8=`strlen "${data8}"`
                   data9="${arr76}|${arr77}|${arr78}|${arr79}|${arr80}"
                   dataLen9=`strlen "${data9}"`
                   data10="${arr85}|${arr86}|${arr87}|${arr88}|${arr89}"
                   dataLen10=`strlen "${data10}"`

                   #structures have the form pcProgNum1=var1Name1|var1Name2|var1Name3&pcProgNum2=var2Name1|var2Name2|var3Name2...
                   #up to and including the set is the same followed by ${pcProgNum1}=${varName1}|${varName2}|${varName[n-1]}&rest
                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=${dataLen1}=${data1}&${pcProgNum2}=${dataLen2}=${data2}&${pcProgNum3}=${dataLen3}=${data3}&${pcProgNum4}=${dataLen4}=${data4}&${pcProgNum5}=${dataLen5}=${data5}&${pcProgNum6}=${dataLen6}=${data6}&${pcProgNum7}=${dataLen7}=${data7}&${pcProgNum8}=${dataLen8}=${data8}&${pcProgNum9}=${dataLen9}=${data9}&${pcProgNum10}=${dataLen10}=${data10}" ${block} ${adminExt}`
#echo "ret=\`/sbin/officeadmin ${ext} ${pin} 5 2102 set \"${pcProgNum1}=${dataLen1}=${data1}&${pcProgNum2}=${dataLen2}=${data2}&${pcProgNum3}=${dataLen3}=${data3}&${pcProgNum4}=${dataLen4}=${data4}&${pcProgNum5}=${dataLen5}=${data5}&${pcProgNum6}=${dataLen6}=${data6}&${pcProgNum7}=${dataLen7}=${data7}&${pcProgNum8}=${dataLen8}=${data8}&${pcProgNum9}=${dataLen9}=${data9}&${pcProgNum10}=${dataLen10}=${data10}\" \"${block}\" ${adminExt}\`" > /ram/web.log
#echo "ret=${ret}" >> /ram/web.log
           fi

           #for each field substitute all the data in the web page
           #the strings are always varInWeb|UI|varName|field_pgnum
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" ${perRange} "s1Ty|DropDown|${arr4}|1_1702" "s1Li|DropDown|${arr5}|1_1702" "s1Nu|text|${arr6}|1_1702" "s1Na|text|${arr7}|1_1702"  "s2Ty|DropDown|${arr13}|2_1702" "s2Li|DropDown|${arr14}|2_1702" "s2Nu|text|${arr15}|2_1702" "s2Na|text|${arr16}|2_1702"  "s3Ty|DropDown|${arr22}|3_1702" "s3Li|DropDown|${arr23}|3_1702" "s3Nu|text|${arr24}|3_1702" "s3Na|text|${arr25}|3_1702"  "s4Ty|DropDown|${arr31}|4_1702" "s4Li|DropDown|${arr32}|4_1702" "s4Nu|text|${arr33}|4_1702" "s4Na|text|${arr34}|4_1702"  "s5Ty|DropDown|${arr40}|5_1702" "s5Li|DropDown|${arr41}|5_1702" "s5Nu|text|${arr42}|5_1702" "s5Na|text|${arr43}|5_1702"  "s6Ty|DropDown|${arr49}|6_1702" "s6Li|DropDown|${arr50}|6_1702" "s6Nu|text|${arr51}|6_1702" "s6Na|text|${arr52}|6_1702"  "s7Ty|DropDown|${arr58}|7_1702" "s7Li|DropDown|${arr59}|7_1702" "s7Nu|text|${arr60}|7_1702" "s7Na|text|${arr61}|7_1702"  "s8Ty|DropDown|${arr67}|8_1702" "s8Li|DropDown|${arr68}|8_1702" "s8Nu|text|${arr69}|8_1702" "s8Na|text|${arr70}|8_1702"  "s9Ty|DropDown|${arr76}|9_1702" "s9Li|DropDown|${arr77}|9_1702" "s9Nu|text|${arr78}|9_1702" "s9Na|text|${arr79}|9_1702"  "s10Ty|DropDown|${arr85}|10_1702" "s10Li|DropDown|${arr86}|10_1702" "s10Nu|text|${arr87}|10_1702" "s10Na|text|${arr88}|10_1702"  "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "sysbin|text|${perRange}|_" "sysSRange|hidden|${perRange}|_" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999" "s1Gr|DropDown|${arr8}|1_1702" "s2Gr|DropDown|${arr17}|2_1702" "s3Gr|DropDown|${arr26}|3_1702" "s4Gr|DropDown|${arr35}|4_1702" "s5Gr|DropDown|${arr44}|5_1702" "s6Gr|DropDown|${arr53}|6_1702" "s7Gr|DropDown|${arr62}|7_1702" "s8Gr|DropDown|${arr71}|8_1702" "s9Gr|DropDown|${arr80}|9_1702" "s10Gr|DropDown|${arr89}|10_1702"
        elif [ "${page}" = "spdialper.html" ]
        then
           #for each field get the pcProgNum
        stringmatch ${QUERY_STRING} perRange__=2
        range=$?
        stringmatch ${QUERY_STRING} perSRange__=2
        submit=$?
        if [ ${range} -eq 1 ] && [ ${submit} -eq 1 ]
        then
            #a return value of 1 means it didn't find it and we should be doing the first range
            perRange=1
            subPerRange=0
        else
            perRange=2
            subPerRange=1
        fi
        if [ ${perRange} -eq 1 ]
        then
           pcProgNum1="1=2151"
           pcProgNum2="2=2151"
           pcProgNum3="3=2151"
           pcProgNum4="4=2151"
           pcProgNum5="5=2151"
           pcProgNum6="6=2151"
           pcProgNum7="7=2151"
           pcProgNum8="8=2151"
           pcProgNum9="9=2151"
           pcProgNum10="10=2151"
        else
           pcProgNum1="11=2151"
           pcProgNum2="12=2151"
           pcProgNum3="13=2151"
           pcProgNum4="14=2151"
           pcProgNum5="15=2151"
           pcProgNum6="16=2151"
           pcProgNum7="17=2151"
           pcProgNum8="18=2151"
           pcProgNum9="19=2151"
           pcProgNum10="20=2151"
        fi

           #for each field get all the data values from the system
                pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=&${pcProgNum5}=0=&${pcProgNum6}=0=&${pcProgNum7}=0=&${pcProgNum8}=0=&${pcProgNum9}=0=&${pcProgNum10}=0=" "" ${adminExt}`
#echo "pcAdminResp=${pcAdminResp}" > /ram/web.log

           #take the pcAdminResp and expand it into variables
           #on structures get the entire item into a string format item1|item2|item[n-1]
           i=0
           IFS='	'
           for value in `charreplace "${pcAdminResp}" "=|&" "	"`
           do
               case $i in
                7) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                15) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                23) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                31) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                39) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                47) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                55) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                63) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                71) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                79) encName=`printenctext "$value"`
                eval arr$i=\"$encName\"
#echo "arr$i=$encName" >> /ram/web.log
                ;;
                *)
                    eval arr$i=\"$value\"
#echo "arr$i=$value" >> /ram/web.log
                    ;;
                esac
               i=$(($i+1))
           done
           IFS=' '

           #if we are doing a submission then set all the data (we should be able to just figure out what changed though
           if [ "${submission}" = "yes" ]
           then
                   #varName=                varInWeb_field_prgNum
                   #varName is your choosing varInWeb is the name from the web page followed by the field and program number
                   arr4=`getitemsvalue p1Ty_1_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1} 1`
                   arr5=`getitemsvalue p1Li_1_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1} 2`
                   arr6=`getitemsvalue p1Nu_1_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1} 3`
                   arr7=`getitemsvalue p1Na_1_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum1} 4`
                   arr12=`getitemsvalue p2Ty_2_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2} 1`
                   arr13=`getitemsvalue p2Li_2_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2} 2`
                   arr14=`getitemsvalue p2Nu_2_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2} 3`
                   arr15=`getitemsvalue p2Na_2_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum2} 4`
                   arr20=`getitemsvalue p3Ty_3_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3} 1`
                   arr21=`getitemsvalue p3Li_3_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3} 2`
                   arr22=`getitemsvalue p3Nu_3_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3} 3`
                   arr23=`getitemsvalue p3Na_3_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum3} 4`
                   arr28=`getitemsvalue p4Ty_4_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4} 1`
                   arr29=`getitemsvalue p4Li_4_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4} 2`
                   arr30=`getitemsvalue p4Nu_4_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4} 3`
                   arr31=`getitemsvalue p4Na_4_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum4} 4`
                   arr36=`getitemsvalue p5Ty_5_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum5} 1`
                   arr37=`getitemsvalue p5Li_5_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum5} 2`
                   arr38=`getitemsvalue p5Nu_5_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum5} 3`
                   arr39=`getitemsvalue p5Na_5_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum5} 4`
                   arr44=`getitemsvalue p6Ty_6_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum6} 1`
                   arr45=`getitemsvalue p6Li_6_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum6} 2`
                   arr46=`getitemsvalue p6Nu_6_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum6} 3`
                   arr47=`getitemsvalue p6Na_6_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum6} 4`
                   arr52=`getitemsvalue p7Ty_7_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum7} 1`
                   arr53=`getitemsvalue p7Li_7_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum7} 2`
                   arr54=`getitemsvalue p7Nu_7_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum7} 3`
                   arr55=`getitemsvalue p7Na_7_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum7} 4`
                   arr60=`getitemsvalue p8Ty_8_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum8} 1`
                   arr61=`getitemsvalue p8Li_8_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum8} 2`
                   arr62=`getitemsvalue p8Nu_8_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum8} 3`
                   arr63=`getitemsvalue p8Na_8_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum8} 4`
                   arr68=`getitemsvalue p9Ty_9_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum9} 1`
                   arr69=`getitemsvalue p9Li_9_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum9} 2`
                   arr70=`getitemsvalue p9Nu_9_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum9} 3`
                   arr71=`getitemsvalue p9Na_9_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum9} 4`
                   arr76=`getitemsvalue p10Ty_10_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum10} 1`
                   arr77=`getitemsvalue p10Li_10_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum10} 2`
                   arr78=`getitemsvalue p10Nu_10_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum10} 3`
                   arr79=`getitemsvalue p10Na_10_2151 "${QUERY_STRING}" "${pcAdminResp}" ${pcProgNum10} 4`
                   data1="${arr4}|${arr5}|${arr6}|${arr7}"
                   dataLen1=`strlen "${data1}"`
                   data2="${arr12}|${arr13}|${arr14}|${arr15}"
                   dataLen2=`strlen "${data2}"`
                   data3="${arr20}|${arr21}|${arr22}|${arr23}"
                   dataLen3=`strlen "${data3}"`
                   data4="${arr28}|${arr29}|${arr30}|${arr31}"
                   dataLen4=`strlen "${data4}"`
                   data5="${arr36}|${arr37}|${arr38}|${arr39}"
                   dataLen5=`strlen "${data5}"`
                   data6="${arr44}|${arr45}|${arr46}|${arr47}"
                   dataLen6=`strlen "${data6}"`
                   data7="${arr52}|${arr53}|${arr54}|${arr55}"
                   dataLen7=`strlen "${data7}"`
                   data8="${arr60}|${arr61}|${arr62}|${arr63}"
                   dataLen8=`strlen "${data8}"`
                   data9="${arr68}|${arr69}|${arr70}|${arr71}"
                   dataLen9=`strlen "${data9}"`
                   data10="${arr76}|${arr77}|${arr78}|${arr79}"
                   dataLen10=`strlen "${data10}"`

                   #structures have the form pcProgNum1=var1Name1|var1Name2|var1Name3&pcProgNum2=var2Name1|var2Name2|var3Name2...
                   #up to and including the set is the same followed by ${pcProgNum1}=${varName1}|${varName2}|${varName[n-1]}&rest
                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=${dataLen1}=${data1}&${pcProgNum2}=${dataLen2}=${data2}&${pcProgNum3}=${dataLen3}=${data3}&${pcProgNum4}=${dataLen4}=${data4}&${pcProgNum5}=${dataLen5}=${data5}&${pcProgNum6}=${dataLen6}=${data6}&${pcProgNum7}=${dataLen7}=${data7}&${pcProgNum8}=${dataLen8}=${data8}&${pcProgNum9}=${dataLen9}=${data9}&${pcProgNum10}=${dataLen10}=${data10}" "" ${adminExt}`
           fi

           #for each field substitute all the data in the web page
           #the strings are always varInWeb|UI|varName|field_pgnum
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" ${subPerRange} "p1Ty|DropDown|${arr4}|1_2151" "p1Li|DropDown|${arr5}|1_2151" "p1Nu|text|${arr6}|1_2151" "p1Na|text|${arr7}|1_2151"  "p2Ty|DropDown|${arr12}|2_2151" "p2Li|DropDown|${arr13}|2_2151" "p2Nu|text|${arr14}|2_2151" "p2Na|text|${arr15}|2_2151"  "p3Ty|DropDown|${arr20}|3_2151" "p3Li|DropDown|${arr21}|3_2151" "p3Nu|text|${arr22}|3_2151" "p3Na|text|${arr23}|3_2151"  "p4Ty|DropDown|${arr28}|4_2151" "p4Li|DropDown|${arr29}|4_2151" "p4Nu|text|${arr30}|4_2151" "p4Na|text|${arr31}|4_2151"  "p5Ty|DropDown|${arr36}|5_2151" "p5Li|DropDown|${arr37}|5_2151" "p5Nu|text|${arr38}|5_2151" "p5Na|text|${arr39}|5_2151"  "p6Ty|DropDown|${arr44}|6_2151" "p6Li|DropDown|${arr45}|6_2151" "p6Nu|text|${arr46}|6_2151" "p6Na|text|${arr47}|6_2151"  "p7Ty|DropDown|${arr52}|7_2151" "p7Li|DropDown|${arr53}|7_2151" "p7Nu|text|${arr54}|7_2151" "p7Na|text|${arr55}|7_2151"  "p8Ty|DropDown|${arr60}|8_2151" "p8Li|DropDown|${arr61}|8_2151" "p8Nu|text|${arr62}|8_2151" "p8Na|text|${arr63}|8_2151"  "p9Ty|DropDown|${arr68}|9_2151" "p9Li|DropDown|${arr69}|9_2151" "p9Nu|text|${arr70}|9_2151" "p9Na|text|${arr71}|9_2151"  "p10Ty|DropDown|${arr76}|10_2151" "p10Li|DropDown|${arr77}|10_2151" "p10Nu|text|${arr78}|10_2151" "p10Na|text|${arr79}|10_2151"  "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "perRange|RadioBox|${perRange}|_" "perSRange|hidden|${perRange}|_" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "vmail_basics.html" ]
        then
            #for each field get the pcProgNum
            pcProgNum1="1=2141"
            pcProgNum2="1=2148"
            pcProgNum3="1=2142"
            pcProgNum4="2=2142"
            pcProgNum5="4=2142"
            pcProgNum6="5=2142"
            pcProgNum7="3=2142"
            pcProgNum8="2=2148"
            pcProgNum9="3=2148"
            pcProgNum10="5=2148"

            #for each field get all the data values from the system
            pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=&${pcProgNum5}=0=&${pcProgNum6}=0=&${pcProgNum7}=0=&${pcProgNum8}=0=&${pcProgNum9}=0=&${pcProgNum10}=0=" "" ${adminExt}`
            totMsgs=`getitem ${pcAdminResp} 2=2148`
            newMsgs=`getitem ${pcAdminResp} 3=2148`
            mBoxUsage=`getitem ${pcAdminResp} 5=2148`
            hours=$((${mBoxUsage}/14400000))
            mins=$((${mBoxUsage}/240000))
            secs=$((${mBoxUsage}/4000))
            if [ ${hours} -lt 10 ]
            then
                hours="0${hours}"
            fi
            if [ ${mins} -lt 10 ]
            then
                mins="0${mins}"
            fi
            if [ ${secs} -lt 10 ]
            then
                secs="0${secs}"
            fi
            mBoxUsage="${hours}:${mins}:${secs}"
            #echo "pcAdminResp=${pcAdminResp}" >&2

            #for each field get the value
            mailBoxType=`getitemsvalue mailBoxType_1_2141 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1}`
            mboxSecCodeReq=`getitemsvalue mboxSecCodeReq_1_2148 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2}`
            #this should move the DSX app
            if [ "${mboxSecCodeReq}" = "ffff" ]
            then
                mboxSecCodeReq="\"\""
            fi
            msNumMsgs=`getitemsvalue msNumMsgs_1_2142 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3}`
            msMsgRet=`getitemsvalue msMsgRet_2_2142 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4}`
            msMenuType=`getitemsvalue msMenuType_4_2142 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5}`
            msLang=`getitemsvalue msLang_5_2142 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum6}`
            msSysAdmin=`getitemsvalue msSysAdmin_3_2142 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum7}`
#echo "mailBoxType=${mailBoxType} mboxSecCodeReq=${mboxSecCodeReq} msNumMsgs=${msNumMsgs} msMsgRet=${msMsgRet} msMenuType=${msMenuType} msLang=${msLang} msSysAdmin=${msSysAdmin} " >&2

            #if we are doing a submission then set all the data (we should be able to just figure out what changed though
            if [ "${submission}" = "yes" ]
            then
                    secLen=`strlen "${mboxSecCodeReq}"`
                    numMsgsLen=`strlen "${msNumMsgs}"`
                    msgRetLen=`strlen "${msMsgRet}"`
                    ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=1=${mailBoxType}&${pcProgNum2}=${secLen}=${mboxSecCodeReq}&${pcProgNum3}=${numMsgsLen}=${msNumMsgs}&${pcProgNum4}=${msgRetLen}=${msMsgRet}&${pcProgNum5}=1=${msMenuType}&${pcProgNum6}=1=${msLang}&${pcProgNum7}=1=${msSysAdmin}" "" ${adminExt}`
                    if [ "${mailBoxType}" -eq 0 ]
                    then
                        pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=&${pcProgNum5}=0=&${pcProgNum6}=0=&${pcProgNum7}=0=" "" ${adminExt}`

                        #for each field get the value
                        mailBoxType=`getitem ${pcAdminResp} ${pcProgNum1}`
                        mboxSecCodeReq=`getitem ${pcAdminResp} ${pcProgNum2}`
                        #this should move the DSX app
                        if [ "${mboxSecCodeReq}" = "ffff" ]
                        then
                            mboxSecCodeReq="\"\""
                        fi
                        msNumMsgs=`getitem ${pcAdminResp} ${pcProgNum3}`
                        msMsgRet=`getitem ${pcAdminResp} ${pcProgNum4}`
                        msMenuType=`getitem ${pcAdminResp} ${pcProgNum5}`
                        msLang=`getitem ${pcAdminResp} ${pcProgNum6}`
                        msSysAdmin=`getitem ${pcAdminResp} ${pcProgNum7}`
                    fi
            fi

            #for each field substitute all the data in the web page
            #echo "sub ${page} $$ ${ext} ${pin} \"${adminExt}\" \"mailBoxType|DropDown|${mailBoxType}|1_2141\" \"mboxSecCodeReq|text|${mboxSecCodeReq}|1_2148\" \"msNumMsgs|text|${msNumMsgs}|1_2142\" \"msMsgRet|text|${msMsgRet}|2_2142\" \"msMenuType|DropDown|${msMenuType}|4_2142\" \"msLang|DropDown|${msLang}|5_2142\" \"msSysAdmin|RadioBox|${msSysAdmin}|3_2142\" \"name|text|${extName}|2_2101\" \"cirType|hidden|${cirType}|1_2101\" \"vmailType|hidden|${vmailType}|1_4101\" \"vmailHWVer|hidden|${vmailHWVer}|4_4200\" \"useraccesslevel|hidden|${accessLevel}|5_2102\" \"offPremis|hidden|${offPremis}|1_1406\" \"callFwrd|hidden|${callFwrd}|2_1406\"" >&2
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "mailBoxType|DropDown|${mailBoxType}|1_2141" "mboxSecCodeReq|text|${mboxSecCodeReq}|1_2148" "msNumMsgs|text|${msNumMsgs}|1_2142" "msMsgRet|text|${msMsgRet}|2_2142" "msMenuType|DropDown|${msMenuType}|4_2142" "msLang|DropDown|${msLang}|5_2142" "msSysAdmin|RadioBox|${msSysAdmin}|3_2142" "totMsgs|text|${totMsgs}|2_2148" "newMsgs|text|${newMsgs}|3_2148" "mBoxUsage|text|${mBoxUsage}|5_2148" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "vmail_call_handling.html" ]
        then
            #for each field get the pcProgNum
            pcProgNum1="6=2144"
            pcProgNum2="7=2144"
            pcProgNum3="1=2144"
            #echo "pcProgNum1=${pcProgNum1} pcProgNum2=${pcProgNum2} pcProgNum3=${pcProgNum3} " >&2

            #for each field get all the data values from the system
            pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=" "" ${adminExt}`
            #echo "pcAdminResp=${pcAdminResp}" >&2

            #for each field get the value
            aaPandP=`getitemsvalue aaPandP_6_2144 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1}`
            aaPageOpt=`getitemsvalue aaPageOpt_7_2144 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2}`
            aaDVM=`getitemsvalue aaDVM_1_2144 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3}`
            #echo "aaPandP=${aaPandP} aaPageOpt=${aaPageOpt} aaDVM=${aaDVM} " >&2

            #if we are doing a submission then set all the data (we should be able to just figure out what changed though
            if [ "${submission}" = "yes" ]
            then
                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=1=${aaPandP}&${pcProgNum2}=1=${aaPageOpt}&${pcProgNum3}=1=${aaDVM}" "" ${adminExt}`
            fi

            #for each field substitute all the data in the web page
            #echo "sub ${page} $$ ${ext} ${pin} \"${adminExt}\" \"aaPandP|RadioBox|${aaPandP}|6_2144\" \"aaPageOpt|DropDown|${aaPageOpt}|7_2144\" \"aaDVM|RadioBox|${aaDVM}|1_2144\" \"name|text|${extName}|2_2101\" \"cirType|hidden|${cirType}|1_2101\" \"vmailType|hidden|${vmailType}|1_4101\" \"vmailHWVer|hidden|${vmailHWVer}|4_4200\" \"useraccesslevel|hidden|${accessLevel}|5_2102\" \"offPremis|hidden|${offPremis}|1_1406\" \"callFwrd|hidden|${callFwrd}|2_1406\"" >&2
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "aaPandP|RadioBox|${aaPandP}|6_2144" "aaPageOpt|RadioBox|${aaPageOpt}|7_2144" "aaDVM|RadioBox|${aaDVM}|1_2144" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        elif [ "${page}" = "vmail_message_options.html" ]
        then
            #for each field get the pcProgNum
            pcProgNum1="1=2143"
            pcProgNum2="2=2143"
            pcProgNum3="6=2143"
            pcProgNum4="3=2143"
            pcProgNum5="5=2143"
            #echo "pcProgNum1=${pcProgNum1} pcProgNum2=${pcProgNum2} pcProgNum3=${pcProgNum3} pcProgNum4=${pcProgNum4} pcProgNum5=${pcProgNum5} " >&2

            #for each field get all the data values from the system
            pcAdminResp=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 get "${pcProgNum1}=0=&${pcProgNum2}=0=&${pcProgNum3}=0=&${pcProgNum4}=0=&${pcProgNum5}=0=" "" ${adminExt}`
            #echo "pcAdminResp=${pcAdminResp}" >&2

            #for each field get the value
            moPlayOrder=`getitemsvalue moPlayOrder_1_2143 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum1}`
            moPostAction=`getitemsvalue moPostAction_2_2143 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum2}`
            moSecCodeReq=`getitemsvalue moSecCodeReq_6_2143 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum3}`
            moTimeStamp=`getitemsvalue moTimeStamp_3_2143 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum4}`
            moRecBeep=`getitemsvalue moRecBeep_5_2143 "${QUERY_STRING}" ${pcAdminResp} ${pcProgNum5}`
            #echo "moPlayOrder=${moPlayOrder} moPostAction=${moPostAction} moSecCodeReq=${moSecCodeReq} moTimeStamp=${moTimeStamp} moRecBeep=${moRecBeep} " >&2

            #if we are doing a submission then set all the data (we should be able to just figure out what changed though
            if [ "${submission}" = "yes" ]
            then
                   ret=`/sbin/officeadmin "${ext}" "${pin}" 5 2102 set "${pcProgNum1}=1=${moPlayOrder}&${pcProgNum2}=1=${moPostAction}&${pcProgNum3}=1=${moSecCodeReq}&${pcProgNum4}=1=${moTimeStamp}&${pcProgNum5}=1=${moRecBeep}" "" ${adminExt}`
            fi

            #for each field substitute all the data in the web page
            #echo "sub ${page} $$ ${ext} ${pin} \"${adminExt}\" \"moPlayOrder|DropDown|${moPlayOrder}|1_2143\" \"moPostAction|DropDown|${moPostAction}|2_2143\" \"moSecCodeReq|DropDown|${moSecCodeReq}|6_2143\" \"moTimeStamp|RadioBox|${moTimeStamp}|3_2143\" \"moRecBeep|RadioBox|${moRecBeep}|5_2143\" \"name|text|${extName}|2_2101\" \"cirType|hidden|${cirType}|1_2101\" \"vmailType|hidden|${vmailType}|1_4101\" \"vmailHWVer|hidden|${vmailHWVer}|4_4200\" \"useraccesslevel|hidden|${accessLevel}|5_2102\" \"offPremis|hidden|${offPremis}|1_1406\" \"callFwrd|hidden|${callFwrd}|2_1406\"" >&2
            /var/www/vmail_sub.elf ${page} $$ ${ext} "${pin}" "${adminExt}" 0 "moPlayOrder|DropDown|${moPlayOrder}|1_2143" "moPostAction|DropDown|${moPostAction}|2_2143" "moSecCodeReq|DropDown|${moSecCodeReq}|6_2143" "moTimeStamp|RadioBox|${moTimeStamp}|3_2143" "moRecBeep|RadioBox|${moRecBeep}|5_2143" "name|text|${extName}|2_2101" "cirType|hidden|${cirType}|1_2101" "vmailType|hidden|${vmailType}|1_4101" "vmailHWVer|hidden|${vmailHWVer}|4_4200" "useraccesslevel|hidden|${accessLevel}|5_2102" "offPremis|hidden|${offPremis}|1_1406" "callFwrd|hidden|${callFwrd}|2_1406" "pageName|hidden|${page}|" "adminName|text|${adminName}|2_2101" "lastTrunk|hidden|${lastTrunk}|1_9999"
        else
            PrintGenericPage ${page} ${ext} "${pin}" "${adminExt}"
        fi
    else
        #invalid login print out error CGI header already done
        PrintInvalidLogin
    fi
elif [ "${HTTP_REFERER}" = "" ]
then
   PrintCGIHeader
   PrintRealLogin
   exit
else
    #doing an update with alpha release
    PrintCGIHeader
    if [ -e /bin/index.cgi_get.sh ]
    then
    echo "<html>"
    echo "<head>"
    echo "<title>NEC dsx</title>"
    echo "</head>"
    echo "<body>"
        echo "<br><a href=\"index.html\">login</a>"
        killall index.cgi_get.sh
        killall html_get.sh
        killall ftp
        /bin/index.cgi_get.sh
        if [ -e /bin/html_get.sh ]
        then
            /bin/html_get.sh
            echo "<br>Your system has been updated"
        else
            PrintRealLogin
            exit
        fi
    else
        PrintRealLogin
        exit
    fi
    echo "<br><a href=\"index.html\">login</a>"
    echo "</body>"
    echo "</html>"
    exit
fi
