@{
   ModuleToProcess        = ''
   ModuleVersion          = '9.10.1.2111'
   GUID                   = '882DB5CD-CCE6-42ea-8B82-DFBB5B1F1AA1'
   Author                 = 'Clinton Knight', 'Steven Beam', 'Eric Nicholson', 'Aparajita Raychaudhury', 'Rajesh Rathnam', 'Robert Mcdermot', 'Sapan Jain', 'Kartik Gupta'
   CompanyName            = 'NetApp'
   Copyright              = 'Copyright (c) 2021 NetApp.  All rights reserved.'
   Description            = 'NetApp.ONTAP PowerShell Toolkit. The ONTAP 9.10.1 PowerShell Toolkit provides end-to-end automation and enables more efficient and scalable administration of NetApp storage. This module contains over 2340 PowerShell cmdlets to help you automate ONTAP administration on FAS and AFF systems, commodity hardware, and the cloud. The toolkit also provides cross-platform support for Windows, Ubuntu, Red Hat Enterprise Linux (RHEL), and macOS.'
   PowerShellVersion      = '5.1'
   DotNetFrameworkVersion = '4.5'
   RequiredAssemblies     = 'OntapiPS.dll', 'DataONTAP.HostUtilities.dll'
   TypesToProcess         = 'DataONTAP.Type.ps1xml', 'DataONTAP.C.Type.ps1xml'
   FormatsToProcess       = 'DataONTAP.Format.ps1xml', 'DataONTAP.C.Format.ps1xml'
   NestedModules          = 'DataONTAP.dll', 'DataONTAP.C.dll', 'DataONTAP.Host.dll', 'DataONTAP.Alias.psm1'
   FunctionsToExport      = '*'
   CmdletsToExport        = '*'
   VariablesToExport      = '*'
   AliasesToExport        = '*'
 PrivateData = @{

   PSData = @{
        # Tags applied to this module. These help with module discovery in online galleries.
        Tags = @('NetApp', 'PSTK', 'ONTAP', 'ONTAP_9.10.1', 'NetApp_ONTAP_PowerShell_Toolkit', 'ONTAP_PSTK_9.10.1', 'NetApp.ONTAP', 'NetApp.ONTAP_9.10.1')

        # A URL to the license for this module.
        LicenseUri = 'https://mysupport.netapp.com/site/tools/tool-eula/ontap-powershell-toolkit'

        # A URL to the main website for this project.
        ProjectUri = 'https://mysupport.netapp.com/site/tools/tool-eula/ontap-powershell-toolkit'
   
   ReleaseNotes = @'
## 9.10.1
- Provides maximum ONTAP API coverage for ONTAP 9.10.1 and is backward compatible with earlier ONTAP versions.
- No new cmdlets have been added in this release.
- The toolkit is renamed from DataONTAP to NetApp.ONTAP. In order to support compatibility with existing scripts, the following cmdlets should be executed:
	- New-Item -ItemType SymbolicLink -Path ("C:\Program Files\WindowsPowerShell\Modules\DataONTAP") -Target ("C:\Program Files\WindowsPowerShell\Modules\NetApp.ONTAP")
	- New-Item -ItemType SymbolicLink -Path ("C:\Program Files\WindowsPowerShell\Modules\DataONTAP\9.10.1.2111\DataONTAP.psd1") -Target ("C:\Program Files\WindowsPowerShell\Modules\DataONTAP\9.10.1.2111\NetApp.ONTAP.psd1")
- Once these commands have completed, you can import the module using either "DataONTAP" or "NetApp.ONTAP" and your existing scripts will not need to change.
'@

# HelpInfoURI = 'http://powershell.netapp.com/help/DataONTAP/'
}
}

}
# SIG # Begin signature block
# MIIVogYJKoZIhvcNAQcCoIIVkzCCFY8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUxJZv4NnchAZsx1cPLoLuK9N2
# N2ugghKIMIIF3zCCBMegAwIBAgIQTkDkN1Tt5owAAAAAUdOUfzANBgkqhkiG9w0B
# AQsFADCBvjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKDAm
# BgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwtdGVybXMxOTA3BgNVBAsT
# MChjKSAyMDA5IEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0aG9yaXplZCB1c2Ugb25s
# eTEyMDAGA1UEAxMpRW50cnVzdCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5
# IC0gRzIwHhcNMjEwNTA3MTU0MzQ1WhcNMzAxMTA3MTYxMzQ1WjBpMQswCQYDVQQG
# EwJVUzEWMBQGA1UECgwNRW50cnVzdCwgSW5jLjFCMEAGA1UEAww5RW50cnVzdCBD
# b2RlIFNpZ25pbmcgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIENTQlIx
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAp4GP9xRFtmJD8tiu0yVe
# SE9Rv8V9n1AcNdHWfmEqlBltJ0akphpd91RRaoAixqhmdU1Ug8leaBur9ltksK2t
# IL1U70ZrbQLnRa519o6KuTIui7h3HFJNeYhfpToYyVAslyctv9oAfWN/7zLsRodj
# 25qfw1ohNnv5m9XKoG5yLPzh8Z5wTQhWFW+Qq/tIurnXwYJ4hWUuf7XJwOIUtzcR
# QQbiiuCo9uV+tngFAcNg7U8HQS4KE0njkJt/3b36rL9kUdFcm7T1XOdc/zubpaAa
# 130JssK3/24cvMh95ukr/HKzFOlKVRKEnEQldR32KvBPpSA9aCXrYZd8D+W2PfOu
# w8ERvBuOzOBHMF5CAIZx41isBsplH3uUpktXZwx+Xq14Z1tV417rx9jsTG6Gy/Pc
# +J+HqnJYEg99pvj4Qjk7PCzkMk1JjODhAMI4oJz6hD5B3G5WrsYaW/RnaAUBzRu/
# roe8nVP2Lui2a+SZ3sVPh1io0mUeyB/Vcm7uWRxXOwlyndfKt5DGzXtFkpFCA0x9
# P8ryqrjCDobzEJ9GLqRmhmhaaBhwKTgRgGBrikOjc2zjs2s3/+adZwGSht8vSNH7
# UGDVXP4h0wFCY/7vcLQXwI+o7tPBS18S6v39Lg6HRGDjqfTCGKPj/c4MhCIN86d4
# 2pPz2zjPuS8zxv8HPF6+RdMCAwEAAaOCASswggEnMA4GA1UdDwEB/wQEAwIBhjAS
# BgNVHRMBAf8ECDAGAQH/AgEBMB0GA1UdJQQWMBQGCCsGAQUFBwMDBggrBgEFBQcD
# CDA7BgNVHSAENDAyMDAGBFUdIAAwKDAmBggrBgEFBQcCARYaaHR0cDovL3d3dy5l
# bnRydXN0Lm5ldC9ycGEwMwYIKwYBBQUHAQEEJzAlMCMGCCsGAQUFBzABhhdodHRw
# Oi8vb2NzcC5lbnRydXN0Lm5ldDAwBgNVHR8EKTAnMCWgI6Ahhh9odHRwOi8vY3Js
# LmVudHJ1c3QubmV0L2cyY2EuY3JsMB0GA1UdDgQWBBSCutY9l86fz3Hokjev/bO1
# aTVXzzAfBgNVHSMEGDAWgBRqciZ60B7vfec7aVHUbI2fkBJmqzANBgkqhkiG9w0B
# AQsFAAOCAQEAH15BBLaDcCRTLFVzHWU6wOy0ewSYXlk4EwmkWZRCXlC/T2xuJSCQ
# k1hADfUZtGLuJF7CAVgVAh0QCW+o1PuSfjc4Pi8UfY8dQzZks2YTXxTMpXH3WyFL
# xpe+3JX8cH0RHNMh3dAkOSnF/goapc97ee46b97cv+kR3RaDCNMsjX9NqBR5LwVh
# UjjrYPMUaH3LsoqtwJRc5CYOLIrdRsPO5FZRxVbjhbhNm0VyiwfxivtJuF/R8paB
# XWlSJPEII9LWIw/ri9d+i8GTa/rxYntY6VCbl24XiA3hxkOY14FhtoWdR+yxnq4/
# IDtDndiiHODUfAjCr3YG+GJmerb3+sivNTCCBi0wggQVoAMCAQICEBACtUsLrwj3
# BiJNUo/AYfgwDQYJKoZIhvcNAQENBQAwTzELMAkGA1UEBhMCVVMxFjAUBgNVBAoT
# DUVudHJ1c3QsIEluYy4xKDAmBgNVBAMTH0VudHJ1c3QgQ29kZSBTaWduaW5nIENB
# IC0gT1ZDUzIwHhcNMjExMDEzMTQ0MzAxWhcNMjQxMDEzMTQ0MzAxWjByMQswCQYD
# VQQGEwJVUzETMBEGA1UECBMKQ2FsaWZvcm5pYTESMBAGA1UEBxMJU3Vubnl2YWxl
# MRQwEgYDVQQKEwtOZXRBcHAsIEluYzEOMAwGA1UECxMFTlBTVEsxFDASBgNVBAMT
# C05ldEFwcCwgSW5jMIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAodol
# gP/sdEyqDEOwlPGv1+l7C3Zl8y9AgYwz44Iv7nihbjvmTyI/COpShxrtB6W4gl7r
# a7ujHb0YTOMvzZxTStXzlvv871qXdJBKaDMRI78URGGBiQQ9N5jQjpAX7I9Zgdk2
# ByfFqTaN+DrYr7LJ7n5kMjUb8jA28iQjs20Lr+MB8d2/mzRIzoD5+qoNkz9GqkEy
# N9PTos+3vZuLTTytt/XMx8M8C+wpJ4CpbAzuYogJUIYpzHtouPqQhJ52xDWq95g3
# cqFqnsP75kWaVPKndpWLukOjpVychBkiM926sSumPNmTCmskJj3LYWakZpKGNw2Y
# DjX8975jJ8RbCOkR0fCbwhkhlu64QooQfyxDrSWM+Zk3CLgWEr+PiVILJs5nsj2r
# 1H3R5w514QsB7p9s+SA5SjN2XR3tPk5LOzjhR/h6IzreT4jTucDFuJas2y54iD7b
# 8QNU/P/WKEkRSMNYJSppHtnUaRLWG7nksVgl1hKcgVk2JgoxBCU9cVxch+t5AgMB
# AAGjggFgMIIBXDAMBgNVHRMBAf8EAjAAMB0GA1UdDgQWBBRu4+Kd8yfGKMu38YjG
# LQzlgrp9ITAfBgNVHSMEGDAWgBTvn7p5sHPyJR54nANSnBtThN6N7TBnBggrBgEF
# BQcBAQRbMFkwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLmVudHJ1c3QubmV0MDIG
# CCsGAQUFBzAChiZodHRwOi8vYWlhLmVudHJ1c3QubmV0L292Y3MyLWNoYWluLnA3
# YzAxBgNVHR8EKjAoMCagJKAihiBodHRwOi8vY3JsLmVudHJ1c3QubmV0L292Y3My
# LmNybDAOBgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwSwYDVR0g
# BEQwQjA2BgpghkgBhvpsCgEDMCgwJgYIKwYBBQUHAgEWGmh0dHA6Ly93d3cuZW50
# cnVzdC5uZXQvcnBhMAgGBmeBDAEEATANBgkqhkiG9w0BAQ0FAAOCAgEAc405oL3/
# r+xIY8ZjVxBHxDuYAnvhRRZr+4pyLyf1aZv+auwvbeiCnTi2rolGZCtLvSC0OaZE
# U641niHGsdjbem8bMbWn7jzo/z1sUh3M+okXRGdXmfqILuDDxZiQO7wE9++1EVKt
# +UXEKoUKGaDBNOkZ64jtqsd+Ykeuf6Ib5mLIMzWizwUEf6Oky7TUB6xtQs+KCWpk
# kFM51lrx+xHyNmxrJknuiEoyh08B6Z448d6WZY8CyAfUGEq7GsN7Qz+5OLXOkb1G
# rH6lPa/7zclX67N7N93hFKMVesnY7Y6l0W9uwcvCLKGmJXO/i+ZtQxft0ZxMs9y8
# s75N5G9DzQnVUbOnw9ABa0HGRhZ7no4ZgkRYTMmuP8gdt+423XK5HZ4yrEYSHCYf
# BaTgXpSBxzkBwDLg6RY0UQgq6QT8dZPCVLh0X2sSvHV4kdgbH0GoJWZsZeq1tdcZ
# nA3HHLFRLYqeRggkJLYdSLYsIIXByIxyMYshbBNKU4lXZ0nK9rWMuRweBhsRW/6/
# WIICBIP2PpBE2p2eCXdoXk0c3Ytvdd3Pt/qHdZBEsxvkqXc7kq283mn8NzM/9gnE
# Zwp3VS/Q9c9CXA3cT9qoLjUy87Llibn9k/gIjAnQgvHl4BoA4jY+2XwJR/audFgk
# u/v8ZFePJzUNWXMTDXJklvU0TyqfBQkTfzwwggZwMIIEWKADAgECAhBx71V0rzVU
# w1osafZvS2vNMA0GCSqGSIb3DQEBDQUAMGkxCzAJBgNVBAYTAlVTMRYwFAYDVQQK
# DA1FbnRydXN0LCBJbmMuMUIwQAYDVQQDDDlFbnRydXN0IENvZGUgU2lnbmluZyBS
# b290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gQ1NCUjEwHhcNMjEwNTA3MTky
# MDQ1WhcNNDAxMjI5MjM1OTAwWjBPMQswCQYDVQQGEwJVUzEWMBQGA1UEChMNRW50
# cnVzdCwgSW5jLjEoMCYGA1UEAxMfRW50cnVzdCBDb2RlIFNpZ25pbmcgQ0EgLSBP
# VkNTMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAJ6ZdhcanlYXCGMs
# k02DYYQzNAK22WKg3sIOuSBMyFedD91UWw0M1gHdL0jhkQnh28gVBIK2e/DY1jA7
# GXFw+6iml/YpXaQMqfRTPlfbDE5u/HbbXyTpql9D45PnDs/KJbzETDALWg/mBvTl
# bgyZZlhPg2HCc3xcIm8BRcUP90BPZEvQFwqpDh4CL6GPTPJnUNs+5J/CTz906zGk
# 0JTQmbwwkglqyyTNoth2UtBOdZhPZFrSXoP0WMBdanXE2D9kOosUDdh24eq5a+cR
# cEkROGMTbvHG+r0QRTUH5nYV0HUWqsJDV/6r/mNzRiKguPPkx3BGCfmpN0Gas0ts
# H3Byowf2NZJ0EWRu+QLVwJKV8ZdZfg3uoiXycVW4m42/ze6u3fsM564yTlCNod/R
# c7/Bzn912qu/0K2COMXniO2ibTqGEbfXsOGoizsMQReaX+RbmMidAJ/3c9LD6Z8F
# h3khg9YL7dHMCJ/g8cXJWLpTX9SHsYtZqNJezWnQPvrEOQmvtLXt5zz6IofWc/kX
# lWrDHPVVeF/U+gvAWz+MeBUOWkw6buUmmNAnzCDfwIY7eo1lRn7ZYV6p9K4+1Pyv
# Rcc6s4UESovICV2zewIoWeOGfYCiWEBmYuA4VYOrnylBJrq76dhk+La7KHPNFUrX
# nnPjZkyxUZ2BI4vIhneytiw3InAhAgMBAAGjggEsMIIBKDASBgNVHRMBAf8ECDAG
# AQH/AgEAMB0GA1UdDgQWBBTvn7p5sHPyJR54nANSnBtThN6N7TAfBgNVHSMEGDAW
# gBSCutY9l86fz3Hokjev/bO1aTVXzzAzBggrBgEFBQcBAQQnMCUwIwYIKwYBBQUH
# MAGGF2h0dHA6Ly9vY3NwLmVudHJ1c3QubmV0MDEGA1UdHwQqMCgwJqAkoCKGIGh0
# dHA6Ly9jcmwuZW50cnVzdC5uZXQvY3NicjEuY3JsMA4GA1UdDwEB/wQEAwIBhjAT
# BgNVHSUEDDAKBggrBgEFBQcDAzBFBgNVHSAEPjA8MDAGBFUdIAAwKDAmBggrBgEF
# BQcCARYaaHR0cDovL3d3dy5lbnRydXN0Lm5ldC9ycGEwCAYGZ4EMAQQBMA0GCSqG
# SIb3DQEBDQUAA4ICAQBe84aZNcF57vAQr9eSQ9KF0FvgmKDgcVHJFMtQmmAOsAQm
# SbHP6bqbCKHaQ13UbyOiufhAx0f+TQELSJA/yNxqtD5TNSi+QEpHhWoed0DMgH9h
# tDxPeajmo6agfkSGcb8SG5WBcvcNpdDeZ5/Gorjxavn8/nRmxmTmeT1qA2FOSx/M
# IGLLAhjsY+1+cT+WugteaCJn7B/A0gUWZrGypOr8xZWjjRKl9Y3vGyDNmffnMvNZ
# cR/dlOZ55VIjEFYq/Fk4v795JZJqx/2rZ3dxsQR9Na0UwT6o/CMXVggYfNd6ImuR
# asw1RW1PO51DnQW4nfP8NCFcBBgyVzg0wcqDI0amiCMhxn4UgKux77sLrAk/7lOR
# MbPiVESqtX0wPCwjnOg/o1jqQAgXoyBfesAM26r/AxYDDXRkIpqUXjA1dhP10+Hj
# 4AfK2epFiEacVNUQ4vMyCUC251wXMv7Mr+ttz2A8dfPuXGBAVRu1Wa9yI2hNnHQE
# DBDJr1Bbpw1mD5blmpXgIKIa0LDuOEmeKmeekZZsmNvEEG1gfB5uSOe2fq8zBxJx
# 772VO76pg9RCfbenNNdfhpG1r1ZY2lV9F73bvM1kQRWNMVEGT7Qusos9nPNN41gD
# VMysiPhSPE5LRgklGf8V56eYRi59uurj43z/+bkZlb52uQ15sgJRGkrIn4jCQzGC
# AoQwggKAAgEBMGMwTzELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3QsIElu
# Yy4xKDAmBgNVBAMTH0VudHJ1c3QgQ29kZSBTaWduaW5nIENBIC0gT1ZDUzICEBAC
# tUsLrwj3BiJNUo/AYfgwCQYFKw4DAhoFAKB4MBgGCisGAQQBgjcCAQwxCjAIoAKA
# AKECgAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
# MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFPWbNnNmHdnpJ76RSTPtx0RH
# E5Q8MA0GCSqGSIb3DQEBAQUABIIBgAol4nEdDl0l5Rwrra+hkef9olsQpxjjk7dB
# K0XzXbwgI0RCuOrADrLZh2+MOf9QFJCtEwf2VjuQqF+jnmlc7EZRriiOgHINO6fM
# I3TOn5p9oS4bE9TTWBgBT/yAHI5xQtLU5wsGNZj+1/qq2vCP8HLIr0dG3+JO1MTm
# jdMb4UGxrrIpCD74wHZKufX/1Cr1E2bubdOKNRkLG+daFar44v87b+hjw8bYf5ab
# Omg/v0Ddkma694b+WNKoOz9RSJOppv4KsYx5BsGqXbI0P5fqx0gY2qaJ85okN7zY
# BHBY0oWIfue+qLE8QKqve5zS3mXccje3UoXy+6oEoYNThWzR0tx/YtVcH8lb3299
# l6MhgzNN3/2XW+wFrdDYvl/kTayamEGzOVmosYfCDk6H6uYiW+HUCgh5oKvdyyDR
# XvDGsTEbzfZWY683kNQkTjMJGVUlcjVWKlnxcFSaVu6e9wCBy4Ad68fg/K8RER32
# df9mNj4cSFZoYlQhcy8CXYiZ5NNR3g==
# SIG # End signature block
