# Module manifest for module 'NetAppDocs'
# Generated by: NetApp
# Generated on: 10/1/2010
@{
    RootModule             = 'NetAppDocs.psm1'
    ModuleVersion          = '4.1.0'
    CompatiblePSEditions   = @( 'Desktop', 'Core' )
    GUID                   = 'c9fdcc5d-088d-499a-89de-47f7c6add98a'
    Author                 = 'Jason Cole'
    CompanyName            = 'NetApp'
    Copyright              = '(c) 2017-2023 NetApp. All rights reserved.'
    Description            = 'Provides a set of functions that automates NetApp site design documentation.'
    PowerShellVersion      = '5.1'
    PowerShellHostName     = ''
    PowerShellHostVersion  = ''
    DotNetFrameworkVersion = '4.7.2'
    CLRVersion             = ''
    ProcessorArchitecture  = ''
    RequiredModules        = @( )
    NestedModules          = @( )
    RequiredAssemblies     = @(
        "lib\$PSEdition\Aspose.Cells.dll"
        "lib\$PSEdition\Aspose.Diagram.dll"
        "lib\$PSEdition\Aspose.Words.dll"
        "lib\$PSEdition\Microsoft.Identity.Client.dll"
        "lib\$PSEdition\NetAppDocs.AuthHelper.dll"
        "lib\$PSEdition\NetAppDocs.Reader.dll"
        "lib\$PSEdition\NetAppDocs.Statistics.Service.dll"
        "lib\$PSEdition\NetAppDocs.Statistics.XmlRepository.dll"
        "lib\$PSEdition\NetAppDocs.UpdateHelper.dll"
        "lib\$PSEdition\NetAppDocs.Utilities.dll"
        "lib\$PSEdition\NetAppDocs.Writer.dll"

        if ($PSEdition -eq 'Desktop') {
            "lib\$PSEdition\System.Data.DataSetExtensions.dll"
        }
        else {
            "lib\$PSEdition\Microsoft.Identity.Client.Desktop.dll"
            "lib\$PSEdition\SkiaSharp.dll"
        }
    )
    ScriptsToProcess       = @( )
    TypesToProcess         = @(
        'Resources\TypeData\NetAppDocs.NaController.Data.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Document#Transition.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Asup.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Asup.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Asup.Document#Transition.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Data.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Asup.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Asup.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcVserver.Asup.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcVserver.Asup.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcVserver.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcVserver.Document#BuildDoc.Types.ps1xml'
    )
    FormatsToProcess       = @( )
    FunctionsToExport      = @(
        'Add-NtapDocsExtendedData'
        'Compare-NtapDocsData'
        'ConvertTo-NtapVserverData'
        'Export-CompressedClixml'
        'Find-NtapAsupSystemInfo'
        'Find-NtapClusterAsup'
        'Find-NtapFilerAsup'
        'Format-NtapClusterData'
        'Format-NtapFilerData'
        'Format-NtapFSxOntapData'
        'Format-NtapVserverData'
        'Get-NtapClusterAsupData'
        'Get-NtapClusterData'
        'Get-NtapDocsVersion'
        'Get-NtapFilerAsupData'
        'Get-NtapFilerData'
        'Get-NtapFSxOntapData'
        'Get-NtapVserverAsupData'
        'Get-NtapVserverData'
        'Invoke-SsoLogin'
        'Merge-NtapDocsData'
        'New-NtapClusterAsupBuildDocument'
        'New-NtapClusterAsupDiffReport'
        'New-NtapClusterBuildDocument'
        'New-NtapFilerAsupBuildDocument'
        'New-NtapFilerAsupDiffReport'
        'New-NtapFilerBuildDocument'
        'Out-NtapDocument'
        'Show-NtapDocsHelp'
        'Show-NtapDocsUpdate'
        'Update-NtapDocsFiles'
        'Update-NtapDocument'
    )
    CmdletsToExport        = @(
        'Add-NaCredential'
        'Add-NcCredential'
        'Connect-NaController'
        'Connect-NcController'
        'ConvertFrom-SerializedString'
        'ConvertTo-FormattedNumber'
        'ConvertTo-SerializedString'
        'Get-NaCredential'
        'Get-NaToolkitVersion'
        'Get-NcCredential'
        'Get-NeCredential'
        'Invoke-NaSsh'
        'Invoke-NcSsh'
        'Invoke-NaSystemApi'
        'Invoke-NcSystemApi'
        'New-NeCredential'
        'New-NeStorageSystem'
        'Remove-NaCredential'
        'Remove-NcCredential'
        'Remove-NeStorageSystem'
    )
    VariablesToExport      = @( )
    AliasesToExport        = @(
        'Find-NtapAsupClusterId'
        'Update-NtapWordDocument'
    )
    ModuleList             = @( )
    FileList               = @(
        'Manifest.json'
        'NetAppDocs.psd1'
        'NetAppDocs.psm1'
        'NOTICE.pdf'
        'en-US\about_NetAppDocs.help.txt'
        'en-US\NetAppDocs-help.xml'
        'lib\Core\Aspose.Cells.dll'
        'lib\Core\Aspose.Diagram.dll'
        'lib\Core\Aspose.Words.dll'
        'lib\Core\Microsoft.Identity.Client.Desktop.dll'
        'lib\Core\Microsoft.Identity.Client.dll'
        'lib\Core\Microsoft.IdentityModel.Abstractions.dll'
        'lib\Core\Microsoft.Web.WebView2.Core.dll'
        'lib\Core\Microsoft.Web.WebView2.WinForms.dll'
        'lib\Core\Microsoft.Web.WebView2.Wpf.dll'
        'lib\Core\Microsoft.Win32.SystemEvents.dll'
        'lib\Core\NetAppDocs.AuthHelper.dll'
        'lib\Core\NetAppDocs.Reader.dll'
        'lib\Core\NetAppDocs.Statistics.Service.dll'
        'lib\Core\NetAppDocs.Statistics.XmlRepository.dll'
        'lib\Core\NetAppDocs.UpdateHelper.dll'
        'lib\Core\NetAppDocs.Utilities.dll'
        'lib\Core\NetAppDocs.Writer.dll'
        'lib\Core\SkiaSharp.dll'
        'lib\Core\System.Drawing.Common.dll'
        'lib\Core\System.Security.Cryptography.Pkcs.dll'
        'lib\Core\WebView2Loader.dll'
        'lib\Core\linux-x64\libSkiaSharp.so'
        'lib\Core\osx-arm64\libSkiaSharp.dylib'
        'lib\Core\osx-x64\libSkiaSharp.dylib'
        'lib\Core\win-x64\libSkiaSharp.dll'
        'lib\Core\win-x86\libSkiaSharp.dll'
        'lib\Desktop\Aspose.Cells.dll'
        'lib\Desktop\Aspose.Diagram.dll'
        'lib\Desktop\Aspose.Words.dll'
        'lib\Desktop\Microsoft.Identity.Client.dll'
        'lib\Desktop\Microsoft.IdentityModel.Abstractions.dll'
        'lib\Desktop\NetAppDocs.AuthHelper.dll'
        'lib\Desktop\NetAppDocs.Reader.dll'
        'lib\Desktop\NetAppDocs.Statistics.Service.dll'
        'lib\Desktop\NetAppDocs.Statistics.XmlRepository.dll'
        'lib\Desktop\NetAppDocs.UpdateHelper.dll'
        'lib\Desktop\NetAppDocs.Utilities.dll'
        'lib\Desktop\NetAppDocs.Writer.dll'
        'lib\Desktop\System.Data.DataSetExtensions.dll'
        'Private\AsupDiscoveryFunctions.ps1'
        'Private\ConnectionFunctions.ps1'
        'Private\DataProtectionFunctions.ps1'
        'Private\DiscoveryFunctions.ps1'
        'Private\DocumentFunctions.ps1'
        'Private\HelperFunctions.ps1'
        'Private\SanitizeFunctions.ps1'
        'Private\StatisticsFunctions.ps1'
        'Private\UpdaterFunctions.ps1'
        'Private\ZipFileFunctions.ps1'
        'Public\Add-NtapDocsExtendedData.ps1'
        'Public\Compare-NtapDocsData.ps1'
        'Public\ConvertTo-NtapVserverData.ps1'
        'Public\Export-CompressedClixml.ps1'
        'Public\Find-NtapAsupSystemInfo.ps1'
        'Public\Find-NtapClusterAsup.ps1'
        'Public\Find-NtapFilerAsup.ps1'
        'Public\Format-NtapClusterData.ps1'
        'Public\Format-NtapFilerData.ps1'
        'Public\Format-NtapFSxOntapData.ps1'
        'Public\Format-NtapVserverData.ps1'
        'Public\Get-NtapClusterAsupData.ps1'
        'Public\Get-NtapClusterData.ps1'
        'Public\Get-NtapDocsVersion.ps1'
        'Public\Get-NtapFilerAsupData.ps1'
        'Public\Get-NtapFilerData.ps1'
        'Public\Get-NtapFSxOntapData.ps1'
        'Public\Get-NtapVserverAsupData.ps1'
        'Public\Get-NtapVserverData.ps1'
        'Public\Invoke-SsoLogin.ps1'
        'Public\Merge-NtapDocsData.ps1'
        'Public\New-NtapClusterAsupBuildDocument.ps1'
        'Public\New-NtapClusterAsupDiffReport.ps1'
        'Public\New-NtapClusterBuildDocument.ps1'
        'Public\New-NtapFilerAsupBuildDocument.ps1'
        'Public\New-NtapFilerAsupDiffReport.ps1'
        'Public\New-NtapFilerBuildDocument.ps1'
        'Public\Out-NtapDocument.ps1'
        'Public\Show-NtapDocsHelp.ps1'
        'Public\Show-NtapDocsUpdate.ps1'
        'Public\Update-NtapDocsFiles.ps1'
        'Public\Update-NtapDocument.ps1'
        'Resources\ExtendedDataScriptExamples\CustomScriptExample1.ps1'
        'Resources\Hardware-ONTAP.xml'
        'Resources\SanitizeMappings_Template-ONTAP.xml'
        'Resources\Schema\NetAppDocs.NaController.Asup.Document#BuildDoc.xsd'
        'Resources\Schema\NetAppDocs.NaController.Asup.Document#Transition.xsd'
        'Resources\Schema\NetAppDocs.NaController.Document#BuildDoc.xsd'
        'Resources\Schema\NetAppDocs.NaController.Document#Transition.xsd'
        'Resources\Schema\NetAppDocs.NcController.Asup.Document#BuildDoc.xsd'
        'Resources\Schema\NetAppDocs.NcController.Document#BuildDoc.xsd'
        'Resources\Schema\NetAppDocs.NcVserver.Document#BuildDoc.xsd'
        'Resources\Schema\NetAppDocs.NcVserver.Asup.Document#BuildDoc.xsd'
        'Resources\TypeData\NetAppDocs.NaController.Asup.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Asup.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Asup.Document#Transition.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Data.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NaController.Document#Transition.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Asup.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Asup.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Data.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcController.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcVserver.Asup.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcVserver.Asup.Document#BuildDoc.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcVserver.Document.Types.ps1xml'
        'Resources\TypeData\NetAppDocs.NcVserver.Document#BuildDoc.Types.ps1xml'
        'Templates\en-US\NetAppDocs Excel Template.xltx'
        'Templates\en-US\Sanitize Mappings Template.xltx'
        'Templates\en-US\Site Design Document Template (7-Mode - ASUP).dotx'
        'Templates\en-US\Site Design Document Template (7-Mode - ASUP).xltx'
        'Templates\en-US\Site Design Document Template (7-Mode).dotx'
        'Templates\en-US\Site Design Document Template (7-Mode).xltx'
        'Templates\en-US\Site Design Document Template (ONTAP - Cluster View - ASUP).dotx'
        'Templates\en-US\Site Design Document Template (ONTAP - Cluster View - ASUP).xltx'
        'Templates\en-US\Site Design Document Template (ONTAP - Cluster View).dotx'
        'Templates\en-US\Site Design Document Template (ONTAP - Cluster View).xltx'
        'Templates\en-US\Site Design Document Template (ONTAP - Single Cluster View - ASUP).dotx'
        'Templates\en-US\Site Design Document Template (ONTAP - Single Cluster View).dotx'
        'Templates\en-US\Site Design Document Template (ONTAP - SVM View - ASUP).dotx'
        'Templates\en-US\Site Design Document Template (ONTAP - SVM View - ASUP).xltx'
        'Templates\en-US\Site Design Document Template (ONTAP - SVM View).dotx'
        'Templates\en-US\Site Design Document Template (ONTAP - SVM View).xltx'
        'Templates\en-US\Site Design Document Template (AWS FSx for ONTAP).dotx'
        'Templates\en-US\Site Design Document Template (AWS FSx for ONTAP).xltx'
        'Templates\en-US\Transition Summary Template (7-Mode - ASUP).xltx'
        'Templates\en-US\Transition Summary Template (7-Mode).xltx'
        'webhelp\examples.html'
        'webhelp\FAQs.html'
        'webhelp\functions.html'
        'webhelp\function_Add-NtapDocsExtendedData.html'
        'webhelp\function_Compare-NtapDocsData.html'
        'webhelp\function_ConvertTo-NtapVserverData.html'
        'webhelp\function_Export-CompressedClixml.html'
        'webhelp\function_Find-NtapAsupSystemInfo.html'
        'webhelp\function_Find-NtapClusterAsup.html'
        'webhelp\function_Find-NtapFilerAsup.html'
        'webhelp\function_Format-NtapClusterData.html'
        'webhelp\function_Format-NtapFilerData.html'
        'webhelp\function_Format-NtapFSxOntapData.html'
        'webhelp\function_Format-NtapVserverData.html'
        'webhelp\function_Get-NtapClusterAsupData.html'
        'webhelp\function_Get-NtapClusterData.html'
        'webhelp\function_Get-NtapDocsVersion.html'
        'webhelp\function_Get-NtapFilerAsupData.html'
        'webhelp\function_Get-NtapFilerData.html'
        'webhelp\function_Get-NtapFSxOntapData.html'
        'webhelp\function_Get-NtapVserverAsupData.html'
        'webhelp\function_Get-NtapVserverData.html'
        'webhelp\function_Invoke-SsoLogin.html'
        'webhelp\function_Merge-NtapDocsData.html'
        'webhelp\function_New-NtapClusterAsupBuildDocument.html'
        'webhelp\function_New-NtapClusterAsupDiffReport.html'
        'webhelp\function_New-NtapClusterBuildDocument.html'
        'webhelp\function_New-NtapFilerAsupBuildDocument.html'
        'webhelp\function_New-NtapFilerAsupDiffReport.html'
        'webhelp\function_New-NtapFilerBuildDocument.html'
        'webhelp\function_Out-NtapDocument.html'
        'webhelp\function_Show-NtapDocsHelp.html'
        'webhelp\function_Show-NtapDocsUpdate.html'
        'webhelp\function_Update-NtapDocsFiles.html'
        'webhelp\function_Update-NtapDocument.html'
        'webhelp\index.html'
        'webhelp\releaseNotes.html'
        'webhelp\resourceFiles.html'
        'webhelp\icons\favicon.ico'
        'webhelp\styles\luci.css'
    )
    PrivateData            = @{
        BuildNumber = '13810'
        PSData      = @{
            Category                   = ''
            Tags                       = @( 'NetAppDocs', 'PSEdition_Core', 'PSEdition_Desktop', 'Windows', 'Linux', 'macOS' )
            IconUri                    = ''
            ProjectUri                 = 'https://mysupport.netapp.com/site/tools/tool-eula/netappdocs'
            LicenseUri                 = 'https://mysupport.netapp.com/site/tools/tool-eula/netappdocs'
            ReleaseNotes               = ''
            ExternalModuleDependencies = @( )
            Prerelease                 = ''
        }
    }
}

# SIG # Begin signature block
# MIIq0AYJKoZIhvcNAQcCoIIqwTCCKr0CAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCCtllkLwCMyKe9Y
# lxbXvIFqT/iy3wvmcfQYTu5nYuPaJqCCJGgwggVvMIIEV6ADAgECAhBI/JO0YFWU
# jTanyYqJ1pQWMA0GCSqGSIb3DQEBDAUAMHsxCzAJBgNVBAYTAkdCMRswGQYDVQQI
# DBJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcMB1NhbGZvcmQxGjAYBgNVBAoM
# EUNvbW9kbyBDQSBMaW1pdGVkMSEwHwYDVQQDDBhBQUEgQ2VydGlmaWNhdGUgU2Vy
# dmljZXMwHhcNMjEwNTI1MDAwMDAwWhcNMjgxMjMxMjM1OTU5WjBWMQswCQYDVQQG
# EwJHQjEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMS0wKwYDVQQDEyRTZWN0aWdv
# IFB1YmxpYyBDb2RlIFNpZ25pbmcgUm9vdCBSNDYwggIiMA0GCSqGSIb3DQEBAQUA
# A4ICDwAwggIKAoICAQCN55QSIgQkdC7/FiMCkoq2rjaFrEfUI5ErPtx94jGgUW+s
# hJHjUoq14pbe0IdjJImK/+8Skzt9u7aKvb0Ffyeba2XTpQxpsbxJOZrxbW6q5KCD
# J9qaDStQ6Utbs7hkNqR+Sj2pcaths3OzPAsM79szV+W+NDfjlxtd/R8SPYIDdub7
# P2bSlDFp+m2zNKzBenjcklDyZMeqLQSrw2rq4C+np9xu1+j/2iGrQL+57g2extme
# me/G3h+pDHazJyCh1rr9gOcB0u/rgimVcI3/uxXP/tEPNqIuTzKQdEZrRzUTdwUz
# T2MuuC3hv2WnBGsY2HH6zAjybYmZELGt2z4s5KoYsMYHAXVn3m3pY2MeNn9pib6q
# RT5uWl+PoVvLnTCGMOgDs0DGDQ84zWeoU4j6uDBl+m/H5x2xg3RpPqzEaDux5mcz
# mrYI4IAFSEDu9oJkRqj1c7AGlfJsZZ+/VVscnFcax3hGfHCqlBuCF6yH6bbJDoEc
# QNYWFyn8XJwYK+pF9e+91WdPKF4F7pBMeufG9ND8+s0+MkYTIDaKBOq3qgdGnA2T
# OglmmVhcKaO5DKYwODzQRjY1fJy67sPV+Qp2+n4FG0DKkjXp1XrRtX8ArqmQqsV/
# AZwQsRb8zG4Y3G9i/qZQp7h7uJ0VP/4gDHXIIloTlRmQAOka1cKG8eOO7F/05QID
# AQABo4IBEjCCAQ4wHwYDVR0jBBgwFoAUoBEKIz6W8Qfs4q8p74Klf9AwpLQwHQYD
# VR0OBBYEFDLrkpr/NZZILyhAQnAgNpFcF4XmMA4GA1UdDwEB/wQEAwIBhjAPBgNV
# HRMBAf8EBTADAQH/MBMGA1UdJQQMMAoGCCsGAQUFBwMDMBsGA1UdIAQUMBIwBgYE
# VR0gADAIBgZngQwBBAEwQwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybC5jb21v
# ZG9jYS5jb20vQUFBQ2VydGlmaWNhdGVTZXJ2aWNlcy5jcmwwNAYIKwYBBQUHAQEE
# KDAmMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5jb21vZG9jYS5jb20wDQYJKoZI
# hvcNAQEMBQADggEBABK/oe+LdJqYRLhpRrWrJAoMpIpnuDqBv0WKfVIHqI0fTiGF
# OaNrXi0ghr8QuK55O1PNtPvYRL4G2VxjZ9RAFodEhnIq1jIV9RKDwvnhXRFAZ/ZC
# J3LFI+ICOBpMIOLbAffNRk8monxmwFE2tokCVMf8WPtsAO7+mKYulaEMUykfb9gZ
# pk+e96wJ6l2CxouvgKe9gUhShDHaMuwV5KZMPWw5c9QLhTkg4IUaaOGnSDip0TYl
# d8GNGRbFiExmfS9jzpjoad+sPKhdnckcW67Y8y90z7h+9teDnRGWYpquRRPaf9xH
# +9/DUp/mBlXpnYzyOmJRvOwkDynUWICE5EV7WtgwggWNMIIEdaADAgECAhAOmxiO
# +dAt5+/bUOIIQBhaMA0GCSqGSIb3DQEBDAUAMGUxCzAJBgNVBAYTAlVTMRUwEwYD
# VQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xJDAi
# BgNVBAMTG0RpZ2lDZXJ0IEFzc3VyZWQgSUQgUm9vdCBDQTAeFw0yMjA4MDEwMDAw
# MDBaFw0zMTExMDkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
# Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERp
# Z2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
# AgoCggIBAL/mkHNo3rvkXUo8MCIwaTPswqclLskhPfKK2FnC4SmnPVirdprNrnsb
# hA3EMB/zG6Q4FutWxpdtHauyefLKEdLkX9YFPFIPUh/GnhWlfr6fqVcWWVVyr2iT
# cMKyunWZanMylNEQRBAu34LzB4TmdDttceItDBvuINXJIB1jKS3O7F5OyJP4IWGb
# NOsFxl7sWxq868nPzaw0QF+xembud8hIqGZXV59UWI4MK7dPpzDZVu7Ke13jrclP
# XuU15zHL2pNe3I6PgNq2kZhAkHnDeMe2scS1ahg4AxCN2NQ3pC4FfYj1gj4QkXCr
# VYJBMtfbBHMqbpEBfCFM1LyuGwN1XXhm2ToxRJozQL8I11pJpMLmqaBn3aQnvKFP
# ObURWBf3JFxGj2T3wWmIdph2PVldQnaHiZdpekjw4KISG2aadMreSx7nDmOu5tTv
# kpI6nj3cAORFJYm2mkQZK37AlLTSYW3rM9nF30sEAMx9HJXDj/chsrIRt7t/8tWM
# cCxBYKqxYxhElRp2Yn72gLD76GSmM9GJB+G9t+ZDpBi4pncB4Q+UDCEdslQpJYls
# 5Q5SUUd0viastkF13nqsX40/ybzTQRESW+UQUOsxxcpyFiIJ33xMdT9j7CFfxCBR
# a2+xq4aLT8LWRV+dIPyhHsXAj6KxfgommfXkaS+YHS312amyHeUbAgMBAAGjggE6
# MIIBNjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTs1+OC0nFdZEzfLmc/57qY
# rhwPTzAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzAOBgNVHQ8BAf8E
# BAMCAYYweQYIKwYBBQUHAQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5k
# aWdpY2VydC5jb20wQwYIKwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcnQwRQYDVR0fBD4wPDA6oDig
# NoY0aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNybDARBgNVHSAECjAIMAYGBFUdIAAwDQYJKoZIhvcNAQEMBQADggEBAHCg
# v0NcVec4X6CjdBs9thbX979XB72arKGHLOyFXqkauyL4hxppVCLtpIh3bb0aFPQT
# SnovLbc47/T/gLn4offyct4kvFIDyE7QKt76LVbP+fT3rDB6mouyXtTP0UNEm0Mh
# 65ZyoUi0mcudT6cGAxN3J0TU53/oWajwvy8LpunyNDzs9wPHh6jSTEAZNUZqaVSw
# uKFWjuyk1T3osdz9HNj0d1pcVIxv76FQPfx2CWiEn2/K2yCNNWAcAgPLILCsWKAO
# QGPFmCLBsln1VWvPJ6tsds5vIy30fnFqI2si/xK4VC0nftg62fC2h5b9W9FcrBjD
# TZ9ztwGpn1eqXijiuZQwggXMMIIENKADAgECAhAg429sPxgagUb53pPffJfkMA0G
# CSqGSIb3DQEBDAUAMFQxCzAJBgNVBAYTAkdCMRgwFgYDVQQKEw9TZWN0aWdvIExp
# bWl0ZWQxKzApBgNVBAMTIlNlY3RpZ28gUHVibGljIENvZGUgU2lnbmluZyBDQSBS
# MzYwHhcNMjEwOTA5MDAwMDAwWhcNMjMwOTA5MjM1OTU5WjBQMQswCQYDVQQGEwJV
# UzETMBEGA1UECAwKQ2FsaWZvcm5pYTEVMBMGA1UECgwMTmV0QXBwLCBJbmMuMRUw
# EwYDVQQDDAxOZXRBcHAsIEluYy4wggGiMA0GCSqGSIb3DQEBAQUAA4IBjwAwggGK
# AoIBgQC4kYYj/oViZD9pN03hrqFjtwOz1Gx4eDWVV8IYUYEr2qpLeNYvWz26B/+E
# mYLboAGVpkYg0Wske3hjRpooZlMORm1S4+2C2NoQCstZ+kmNTevbXHJe/w1VNJrm
# fKjpXOJEfx8GUGDqCMR30dChVpsdBEavrM7T0hnfJLv18i19SGv3a+nhvB3iOjLP
# SEg8+DFkjD5jTI6fQ83DBEiVR4UEYq7yyH578ZEylhsRfJmK+uIREycEUk/NpFTw
# g6/7lxh/WYabCrZzqI4Ep3QataRKaAlxt3BiOlZkX4WGX3DYvSYltWOM2UlCcGpP
# m/1/LN8Xuvf+YO6H472QecHe59XtXbHSMKvqDuOEJu8Wk2LFMNK732o3Fc5QIHie
# 6JtNsgNYf+Vsm5EMBD1ZHNE+C3zlmQbbWIU5uEU1nhiodBPKsu0SkS6pARyKBO05
# DSc2gWWv0aukKi04ZAn+hAdSl5s1dgmU5shBvKHqe15K9ZRN4FFO/CgHE0BoGYQS
# UQVKwa0CAwEAAaOCAZwwggGYMB8GA1UdIwQYMBaAFA8qyyCHKLjsb0iuK1SmKaoX
# pM0MMB0GA1UdDgQWBBQuH643KcBMmb/Q6IZt+H9IrnXFwDAOBgNVHQ8BAf8EBAMC
# B4AwDAYDVR0TAQH/BAIwADATBgNVHSUEDDAKBggrBgEFBQcDAzARBglghkgBhvhC
# AQEEBAMCBBAwSgYDVR0gBEMwQTA1BgwrBgEEAbIxAQIBAwIwJTAjBggrBgEFBQcC
# ARYXaHR0cHM6Ly9zZWN0aWdvLmNvbS9DUFMwCAYGZ4EMAQQBMEkGA1UdHwRCMEAw
# PqA8oDqGOGh0dHA6Ly9jcmwuc2VjdGlnby5jb20vU2VjdGlnb1B1YmxpY0NvZGVT
# aWduaW5nQ0FSMzYuY3JsMHkGCCsGAQUFBwEBBG0wazBEBggrBgEFBQcwAoY4aHR0
# cDovL2NydC5zZWN0aWdvLmNvbS9TZWN0aWdvUHVibGljQ29kZVNpZ25pbmdDQVIz
# Ni5jcnQwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLnNlY3RpZ28uY29tMA0GCSqG
# SIb3DQEBDAUAA4IBgQCOoGdXjP8Sif0h3ZvoDsIVfrJvQUdP9pZExRJGGj/Te6ML
# XyqHNc/G2WklNv+BC4ryNJ4zp0oneHOub55ejrYPfhgP9oFWS8oOPJbrp3rAtINa
# OeKRC88WUYZSKYAxSX6kubEjnQD6cmazXjxVN6P8+6q9smeqF3xI+++c+ekMw3Xv
# 4EWRYXqN0/srfFp1WpoluwSQcZMqj9haSX0bgO6AAWH2AnVJMfXTIKz/0FQ/RW0y
# Ed5QYQqYInhA7IUz9dBziNpJlwONeF5j7xzgfYDY63WU6WrgJnGjYkQCOOsUx74j
# gUiMRe9zV48GS8Vxz22c/TQs0x4/1GmOSJvUHEk3GseBmB3v+yEhh/D6zWOfYP4X
# D/9b91CxmugTuepuaJSeRg+qUm3KarKsOCUF/CLqUrNh/JwKrWD1cghRaYLvMucs
# ScksHHe7ZDvb2OtvxWXjPk1d1NKvEwFJSS6hIVIbug9x28AJqOoP5Pn9wZvJSzvW
# uQJGCLscdGyKefdCo30wggYaMIIEAqADAgECAhBiHW0MUgGeO5B5FSCJIRwKMA0G
# CSqGSIb3DQEBDAUAMFYxCzAJBgNVBAYTAkdCMRgwFgYDVQQKEw9TZWN0aWdvIExp
# bWl0ZWQxLTArBgNVBAMTJFNlY3RpZ28gUHVibGljIENvZGUgU2lnbmluZyBSb290
# IFI0NjAeFw0yMTAzMjIwMDAwMDBaFw0zNjAzMjEyMzU5NTlaMFQxCzAJBgNVBAYT
# AkdCMRgwFgYDVQQKEw9TZWN0aWdvIExpbWl0ZWQxKzApBgNVBAMTIlNlY3RpZ28g
# UHVibGljIENvZGUgU2lnbmluZyBDQSBSMzYwggGiMA0GCSqGSIb3DQEBAQUAA4IB
# jwAwggGKAoIBgQCbK51T+jU/jmAGQ2rAz/V/9shTUxjIztNsfvxYB5UXeWUzCxEe
# AEZGbEN4QMgCsJLZUKhWThj/yPqy0iSZhXkZ6Pg2A2NVDgFigOMYzB2OKhdqfWGV
# oYW3haT29PSTahYkwmMv0b/83nbeECbiMXhSOtbam+/36F09fy1tsB8je/RV0mIk
# 8XL/tfCK6cPuYHE215wzrK0h1SWHTxPbPuYkRdkP05ZwmRmTnAO5/arnY83jeNzh
# P06ShdnRqtZlV59+8yv+KIhE5ILMqgOZYAENHNX9SJDm+qxp4VqpB3MV/h53yl41
# aHU5pledi9lCBbH9JeIkNFICiVHNkRmq4TpxtwfvjsUedyz8rNyfQJy/aOs5b4s+
# ac7IH60B+Ja7TVM+EKv1WuTGwcLmoU3FpOFMbmPj8pz44MPZ1f9+YEQIQty/NQd/
# 2yGgW+ufflcZ/ZE9o1M7a5Jnqf2i2/uMSWymR8r2oQBMdlyh2n5HirY4jKnFH/9g
# Rvd+QOfdRrJZb1sCAwEAAaOCAWQwggFgMB8GA1UdIwQYMBaAFDLrkpr/NZZILyhA
# QnAgNpFcF4XmMB0GA1UdDgQWBBQPKssghyi47G9IritUpimqF6TNDDAOBgNVHQ8B
# Af8EBAMCAYYwEgYDVR0TAQH/BAgwBgEB/wIBADATBgNVHSUEDDAKBggrBgEFBQcD
# AzAbBgNVHSAEFDASMAYGBFUdIAAwCAYGZ4EMAQQBMEsGA1UdHwREMEIwQKA+oDyG
# Omh0dHA6Ly9jcmwuc2VjdGlnby5jb20vU2VjdGlnb1B1YmxpY0NvZGVTaWduaW5n
# Um9vdFI0Ni5jcmwwewYIKwYBBQUHAQEEbzBtMEYGCCsGAQUFBzAChjpodHRwOi8v
# Y3J0LnNlY3RpZ28uY29tL1NlY3RpZ29QdWJsaWNDb2RlU2lnbmluZ1Jvb3RSNDYu
# cDdjMCMGCCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNvbTANBgkqhkiG
# 9w0BAQwFAAOCAgEABv+C4XdjNm57oRUgmxP/BP6YdURhw1aVcdGRP4Wh60BAscjW
# 4HL9hcpkOTz5jUug2oeunbYAowbFC2AKK+cMcXIBD0ZdOaWTsyNyBBsMLHqafvIh
# rCymlaS98+QpoBCyKppP0OcxYEdU0hpsaqBBIZOtBajjcw5+w/KeFvPYfLF/ldYp
# mlG+vd0xqlqd099iChnyIMvY5HexjO2AmtsbpVn0OhNcWbWDRF/3sBp6fWXhz7Dc
# ML4iTAWS+MVXeNLj1lJziVKEoroGs9Mlizg0bUMbOalOhOfCipnx8CaLZeVme5yE
# Lg09Jlo8BMe80jO37PU8ejfkP9/uPak7VLwELKxAMcJszkyeiaerlphwoKx1uHRz
# NyE6bxuSKcutisqmKL5OTunAvtONEoteSiabkPVSZ2z76mKnzAfZxCl/3dq3dUNw
# 4rg3sTCggkHSRqTqlLMS7gjrhTqBmzu1L90Y1KWN/Y5JKdGvspbOrTfOXyXvmPL6
# E52z1NZJ6ctuMFBQZH3pwWvqURR8AgQdULUvrxjUYbHHj95Ejza63zdrEcxWLDX6
# xWls/GDnVNueKjWUH3fTv1Y8Wdho698YADR7TNx8X8z2Bev6SivBBOHY+uqiirZt
# g0y9ShQoPzmCcn63Syatatvx157YK9hlcPmVoa1oDE5/L9Uo2bC5a4CH2Rwwggau
# MIIElqADAgECAhAHNje3JFR82Ees/ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJ
# BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5k
# aWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAe
# Fw0yMjAzMjMwMDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYTAlVTMRcw
# FQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
# ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJUVXHJQPE8pE3qZdRodbSg9Ge
# TKJtoLDMg/la9hGhRBVCX6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0
# hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w1lbU5ygt69OxtXXnHwZl
# jZQp09nsad/ZkIdGAHvbREGJ3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAsh
# aG43IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFkdECnwHLFuk4fsbVY
# TXn+149zk6wsOeKlSNbwsDETqVcplicu9Yemj052FVUmcJgmf6AaRyBD40NjgHt1
# biclkJg6OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTyUpURK1h0QCir
# c0PO30qhHGs4xSnzyqqWc0Jon7ZGs506o9UD4L/wojzKQtwYSH8UNM/STKvvmz3+
# DrhkKvp1KCRB7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfcYd6T/jnA
# +bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwMO1uKIqjBJgj5FBASA31fI7tk42Pg
# puE+9sJ0sj8eCXbsq11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5rmQzS
# M7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQU
# uhbZbU2FL3MpdpovdYxqII+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6
# mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHcGCCsG
# AQUFBwEBBGswaTAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# MEEGCCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRUcnVzdGVkUm9vdEc0LmNydDBDBgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3Js
# My5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAgBgNVHSAE
# GTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggIBAH1Z
# jsCTtm+YqUQiAX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaopafxpwc8d
# B+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQTGIdDAiCqBa9qVbPFXONASIlzpVp
# P0d3+3J0FNf/q0+KLHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQcAp8
# 76i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6wCeCRK6ZJxurJB4mwbfeKuv2
# nrF5mYGjVoarCkXJ38SNoOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3
# ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/a6fxZsNBzU+2QJshIUDQ
# txMkzdwdeDrknq3lNHGS1yZr5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc
# 4d0j/R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT1ObyF5lZynDwN7+Y
# AN8gFk8n+2BnFqFmut1VwDophrCYoCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZ
# vAT6gt4y3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqkhQ/8mJb2VVQr
# H4D6wPIOK+XW+6kvRBVK5xMOHds3OBqhK/bt1nz8MIIGwDCCBKigAwIBAgIQDE1p
# ckuU+jwqSj0pB4A9WjANBgkqhkiG9w0BAQsFADBjMQswCQYDVQQGEwJVUzEXMBUG
# A1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRydXN0ZWQg
# RzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5nIENBMB4XDTIyMDkyMTAwMDAw
# MFoXDTMzMTEyMTIzNTk1OVowRjELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERpZ2lD
# ZXJ0MSQwIgYDVQQDExtEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMiAtIDIwggIiMA0G
# CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDP7KUmOsap8mu7jcENmtuh6BSFdDMa
# JqzQHFUeHjZtvJJVDGH0nQl3PRWWCC9rZKT9BoMW15GSOBwxApb7crGXOlWvM+xh
# iummKNuQY1y9iVPgOi2Mh0KuJqTku3h4uXoW4VbGwLpkU7sqFudQSLuIaQyIxvG+
# 4C99O7HKU41Agx7ny3JJKB5MgB6FVueF7fJhvKo6B332q27lZt3iXPUv7Y3UTZWE
# aOOAy2p50dIQkUYp6z4m8rSMzUy5Zsi7qlA4DeWMlF0ZWr/1e0BubxaompyVR4aF
# eT4MXmaMGgokvpyq0py2909ueMQoP6McD1AGN7oI2TWmtR7aeFgdOej4TJEQln5N
# 4d3CraV++C0bH+wrRhijGfY59/XBT3EuiQMRoku7mL/6T+R7Nu8GRORV/zbq5Xwx
# 5/PCUsTmFntafqUlc9vAapkhLWPlWfVNL5AfJ7fSqxTlOGaHUQhr+1NDOdBk+lbP
# 4PQK5hRtZHi7mP2Uw3Mh8y/CLiDXgazT8QfU4b3ZXUtuMZQpi+ZBpGWUwFjl5S4p
# kKa3YWT62SBsGFFguqaBDwklU/G/O+mrBw5qBzliGcnWhX8T2Y15z2LF7OF7ucxn
# EweawXjtxojIsG4yeccLWYONxu71LHx7jstkifGxxLjnU15fVdJ9GSlZA076XepF
# cxyEftfO4tQ6dwIDAQABo4IBizCCAYcwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB
# /wQCMAAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwIAYDVR0gBBkwFzAIBgZngQwB
# BAIwCwYJYIZIAYb9bAcBMB8GA1UdIwQYMBaAFLoW2W1NhS9zKXaaL3WMaiCPnshv
# MB0GA1UdDgQWBBRiit7QYfyPMRTtlwvNPSqUFN9SnDBaBgNVHR8EUzBRME+gTaBL
# hklodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0
# MDk2U0hBMjU2VGltZVN0YW1waW5nQ0EuY3JsMIGQBggrBgEFBQcBAQSBgzCBgDAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFgGCCsGAQUFBzAC
# hkxodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkRzRS
# U0E0MDk2U0hBMjU2VGltZVN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEBCwUAA4IC
# AQBVqioa80bzeFc3MPx140/WhSPx/PmVOZsl5vdyipjDd9Rk/BX7NsJJUSx4iGNV
# CUY5APxp1MqbKfujP8DJAJsTHbCYidx48s18hc1Tna9i4mFmoxQqRYdKmEIrUPwb
# tZ4IMAn65C3XCYl5+QnmiM59G7hqopvBU2AJ6KO4ndetHxy47JhB8PYOgPvk/9+d
# EKfrALpfSo8aOlK06r8JSRU1NlmaD1TSsht/fl4JrXZUinRtytIFZyt26/+YsiaV
# OBmIRBTlClmia+ciPkQh0j8cwJvtfEiy2JIMkU88ZpSvXQJT657inuTTH4YBZJwA
# wuladHUNPeF5iL8cAZfJGSOA1zZaX5YWsWMMxkZAO85dNdRZPkOaGK7DycvD+5sT
# X2q1x+DzBcNZ3ydiK95ByVO5/zQQZ/YmMph7/lxClIGUgp2sCovGSxVK05iQRWAz
# gOAj3vgDpPZFR+XOuANCR+hBNnF3rf2i6Jd0Ti7aHh2MWsgemtXC8MYiqE+bvdgc
# mlHEL5r2X6cnl7qWLoVXwGDneFZ/au/ClZpLEQLIgpzJGgV8unG1TnqZbPTontRa
# mMifv427GFxD9dAq6OJi7ngE273R+1sKqHB+8JeEeOMIA11HLGOoJTiXAdI/Otrl
# 5fbmm9x+LMz/F0xNAKLY1gEOuIvu5uByVYksJxlh9ncBjDGCBb4wggW6AgEBMGgw
# VDELMAkGA1UEBhMCR0IxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRlZDErMCkGA1UE
# AxMiU2VjdGlnbyBQdWJsaWMgQ29kZSBTaWduaW5nIENBIFIzNgIQIONvbD8YGoFG
# +d6T33yX5DANBglghkgBZQMEAgEFAKCBhDAYBgorBgEEAYI3AgEMMQowCKACgACh
# AoAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAM
# BgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJBDEiBCADqo2tlT/dLaqTjftgfmWMgyB8
# ZBM7ZQGxujbMbnaQXTANBgkqhkiG9w0BAQEFAASCAYC2OQMgGvMe6N6dtyRwZpZv
# iNX2yeoZt34Dd4qV+G1jP13rdWTxMq6cflxClDNvc7nunOr9Wpv+n0Vef25Q75QZ
# bUoktZa0R8kwW/vD+IGo0j/AwTDgr2yrOkMCamCbjggVMiMMRzTgLAsS1/FoBOFk
# WzB84XqhUxz7DS5X+S8+I/6dAY8jHtWbLg24WJ/drzioZFP860n5d/zPujHB4DG6
# ypt4KARDEx2McSsYDs5A2Rc8+foGASNxtHMUaBzRuDk1V9m71tGgvWvLNM8ihCkn
# izVa3abFOEwiRr4QJAl/+9us2gMzFnuK49GdZRDtXn3EcOEdtmFtYpM78MC6XI5L
# TbgXjEOhb9X5xIEgZDD8HOn/J3eqovjSqLYli2IFnkRqHm0NThkb4pOm0F+t/JuX
# sKosluxOVGbTNqBAIYyxTrXIdZBxlJJmp13TxjzYGDyFDXkHmRJUlL/r51Y1MEyg
# ceuBEyqRp1K4Umn3O0/trNP+2op3XvTBxV0pwZEPwByhggMgMIIDHAYJKoZIhvcN
# AQkGMYIDDTCCAwkCAQEwdzBjMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNl
# cnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
# SEEyNTYgVGltZVN0YW1waW5nIENBAhAMTWlyS5T6PCpKPSkHgD1aMA0GCWCGSAFl
# AwQCAQUAoGkwGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjMwNDAyMTUyODIxWjAvBgkqhkiG9w0BCQQxIgQgpoR5qhM/TgsPbrpO99Ef
# eSl5zswpPpbF+qIRzYPMuEMwDQYJKoZIhvcNAQEBBQAEggIAMdNxMr6Hn1rZLLWQ
# Az9dDfOLDrnB4KCMdPEcG0fJ+7J+uciwUHYy5vZZbVmlVjvACRtgOqlcACbJUynU
# wS/wM3rPLyfRmqad8TkxDW0WhtCnIuIbiqTSfeakblYI6poyZ8fOqwvk4uU8GJzd
# Lr3KkogjXS7SlxCUsOPthM/dEZgYf9Hc7ccpK204ku/FNnHBMB4RqZiGzvx/bdmh
# Uxr7zF+u8P2Td8p3/L+9+GSVKbb38Eki/3xS1wBf5SKzyKtkY3CwfA58649d324D
# vIpcXPIZq8HfIUUNl+rm3S7CINv0oxk7YXnp2Q+RaRBKBxz2rYkxVuNdh/y4Vnpl
# 6Vq2L6dIWK5loPBHIrL0QFCOz/zJ8vl3QI7cG/lBTmDWmhqVf4T6Otia0Q4wiuj7
# 9h2bE6Cv/QabK7bjOYB96lPEGLRuNEE4pOM8dFLJMO+M9G/3kZRfjzgQx+QtW5DN
# Aq7FQPhDhpx+KtlXdlYqS2fToMSN9s2+JsNlJ7QbJtKS1yZ1FMgxqqDEuZrOkQ+c
# 4tmSKCk7ttogBrHw5y2dziBM82I5qbCE+MhtA3B1vMk+Gm+4IwCesUX24RiJGO4A
# x6rhmFhTCuedBWD7qR9Na9FyzZB3a8qjaq4Ia1uGo2TgzOo1H1988mIh8VrPV+Ut
# uk2U80S/6+8UCgcQNx167rotS4s=
# SIG # End signature block
