#!/bin/bash

export CurrentFolder=`pwd`

for file in $( find ./NetAppDocs_package -type f -name 'NetAppDocs*.zip' );
    do
        export NetAppDocsPackageFile=$file
        break
    done

if [ ! $NetAppDocsPackageFile ]; then
    echo 'NetAppDocs package file is not present. Unable to continue with install.'
    exit
fi

pwsh -NoProfile -ExecutionPolicy RemoteSigned -Command "& '$CurrentFolder/Install_Script/install.ps1' -ModulePackageFile '$NetAppDocsPackageFile'"
