'''
Created on Feb 26, 2015

@author: tsnguyen
SFR Settings Class
'''



from translator.base.simpletype import SimpleType
from translator.state_type import State
from utils.util import ifcize_param_dict, filter_first
import asaio.cli_interaction as cli_interaction
from translator.structured_cli import convert_to_structured_commands,\
    StructuredCommand

class SFRSubCommands(SimpleType):
    '''
    Class for SFR Sub Command in service policy
    CLI:
    sfr { fail-close | fail-open } [ monitor-only ]
    '''


    def __init__(self):
        SimpleType.__init__(self, ifc_key = 'SFRSettings', asa_key = 'sfr',
                            asa_gen_template='sfr %(fail_mode)s',
                            response_parser = cli_interaction.ignore_warning_response_parser)
    def get_cli(self):
        '''Generate the CLI for this SFR config.
        '''
        if not self.has_ifc_delta_cfg():
            return ''
        config = self.get_value()
        monitor = ''
        if 'monitor_only' in config:
            if config['monitor_only'] == 'enable':
                monitor = ' monitor-only'
        return (self.asa_gen_template % config) + monitor

    def parse_multi_parameter_cli(self, cli, alternate_asa_gen_template = None):
        ''' Parse parameters '''
        result = {}
        data = cli.split()
        result['fail_mode'] = ''
        if len(data) >= 2:
            result['fail_mode'] = data[1]
            if len(data) == 3:
                if data[2] == 'monitor-only':
                    result['monitor_only'] = 'enable'
        return ifcize_param_dict(result)

    def ifc2asa(self, no_asa_cfg_stack, asa_cfg_list):
        """
        Override the default implementation to remove the old value before issue the new command to
        cope with the peculiarity of the CLI on ASA.
        """
        if self.get_action() == State.MODIFY:
            old_cli = self.get_old_cli()
            if old_cli:
                self.generate_cli(no_asa_cfg_stack, 'no ' + old_cli)
        SimpleType.ifc2asa(self, no_asa_cfg_stack, asa_cfg_list)

    def get_old_cli(self):
        '@return the old CLI for modification operation.'
        old_cli = self.delta_ifc_cfg_value.get('old_cli')
        if old_cli:
            return old_cli
        query_cmd = "show run " + self.mode_command[0]
        asa_config = self.query_asa(query_cmd)
        if not asa_config:
            return
        asa_config = filter(lambda cli: cli != '!', asa_config.split('\n'))
        clis = convert_to_structured_commands(asa_config)
        class_cmd = filter_first(lambda cmd: isinstance(cmd, StructuredCommand) and
                                 cmd.command == self.mode_command[1],
                                 clis[0].sub_commands)
        if not class_cmd:
            return
        old_cli = filter_first(lambda cmd: cmd.startswith(self.asa_key), class_cmd.sub_commands)
        self.delta_ifc_cfg_value['old_cli'] = old_cli
        return old_cli.strip() if old_cli else None

    def diff_ifc_asa(self, cli):
        'Override the default implementation to remember the old cli for deletion purpose'
        SimpleType.diff_ifc_asa(self, cli)
        self.delta_ifc_cfg_value['old_cli'] = cli
