'''
Created on Oct 9, 2013

Exception classes for device package

@author: dli
'''
class ConnectionError(Exception):
    def __init__(self, message):
        Exception.__init__(self, message)

class ConfigurationError(Exception):
    def __init__(self, fault_list):
        self.fault_list = fault_list

class IFCConfigError(ConfigurationError):
    def __init__(self, fault_list):
        ConfigurationError.__init__(self, fault_list)

class ASACommandError(ConfigurationError):
    def __init__(self, fault_list):
        ConfigurationError.__init__(self, fault_list)

class ASABusyError(Exception):
    def __init__(self, message):
        Exception.__init__(self, message)

class DeviceParameterError(Exception):
    def __init__(self, message):
        Exception.__init__(self, message)

class FaultCode(object):
    CONFIGURATION_ERROR=10
    CONNECTION_ERROR=20
    UNEXPECTED_ERROR=30
    UNSUPPORTED_ASA=40
    BUSY_ERROR=50
    LINE_STATUS_ERROR=60
    DEVICE_PARAMETER_ERROR=70
