'''
Created on Oct 18, 2017

@author: dli
'''
from translator.base.dmlist import DMList
from translator.base.dmobject import DMObject
from translator.base.simpletype import SimpleType
from translator.state_type import State

class Banner(DMObject):
    '''
    Model after a 'banner motd' on ASA
    '''

    def __init__(self):
        DMObject.__init__(self, Banner.__name__)
        self.register_child(MOTDList())

class MOTDList(DMList):
    def __init__(self):
        DMList.__init__(self, 'motd', MOTD, 'banner motd')

    def ifc2asa(self, no_asa_cfg_stack, asa_cfg_list):
        '''
        Override the default so that we order the rules according to the ifc_keys
        Also, one cannot delete individual line. On modifying the motd, we need to
        delete all the lines, and the add back existing lines.
        '''
        states = map(lambda line: line.get_state(), self)
        if not states:
            return
        if all(map(lambda state: state == State.DESTROY, states)):
            self.generate_cli(no_asa_cfg_stack, 'no ' + self.asa_key)
            return
        if State.DESTROY in states or State.MODIFY in states:
            for key, child in self.children.items():
                if child.get_state() == State.DESTROY:
                    del(self.children[key])
                else:
                    child.set_state(State.CREATE)
            self.generate_cli(no_asa_cfg_stack, 'no ' + self.asa_key)

        # generate the CLI ordered by the ifc_key
        child_values = self.children.values()
        child_values.sort(key=lambda value: value.ifc_key)
        for child in child_values:
            child.ifc2asa(no_asa_cfg_stack, asa_cfg_list)

class MOTD(SimpleType):
    def __init__(self, name):
        SimpleType.__init__(self, ifc_key = name, asa_key='banner motd')

    def is_my_cli(self, cli):
        if isinstance(cli, basestring):
            return cli == self.get_cli()

    def get_cli(self):
        'Override the default implementation to take care of the case when the field is empty'
        value = self.get_value()
        if not value:
            return self.asa_key
        else:
            return SimpleType.get_cli(self)

    def parse_cli(self, cli):
        'Override default implementation because the value is multiple words'
        if cli.strip() == self.asa_key:
            return ''
        return cli[len(self.asa_key)+1:]
