'''
Created on Apr 24, 2014

The module contains objects for empty "object" CLI's,
   - object network <name>
   - object service <name>

They are used to clean up empty object CLIs during clusterAudit call.

They cannot be directly manipulated by south bound or north bound APIs.

See CSCuo28043

Note: empty "object-group" CLIs are already handled in service_object_group  and network_object_group modules.

@author: dli
'''

from base.dmobject import DMObject
from base.simpletype import SimpleType
from base.dmlist import DMList

class EmptyObjectsList(DMObject):
    'Container of all empty "object" CLIs'
    def __init__(self):
        DMObject.__init__(self, EmptyObjectsList.__name__)
        clis = ('object network', 'object service')
        for cli in clis:
            self.register_child(EmptyObjects(cli))

class EmptyObjects(DMList):
    """
    Base class for all empty "object network" and "object service" CLIs'.
    Each instance of this class represents the collection of all instances of a given type of "object" CLIs,
    such as "object network".
    """
    def __init__(self, name):
        DMList.__init__(self, name, SimpleType, asa_key = name)

    def is_my_cli(self, cli):
        if isinstance(cli, basestring):
            'No sub-command'
            return cli.startswith(self.asa_key)

    def register_child(self, child):
        DMList.register_child(self, child)
        child.asa_gen_template = self.asa_key + ' %s'
