'''
Created on Dec 10, 2013

@author: tsnguyen
Inspection Settings Class
'''


from translator.base.dmobject import DMObject
from translator.base.dmboolean import DMBoolean
from translator.state_type import State

class InspectionSubCommands(DMObject):
    '''
    Class for Inspect Sub Command in service policy
    '''


    CLASS_MAP_INSPECT_CLI = "class-map inspection_default"
    MATCH_DEFAULT_INSPECT_CLI = "match default-inspection-traffic"

    ifc_asa_keys = [
                # IFC key      ASA CLI
                ("ctiqbe",  "inspect ctiqbe"),
                ("dcerpc",  "inspect dcerpc"),
                ("dns_preset","inspect dns preset_dns_map"),
                ("dns",     "inspect dns"),
                ("esmtp",   "inspect esmtp"),
                ("ftp_strict","inspect ftp strict"),
                ("ftp",     "inspect ftp"),
                ("gtp",     "inspect gtp"),
                ("h323_h225","inspect h323 h225"),
                ("h323_ras", "inspect h323 ras"),
                ("http",    "inspect http"),
                ("icmp_error","inspect icmp error"),
                ("icmp",    "inspect icmp"),
                ("ils",     "inspect ils"),
                ("ip_options","inspect ip-options"),
                ("ipsec_pass_thru","inspect ipsec-pass-thru"),
                ("mgcp",    "inspect mgcp"),
                ("mmp",     "inspect mmp"),
                ("netbios", "inspect netbios"),
                ("pptp",    "inspect pptp"),
                ("rsh",     "inspect rsh"),
                ("rtsp",    "inspect rtsp"),
                ("sip",     "inspect sip"),
                ("skinny",  "inspect skinny"),
                ("snmp",    "inspect snmp"),
                ("sqlnet",  "inspect sqlnet"),
                ("sunrpc",  "inspect sunrpc"),
                ("tftp",    "inspect tftp"),
                ("waas",    "inspect waas"),
                ("xdmcp",   "inspect xdmcp")
                ]

    def __init__(self):
        '''
        Constructor
        '''
        DMObject.__init__(self, ifc_key = 'InspectionSettings', asa_key = 'inspect')
        self.mode_command = None
        for ifc, cli_prefix in InspectionSubCommands.ifc_asa_keys:
            self.register_child(DMBoolean(ifc, cli_prefix))

        self.dns_preset_map = DNSPresetMap()
        self.dns_preset_map.parent = self

    def ifc2asa(self, no_asa_cfg_stack, asa_cfg_list):
        ''' Translate IFC config to ASA config  '''
        if not self.has_ifc_delta_cfg():
            return
        self.dns_preset_map.ifc2asa(no_asa_cfg_stack, asa_cfg_list)
        for child in self:
            child.mode_command = self.mode_command
        DMObject.ifc2asa(self, no_asa_cfg_stack, asa_cfg_list)

    def populate_model(self, delta_ifc_key, delta_ifc_cfg_value):
        '''
        Override the default implementation to take care of preset_dns_map policy-map
        '''
        DMObject.populate_model(self, delta_ifc_key, delta_ifc_cfg_value)
        dns_preset = self.get_child('dns_preset')
        state =  dns_preset.get_state()
        self.dns_preset_map.set_state(State.CREATE if state and state == State.CREATE else State.NOCHANGE)

class DNSPresetMap(DMObject):
    '''
    Model after following commands:
        policy-map type inspect dns preset_dns_map
         parameters
          message-length maximum 512
    '''
    def __init__(self):
        self.state = State.NOCHANGE
        self.mode_command = ('policy-map type inspect dns preset_dns_map', 'parameters')

    def set_state(self, state):
        self.state = state

    def ifc2asa(self, no_asa_cfg_stack, asa_cfg_list):
        if self.state == State.CREATE:
            self.generate_cli(asa_cfg_list, 'message-length maximum 512')

