'''
Created on Dec 18, 2013

@author: linlilia

Copyright (c) 2013 by Cisco Systems

This module is for the support of Smart Call Home.

In current phase, only Anonymous Reporting, the subfeature of SCH, is supported to allow Cisco
to anonymously receive minimal error and health information from the device.

CLI to enable the Anonymous Reporting feature and create a new anonymous profile:
    call-home reporting anonymous
'''
from translator.base.dmobject import DMObject
from base.dmboolean import DMBoolean
from translator.validators import AdminContextValidator

class SmartCallHome(DMObject):
    '''
    Container of Smart Call Home Feature
    '''
    def __init__(self, is_multi_mode_asa):
        DMObject.__init__(self, SmartCallHome.__name__)
        self.register_child(AnonymousReporting(is_multi_mode_asa))
        self.is_system_context = is_multi_mode_asa

class AnonymousReporting(DMBoolean, AdminContextValidator):
    def __init__(self, is_multi_mode_asa):
        DMBoolean.__init__(self,
                           ifc_key = 'anonymous_reporting',
                           asa_key = 'call-home reporting anonymous',
                           on_value = 'enable',
                           response_parser = self.ignore_msg_response_parser,
                           is_system_context = is_multi_mode_asa)

    @staticmethod
    def ignore_msg_response_parser(response):
        'Ignores response "Creating trustpoint...", otherwise returns original'
        if response:
            if "Creating trustpoint" in response:
                return None
            return response
        else:
            return None
