/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin;

import com.vmware.vise.data.uri.ResourceTypeResolver;
import java.net.URI;
import java.net.URISyntaxException;

public class ModelObjectUriResolver
implements ResourceTypeResolver {
    private static final String SCHEME = "urn";
    private static final String NAMESPACE = "cr";
    private static final String UID_PREFIX = "urn:cr";
    private static final String TYPE_DELIMITER = ":";
    private static final String FRAGMENT_SEPARATOR = "/";

    public String getResourceType(URI uri) {
        if (!this.isValid(uri)) {
            this.throwExceptionForInvalidURI(uri);
        }
        return this.parseUri(uri, true);
    }

    public String getServerGuid(URI uri) {
        String id = this.getId(uri);
        int fragmentSeparatorIndex = id.indexOf(FRAGMENT_SEPARATOR);
        if (fragmentSeparatorIndex <= 0) {
            this.throwExceptionForInvalidURI(uri);
        }
        return id.substring(0, fragmentSeparatorIndex);
    }

    public String getId(URI uri) {
        if (!this.isValid(uri)) {
            this.throwExceptionForInvalidURI(uri);
        }
        return this.parseUri(uri, false);
    }

    public String getUid(URI uri) {
        if (!this.isValid(uri)) {
            this.throwExceptionForInvalidURI(uri);
        }
        return uri.toString();
    }

    public URI createUri(String type, String id) {
        if (type == null || type.length() < 1) {
            throw new IllegalArgumentException("type must be non-null.");
        }
        if (id == null || id.length() < 1) {
            throw new IllegalArgumentException("id must be non-null.");
        }
        URI uri = null;
        try {
            String schemeSpecificPart = "cr:" + type + TYPE_DELIMITER + id;
            String fragment = null;
            uri = new URI(SCHEME, schemeSpecificPart, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    public String createResourceId(String serverGuid, String objectId) {
        String id = serverGuid + FRAGMENT_SEPARATOR + objectId;
        return id;
    }

    public boolean isValid(URI uri) {
        return uri != null && uri.toString().startsWith(UID_PREFIX);
    }

    private String parseUri(URI uri, boolean parseType) {
        String ssPart = uri.getSchemeSpecificPart();
        int typeIndex = ssPart.indexOf(TYPE_DELIMITER);
        int resourceIndex = (ssPart = ssPart.substring(typeIndex + 1)).lastIndexOf(TYPE_DELIMITER);
        if (resourceIndex == -1) {
            String message = "Invalid URI, missing type delimiter: " + this.toString(uri);
            throw new IllegalArgumentException(message);
        }
        String result = parseType ? ssPart.substring(0, resourceIndex) : ssPart.substring(resourceIndex + 1);
        return result;
    }

    private void throwExceptionForInvalidURI(URI uri) {
        throw new IllegalArgumentException("URI " + this.toString(uri) + " is invalid for this resolver.");
    }

    private String toString(URI uri) {
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }
}

