/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.handles.ApiSpecUtil;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.api.ComputeApi;
import com.cisco.aci.vcplugin.swagger.model.ApiSpec;
import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ComputeApiController
implements ComputeApi {
    private final WrapperService _wrapper;
    private final HttpServletRequest _request;
    private final VcpLogger log = new VcpLogger();

    @Autowired
    public ComputeApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper) {
        this._wrapper = wrapper;
        this._request = request;
    }

    @Override
    public ResponseEntity<List<EsxHost>> vcenterIdComputeHostsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="IDs of object to query") @Valid @RequestParam(value="ids", required=false) List<String> ids, @ApiParam(value="Filter based on VMM domain") @Valid @RequestParam(value="domain", required=false) String domain, @ApiParam(value="Filter based on Datacenter") @Valid @RequestParam(value="datacenter", required=false) String datacenter, @ApiParam(value="Properties to includes", allowableValues="ave, datastore") @Valid @RequestParam(value="include", required=false) List<String> include, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        Vcenter server;
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        String user = this._wrapper.getUsername();
        VCenterSdk sdk = AaaApiController.getVCHandle(user, (server = this._wrapper.getVCenterInfo(id)).getGuid());
        if (sdk == null) {
            sdk = new VCenterSdk(user, server);
        }
        if (include != null && include.contains("ave") && domain == null) {
            return ResponseUtils.getErrorResponse("Can't use the 'ave' include without the 'domain' property specified", HttpStatus.BAD_REQUEST);
        }
        ApiSpec spec = ApiSpecUtil.all();
        if (datacenter != null) {
            spec = ApiSpecUtil.parentSpec("Datacenter", datacenter);
        }
        this.log.info("includes:" + include);
        if (ids != null && ids.size() > 0) {
            spec.setIdList(ids);
            this.log.info("setting spec id list:" + ids);
        }
        List<EsxHost> esxs = null;
        try {
            esxs = sdk.getEsxHosts(spec, include, domain);
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = e.getMessage();
            this.log.error(msg);
            if (msg.contains("incorrect user name or password")) {
                this.log.error("VC handle is not authenticated due to bad credentials");
                this.log.error("Invalidating cached connections to vc");
                sdk.invalidateCachedSessions();
                this.log.error("Invalidated cached connections to vc");
                this.log.error("Updating vc handle in map with cache removed");
                AaaApiController.insertVCHandle(user, server.getGuid(), sdk);
            }
            return ResponseUtils.getExceptionResponse(e);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(esxs);
    }

    @Override
    public ResponseEntity<EsxHost> vcentersIdComputeHostsHostOidGet(String id, String hostOid, List<String> include) {
        return null;
    }
}

