/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.api.builders.PageQueryBuilder;
import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.api.DomainApi;
import com.cisco.aci.vcplugin.swagger.api.VcenterApi;
import com.cisco.aci.vcplugin.swagger.model.Epg;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.swagger.model.VmmDomain;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import com.cisco.apic.util.ApicMoOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DomainApiController
implements DomainApi {
    private final WrapperService _wrapper;
    private final HttpServletRequest _request;
    private final VcpLogger log = new VcpLogger();
    private VcenterApi vcenterApi;

    public void setVcenterApi(VcenterApi api) {
        this.vcenterApi = api;
    }

    @Autowired
    public DomainApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper) {
        this._wrapper = wrapper;
        this._request = request;
    }

    @Override
    public ResponseEntity<List<Epg>> fabricsIdDomainsDomNameEpgsGet(@PathVariable(value="id") String id, @PathVariable(value="domName") String domName, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer size, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            List<Epg> epgs;
            if (count.booleanValue()) {
                int epgCount = sdk.getEpgsForDomCount(domName, propValue);
                return ResponseUtils.getCountResponse(epgCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, size);
            try {
                epgs = sdk.getEpgsFromDomain(domName, this._wrapper.getVCenters(), this._wrapper.getUsername(), propValue, pqb);
            }
            catch (Exception excep) {
                excep.printStackTrace();
                return ResponseUtils.getExceptionResponse(excep);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(epgs);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<List<VmmDomain>> fabricsIdDomainsGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="aveOnly", required=false, defaultValue="false") Boolean aveOnly, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        String username = this._wrapper.getUsername();
        List<Vcenter> vcenters = this._wrapper.getVCenters();
        ArrayList<VCenterSdk> sdks = new ArrayList<VCenterSdk>();
        for (Vcenter vc : vcenters) {
            VCenterSdk vcsdk = new VCenterSdk(username, vc);
            sdks.add(vcsdk);
        }
        try {
            if (count.booleanValue()) {
                return ResponseUtils.getCountResponse(sdk.getDomainsCount(vcenters, aveOnly, propValue));
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, pageSize);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(sdk.getDomains(vcenters, sdks, aveOnly, propValue, pqb));
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
    }
}

