/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.api.FabricApi;
import com.cisco.aci.vcplugin.swagger.model.Fabric;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import com.cisco.apic.util.ApicMoOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class FabricApiController
implements FabricApi {
    private final WrapperService _wrapper;
    private HttpServletRequest _request;
    private final VcpLogger log = new VcpLogger();

    public FabricApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper) {
        this._wrapper = wrapper;
        this._request = request;
    }

    @Override
    public ResponseEntity<List<Fabric>> fabricsGet(@Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        Map<String, ApicSdk> map = AaaApiController.getUserHandleMap(this._wrapper.getUsername());
        ArrayList<Fabric> result = new ArrayList<Fabric>();
        if (map != null) {
            for (String key : map.keySet()) {
                ApicSdk apicSdk = map.get(key);
                result.add(apicSdk.getFabric());
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(result);
    }

    public ResponseEntity fabricsIdApicsGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (sdk != null) {
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(sdk.getApics());
            }
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
        return ResponseUtils.getErrorResponse("Fabric ID " + id + " not found", HttpStatus.NOT_FOUND);
    }

    @Override
    public ResponseEntity<Fabric> fabricsIdGet(String id) {
        return null;
    }

    @Override
    public ResponseEntity<Fabric> fabricsIdRefreshGet(String id) {
        return null;
    }
}

