/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api.builders;

import com.cisco.aci.vcplugin.api.builders.OrderQueryBuilder;
import com.cisco.aci.vcplugin.api.builders.PageQueryBuilder;
import com.cisco.apic.ApicHandle;
import com.cisco.apic.ManagedObject;
import com.cisco.apic.util.ApicMoOperationException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ManagedObjectQueryBuilder {
    private List<ManagedObject> _inMos;
    private String _moClassName;
    private Map _moParams;
    private String _queryTargetFilter;
    private String _queryTarget;
    private String _targetSubtreeClasses;
    private String _rspSubtree;
    private String _rspSubtreeClass;
    private String _rspSubtreeFilter;
    private String _rspSubtreeInclude;
    private OrderQueryBuilder _orderQb;
    private PageQueryBuilder _pageQb;

    public ManagedObjectQueryBuilder withInMos(List<ManagedObject> inMos) {
        this._inMos = inMos;
        return this;
    }

    public ManagedObjectQueryBuilder withMoClassName(String moClassName) {
        this._moClassName = moClassName;
        return this;
    }

    public ManagedObjectQueryBuilder withMoParams(Map moParams) {
        this._moParams = moParams;
        return this;
    }

    public ManagedObjectQueryBuilder withQueryTargetFilter(String queryTargetFilter) {
        this._queryTargetFilter = queryTargetFilter;
        return this;
    }

    public ManagedObjectQueryBuilder addQueryTargetFilter(String additionalQueryTargetFilter) {
        if (additionalQueryTargetFilter == null) {
            return this;
        }
        if (this._queryTargetFilter == null) {
            return this.withQueryTargetFilter(additionalQueryTargetFilter);
        }
        if (this._queryTargetFilter.contains("and(")) {
            this._queryTargetFilter = this._queryTargetFilter.substring(0, this._queryTargetFilter.length() - 1);
            this._queryTargetFilter = this._queryTargetFilter + "," + additionalQueryTargetFilter + ")";
            return this;
        }
        this._queryTargetFilter = "and(" + this._queryTargetFilter + "," + additionalQueryTargetFilter + ")";
        return this;
    }

    public ManagedObjectQueryBuilder addOptionalQueryTargetFilter(String additionalQueryTargetFilter) {
        if (additionalQueryTargetFilter == null) {
            return this;
        }
        if (this._queryTargetFilter == null) {
            return this.withQueryTargetFilter(additionalQueryTargetFilter);
        }
        if (this._queryTargetFilter.contains("or(")) {
            this._queryTargetFilter = this._queryTargetFilter.substring(0, this._queryTargetFilter.length() - 1);
            this._queryTargetFilter = this._queryTargetFilter + "," + additionalQueryTargetFilter + ")";
            return this;
        }
        this._queryTargetFilter = "or(" + this._queryTargetFilter + "," + additionalQueryTargetFilter + ")";
        return this;
    }

    public ManagedObjectQueryBuilder withQueryTarget(String queryTarget) {
        this._queryTarget = queryTarget;
        return this;
    }

    public ManagedObjectQueryBuilder withTargetSubtreeClasses(String targetSubtreeClasses) {
        this._targetSubtreeClasses = targetSubtreeClasses;
        return this;
    }

    public ManagedObjectQueryBuilder withRspSubtree(String rspSubtree) {
        this._rspSubtree = rspSubtree;
        return this;
    }

    public ManagedObjectQueryBuilder withRspSubtreeClass(String rspSubtreeClass) {
        this._rspSubtreeClass = rspSubtreeClass;
        return this;
    }

    public ManagedObjectQueryBuilder withRspSubtreeFilter(String rspSubtreeFilter) {
        this._rspSubtreeFilter = rspSubtreeFilter;
        return this;
    }

    public ManagedObjectQueryBuilder withRspSubtreeInclude(String rspSubtreeInclude) {
        this._rspSubtreeInclude = rspSubtreeInclude;
        return this;
    }

    public ManagedObjectQueryBuilder withOrderQuery(OrderQueryBuilder oqb) {
        this._orderQb = oqb;
        return this;
    }

    public ManagedObjectQueryBuilder withPagination(PageQueryBuilder pqb) {
        this._pageQb = pqb;
        return this;
    }

    public String getRspSubtreeInclude() {
        return this._rspSubtreeInclude;
    }

    public String getQueryTargetFilter() {
        return this._queryTargetFilter;
    }

    public List<ManagedObject> getManagedObjectsFromBuilder(ApicHandle handle) throws ApicMoOperationException {
        List mos;
        if (Optional.ofNullable(this._orderQb).isPresent()) {
            this._rspSubtreeInclude = this._rspSubtreeInclude + this._orderQb.generateQueryString();
        }
        if (Optional.ofNullable(this._pageQb).isPresent()) {
            this._rspSubtreeInclude = this._rspSubtreeInclude + this._pageQb.generateQueryString();
        }
        if ((mos = handle.getManagedObjects(this._inMos, this._moClassName, this._moParams, this._queryTargetFilter, this._queryTarget, this._targetSubtreeClasses, this._rspSubtree, this._rspSubtreeClass, this._rspSubtreeFilter, this._rspSubtreeInclude)) == null) {
            return Collections.emptyList();
        }
        return mos;
    }

    public static String createWildcardFilter(String className, String property, String propValue) {
        return String.format("wcard(%s.%s, \"%s\")", className, property, propValue);
    }

    public static String createEqFilter(String className, String property, String propValue) {
        return String.format("eq(%s.%s, \"%s\")", className, property, propValue);
    }

    public static ManagedObjectQueryBuilder getMoqbForClass(String className, String propValue) {
        String rspSubtreeInclude = "health,fault-count";
        String wcardFilter = propValue.isEmpty() ? null : ManagedObjectQueryBuilder.createWildcardFilter(className, "name", propValue);
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        moqb.withMoClassName(className).withQueryTargetFilter(wcardFilter).withRspSubtreeInclude(rspSubtreeInclude);
        return moqb;
    }

    public static ManagedObjectQueryBuilder getMoqbForClass(String className, List<ManagedObject> inMos, String propValue) {
        String rspSubtreeInclude = "health,fault-count";
        String wcardFilter = propValue.isEmpty() ? null : ManagedObjectQueryBuilder.createWildcardFilter(className, "name", propValue);
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        moqb.withMoClassName(className).withQueryTargetFilter(wcardFilter).withInMos(inMos).withRspSubtreeInclude(rspSubtreeInclude);
        return moqb;
    }
}

