/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.event.listener;

import com.cisco.aci.vcplugin.event.VcpObserver;
import com.cisco.aci.vcplugin.log.VcpLogger;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EventListener
extends VcpObserver
implements Runnable {
    protected int THREAD_SLEEP = 1000;
    protected String _username;
    protected Map<String, Integer> _apis;
    protected Thread _listenerThread;
    protected boolean _running;
    protected boolean _initialized = false;
    private VcpLogger log = new VcpLogger();

    public EventListener(String username) {
        this._username = username;
        this._apis = new ConcurrentHashMap<String, Integer>();
    }

    public void start() {
        if (!this._initialized) {
            this.log.info("not starting since not yet initialized");
            return;
        }
        this.log.info("starting listener thread");
        this._running = true;
        this._listenerThread = new Thread(this);
        this._listenerThread.start();
    }

    public void stop() {
        this._running = false;
        this._listenerThread = null;
        this.log.info("stopping listener thread");
    }

    public void addApi(String api) {
        Integer currentCount;
        Integer n = currentCount = this._apis.containsKey(api) ? this._apis.get(api) : Integer.valueOf(0);
        Integer n2 = currentCount = Integer.valueOf(currentCount + 1);
        this._apis.put(api, currentCount);
        if (this._apis.keySet().size() > 0 && !this._running) {
            this.start();
        }
    }

    public void removeApi(String api) {
        if ("*".equals(api)) {
            this.removeAllApis();
        } else {
            Integer currentCount;
            Integer n = currentCount = this._apis.containsKey(api) ? this._apis.get(api) : Integer.valueOf(0);
            Integer n2 = currentCount = Integer.valueOf(currentCount - 1);
            if (currentCount < 0) {
                return;
            }
            if (currentCount == 0) {
                this._apis.remove(api);
            } else {
                this._apis.put(api, currentCount);
            }
        }
        if (this._apis.keySet().size() == 0 && this._running) {
            this.stop();
        }
    }

    public void removeAllApis() {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (String url : this._apis.keySet()) {
            Integer currentCount;
            Integer n = currentCount = this._apis.get(url);
            Integer n2 = currentCount = Integer.valueOf(currentCount - 1);
            if (currentCount == 0) {
                toDelete.add(url);
                continue;
            }
            this._apis.put(url, currentCount);
        }
        for (String url : toDelete) {
            this._apis.remove(url);
        }
    }

    public abstract void doEventProcessing();

    @Override
    public void run() {
        this.log.info("event listener started for " + this._username);
        while (this._running) {
            this.doEventProcessing();
            try {
                Thread.sleep(this.THREAD_SLEEP);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.log.info("event listener stopped for " + this._username);
    }

    public boolean isRunning() {
        return this._running;
    }
}

