/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.handles;

import com.cisco.aci.vcplugin.Constants;
import com.cisco.aci.vcplugin.api.builders.ManagedObjectQueryBuilder;
import com.cisco.aci.vcplugin.api.builders.OrderQueryBuilder;
import com.cisco.aci.vcplugin.api.builders.PageQueryBuilder;
import com.cisco.aci.vcplugin.handles.ApiSpecUtil;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.model.AciMo;
import com.cisco.aci.vcplugin.swagger.model.Apic;
import com.cisco.aci.vcplugin.swagger.model.App;
import com.cisco.aci.vcplugin.swagger.model.Bd;
import com.cisco.aci.vcplugin.swagger.model.Contract;
import com.cisco.aci.vcplugin.swagger.model.CustomDefinition;
import com.cisco.aci.vcplugin.swagger.model.Datacenter;
import com.cisco.aci.vcplugin.swagger.model.Dvs;
import com.cisco.aci.vcplugin.swagger.model.Endpoint;
import com.cisco.aci.vcplugin.swagger.model.Entry;
import com.cisco.aci.vcplugin.swagger.model.Epg;
import com.cisco.aci.vcplugin.swagger.model.EpgDomainSettings;
import com.cisco.aci.vcplugin.swagger.model.Fabric;
import com.cisco.aci.vcplugin.swagger.model.Fault;
import com.cisco.aci.vcplugin.swagger.model.FaultsCount;
import com.cisco.aci.vcplugin.swagger.model.Filter;
import com.cisco.aci.vcplugin.swagger.model.LagPolicy;
import com.cisco.aci.vcplugin.swagger.model.PermissionMap;
import com.cisco.aci.vcplugin.swagger.model.Pod;
import com.cisco.aci.vcplugin.swagger.model.PortGroup;
import com.cisco.aci.vcplugin.swagger.model.PrivilegeList;
import com.cisco.aci.vcplugin.swagger.model.PrivilegeMap;
import com.cisco.aci.vcplugin.swagger.model.RBAC;
import com.cisco.aci.vcplugin.swagger.model.Status;
import com.cisco.aci.vcplugin.swagger.model.StatusLevel;
import com.cisco.aci.vcplugin.swagger.model.Subnet;
import com.cisco.aci.vcplugin.swagger.model.SystemHealth;
import com.cisco.aci.vcplugin.swagger.model.Tenant;
import com.cisco.aci.vcplugin.swagger.model.USegAttribute;
import com.cisco.aci.vcplugin.swagger.model.USegCriterion;
import com.cisco.aci.vcplugin.swagger.model.USegSubCriterion;
import com.cisco.aci.vcplugin.swagger.model.VNode;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.swagger.model.VirtualMachine;
import com.cisco.aci.vcplugin.swagger.model.VmmDomain;
import com.cisco.aci.vcplugin.swagger.model.Vrf;
import com.cisco.aciPluginServices.core.Utils;
import com.cisco.apic.ApicBase;
import com.cisco.apic.ApicHandle;
import com.cisco.apic.ApicUserPermission;
import com.cisco.apic.ManagedObject;
import com.cisco.apic.MethodFactory;
import com.cisco.apic.gson.AaaUserDomainGson;
import com.cisco.apic.gson.DnDomainMapEntryGson;
import com.cisco.apic.gson.WhoAmIChild;
import com.cisco.apic.gson.WhoAmIGson;
import com.cisco.apic.method.AaaLogin;
import com.cisco.apic.method.helper.imdata;
import com.cisco.apic.mo.compCtrlr;
import com.cisco.apic.mo.fabricNode;
import com.cisco.apic.mo.fabricOverallHealthHist5min;
import com.cisco.apic.mo.faultCounts;
import com.cisco.apic.mo.faultCountsWithDetails;
import com.cisco.apic.mo.faultDelegate;
import com.cisco.apic.mo.faultInst;
import com.cisco.apic.mo.firmwareCtrlrRunning;
import com.cisco.apic.mo.fvAEPg;
import com.cisco.apic.mo.fvAEPgLagPolAtt;
import com.cisco.apic.mo.fvAp;
import com.cisco.apic.mo.fvBD;
import com.cisco.apic.mo.fvCEp;
import com.cisco.apic.mo.fvCrtrn;
import com.cisco.apic.mo.fvCtx;
import com.cisco.apic.mo.fvIpAttr;
import com.cisco.apic.mo.fvMacAttr;
import com.cisco.apic.mo.fvRsBDToOut;
import com.cisco.apic.mo.fvRsBd;
import com.cisco.apic.mo.fvRsCons;
import com.cisco.apic.mo.fvRsConsIf;
import com.cisco.apic.mo.fvRsCtx;
import com.cisco.apic.mo.fvRsDomAtt;
import com.cisco.apic.mo.fvRsProv;
import com.cisco.apic.mo.fvRsToVm;
import com.cisco.apic.mo.fvRsVm;
import com.cisco.apic.mo.fvRsVmmVSwitchEnhancedLagPol;
import com.cisco.apic.mo.fvRtCtx;
import com.cisco.apic.mo.fvRtEBd;
import com.cisco.apic.mo.fvSCrtrn;
import com.cisco.apic.mo.fvSubnet;
import com.cisco.apic.mo.fvTenant;
import com.cisco.apic.mo.fvVmAttr;
import com.cisco.apic.mo.healthInst;
import com.cisco.apic.mo.hvsExtPol;
import com.cisco.apic.mo.hvsLNode;
import com.cisco.apic.mo.hvsRsEpPD;
import com.cisco.apic.mo.infraEpPD;
import com.cisco.apic.mo.infraWiNode;
import com.cisco.apic.mo.lacpEnhancedLagPol;
import com.cisco.apic.mo.moCount;
import com.cisco.apic.mo.polUni;
import com.cisco.apic.mo.topSystem;
import com.cisco.apic.mo.vmmDomP;
import com.cisco.apic.mo.vzBrCP;
import com.cisco.apic.mo.vzCPIf;
import com.cisco.apic.mo.vzConsDef;
import com.cisco.apic.mo.vzEntry;
import com.cisco.apic.mo.vzFilter;
import com.cisco.apic.mo.vzInTerm;
import com.cisco.apic.mo.vzIntDef;
import com.cisco.apic.mo.vzRsFiltAtt;
import com.cisco.apic.mo.vzRsIf;
import com.cisco.apic.mo.vzRsSubjFiltAtt;
import com.cisco.apic.mo.vzRtCons;
import com.cisco.apic.mo.vzRtProv;
import com.cisco.apic.mo.vzSubj;
import com.cisco.apic.util.ApicMoOperationException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import vim25.ManagedObjectReference;

public class ApicSdk {
    private ApicHandle _handle;
    private final VcpLogger log = new VcpLogger();
    private final String _fabricId;
    private final String _apicUser;
    private final String _apicPassword;
    private final String _apicUrl;
    private final String _fabricName;
    private final String _apicVersion;

    public ApicSdk(ApicHandle handle, String fabricId, String apicUser, String apicPassword, String apicUrl, String fabricName) {
        this._fabricId = fabricId;
        this._handle = handle;
        this._apicUser = apicUser;
        this._apicPassword = apicPassword;
        this._apicUrl = apicUrl;
        this._fabricName = fabricName;
        this._apicVersion = this.retrieveApicVersion();
    }

    public ApicHandle getHandle() {
        return this._handle;
    }

    public String getApicUrl() {
        return this._apicUrl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApicSdk {\n");
        sb.append(" fabricId:   ").append(this._fabricId).append("\n");
        sb.append("  apicUrl: ").append(this._apicUrl).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String getApicVersion() {
        return this._apicVersion;
    }

    public String retrieveApicVersion() {
        this.log.info("Getting version using aaaLogin");
        AaaLogin response = MethodFactory.getAaaLogin((ApicHandle)this._handle, (String)this._apicUser, (String)this._apicPassword);
        if (response != null && response.getVersion() != null) {
            return response.getVersion();
        }
        this.log.info("Failed to fetch aaaLogin");
        String versionUrl = this.getApicUrl() + "/insieme/stromboli/meta/Version.js";
        this.log.info("Fetching APIC version using URL: " + versionUrl);
        try {
            String version = ApicSdk.getHTML(versionUrl);
            version = version.split("versionString: '")[1].split("'")[0];
            return version;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                throw new ApicMoOperationException("failed to get apic version");
            }
            catch (ApicMoOperationException excep) {
                excep.printStackTrace();
                return null;
            }
        }
    }

    public static String getHTML(String urlToRead) throws Exception {
        String line;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        StringBuilder result = new StringBuilder();
        URL url = new URL(urlToRead);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        return result.toString();
    }

    public Fabric getFabric() {
        Fabric f = new Fabric();
        f.setId(this._fabricId);
        f.setApicUrl(this._apicUrl);
        f.setMoUrl("/fabric/" + f.getId());
        f.setName(this._fabricName);
        f.setReachable(this._handle.isSessionValid());
        return f;
    }

    public RBAC getRBAC() {
        ApicUserPermission perm = this._handle.updateAndGetApicUserPermission();
        RBAC rbacInfo = new RBAC();
        rbacInfo.setUsername(perm.getUsername());
        List aaaUserDomains = perm.getAaaUserDomains();
        PermissionMap domPermMap = new PermissionMap();
        for (AaaUserDomainGson aaaUserDomain : aaaUserDomains) {
            String securityDomainName = aaaUserDomain.getName();
            this.logInformation(securityDomainName, (WhoAmIChild)aaaUserDomain);
            String[] readRoles = aaaUserDomain.getReadRoles();
            String[] writeRoles = aaaUserDomain.getWriteRoles();
            PrivilegeMap domMap = new PrivilegeMap();
            PrivilegeList rp = new PrivilegeList();
            for (String s : readRoles) {
                rp.add(s);
            }
            PrivilegeList wp = new PrivilegeList();
            for (String string : writeRoles) {
                wp.add(string);
            }
            PrivilegeList name = new PrivilegeList();
            name.add(securityDomainName);
            domMap.put("name", name);
            domMap.put(WhoAmIGson.DomainRoleType.USER_DOMAIN_READ.getRoleKey(), rp);
            domMap.put(WhoAmIGson.DomainRoleType.USER_DOMAIN_WRITE.getRoleKey(), wp);
            domPermMap.put(securityDomainName, domMap);
        }
        rbacInfo.setDomainPermissions(domPermMap);
        List dnDomainMapEntries = perm.getDnDomainMapEntries();
        PermissionMap tenPermMap = new PermissionMap();
        for (DnDomainMapEntryGson dnDomainMapEntry : dnDomainMapEntries) {
            String dn = dnDomainMapEntry.getDn();
            boolean isTenantDn = dn.startsWith("uni/tn-") && dn.split("/").length == 2;
            if (!isTenantDn) continue;
            String tenantName = Utils.getTenantFromDn((String)dn);
            this.logInformation(tenantName, (WhoAmIChild)dnDomainMapEntry);
            String[] readRoles = dnDomainMapEntry.getReadRoles();
            String[] writeRoles = dnDomainMapEntry.getWriteRoles();
            PrivilegeMap tenMap = new PrivilegeMap();
            PrivilegeList rp = new PrivilegeList();
            for (String s : readRoles) {
                rp.add(s);
            }
            PrivilegeList privilegeList = new PrivilegeList();
            for (String s : writeRoles) {
                privilegeList.add(s);
            }
            PrivilegeList name = new PrivilegeList();
            name.add(tenantName);
            tenMap.put("name", name);
            tenMap.put(WhoAmIGson.DomainRoleType.USER_DOMAIN_READ.getRoleKey(), rp);
            tenMap.put(WhoAmIGson.DomainRoleType.USER_DOMAIN_WRITE.getRoleKey(), privilegeList);
            tenPermMap.put(tenantName, tenMap);
        }
        rbacInfo.setTenantPermissions(tenPermMap);
        return rbacInfo;
    }

    public void logInformation(String name, WhoAmIChild child) {
        String nameHeader = child instanceof AaaUserDomainGson ? "security domain" : "tenant";
        this.log.info("Adding " + nameHeader + ": " + name + " to RBACInformation");
        this.log.info("Read roles: " + Arrays.toString(child.getReadRoles()));
        this.log.info("Write roles: " + Arrays.toString(child.getWriteRoles()));
    }

    public String getWcardDnFilter(String moClass, List<String> dns) {
        if (dns == null || dns.size() == 0) {
            return null;
        }
        String filter = "or(";
        for (String dn : dns) {
            if (!"or(".equals(filter)) {
                filter = filter + ",";
            }
            String f = "wcard(" + moClass + ".dn, \"" + dn + "\")";
            filter = filter + f;
        }
        filter = filter + ")";
        return filter;
    }

    public List<Apic> getApics() throws ApicMoOperationException {
        ArrayList<Apic> apics = new ArrayList();
        List nodeMoList = this._handle.getManagedObjects(null, "fabricNode", null, "eq(fabricNode.role, \"controller\")", null, null, null, null, null, null);
        ArrayList<String> fabricNodesDns = new ArrayList<String>();
        if (nodeMoList != null) {
            for (ManagedObject fabricNodeMo : nodeMoList) {
                fabricNodesDns.add(fabricNodeMo.getDn());
            }
        }
        List infra = this._handle.getManagedObjects(null, "infraWiNode", null, this.getWcardDnFilter("infraWiNode", fabricNodesDns), null, null, null, null, null, null);
        List topSystemMoList = this._handle.getManagedObjects(null, "topSystem", null, this.getWcardDnFilter("infraWiNode", fabricNodesDns), null, null, null, null, null, null);
        List firmware = this._handle.getManagedObjects(null, "firmwareCtrlrRunning", null, this.getWcardDnFilter("firmwareCtrlrRunning", fabricNodesDns), null, null, null, null, null, null);
        apics = this.buildApics(nodeMoList, infra, topSystemMoList, firmware);
        return apics;
    }

    public List<Apic> buildApics(List<ManagedObject> fabricNodeMoList, List<ManagedObject> infraWiNodeMoList, List<ManagedObject> topSystemMoList, List<ManagedObject> firmwareMoList) {
        ArrayList<Apic> apics = new ArrayList<Apic>();
        if (topSystemMoList == null || topSystemMoList.size() == 0) {
            Apic fakeApic = new Apic();
            fakeApic.setUsername(this._handle.getUserName());
            fakeApic.setHealth("fully-fit");
            fakeApic.setIp("IP");
            apics.add(fakeApic);
            return apics;
        }
        for (ManagedObject mo : fabricNodeMoList) {
            if (!(mo instanceof fabricNode)) continue;
            fabricNode fnode = (fabricNode)mo;
            Apic a = new Apic();
            a.setUsername(this._handle.getUserName());
            a.setName(fnode.getName());
            a.setId(a.getName());
            a.setNodeId(Long.toString(fnode.getId()));
            String dn = fnode.getDn();
            a.setPodId(dn.split("pod-", 5)[1].split("/", 5)[0]);
            a.setReachable(true);
            a.setVendor(fnode.getVendor());
            apics.add(a);
        }
        block1: for (Apic apic : apics) {
            if (topSystemMoList != null) {
                for (ManagedObject mo : topSystemMoList) {
                    topSystem topsys = (topSystem)mo;
                    if (!topsys.getDn().contains("/pod-" + apic.getPodId() + "/node-" + apic.getNodeId() + "/")) continue;
                    apic.setIp(topsys.getOobMgmtAddr());
                }
            }
            if (firmwareMoList != null) {
                for (ManagedObject mo : firmwareMoList) {
                    firmwareCtrlrRunning firmware = (firmwareCtrlrRunning)mo;
                    if (!firmware.getDn().contains("/pod-" + apic.getPodId() + "/node-" + apic.getNodeId() + "/")) continue;
                    apic.setVersion(firmware.getVersion());
                    break;
                }
            }
            for (ManagedObject mo : infraWiNodeMoList) {
                infraWiNode infra;
                if (!(mo instanceof infraWiNode) || !(infra = (infraWiNode)mo).getDn().endsWith("/node-" + apic.getNodeId())) continue;
                apic.setOperationalStatus(infra.getOperSt());
                apic.setAdminStatus(infra.getAdminSt());
                apic.setHealth(infra.getHealth());
                continue block1;
            }
        }
        return apics;
    }

    public List<VmmDomain> getDomains(List<Vcenter> vcenters, List<VCenterSdk> vcSdks, boolean aveOnly, String propValue, PageQueryBuilder pqb) throws Exception {
        ArrayList<VmmDomain> domains = new ArrayList<VmmDomain>();
        HashMap<String, Vcenter> vcMap = new HashMap<String, Vcenter>();
        HashMap<String, VCenterSdk> vcHandleMap = new HashMap<String, VCenterSdk>();
        for (Vcenter vc : vcenters) {
            vcMap.put(vc.getGuid(), vc);
        }
        for (VCenterSdk sdk : vcSdks) {
            vcHandleMap.put(sdk.getGuid(), sdk);
        }
        HashMap<String, VmmDomain> domainsMap = new HashMap<String, VmmDomain>();
        List<ManagedObject> compCtrlrMOs = this.getCompCtrlrsForVc(vcenters, aveOnly, propValue, pqb);
        for (ManagedObject managedObject : compCtrlrMOs) {
            compCtrlr compCtrlrMO = (compCtrlr)managedObject;
            VCenterSdk sdk = (VCenterSdk)vcHandleMap.get(compCtrlrMO.getSer());
            if (domainsMap.containsKey(compCtrlrMO.getDomName())) {
                VmmDomain dom = (VmmDomain)domainsMap.get(compCtrlrMO.getDomName());
                dom.addVcentersItem((Vcenter)vcMap.get(compCtrlrMO.getSer()));
                List<Datacenter> dc = sdk.getDatacenters(ApiSpecUtil.propFilterSpec("name", compCtrlrMO.getRootContName()));
                dom.addDatacentersItem(dc.get(0));
                continue;
            }
            VmmDomain domain = new VmmDomain();
            domain.setFabricId(this._fabricId);
            domain.setName(compCtrlrMO.getDomName());
            domain.addVcentersItem((Vcenter)vcMap.get(compCtrlrMO.getSer()));
            String domDnString = compCtrlrMO.getCtrlrPKey();
            String domDn = domDnString.substring(0, domDnString.lastIndexOf("/"));
            domain.setDn(domDn);
            domain.setId(domDn);
            domain.setAccessMode(VmmDomain.AccessModeEnum.fromValue(compCtrlrMO.getAccessMode()));
            if (compCtrlrMO.getAccessMode().equals("read-only")) {
                String dvsUuid = null;
                List hvsLNodeList = compCtrlrMO.getChild(hvsLNode.class.getSimpleName());
                for (ApicBase ab : hvsLNodeList) {
                    hvsLNode hvsLNodeMo = (hvsLNode)ab;
                    dvsUuid = hvsLNodeMo.getGuid();
                }
                List<Dvs> dvsList = null;
                if (dvsUuid != null) {
                    dvsList = sdk.getDvs(ApiSpecUtil.propFilterSpec("uuid", dvsUuid), true);
                }
                Dvs dvs = null;
                if (dvsList != null && dvsList.size() != 0 && dvsList.get(0).getVcId().equals(compCtrlrMO.getSer())) {
                    dvs = dvsList.get(0);
                }
                ArrayList<PortGroup> existingPortGroupListOnDvs = new ArrayList<PortGroup>();
                List<PortGroup> vcPortGroupList = null;
                if (dvs != null && (vcPortGroupList = dvs.getPortgroups()) != null && vcPortGroupList.size() > 0) {
                    for (PortGroup portGroup : vcPortGroupList) {
                        this.log.info("Port Group name = " + portGroup.getName());
                        CustomDefinition customAttr = portGroup.getCustomAttributes().stream().filter(obj -> obj.getName().equals(Constants.CUSTOMATTR_NAME)).findFirst().orElse(null);
                        if (customAttr != null) {
                            this.log.info("On portGroup " + portGroup.getName() + " Custom attribute " + customAttr.getName() + " with key " + customAttr.getKey() + " found");
                            String customValue = customAttr.getValue();
                            if (customValue != null) {
                                this.log.info("On portGroup " + portGroup.getName() + " Custom attribute having key " + customAttr.getKey() + " has custom value  " + customAttr.getValue());
                                this.log.info("Not adding PortGroup " + portGroup.getName() + " to available portgroups list");
                                continue;
                            }
                        }
                        this.log.info("Adding portgroup" + portGroup.getName() + " to list");
                        existingPortGroupListOnDvs.add(portGroup);
                    }
                }
                domain.setExistingPortGroups(existingPortGroupListOnDvs);
            }
            ArrayList<LagPolicy> lagPolicies = new ArrayList<LagPolicy>();
            List<ManagedObject> apicPoliciesList = null;
            try {
                ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
                String dnFilter = ManagedObjectQueryBuilder.createWildcardFilter(lacpEnhancedLagPol.class.getSimpleName(), "dn", domDn + "/");
                moqb.withMoClassName(lacpEnhancedLagPol.class.getSimpleName()).withQueryTargetFilter(dnFilter);
                apicPoliciesList = moqb.getManagedObjectsFromBuilder(this._handle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (apicPoliciesList != null && apicPoliciesList.size() > 0) {
                for (ManagedObject mo : apicPoliciesList) {
                    lacpEnhancedLagPol lagPol = (lacpEnhancedLagPol)mo;
                    LagPolicy lagPolicy = new LagPolicy();
                    lagPolicy.setName(lagPol.getName());
                    lagPolicy.setDn(lagPol.getDn());
                    lagPolicies.add(lagPolicy);
                }
            }
            domain.setAvailableLagPolicies(lagPolicies);
            if ("default".equals(compCtrlrMO.getMode())) {
                if (this.isTrue(compCtrlrMO.getEnableAVE())) {
                    domain.setType(VmmDomain.TypeEnum.AVE);
                } else if (compCtrlrMO.getAccessMode().equals("read-only")) {
                    domain.setType(VmmDomain.TypeEnum.VSPHEREMANAGED);
                } else {
                    domain.setType(VmmDomain.TypeEnum.NATIVE);
                }
            } else if ("n1kv".equals(compCtrlrMO.getMode())) {
                domain.setType(VmmDomain.TypeEnum.AVS);
            }
            domain.setProactiveHA(false);
            List<Datacenter> dc = sdk.getDatacenters(ApiSpecUtil.propFilterSpec("name", compCtrlrMO.getRootContName()));
            domain.setDatacenters(dc);
            domainsMap.put(domain.getName(), domain);
        }
        ArrayList<String> domainFilters = new ArrayList<String>();
        for (String domName : domainsMap.keySet()) {
            domainFilters.add("eq(vmmDomP.name, \"" + domName + "\")");
        }
        String string = "or(" + StringUtils.join(domainFilters, (char)',') + ")";
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        moqb.withMoClassName(vmmDomP.class.getSimpleName()).withQueryTargetFilter(string).withRspSubtreeInclude("fault-count");
        List<ManagedObject> vmmDomPList = moqb.getManagedObjectsFromBuilder(this._handle);
        for (ManagedObject mo : vmmDomPList) {
            vmmDomP apicDomain = (vmmDomP)mo;
            VmmDomain vcpluginDomain = (VmmDomain)domainsMap.get(apicDomain.getName());
            if (vcpluginDomain == null) continue;
            if (apicDomain.getHvAvailMonitor() != null && apicDomain.getHvAvailMonitor().equals("yes")) {
                vcpluginDomain.setProactiveHA(true);
            }
            this.setFaultsCountUtil((ManagedObject)apicDomain, vcpluginDomain);
            domainsMap.put(vcpluginDomain.getName(), vcpluginDomain);
        }
        domains.addAll(domainsMap.values());
        return domains;
    }

    public int getDomainsCount(List<Vcenter> vcenters, boolean aveOnly, String propValue) throws Exception {
        List<ManagedObject> compCtrlrMOs = this.getCompCtrlrsForVc(vcenters, aveOnly, propValue, null);
        HashSet<String> domainSet = new HashSet<String>();
        for (ManagedObject ctrlrMO : compCtrlrMOs) {
            compCtrlr compCtrlrMO = (compCtrlr)ctrlrMO;
            domainSet.add(compCtrlrMO.getDomName());
        }
        return domainSet.size();
    }

    public int getMOCountForClass(String className, String propValue) throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = ManagedObjectQueryBuilder.getMoqbForClass(className, propValue);
        return this.getMoCount(moqb);
    }

    public int getTenantsCount(String propValue) throws ApicMoOperationException {
        return this.getMOCountForClass(fvTenant.class.getSimpleName(), propValue);
    }

    public int getEPGsCount(String tenantName, String propValue, boolean includeCommon) throws ApicMoOperationException {
        String tenantDn = String.format("uni/tn-%s/", tenantName);
        String className = fvAEPg.class.getSimpleName();
        String wcardFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", tenantDn);
        ManagedObjectQueryBuilder moqb = ManagedObjectQueryBuilder.getMoqbForClass(className, propValue);
        moqb.addQueryTargetFilter(wcardFilter);
        if (includeCommon && !tenantName.equals("common")) {
            moqb.addOptionalQueryTargetFilter(ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", Constants.commonTenantDn));
        }
        return this.getMoCount(moqb);
    }

    public int getVrfsCount(String tenantName, String propValue) throws ApicMoOperationException {
        String tenantDn = String.format("uni/tn-%s/", tenantName);
        String className = fvCtx.class.getSimpleName();
        String wcardFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", tenantDn);
        ManagedObjectQueryBuilder moqb = ManagedObjectQueryBuilder.getMoqbForClass(className, propValue);
        moqb.addQueryTargetFilter(wcardFilter);
        return this.getMoCount(moqb);
    }

    public int getBdsCount(String tenantName, String propValue, boolean includeCommon) throws ApicMoOperationException {
        String tenantDn = String.format("uni/tn-%s/", tenantName);
        String className = fvBD.class.getSimpleName();
        String wcardFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", tenantDn);
        ManagedObjectQueryBuilder moqb = ManagedObjectQueryBuilder.getMoqbForClass(className, propValue);
        moqb.addQueryTargetFilter(wcardFilter);
        if (includeCommon && !tenantName.equals("common")) {
            moqb.addOptionalQueryTargetFilter(ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", Constants.commonTenantDn));
        }
        return this.getMoCount(moqb);
    }

    public List<Tenant> getTenants(String propValue, PageQueryBuilder pqb) throws ApicMoOperationException {
        String className = fvTenant.class.getSimpleName();
        OrderQueryBuilder orderQb = new OrderQueryBuilder(className);
        ManagedObjectQueryBuilder moqb = ManagedObjectQueryBuilder.getMoqbForClass(fvTenant.class.getSimpleName(), propValue);
        moqb.withOrderQuery(orderQb).withPagination(pqb);
        ArrayList<Tenant> tenants = new ArrayList<Tenant>();
        List<ManagedObject> tenantObjs = moqb.getManagedObjectsFromBuilder(this._handle);
        for (ManagedObject tenantMo : tenantObjs) {
            fvTenant mo = (fvTenant)tenantMo;
            Tenant t = new Tenant();
            t.setName(mo.getName());
            t.setDescr(mo.getDescr());
            t.setId(mo.getDn());
            t.setDn(mo.getDn());
            t.setFabricId(this._fabricId);
            this.setFaultsCountUtil((ManagedObject)mo, t);
            this.setHealthScoreUtil((ManagedObject)mo, t);
            tenants.add(t);
        }
        return tenants;
    }

    public List<Fault> getFaultsForObject(String dn, PageQueryBuilder pqb) throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = this.getMoqbForFaults(dn);
        List<ManagedObject> apicFaultList = moqb.getManagedObjectsFromBuilder(this._handle);
        apicFaultList = ApicSdk.getPaginatedObjects(apicFaultList, pqb);
        ArrayList<Fault> faults = new ArrayList<Fault>();
        this.setFaultDetailsUtil(faults, apicFaultList);
        return faults;
    }

    ManagedObjectQueryBuilder getMoqbForFaults(String dn) {
        String className = this.getAciClassFromDn(dn);
        String eqFilter = ManagedObjectQueryBuilder.createEqFilter(className, "dn", dn);
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder().withMoClassName(className).withQueryTargetFilter(eqFilter).withRspSubtreeInclude("faults,no-scoped,subtree");
        return moqb;
    }

    public int getFaultsCount(String dn) throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = this.getMoqbForFaults(dn);
        List<ManagedObject> apicFaultList = moqb.getManagedObjectsFromBuilder(this._handle);
        return apicFaultList.size();
    }

    private void setFaultDetailsUtil(List<Fault> faults, List<ManagedObject> apicFaultList) {
        for (ManagedObject mo : apicFaultList) {
            faultDelegate apicFault;
            Fault f = new Fault();
            if (mo instanceof faultDelegate) {
                apicFault = (faultDelegate)mo;
                f.setId(apicFault.getDn());
                f.setAffected(apicFault.getAffected());
                f.setCode(apicFault.getCode());
                f.setAcknowledged(apicFault.getAck());
                f.setSeverity(apicFault.getSeverity());
                f.setDescription(apicFault.getDescr());
                f.setCreationTime(apicFault.getCreated());
            } else if (mo instanceof faultInst) {
                apicFault = (faultInst)mo;
                f.setId(apicFault.getDn());
                f.setCode(apicFault.getCode());
                f.setAcknowledged(apicFault.getAck());
                f.setSeverity(apicFault.getSeverity());
                f.setDescription(apicFault.getDescr());
                f.setCreationTime(apicFault.getCreated());
            }
            faults.add(f);
        }
    }

    public int getEndpointsCount(String tenantName, String appName, String epgName, List<Vcenter> vcenters, String username, String propValue) throws Exception, ApicMoOperationException {
        List<Endpoint> endpoints = this.getEndpointsList(tenantName, appName, epgName, vcenters, username, propValue);
        return endpoints.size();
    }

    public List<Endpoint> getEndpointsList(String tenantName, String appName, String epgName, List<Vcenter> vcenters, String username, String propValue) throws Exception {
        HashMap<String, String> ctrlrVcMap = new HashMap<String, String>();
        HashMap<String, Set<String>> vmsMap = new HashMap<String, Set<String>>();
        List<Endpoint> endpoints = new ArrayList<Endpoint>();
        ArrayList<String> guidFilters = new ArrayList<String>();
        for (Vcenter vc : vcenters) {
            this.log.info("filter=" + vc.getGuid());
            guidFilters.add("eq(compCtrlr.ser, \"" + vc.getGuid() + "\")");
        }
        String ctrlrTargetFilter = "and(wcard(compCtrlr.dn, \"comp/prov-VMware/ctrlr-\"), or(" + StringUtils.join(guidFilters, (char)',') + "))";
        ManagedObjectQueryBuilder ctrlrqb = new ManagedObjectQueryBuilder();
        ctrlrqb.withMoClassName(compCtrlr.class.getSimpleName()).withQueryTargetFilter(ctrlrTargetFilter);
        List<ManagedObject> compCtrlrMOs = ctrlrqb.getManagedObjectsFromBuilder(this._handle);
        for (ManagedObject ctrlrMO : compCtrlrMOs) {
            compCtrlr compCtrlrMO = (compCtrlr)ctrlrMO;
            ctrlrVcMap.put(compCtrlrMO.getDn(), compCtrlrMO.getSer());
        }
        String className = fvCEp.class.getSimpleName();
        OrderQueryBuilder orderQb = new OrderQueryBuilder(className);
        ManagedObjectQueryBuilder moqb = this.getMoqbForEndpoints(tenantName, appName, epgName);
        moqb.withOrderQuery(orderQb);
        List<ManagedObject> endpointObjs = moqb.getManagedObjectsFromBuilder(this._handle);
        for (ManagedObject mo : endpointObjs) {
            fvCEp apicEndpoint = (fvCEp)mo;
            Endpoint e = new Endpoint();
            e.setId(apicEndpoint.getDn());
            e.setIp(apicEndpoint.getIp());
            e.setMac(apicEndpoint.getMac());
            e.setName(apicEndpoint.getName());
            if (ctrlrVcMap.size() > 0) {
                Object ab2;
                List vmRsVmList = apicEndpoint.getChild(fvRsVm.class.getSimpleName());
                for (Object ab2 : vmRsVmList) {
                    Set<String> vmSet;
                    fvRsVm vmRelation = (fvRsVm)ab2;
                    String vmRelationtDn = vmRelation.getTDn();
                    String vmOid = this.getVmOidFromDn(vmRelationtDn);
                    e.setVmoid(vmOid);
                    String ctrlrDn = this.getCtrlrDn(vmRelationtDn);
                    String vcId = (String)ctrlrVcMap.get(ctrlrDn);
                    if (vcId == null) continue;
                    if (vmsMap.containsKey(vcId)) {
                        vmSet = (Set)vmsMap.get(vcId);
                        if (vmSet.contains(vmOid)) continue;
                        vmSet.add(vmOid);
                        vmsMap.put(vcId, vmSet);
                        continue;
                    }
                    vmSet = new HashSet();
                    vmSet.add(vmOid);
                    vmsMap.put(vcId, vmSet);
                }
                List vmRsToVmList = apicEndpoint.getChild(fvRsToVm.class.getSimpleName());
                ab2 = vmRsToVmList.iterator();
                while (ab2.hasNext()) {
                    Set<String> vmSet;
                    ApicBase ab3 = (ApicBase)ab2.next();
                    fvRsToVm vmRelation = (fvRsToVm)ab3;
                    String vmRelationtDn = vmRelation.getTDn();
                    String vmOid = this.getVmOidFromDn(vmRelationtDn);
                    e.setVmoid(vmOid);
                    String ctrlrDn = this.getCtrlrDn(vmRelationtDn);
                    String vcId = (String)ctrlrVcMap.get(ctrlrDn);
                    if (vcId == null) continue;
                    if (vmsMap.containsKey(vcId)) {
                        vmSet = (Set)vmsMap.get(vcId);
                        if (vmSet.contains(vmOid)) continue;
                        vmSet.add(vmOid);
                        vmsMap.put(vcId, vmSet);
                        continue;
                    }
                    vmSet = new HashSet();
                    vmSet.add(vmOid);
                    vmsMap.put(vcId, vmSet);
                }
            }
            endpoints.add(e);
        }
        for (String vcenterId : vmsMap.keySet()) {
            Vcenter vc = vcenters.stream().filter(obj -> obj.getGuid().equals(vcenterId)).findFirst().orElse(null);
            if (vc == null) {
                throw new Exception("Cannot find VC ");
            }
            VCenterSdk vcsdk = new VCenterSdk(username, vc);
            vcsdk.connectVIM();
            Set vmSet = (Set)vmsMap.get(vcenterId);
            ArrayList<String> vmoidList = new ArrayList<String>();
            vmoidList.addAll(vmSet);
            List<VirtualMachine> virtualMachineList = vcsdk.getVMs(ApiSpecUtil.moIdSpec(vmoidList));
            for (VirtualMachine vm : virtualMachineList) {
                Endpoint endpoint = endpoints.stream().filter(ep -> ep.getVmoid().equals(vm.getOid())).findFirst().orElse(null);
                endpoint.setVm(vm);
            }
        }
        endpoints = this.getFilteredEndpoints(endpoints, propValue);
        return endpoints;
    }

    public List<Endpoint> getEndpoints(String tenantName, String appName, String epgName, List<Vcenter> vcenters, String username, String propValue, PageQueryBuilder pqb) throws Exception {
        List<Endpoint> endpoints = this.getEndpointsList(tenantName, appName, epgName, vcenters, username, propValue);
        endpoints = ApicSdk.getPaginatedObjects(endpoints, pqb);
        return endpoints;
    }

    public String getVmOidFromDn(String dn) {
        String[] s = dn.split("/vm-");
        String oid = "";
        oid = oid + s[s.length - 1];
        return oid;
    }

    public String getCtrlrDn(String dn) {
        String[] s = dn.split("/vm-");
        String ctrlrDn = "";
        ctrlrDn = ctrlrDn + s[0];
        return ctrlrDn;
    }

    ManagedObjectQueryBuilder getMoqbForEndpoints(String tenantName, String appName, String epgName) throws ApicMoOperationException {
        String epgDn = "uni/tn-" + tenantName + "/ap-" + appName + "/epg-" + epgName + "/";
        String className = fvCEp.class.getSimpleName();
        String queryTargetFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", epgDn);
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder().withMoClassName(className).withQueryTargetFilter(queryTargetFilter).withRspSubtree("children").withRspSubtreeClass("fvCEp,fvRsVm,fvRsToVm").withRspSubtreeInclude("health,fault-count");
        return moqb;
    }

    public List<Epg> getEPGs(String tenantName, List<Vcenter> vcenters, String username, PageQueryBuilder pqb, String propValue, boolean includeCommon) throws Exception {
        ArrayList<VCenterSdk> sdks = new ArrayList<VCenterSdk>();
        HashMap<String, Object> vCenterSdkMap = new HashMap<String, Object>();
        for (Vcenter vc : vcenters) {
            VCenterSdk sdk = new VCenterSdk(username, vc);
            sdk.connectVIM();
            if (sdk == null) continue;
            sdks.add(sdk);
            vCenterSdkMap.put(vc.getGuid(), sdk);
        }
        List<VmmDomain> vmmDomains = this.getDomains(vcenters, sdks, false, "", null);
        HashMap<String, VmmDomain> domainsMap = new HashMap<String, VmmDomain>();
        for (VmmDomain vmmDom : vmmDomains) {
            domainsMap.put(vmmDom.getName(), vmmDom);
        }
        ArrayList<Epg> epgs = new ArrayList<Epg>();
        String tenantDn = String.format("uni/tn-%s/", tenantName);
        String className = fvAEPg.class.getSimpleName();
        String wcardFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", tenantDn);
        ManagedObjectQueryBuilder moqb = ManagedObjectQueryBuilder.getMoqbForClass(className, propValue);
        moqb.addQueryTargetFilter(wcardFilter);
        if (includeCommon && !tenantName.equals("common")) {
            moqb.addOptionalQueryTargetFilter(ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", Constants.commonTenantDn));
        }
        moqb.withRspSubtree("full");
        moqb.withPagination(pqb);
        List<ManagedObject> epgObjs = moqb.getManagedObjectsFromBuilder(this._handle);
        for (ManagedObject epgObj : epgObjs) {
            List criterionList;
            fvAEPg epgMo = (fvAEPg)epgObj;
            Epg epg = new Epg();
            epg.setName(epgMo.getName());
            epg.setDescr(epgMo.getDescr());
            epg.setDn(epgMo.getDn());
            epg.setId(epgMo.getDn());
            boolean isIntraIsolated = epgMo.getPcEnfPref().equals("enforced");
            epg.setIsIntraIsolated(isIntraIsolated);
            Tenant tn = new Tenant();
            tn.setName(Utils.getTenantFromDn((String)epgMo.getDn()));
            tn.setId(this.buildDnForAciObject(fvTenant.class.getSimpleName(), tn.getName(), null));
            tn.setDn(this.buildDnForAciObject(fvTenant.class.getSimpleName(), tn.getName(), null));
            epg.setParentTenant(tn);
            App ap = new App();
            ap.setName(Utils.getApFromDn((String)epgMo.getDn()));
            ap.setId(this.buildDnForAciObject(fvAp.class.getSimpleName(), epg.getParentTenant().getName(), ap.getName()));
            ap.setDn(this.buildDnForAciObject(fvAp.class.getSimpleName(), epg.getParentTenant().getName(), ap.getName()));
            epg.setParentApp(ap);
            ArrayList<VmmDomain> epgDomainsList = new ArrayList<VmmDomain>();
            ArrayList<EpgDomainSettings> epgDomains = new ArrayList<EpgDomainSettings>();
            List fvRsDomAttChildren = epgMo.getChild(fvRsDomAtt.class.getSimpleName());
            if (fvRsDomAttChildren != null && fvRsDomAttChildren.size() > 0) {
                for (Object mo : fvRsDomAttChildren) {
                    fvRsDomAtt rsDomainAtt = (fvRsDomAtt)mo;
                    if (!rsDomainAtt.getTCl().equals(vmmDomP.class.getSimpleName())) continue;
                    EpgDomainSettings domainSettings = new EpgDomainSettings();
                    String domainDn = rsDomainAtt.getTDn();
                    String domainName = this.getPropertyFromDn(domainDn, "dom-");
                    if (domainsMap.containsKey(domainName)) {
                        epg.setType("local");
                        domainSettings.setVmmDomain((VmmDomain)domainsMap.get(domainName));
                        epgDomainsList.add((VmmDomain)domainsMap.get(domainName));
                    } else {
                        epg.setType("remote");
                        VmmDomain domain = new VmmDomain();
                        domain.setId(domainDn);
                        domain.setDn(domainDn);
                        domain.setName(domainName);
                        domainSettings.setVmmDomain(domain);
                        epgDomainsList.add((VmmDomain)domainsMap.get(domainName));
                    }
                    domainSettings.setSwitchingMode(rsDomainAtt.getSwitchingMode());
                    List lagPolicAttributeList = rsDomainAtt.getChild(fvAEPgLagPolAtt.class.getSimpleName());
                    for (ApicBase ab : lagPolicAttributeList) {
                        fvAEPgLagPolAtt lagPolAtt = (fvAEPgLagPolAtt)ab;
                        List lagPolRelationList = lagPolAtt.getChild(fvRsVmmVSwitchEnhancedLagPol.class.getSimpleName());
                        for (ApicBase apicBase : lagPolRelationList) {
                            fvRsVmmVSwitchEnhancedLagPol lagPolRelation = (fvRsVmmVSwitchEnhancedLagPol)apicBase;
                            LagPolicy lagPolicy = new LagPolicy();
                            String enhancedLagPolicyDn = lagPolRelation.getTDn();
                            String expectedDn = domainDn + "/vswitchpolcont/enlacplagp-";
                            int startIndex = expectedDn.length();
                            String lagPolicyName = enhancedLagPolicyDn.substring(startIndex);
                            lagPolicy.setDn(enhancedLagPolicyDn);
                            lagPolicy.setName(lagPolicyName);
                            domainSettings.setSelectedLagPolicy(lagPolicy);
                        }
                    }
                    if (domainsMap.containsKey(domainName) && ((VmmDomain)domainsMap.get(domainName)).getType().equals((Object)VmmDomain.TypeEnum.VSPHEREMANAGED)) {
                        String customAttributeValue = epg.getParentTenant().getName() + "|" + epg.getParentApp().getName() + "|" + epg.getName();
                        boolean portGroupFound = false;
                        List<ManagedObject> compCtrlrMo = this.getCompCtrlrsForVcForDomain(vcenters, domainName);
                        if (compCtrlrMo != null && compCtrlrMo.size() > 0) {
                            block6: for (ManagedObject controller : compCtrlrMo) {
                                Dvs dvs;
                                if (portGroupFound) break;
                                compCtrlr ctrlr = (compCtrlr)controller;
                                hvsLNode apicDvs = (hvsLNode)this.getChildbyName((ManagedObject)ctrlr, hvsLNode.class.getSimpleName(), domainName);
                                if (apicDvs == null) continue;
                                String dvsUuid = apicDvs.getGuid();
                                VCenterSdk vCenterSdk = (VCenterSdk)vCenterSdkMap.get(ctrlr.getSer());
                                List<Dvs> dvsList = vCenterSdk.getDvs(ApiSpecUtil.propFilterSpec("uuid", dvsUuid), true);
                                if (dvsList == null || dvsList.size() <= 0 || (dvs = dvsList.get(0)) == null) continue;
                                List<PortGroup> portGroupList = dvs.getPortgroups();
                                for (PortGroup portGroup : portGroupList) {
                                    List<CustomDefinition> customAttributes = portGroup.getCustomAttributes();
                                    CustomDefinition def = customAttributes.stream().filter(obj -> Constants.CUSTOMATTR_NAME.equals(obj.getName()) && customAttributeValue.equals(obj.getValue())).findFirst().orElse(null);
                                    if (def == null) continue;
                                    domainSettings.setSelectedPortGroup(portGroup);
                                    portGroupFound = true;
                                    continue block6;
                                }
                            }
                        }
                    }
                    epgDomains.add(domainSettings);
                }
            }
            epg.setEpgDomainSettings(epgDomains);
            epg.setDomainList(epgDomainsList);
            List fvRsBdChildren = epgMo.getChild(fvRsBd.class.getSimpleName());
            if (fvRsBdChildren != null && fvRsBdChildren.size() > 0) {
                Object mo;
                mo = fvRsBdChildren.iterator();
                while (mo.hasNext()) {
                    ApicBase mo2 = (ApicBase)mo.next();
                    fvRsBd rsBd = (fvRsBd)mo2;
                    String bdName = this.getPropertyFromDn(rsBd.getTDn(), "BD-");
                    Bd bd = new Bd();
                    bd.setId(rsBd.getTDn());
                    bd.setDn(rsBd.getTDn());
                    bd.setName(bdName);
                    epg.setBd(bd);
                }
            }
            if ((criterionList = epgMo.getChild(fvCrtrn.class.getSimpleName())) != null && criterionList.size() > 0) {
                fvCrtrn apicCriterion = (fvCrtrn)criterionList.get(0);
                USegCriterion criterion = new USegCriterion();
                criterion.setName(apicCriterion.getName());
                criterion.setDescr(apicCriterion.getDescr());
                criterion.setMatch(apicCriterion.getMatch());
                this.buildVCSubCriterion((ManagedObject)apicCriterion, criterion);
                epg.setUSegCriterion(criterion);
            }
            this.setFaultsCountUtil((ManagedObject)epgMo, epg);
            this.setHealthScoreUtil((ManagedObject)epgMo, epg);
            epgs.add(epg);
        }
        return epgs;
    }

    private void buildVCSubCriterion(ManagedObject apicSubCriterion, USegSubCriterion subCriterion) {
        ArrayList<USegAttribute> attributes = new ArrayList<USegAttribute>();
        List vmAttributeList = apicSubCriterion.getChild(fvVmAttr.class.getSimpleName());
        for (Object att : vmAttributeList) {
            fvVmAttr apicAttr = (fvVmAttr)att;
            USegAttribute attribute = new USegAttribute();
            attribute.setName(apicAttr.getName());
            attribute.setDescr(apicAttr.getDescr());
            attribute.setType(apicAttr.getType());
            attribute.setOperator(apicAttr.getOperator());
            attribute.setValue(apicAttr.getValue());
            if ("custom-label".equals(apicAttr.getType())) {
                attribute.setLabelName(apicAttr.getLabelName());
            }
            if ("tag".equals(attribute.getType())) {
                attribute.setLabelName(apicAttr.getCategory());
            }
            attributes.add(attribute);
        }
        List macAttributeList = apicSubCriterion.getChild(fvMacAttr.class.getSimpleName());
        for (Object att : macAttributeList) {
            fvMacAttr apicAttr = (fvMacAttr)att;
            USegAttribute attribute = new USegAttribute();
            attribute.setName(apicAttr.getName());
            attribute.setDescr(apicAttr.getDescr());
            attribute.setValue(apicAttr.getMac());
            attributes.add(attribute);
        }
        List ipAttributeList = apicSubCriterion.getChild(fvIpAttr.class.getSimpleName());
        for (ApicBase att : ipAttributeList) {
            fvIpAttr apicAttr = (fvIpAttr)att;
            USegAttribute attribute = new USegAttribute();
            attribute.setName(apicAttr.getName());
            attribute.setValue(apicAttr.getIp());
            attributes.add(attribute);
        }
        subCriterion.setAttributes(attributes);
        ArrayList<USegSubCriterion> subCriteria = new ArrayList<USegSubCriterion>();
        List apicSubCriteria = apicSubCriterion.getChild(fvSCrtrn.class.getSimpleName());
        for (ApicBase ab : apicSubCriteria) {
            fvSCrtrn apicNestedSubCriterion = (fvSCrtrn)ab;
            USegSubCriterion vcSubCriterion = new USegSubCriterion();
            vcSubCriterion.setName(apicNestedSubCriterion.getName());
            vcSubCriterion.setDescr(apicNestedSubCriterion.getDescr());
            vcSubCriterion.setMatch(apicNestedSubCriterion.getMatch());
            this.buildVCSubCriterion((ManagedObject)apicNestedSubCriterion, vcSubCriterion);
            subCriteria.add(vcSubCriterion);
        }
        subCriterion.setSubCriteria(subCriteria);
    }

    public List<Vrf> getVRFs(String tenantName, PageQueryBuilder pqb, String propValue) throws ApicMoOperationException {
        ArrayList<Vrf> vrfs = new ArrayList<Vrf>();
        String tenantDn = String.format("uni/tn-%s/", tenantName);
        String className = fvCtx.class.getSimpleName();
        String wcardFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", tenantDn);
        ManagedObjectQueryBuilder moqb = ManagedObjectQueryBuilder.getMoqbForClass(className, propValue);
        moqb.addQueryTargetFilter(wcardFilter);
        moqb.withRspSubtree("full");
        moqb.withRspSubtreeClass(String.format("%s", fvRtCtx.class.getSimpleName()));
        moqb.withPagination(pqb);
        List<ManagedObject> vrfObjs = moqb.getManagedObjectsFromBuilder(this._handle);
        for (ManagedObject vrfObj : vrfObjs) {
            fvCtx ctxMo = (fvCtx)vrfObj;
            Vrf vrf = new Vrf();
            vrf.setName(ctxMo.getName());
            vrf.setDescr(ctxMo.getDescr());
            vrf.setDn(ctxMo.getDn());
            vrf.setId(ctxMo.getDn());
            vrf.setPcEnfPref(ctxMo.getPcEnfPref());
            List fvRtCtxChildren = vrfObj.getChild(fvRtCtx.class.getSimpleName());
            if (fvRtCtxChildren != null && fvRtCtxChildren.size() > 0) {
                for (ApicBase mo : fvRtCtxChildren) {
                    fvRtCtx rtCtx = (fvRtCtx)mo;
                    String bdName = this.getPropertyFromDn(rtCtx.getTDn(), "BD-");
                    Bd bd = new Bd();
                    bd.setDn(rtCtx.getTDn());
                    bd.setName(bdName);
                    vrf.addBdsItem(bd);
                }
            }
            Tenant parentTenant = new Tenant();
            parentTenant.setName(Utils.getTenantFromDn((String)ctxMo.getDn()));
            parentTenant.setId(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            parentTenant.setDn(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            vrf.setParentTenant(parentTenant);
            this.setFaultsCountUtil((ManagedObject)ctxMo, vrf);
            this.setHealthScoreUtil((ManagedObject)ctxMo, vrf);
            vrfs.add(vrf);
        }
        return vrfs;
    }

    public void createVrf(String vrfName, String description, String tenantName, String enforcePolicyPreference, boolean createOnly) throws ApicMoOperationException {
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        if (createOnly) {
            String vrfDn = "uni/tn-" + tenantName + "/ctx-" + vrfName;
            String dnFilter = ManagedObjectQueryBuilder.createEqFilter(fvCtx.class.getSimpleName(), "dn", vrfDn);
            ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
            moqb.withMoClassName(fvCtx.class.getSimpleName()).withQueryTargetFilter(dnFilter);
            List<ManagedObject> existingVrf = moqb.getManagedObjectsFromBuilder(this._handle);
            if (!existingVrf.isEmpty()) {
                throw new ApicMoOperationException("Request sent with create-only , VRF " + vrfName + " already exists under Tenant " + tenantName + " in this fabric");
            }
        }
        fvTenant ctxParentTenant = new fvTenant();
        ctxParentTenant.setName(tenantName);
        fvCtx ctx = new fvCtx();
        ctx.setName(vrfName);
        ctx.setDescr(description);
        ctx.setPcEnfPref(enforcePolicyPreference);
        ctxParentTenant.addManagedObject((ManagedObject)ctx);
        this.pushApicConfig((ManagedObject)ctxParentTenant);
    }

    public void deleteVrf(String vrfName, String tenantName) throws ApicMoOperationException {
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        fvTenant ctxParentTenant = new fvTenant();
        ctxParentTenant.setName(tenantName);
        fvCtx ctx = new fvCtx();
        ctx.setName(vrfName);
        ctx.setStatus("deleted");
        ctxParentTenant.addManagedObject((ManagedObject)ctx);
        this.pushApicConfig((ManagedObject)ctxParentTenant);
    }

    public List<Bd> getBDs(String tenantName, PageQueryBuilder pqb, String propValue, boolean includeCommon) throws ApicMoOperationException {
        ArrayList<Bd> bds = new ArrayList<Bd>();
        String tenantDn = String.format("uni/tn-%s/", tenantName);
        String className = fvBD.class.getSimpleName();
        String wcardFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", tenantDn);
        ManagedObjectQueryBuilder moqb = ManagedObjectQueryBuilder.getMoqbForClass(className, propValue);
        moqb.addQueryTargetFilter(wcardFilter);
        moqb.withRspSubtree("full");
        moqb.withRspSubtreeClass(String.format("%s,%s", fvRsCtx.class.getSimpleName(), fvSubnet.class.getSimpleName()));
        moqb.withPagination(pqb);
        if (includeCommon && !tenantName.equals("common")) {
            moqb.addOptionalQueryTargetFilter(ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", Constants.commonTenantDn));
        }
        List<ManagedObject> bdObjs = moqb.getManagedObjectsFromBuilder(this._handle);
        for (ManagedObject bdObj : bdObjs) {
            fvBD bdMo = (fvBD)bdObj;
            Bd bd = new Bd();
            bd.setName(bdMo.getName());
            bd.setDescr(bdMo.getDescr());
            Tenant parentTenant = new Tenant();
            parentTenant.setName(Utils.getTenantFromDn((String)bdMo.getDn()));
            parentTenant.setId(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            parentTenant.setDn(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            bd.setParentTenant(parentTenant);
            bd.setDn(bdMo.getDn());
            bd.setId(bdMo.getDn());
            List fvRsCtxChildren = bdObj.getChild(fvRsCtx.class.getSimpleName());
            if (fvRsCtxChildren != null && fvRsCtxChildren.size() > 0) {
                for (ApicBase mo : fvRsCtxChildren) {
                    fvRsCtx rsCtx = (fvRsCtx)mo;
                    String vrfName = this.getPropertyFromDn(rsCtx.getTDn(), "ctx-");
                    Vrf vrf = new Vrf();
                    vrf.setId(rsCtx.getTDn());
                    vrf.setDn(rsCtx.getTDn());
                    vrf.setName(vrfName);
                    bd.setVrf(vrf);
                }
            }
            ArrayList<Subnet> privateSubnetList = new ArrayList<Subnet>();
            ArrayList<Subnet> sharedSubnetList = new ArrayList<Subnet>();
            ArrayList<Subnet> advertisedSubnetList = new ArrayList<Subnet>();
            List fvSubnetList = bdObj.getChild(fvSubnet.class.getSimpleName());
            for (ApicBase ab : fvSubnetList) {
                fvSubnet apicSubnet = (fvSubnet)ab;
                Subnet subnet = new Subnet();
                subnet.setId(apicSubnet.getDn());
                subnet.setIp(apicSubnet.getIp());
                subnet.setName(apicSubnet.getName());
                subnet.setDescr(apicSubnet.getDescr());
                String scope = apicSubnet.getScope();
                subnet.setScope(scope);
                if (scope.contains("private")) {
                    privateSubnetList.add(subnet);
                }
                if (scope.contains("public")) {
                    advertisedSubnetList.add(subnet);
                }
                if (!scope.contains("shared")) continue;
                sharedSubnetList.add(subnet);
            }
            bd.setSubnetList(privateSubnetList);
            bd.setSharedSubnetList(sharedSubnetList);
            bd.setAdvertisedSubnetList(advertisedSubnetList);
            this.setFaultsCountUtil((ManagedObject)bdMo, bd);
            this.setHealthScoreUtil((ManagedObject)bdMo, bd);
            bds.add(bd);
        }
        return bds;
    }

    public void createBd(String name, String description, List<Subnet> subnetList, String tenantName, Vrf vrf, boolean createOnly) throws ApicMoOperationException {
        boolean subnetIpNull;
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        if (vrf == null || vrf.getName() == null) {
            throw new ApicMoOperationException("VRF missing");
        }
        if (subnetList != null && subnetList.size() > 0 && (subnetIpNull = subnetList.stream().anyMatch(sub -> sub.getIp() == null))) {
            throw new ApicMoOperationException("Subnet IP missing");
        }
        fvTenant parentTenant = new fvTenant();
        parentTenant.setName(tenantName);
        fvCtx ctx = new fvCtx();
        ctx.setName(vrf.getName());
        parentTenant.addManagedObject((ManagedObject)ctx);
        fvBD bd = new fvBD();
        bd.setDescr(description);
        bd.setName(name);
        fvRsCtx bdVrfRelation = new fvRsCtx();
        bdVrfRelation.setTnFvCtxName(vrf.getName());
        bd.addManagedObject((ManagedObject)bdVrfRelation);
        parentTenant.addManagedObject((ManagedObject)bd);
        ArrayList updatedSubnetList = new ArrayList();
        String className = fvBD.class.getSimpleName();
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        String bdDn = "uni/tn-" + tenantName + "/BD-" + name;
        String eqFilter = ManagedObjectQueryBuilder.createEqFilter(className, "dn", bdDn);
        moqb.withMoClassName(className).withQueryTargetFilter(eqFilter).withRspSubtree("full");
        List<ManagedObject> bdList = moqb.getManagedObjectsFromBuilder(this._handle);
        if (bdList != null && bdList.size() > 0) {
            if (createOnly) {
                throw new ApicMoOperationException("Request sent with create-only , BD " + name + " already exists under Tenant " + tenantName + " in this fabric");
            }
            fvBD oldBdObject = (fvBD)bdList.get(0);
            this.updateSubnets(oldBdObject, subnetList, bd);
        }
        for (Subnet sub2 : subnetList) {
            fvSubnet subnet = new fvSubnet();
            subnet.setIp(sub2.getIp());
            subnet.setDescr(sub2.getDescr());
            subnet.setName(sub2.getName());
            subnet.setScope(sub2.getScope());
            bd.addManagedObject((ManagedObject)subnet);
        }
        this.pushApicConfig((ManagedObject)parentTenant);
    }

    private void updateSubnets(fvBD oldBdObject, List<Subnet> inputSubnetList, fvBD newBdObject) {
        List existingSubnets = oldBdObject.getChild(fvSubnet.class.getSimpleName());
        for (ApicBase ab : existingSubnets) {
            boolean subnetPresentandNeeded;
            fvSubnet existingSubnet = (fvSubnet)ab;
            String existingSubnetIp = existingSubnet.getIp();
            if (!existingSubnet.getScope().contains("private") || (subnetPresentandNeeded = inputSubnetList.stream().anyMatch(sub -> sub.getIp().equals(existingSubnetIp)))) continue;
            fvSubnet removeSubnet = new fvSubnet();
            removeSubnet.setIp(existingSubnetIp);
            removeSubnet.setStatus("deleted");
            newBdObject.addManagedObject((ManagedObject)removeSubnet);
        }
    }

    public void deleteBd(String name, String tenantName) throws ApicMoOperationException {
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        String className = fvBD.class.getSimpleName();
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        String bdDn = "uni/tn-" + tenantName + "/BD-" + name;
        String wcardFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", bdDn);
        moqb.withMoClassName(className).withQueryTargetFilter(wcardFilter).withRspSubtree("full");
        List<ManagedObject> bdList = moqb.getManagedObjectsFromBuilder(this._handle);
        if (bdList != null && bdList.size() > 0) {
            fvBD oldBdObject = (fvBD)bdList.get(0);
            List l3OutRelationList = oldBdObject.getChild(fvRsBDToOut.class.getSimpleName());
            if (l3OutRelationList != null && l3OutRelationList.size() > 0) {
                throw new ApicMoOperationException("This Bridge Domain is linked to an L3 Out, it cannot be deleted");
            }
            List l2OutRelationList = oldBdObject.getChild(fvRtEBd.class.getSimpleName());
            if (l2OutRelationList != null && l2OutRelationList.size() > 0) {
                throw new ApicMoOperationException("This Bridge Domain is linked to an L2 Out, it cannot be deleted");
            }
            fvTenant parentTenant = new fvTenant();
            parentTenant.setName(tenantName);
            fvBD bd = new fvBD();
            bd.setName(name);
            bd.setStatus("deleted");
            parentTenant.addManagedObject((ManagedObject)bd);
            this.pushApicConfig((ManagedObject)parentTenant);
        }
    }

    public void setFaultsCountUtil(ManagedObject mo, AciMo aciMo) throws ApicMoOperationException {
        if (mo == null) {
            throw new ApicMoOperationException(" Cannot set faults, APIC object is null");
        }
        if (aciMo == null) {
            throw new ApicMoOperationException("Cannot set faults on null object");
        }
        List faultCountsWithDetails2 = mo.getChild("faultCountsWithDetails");
        if (faultCountsWithDetails2.size() > 0) {
            for (ApicBase fCountObj : faultCountsWithDetails2) {
                faultCountsWithDetails fc = (faultCountsWithDetails)fCountObj;
                FaultsCount fault = new FaultsCount();
                fault.setCritical(fc.getCrit());
                fault.setMajor(fc.getMaj());
                fault.setMinor(fc.getMinor());
                fault.setWarning(fc.getWarn());
                aciMo.setFaultsCount(fault);
            }
        } else {
            List faultCounts2 = mo.getChild("faultCounts");
            for (ApicBase fCountObj : faultCounts2) {
                faultCounts fc = (faultCounts)fCountObj;
                FaultsCount fault = new FaultsCount();
                fault.setCritical(fc.getCrit());
                fault.setMajor(fc.getMaj());
                fault.setMinor(fc.getMinor());
                fault.setWarning(fc.getWarn());
                aciMo.setFaultsCount(fault);
            }
        }
    }

    public void setHealthScoreUtil(ManagedObject mo, AciMo aciMo) {
        List healthInstObjs = mo.getChild("healthInst");
        for (ApicBase hObj : healthInstObjs) {
            healthInst hi = (healthInst)hObj;
            aciMo.setHealthscore(Integer.valueOf(hi.getCur()));
        }
    }

    public boolean isTrue(String value) {
        return "yes".equals(value) || "true".equals(value);
    }

    public String getPropertyFromDn(String dn, String rnPrefix) {
        String pattern = String.format(".*\\/%s(.*)", rnPrefix);
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(dn);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private ManagedObjectQueryBuilder getMoqbForEpgsForDom(String domName, String propValue) {
        String dnFilter = ManagedObjectQueryBuilder.createEqFilter(fvRsDomAtt.class.getSimpleName(), "tDn", "uni/vmmp-VMware/dom-" + domName + "/");
        String className = fvAEPg.class.getSimpleName();
        String wcardFilter = propValue.isEmpty() ? null : ManagedObjectQueryBuilder.createWildcardFilter(className, "name", propValue);
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        moqb.withMoClassName(className).withQueryTargetFilter(wcardFilter).withRspSubtree("full").withRspSubtreeFilter(dnFilter).withRspSubtreeInclude("health,required");
        return moqb;
    }

    public int getEpgsForDomCount(String domName, String propValue) throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = this.getMoqbForEpgsForDom(domName, propValue);
        int count = this.getMoCount(moqb);
        return count;
    }

    public List<Epg> getEpgsFromDomain(String domainName, List<Vcenter> vcenters, String username, String propVaule, PageQueryBuilder pqb) throws ApicMoOperationException, Exception {
        List<ManagedObject> hvsExtPolList;
        List<ManagedObject> compCtrlrMOs = this.getCompCtrlrsForVcForDomain(vcenters, domainName);
        ManagedObjectQueryBuilder moqb_hvs = new ManagedObjectQueryBuilder();
        String domainString = "\\[" + domainName + "\\]";
        String domainFilter = ManagedObjectQueryBuilder.createWildcardFilter(hvsExtPol.class.getSimpleName(), "dn", domainString);
        moqb_hvs.withMoClassName(hvsExtPol.class.getSimpleName()).withQueryTargetFilter(domainFilter).withRspSubtree("full");
        List<ManagedObject> apicPortGroupList = hvsExtPolList = moqb_hvs.getManagedObjectsFromBuilder(this._handle);
        HashMap<String, List> expectedPortGroupMap = new HashMap<String, List>();
        for (ManagedObject ctrlrMO : compCtrlrMOs) {
            compCtrlr compCtrlrMO = (compCtrlr)ctrlrMO;
            if (!compCtrlrMO.getDomName().equals(domainName)) continue;
            compCtrlr domainCtrlr = compCtrlrMO;
            String vcGuid = domainCtrlr.getSer();
            String domainCtrlrDn = domainCtrlr.getDn();
            this.log.info("CompCtrlrDn is " + domainCtrlrDn);
            HashMap<String, hvsExtPol> apicPortGroupMap = new HashMap<String, hvsExtPol>();
            for (hvsExtPol hvsExtPol2 : apicPortGroupList) {
                if (!hvsExtPol2.getDn().contains(domainCtrlrDn)) continue;
                if (apicPortGroupMap.containsKey(hvsExtPol2.getName())) {
                    throw new ApicMoOperationException("Multiple Port Group by same name under same compCtrlr");
                }
                apicPortGroupMap.put(hvsExtPol2.getName(), hvsExtPol2);
            }
            Vcenter vc = vcenters.stream().filter(obj -> obj.getGuid().equals(vcGuid)).findFirst().orElse(null);
            if (vc == null) {
                throw new ApicMoOperationException("Cannot identify VC linked to compCtrlr matching on domainName");
            }
            VCenterSdk vCenterSdk = new VCenterSdk(username, vc);
            vCenterSdk.connectVIM();
            String dvsUuid = null;
            List hvsLNodeList = compCtrlrMO.getChild(hvsLNode.class.getSimpleName());
            for (ApicBase ab : hvsLNodeList) {
                hvsLNode hvsLNodeMo = (hvsLNode)ab;
                dvsUuid = hvsLNodeMo.getGuid();
            }
            List<Dvs> dvsList = null;
            dvsList = vCenterSdk.getDvs(ApiSpecUtil.propFilterSpec("uuid", dvsUuid), true);
            Dvs dvs = null;
            if (dvsList != null && dvsList.size() != 0 && dvsList.get(0).getVcId().equals(vcGuid)) {
                dvs = dvsList.get(0);
            }
            List<PortGroup> vcPortGroupList = null;
            if (dvs != null) {
                vcPortGroupList = dvs.getPortgroups();
            }
            if (vcPortGroupList == null) continue;
            for (PortGroup pg : vcPortGroupList) {
                List<CustomDefinition> customAttributes;
                CustomDefinition def;
                this.log.info("For Port Group " + pg.getName());
                if (domainCtrlr.getAccessMode().equals("read-only") && (def = (CustomDefinition)(customAttributes = pg.getCustomAttributes()).stream().filter(obj -> obj.getName().equals(Constants.CUSTOMATTR_NAME)).findAny().orElse(null)) != null && def.getValue() != null && !def.getValue().isEmpty()) {
                    expectedPortGroupMap.computeIfAbsent(def.getValue(), k -> new ArrayList()).add(pg);
                    continue;
                }
                hvsExtPol apicPortGroup = (hvsExtPol)apicPortGroupMap.get(pg.getName());
                if (apicPortGroup == null) continue;
                this.log.info("Found hvsExtPol " + apicPortGroup.getName());
                List hvsRsEpPDList = apicPortGroup.getChild(hvsRsEpPD.class.getSimpleName());
                List apicRelationList = hvsRsEpPDList;
                if (apicRelationList == null || apicRelationList.size() <= 0 || !((hvsRsEpPD)apicRelationList.get(0)).getTDn().contains(domainCtrlrDn)) continue;
                hvsRsEpPD epPDRelation = (hvsRsEpPD)apicRelationList.get(0);
                this.log.info("Found relational object hvsRsEpPD: " + epPDRelation.getTDn());
                String epPDRelationDn = epPDRelation.getTDn();
                String splitString = domainCtrlrDn + "/eppd-";
                int splitStringSize = splitString.length();
                String epgDn = epPDRelationDn.substring(splitStringSize);
                String expectedPortGroupName = this.getExpectedPortGroupNameFromEpg(epgDn = epgDn.replaceAll("\\[", "").replaceAll("\\]", ""));
                if (expectedPortGroupName == null) continue;
                expectedPortGroupMap.computeIfAbsent(expectedPortGroupName, k -> new ArrayList()).add(pg);
            }
        }
        String className = fvAEPg.class.getSimpleName();
        OrderQueryBuilder orderQb = new OrderQueryBuilder(className);
        ManagedObjectQueryBuilder moqb = this.getMoqbForEpgsForDom(domainName, propVaule);
        moqb.withOrderQuery(orderQb).withPagination(pqb);
        List<ManagedObject> aepgObjs = moqb.getManagedObjectsFromBuilder(this._handle);
        ArrayList<Epg> epgList = new ArrayList<Epg>();
        for (ManagedObject mo : aepgObjs) {
            fvAEPg fvAEPg2 = (fvAEPg)mo;
            Epg epg = new Epg();
            epg.setId(fvAEPg2.getDn());
            epg.setDn(fvAEPg2.getDn());
            epg.setName(fvAEPg2.getName());
            epg.setDescr(fvAEPg2.getDescr());
            epg.setType("local");
            String expectedPortGroupName = this.getExpectedPortGroupNameFromEpg(fvAEPg2.getDn());
            List portGroupList = (List)expectedPortGroupMap.get(expectedPortGroupName);
            epg.setPortGroups(portGroupList);
            VmmDomain dom = new VmmDomain();
            dom.setName(domainName);
            ArrayList<EpgDomainSettings> epgDomainSettings = new ArrayList<EpgDomainSettings>();
            EpgDomainSettings settings = new EpgDomainSettings();
            settings.setVmmDomain(dom);
            epgDomainSettings.add(settings);
            epg.setEpgDomainSettings(epgDomainSettings);
            Tenant tenant = new Tenant();
            tenant.setName(Utils.getTenantFromDn((String)fvAEPg2.getDn()));
            tenant.setId(this.buildDnForAciObject(fvTenant.class.getSimpleName(), tenant.getName(), null));
            tenant.setDn(this.buildDnForAciObject(fvTenant.class.getSimpleName(), tenant.getName(), null));
            epg.setParentTenant(tenant);
            App app = new App();
            app.setName(Utils.getApFromDn((String)fvAEPg2.getDn()));
            app.setId(this.buildDnForAciObject(fvAp.class.getSimpleName(), epg.getParentTenant().getName(), app.getName()));
            app.setDn(this.buildDnForAciObject(fvAp.class.getSimpleName(), epg.getParentTenant().getName(), app.getName()));
            epg.setParentApp(app);
            this.setHealthScoreUtil((ManagedObject)fvAEPg2, epg);
            epgList.add(epg);
        }
        return epgList;
    }

    String getExpectedPortGroupNameFromEpg(String epgDn) {
        if (epgDn == null) {
            return null;
        }
        String tenantName = Utils.getTenantFromDn((String)epgDn);
        String appName = Utils.getApFromDn((String)epgDn);
        String epgName = Utils.getEpgFromDn((String)epgDn);
        if (tenantName.equals("") || appName.equals("") || epgName.equals("")) {
            this.log.info("Input EPG dn does not have standard format");
            return null;
        }
        String expectedPortGroupName = tenantName + "|" + appName + "|" + epgName;
        return expectedPortGroupName;
    }

    public void createApp(String tenantName, String appName, String descr, boolean createOnly) throws ApicMoOperationException {
        if (createOnly) {
            String appDn = "uni/tn-" + tenantName + "/ap-" + appName;
            String eqFilter = ManagedObjectQueryBuilder.createEqFilter(fvAp.class.getSimpleName(), "dn", appDn);
            ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
            moqb.withMoClassName(fvAp.class.getSimpleName()).withQueryTargetFilter(eqFilter);
            List<ManagedObject> existingAp = moqb.getManagedObjectsFromBuilder(this._handle);
            if (!existingAp.isEmpty()) {
                throw new ApicMoOperationException("Request sent with create-only , Application Profile " + appName + " already exists under Tenant " + tenantName + " in this fabric");
            }
        }
        fvTenant fvTenantMo = new fvTenant();
        fvTenantMo.setName(tenantName);
        fvAp fvApMo = new fvAp();
        fvApMo.setName(appName);
        fvApMo.setDescr(descr);
        fvTenantMo.addManagedObject((ManagedObject)fvApMo);
        this.log.info("Creating application profile: " + appName);
        this.pushApicConfig((ManagedObject)fvTenantMo);
        this.log.info("Created application profile: " + appName);
    }

    public void deleteApp(String tenantname, String appName) throws ApicMoOperationException {
        fvTenant fvTenantMo = new fvTenant();
        fvTenantMo.setName(tenantname);
        fvAp fvApMo = new fvAp();
        fvApMo.setName(appName);
        fvApMo.setStatus("deleted");
        fvTenantMo.addManagedObject((ManagedObject)fvApMo);
        this.log.info("Deleting application profile: " + appName);
        this.pushApicConfig((ManagedObject)fvTenantMo);
        this.log.info("Deleted application profile: " + appName);
    }

    public List<App> getAppsUnderTenant(String tenantName, PageQueryBuilder pqb, String propValue) throws ApicMoOperationException {
        String className = fvAp.class.getSimpleName();
        OrderQueryBuilder orderQb = new OrderQueryBuilder(className);
        ManagedObjectQueryBuilder moqb = this.getMoqbForApps(tenantName, propValue);
        moqb.withOrderQuery(orderQb).withPagination(pqb);
        List<ManagedObject> appObjects = moqb.getManagedObjectsFromBuilder(this._handle);
        ArrayList<App> appList = new ArrayList<App>();
        for (ManagedObject mo : appObjects) {
            fvAp apMo = (fvAp)mo;
            App app = new App();
            app.setName(apMo.getName());
            app.setDescr(apMo.getDescr());
            String appDn = apMo.getDn();
            app.setDn(appDn);
            app.setId(appDn);
            Tenant parentTenant = new Tenant();
            parentTenant.setName(Utils.getTenantFromDn((String)appDn));
            parentTenant.setId(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            parentTenant.setDn(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            app.setParentTenant(parentTenant);
            this.setFaultsCountUtil((ManagedObject)apMo, app);
            this.setHealthScoreUtil((ManagedObject)apMo, app);
            appList.add(app);
        }
        return appList;
    }

    public int getAppsCount(String tenantName, String propValue) throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = this.getMoqbForApps(tenantName, propValue);
        int count = this.getMoCount(moqb);
        return count;
    }

    private ManagedObjectQueryBuilder getMoqbForApps(String tenantName, String propValue) {
        String className = fvAp.class.getSimpleName();
        String appDn = "uni/tn-" + tenantName + "/ap-";
        String dnFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", appDn);
        String finalFilter = propValue.isEmpty() ? dnFilter : "and(" + dnFilter + "," + ManagedObjectQueryBuilder.createWildcardFilter(className, "name", propValue) + ")";
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        moqb.withMoClassName(className).withQueryTargetFilter(finalFilter).withRspSubtreeInclude("health,fault-count");
        return moqb;
    }

    private void pushApicConfig(ManagedObject mo) throws ApicMoOperationException {
        imdata imd = MethodFactory.configMo((ApicHandle)this._handle, (ManagedObject)mo);
        if (imd.getErrorCode() != 0L) {
            String errorMsg = String.format("Error description: %s . Error code: %s", imd.getErrorDescr(), imd.getErrorCode());
            this.log.error(errorMsg);
            throw new ApicMoOperationException(errorMsg);
        }
    }

    public void createTenant(String tenantName, String tenantDescr, boolean createOnly) throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb;
        List<ManagedObject> existingTenant;
        if (createOnly && !(existingTenant = (moqb = new ManagedObjectQueryBuilder().withMoClassName(fvTenant.class.getSimpleName()).withQueryTargetFilter(ManagedObjectQueryBuilder.createEqFilter(fvTenant.class.getSimpleName(), "name", tenantName))).getManagedObjectsFromBuilder(this._handle)).isEmpty()) {
            throw new ApicMoOperationException("Request sent with create-only , Tenant " + tenantName + " already exists in this fabric ");
        }
        fvTenant fvTenantMo = new fvTenant();
        fvTenantMo.setName(tenantName);
        fvTenantMo.setDescr(tenantDescr);
        fvAp defaultAp = new fvAp();
        defaultAp.setName(tenantName + "_default");
        fvTenantMo.addManagedObject((ManagedObject)defaultAp);
        fvBD bd = new fvBD();
        bd.setName(tenantName + "_default");
        bd.setDescr(tenantName + " default Bridge Domain");
        fvCtx privateNetwork = new fvCtx();
        String pvName = tenantName + "_default";
        privateNetwork.setName(pvName);
        privateNetwork.setDescr(tenantName + " default VRF");
        fvRsCtx rsCtx = new fvRsCtx();
        rsCtx.setTnFvCtxName(pvName);
        bd.addManagedObject((ManagedObject)rsCtx);
        fvTenantMo.addManagedObject((ManagedObject)bd);
        fvTenantMo.addManagedObject((ManagedObject)privateNetwork);
        this.log.info("Creating tenant: " + tenantName);
        this.pushApicConfig((ManagedObject)fvTenantMo);
        this.log.info("Created tenant: " + tenantName);
    }

    public void deleteTenant(String tenantName) throws ApicMoOperationException {
        fvTenant fvTenantMo = new fvTenant();
        fvTenantMo.setName(tenantName);
        fvTenantMo.setStatus("deleted");
        this.log.info("Deleting tenant: " + tenantName);
        this.pushApicConfig((ManagedObject)fvTenantMo);
        this.log.info("Deleted tenant: " + tenantName);
    }

    public void deleteEpg(String tenantName, String appName, String epgName) throws ApicMoOperationException {
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        if (appName == null) {
            throw new ApicMoOperationException("Application profile missing ");
        }
        if (epgName == null) {
            throw new ApicMoOperationException("Epg name missing ");
        }
        fvTenant parentTenant = new fvTenant();
        parentTenant.setName(tenantName);
        fvAp parentApp = new fvAp();
        parentApp.setName(appName);
        parentTenant.addManagedObject((ManagedObject)parentApp);
        fvAEPg epg = new fvAEPg();
        epg.setName(epgName);
        epg.setStatus("deleted");
        parentApp.addManagedObject((ManagedObject)epg);
        this.pushApicConfig((ManagedObject)parentTenant);
    }

    public void createEpg(String name, String description, String tenantName, String appName, List<EpgDomainSettings> domainSettings, boolean useSharedBd, String bdName, boolean isIntraIsolated, USegCriterion uSegCriterion, boolean createOnly, String username) throws ApicMoOperationException, Exception {
        this.log.info(" ApicSdk || createEpg for " + name);
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        if (appName == null) {
            throw new ApicMoOperationException("Application profile missing ");
        }
        HashMap<ManagedObjectReference, VCenterSdk> portgroupVCenterSdkMap = new HashMap<ManagedObjectReference, VCenterSdk>();
        fvTenant parentTenant = new fvTenant();
        parentTenant.setName(tenantName);
        fvAp parentApp = new fvAp();
        parentApp.setName(appName);
        parentTenant.addManagedObject((ManagedObject)parentApp);
        fvAEPg epg = new fvAEPg();
        epg.setName(name);
        epg.setDescr(description);
        parentApp.addManagedObject((ManagedObject)epg);
        if (useSharedBd && bdName == null) {
            bdName = "default";
        }
        fvRsBd bdRelation = new fvRsBd();
        bdRelation.setTnFvBDName(bdName);
        epg.addManagedObject((ManagedObject)bdRelation);
        if (isIntraIsolated) {
            epg.setPcEnfPref("enforced");
        } else {
            epg.setPcEnfPref("unenforced");
        }
        String className = fvAEPg.class.getSimpleName();
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        String epgDn = "uni/tn-" + tenantName + "/ap-" + appName + "/epg-" + name;
        String eqFilter = ManagedObjectQueryBuilder.createEqFilter(className, "dn", epgDn);
        moqb.withMoClassName(className).withQueryTargetFilter(eqFilter).withRspSubtree("full");
        List<ManagedObject> epglist = moqb.getManagedObjectsFromBuilder(this._handle);
        fvAEPg oldEpgObject = null;
        if (epglist != null && epglist.size() > 0) {
            if (createOnly) {
                throw new ApicMoOperationException("EPG " + name + " already exists under Tenant " + tenantName + " under Application Profile " + appName + " in this fabric");
            }
            this.log.info("EPG " + name + " exists already");
            oldEpgObject = (fvAEPg)epglist.get(0);
            this.updateEpgDomains(epg, oldEpgObject, domainSettings);
        }
        if (uSegCriterion != null) {
            if (oldEpgObject == null) {
                epg.setIsAttrBasedEPg("yes");
            }
            fvCrtrn newCriterion = new fvCrtrn();
            epg.addManagedObject((ManagedObject)newCriterion);
            newCriterion.setName(uSegCriterion.getName());
            newCriterion.setMatch(uSegCriterion.getMatch());
            newCriterion.setPrec((long)uSegCriterion.getPrec().intValue());
            if (oldEpgObject != null) {
                List oldCriterionList = oldEpgObject.getChild(fvCrtrn.class.getSimpleName());
                fvCrtrn oldCriterion = (fvCrtrn)oldCriterionList.get(0);
                this.updateCriterion((ManagedObject)oldCriterion, (ManagedObject)newCriterion, uSegCriterion);
            } else {
                List<USegAttribute> attributeList = uSegCriterion.getAttributes();
                this.buildAttributes((ManagedObject)newCriterion, attributeList);
                List<USegSubCriterion> subCriteria = uSegCriterion.getSubCriteria();
                if (subCriteria != null) {
                    for (USegSubCriterion subCriterion : subCriteria) {
                        fvSCrtrn newSubCriterion = new fvSCrtrn();
                        newCriterion.addManagedObject((ManagedObject)newSubCriterion);
                        this.buildSubCriteria(newSubCriterion, subCriterion);
                    }
                }
            }
        }
        if (domainSettings != null) {
            for (EpgDomainSettings epgSettings : domainSettings) {
                PortGroup selectedPortGroup;
                LagPolicy lagPolicy;
                boolean isAvsOrAve;
                boolean isAve = "yes".equals(epgSettings.getEnableAve()) || "true".equals(epgSettings.getEnableAve());
                boolean bl = isAvsOrAve = "n1kv".equals(epgSettings.getMode()) || isAve;
                VmmDomain inputDomain = epgSettings.getVmmDomain();
                if (inputDomain == null) continue;
                String inputDomainName = inputDomain.getName();
                fvRsDomAtt vmmRelation = new fvRsDomAtt();
                vmmRelation.setTDn(epgSettings.getVmmDomain().getDn());
                vmmRelation.setEncapMode(epgSettings.getEncapMode());
                vmmRelation.setResImedcy("immediate");
                if (uSegCriterion != null && !isAvsOrAve) {
                    vmmRelation.setInstrImedcy("immediate");
                }
                if (!isAvsOrAve && epgSettings.isAllowUSeg() != null) {
                    vmmRelation.setClassPref(epgSettings.isAllowUSeg() != false ? "useg" : "encap");
                } else if (isAvsOrAve && !"unspecified".equals(epgSettings.getDomainEncapMode())) {
                    vmmRelation.setEncapMode(epgSettings.getEncapMode());
                }
                if (isAve) {
                    vmmRelation.setSwitchingMode(epgSettings.getSwitchingMode());
                    this.log.info("Got switching mode= " + epgSettings.getSwitchingMode());
                }
                if ((lagPolicy = epgSettings.getSelectedLagPolicy()) != null) {
                    fvAEPgLagPolAtt lagPolAtt = new fvAEPgLagPolAtt();
                    fvRsVmmVSwitchEnhancedLagPol lagPolRelation = new fvRsVmmVSwitchEnhancedLagPol();
                    lagPolRelation.setTDn(lagPolicy.getDn());
                    lagPolAtt.addManagedObject((ManagedObject)lagPolRelation);
                    vmmRelation.addManagedObject((ManagedObject)lagPolAtt);
                }
                if (inputDomain.getType() != null && inputDomain.getType().equals((Object)VmmDomain.TypeEnum.VSPHEREMANAGED) && (selectedPortGroup = epgSettings.getSelectedPortGroup()) != null) {
                    ManagedObjectReference distributedVirtualPortgroup;
                    int vlanId = selectedPortGroup.getVlanId();
                    List<Vcenter> vcenters = inputDomain.getVcenters();
                    HashMap<String, Vcenter> vcGuidMap = new HashMap<String, Vcenter>();
                    if (vcenters != null) {
                        for (Vcenter vc : vcenters) {
                            vcGuidMap.put(vc.getGuid(), vc);
                        }
                    }
                    if (selectedPortGroup.isCreateOnly().booleanValue()) {
                        boolean atleastOneDvsFound = false;
                        List<ManagedObject> compCtrlrs = this.getCompCtrlrsForVcForDomain(inputDomain.getVcenters(), inputDomainName);
                        for (ManagedObject mo : compCtrlrs) {
                            compCtrlr compCtrlrMo = (compCtrlr)mo;
                            Vcenter vc = (Vcenter)vcGuidMap.get(compCtrlrMo.getSer());
                            VCenterSdk vCenterSdk = new VCenterSdk(username, vc);
                            vCenterSdk.connectVIM();
                            String dvsUuid = null;
                            List hvsLNodeList = compCtrlrMo.getChild(hvsLNode.class.getSimpleName());
                            for (ApicBase ab : hvsLNodeList) {
                                hvsLNode hvsLNodeMo = (hvsLNode)ab;
                                dvsUuid = hvsLNodeMo.getGuid();
                            }
                            if (dvsUuid == null) continue;
                            atleastOneDvsFound = true;
                            distributedVirtualPortgroup = vCenterSdk.createDistributedVirtualPortGroup(dvsUuid, selectedPortGroup);
                            if (distributedVirtualPortgroup == null) continue;
                            portgroupVCenterSdkMap.put(distributedVirtualPortgroup, vCenterSdk);
                        }
                        if (!atleastOneDvsFound) {
                            throw new ApicMoOperationException("Did not find configuration indicating DVS for read-only domain " + inputDomainName + " is present on VC");
                        }
                    } else {
                        String vcGuid = selectedPortGroup.getVcId();
                        String moId = selectedPortGroup.getOid();
                        Vcenter vc = (Vcenter)vcGuidMap.get(vcGuid);
                        VCenterSdk vCenterSdk = new VCenterSdk(username, vc);
                        vCenterSdk.connectVIM();
                        distributedVirtualPortgroup = vCenterSdk.getDistributedVirtualPortGroupById(moId);
                        if (distributedVirtualPortgroup != null) {
                            portgroupVCenterSdkMap.put(distributedVirtualPortgroup, vCenterSdk);
                        }
                    }
                    String vlanEncap = "vlan-" + vlanId;
                    this.log.info("CreatePG: Setting encap on fvRsDomAtt to " + vlanEncap);
                    vmmRelation.setEncap(vlanEncap);
                }
                epg.addManagedObject((ManagedObject)vmmRelation);
            }
        }
        this.log.info("CreatePG: Pushing config to APIC");
        this.pushApicConfig((ManagedObject)parentTenant);
        this.log.info("CreatePG: Epg creation completed");
        this.log.info("CreatePG: Adding custom attribute to portgroup on VC");
        String expectedCustomAttributeValue = tenantName + "|" + appName + "|" + name;
        if (portgroupVCenterSdkMap != null) {
            for (ManagedObjectReference dvPortGroup : portgroupVCenterSdkMap.keySet()) {
                VCenterSdk sdk = (VCenterSdk)portgroupVCenterSdkMap.get(dvPortGroup);
                sdk.addCustomAttributeValue(dvPortGroup, expectedCustomAttributeValue);
            }
        }
        this.log.info("CreatePG: Custom attribute set");
    }

    private void buildSubCriteria(fvSCrtrn apicSubCriterion, USegSubCriterion inputSubCriterion) {
        List<USegSubCriterion> uSegSubCriteriaList;
        apicSubCriterion.setName(inputSubCriterion.getName());
        apicSubCriterion.setMatch(inputSubCriterion.getMatch());
        List<USegAttribute> attributeList = inputSubCriterion.getAttributes();
        if (attributeList != null) {
            this.buildAttributes((ManagedObject)apicSubCriterion, attributeList);
        }
        if ((uSegSubCriteriaList = inputSubCriterion.getSubCriteria()) != null) {
            for (USegSubCriterion nestedInputSubCriterion : uSegSubCriteriaList) {
                fvSCrtrn nestedSubCriterion = new fvSCrtrn();
                apicSubCriterion.addManagedObject((ManagedObject)nestedSubCriterion);
                this.buildSubCriteria(nestedSubCriterion, nestedInputSubCriterion);
            }
        }
    }

    private void buildAttributes(ManagedObject parentMo, List<USegAttribute> attributeList) {
        if (attributeList != null) {
            for (USegAttribute attribute : attributeList) {
                if (attribute.getType().equals("ip")) {
                    fvIpAttr ipAttr = new fvIpAttr();
                    ipAttr.setName(attribute.getName());
                    ipAttr.setDescr(attribute.getDescr());
                    ipAttr.setIp(attribute.getValue());
                    parentMo.addManagedObject((ManagedObject)ipAttr);
                    continue;
                }
                if (attribute.getType().equals("mac")) {
                    fvMacAttr macAttr = new fvMacAttr();
                    macAttr.setName(attribute.getName());
                    macAttr.setDescr(attribute.getDescr());
                    macAttr.setMac(attribute.getValue());
                    parentMo.addManagedObject((ManagedObject)macAttr);
                    continue;
                }
                fvVmAttr vmAttr = new fvVmAttr();
                vmAttr.setName(attribute.getName());
                vmAttr.setDescr(attribute.getDescr());
                vmAttr.setType(attribute.getType());
                vmAttr.setOperator(attribute.getOperator());
                vmAttr.setValue(attribute.getValue());
                if ("custom-label".equals(attribute.getType())) {
                    vmAttr.setLabelName(attribute.getLabelName());
                }
                if ("tag".equals(attribute.getType())) {
                    vmAttr.setCategory(attribute.getLabelName());
                }
                parentMo.addManagedObject((ManagedObject)vmAttr);
            }
        }
    }

    private void updateCriterion(ManagedObject oldCriterion, ManagedObject newCriterion, USegSubCriterion uSegCriterion) {
        List<USegAttribute> uSegCriterionAttributes = uSegCriterion.getAttributes();
        List vmAttributeList = oldCriterion.getChild(fvVmAttr.class.getSimpleName());
        for (Object att : vmAttributeList) {
            fvVmAttr apicAttr = (fvVmAttr)att;
            String apicAttrName = apicAttr.getName();
            USegAttribute attribute = uSegCriterionAttributes.stream().filter(attr -> attr.getName().equals(apicAttr.getName())).findFirst().orElse(null);
            if (attribute == null) {
                fvVmAttr deleteAttr = (fvVmAttr)this.getOrCreateChildByName(newCriterion, fvVmAttr.class, apicAttrName);
                deleteAttr.setStatus("deleted");
                continue;
            }
            fvVmAttr editedAttr = (fvVmAttr)this.getOrCreateChildByName(newCriterion, fvVmAttr.class, apicAttrName);
            editedAttr.setType(attribute.getType());
            editedAttr.setOperator(attribute.getOperator());
            editedAttr.setValue(attribute.getValue());
            if ("custom-label".equals(attribute.getType())) {
                editedAttr.setLabelName(attribute.getLabelName());
            }
            if ("tag".equals(attribute.getType())) {
                editedAttr.setCategory(attribute.getLabelName());
            }
            uSegCriterionAttributes.remove(attribute);
        }
        List macAttributeList = oldCriterion.getChild(fvMacAttr.class.getSimpleName());
        for (Object att : macAttributeList) {
            fvMacAttr apicAttr = (fvMacAttr)att;
            String apicAttrNAme = apicAttr.getName();
            USegAttribute attribute = uSegCriterionAttributes.stream().filter(attr -> attr.getName().equals(apicAttr.getName())).findFirst().orElse(null);
            if (attribute == null) {
                fvMacAttr deleteAttr = (fvMacAttr)this.getOrCreateChildByName(newCriterion, fvMacAttr.class, apicAttrNAme);
                deleteAttr.setStatus("deleted");
                continue;
            }
            fvMacAttr editedMacAttr = (fvMacAttr)this.getOrCreateChildByName(newCriterion, fvMacAttr.class, apicAttrNAme);
            editedMacAttr.setMac(attribute.getValue());
            uSegCriterionAttributes.remove(attribute);
        }
        List ipAttributeList = oldCriterion.getChild(fvIpAttr.class.getSimpleName());
        for (ApicBase att : ipAttributeList) {
            fvIpAttr apicAttr = (fvIpAttr)att;
            String apicAttrNAme = apicAttr.getName();
            USegAttribute attribute = uSegCriterionAttributes.stream().filter(attr -> attr.getName().equals(apicAttr.getName())).findFirst().orElse(null);
            if (attribute == null) {
                fvIpAttr deleteAttr = (fvIpAttr)this.getOrCreateChildByName(newCriterion, fvIpAttr.class, apicAttrNAme);
                deleteAttr.setStatus("deleted");
                continue;
            }
            fvIpAttr editedIpAttr = (fvIpAttr)this.getOrCreateChildByName(newCriterion, fvIpAttr.class, apicAttrNAme);
            editedIpAttr.setIp(attribute.getValue());
            uSegCriterionAttributes.remove(attribute);
        }
        this.buildAttributes(newCriterion, uSegCriterionAttributes);
        List<USegSubCriterion> inputSubCriteria = uSegCriterion.getSubCriteria();
        List apicSubCriteriaList = oldCriterion.getChild(fvSCrtrn.class.getSimpleName());
        for (ApicBase subc : apicSubCriteriaList) {
            fvSCrtrn apicSubCriterion = (fvSCrtrn)subc;
            String apicSubCriterionName = apicSubCriterion.getName();
            USegSubCriterion inputSubCriterion = inputSubCriteria.stream().filter(crit -> crit.getName().equals(apicSubCriterionName)).findFirst().orElse(null);
            if (inputSubCriterion == null) {
                fvSCrtrn deleteSC = (fvSCrtrn)this.getOrCreateChildByName(newCriterion, fvSCrtrn.class, apicSubCriterionName);
                deleteSC.setStatus("deleted");
                continue;
            }
            fvSCrtrn newSC = (fvSCrtrn)this.getOrCreateChildByName(newCriterion, fvSCrtrn.class, apicSubCriterionName);
            this.updateCriterion((ManagedObject)apicSubCriterion, (ManagedObject)newSC, inputSubCriterion);
            inputSubCriteria.remove(inputSubCriterion);
        }
        if (inputSubCriteria != null) {
            for (USegSubCriterion userCriterion : inputSubCriteria) {
                fvSCrtrn newSubCriterion = (fvSCrtrn)this.getOrCreateChildByName(newCriterion, fvSCrtrn.class, userCriterion.getName());
                this.buildSubCriteria(newSubCriterion, userCriterion);
            }
        }
    }

    private void updateEpgDomains(fvAEPg newEpgObject, fvAEPg oldEpgObject, List<EpgDomainSettings> domainSettings) {
        this.log.info("EPG " + oldEpgObject.getName() + " Updating domains ");
        List fvRsDomAttList = oldEpgObject.getChild("fvRsDomAtt");
        for (ApicBase ab : fvRsDomAttList) {
            fvRsDomAtt domainRelation = (fvRsDomAtt)ab;
            String domainDn = domainRelation.getTDn();
            boolean dvsPresentandRequired = domainSettings.stream().anyMatch(dvsInfo -> dvsInfo.getVmmDomain().getDn().equals(domainDn));
            if (dvsPresentandRequired) continue;
            fvRsDomAtt removeDomainRelation = new fvRsDomAtt();
            removeDomainRelation.setTDn(domainDn);
            removeDomainRelation.setStatus("deleted");
            newEpgObject.addManagedObject((ManagedObject)removeDomainRelation);
        }
    }

    private ManagedObjectQueryBuilder getMoqbForContracts(String tenantName, String propValue) {
        String className = vzBrCP.class.getSimpleName();
        String tenantDn = "uni/tn-" + tenantName + "/";
        String dnFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", tenantDn);
        String finalFilter = propValue.isEmpty() ? dnFilter : "and(" + dnFilter + "," + ManagedObjectQueryBuilder.createWildcardFilter(className, "name", propValue) + ")";
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        moqb.withMoClassName(className).withQueryTargetFilter(finalFilter).withRspSubtree("full").withRspSubtreeInclude("health,fault-count");
        return moqb;
    }

    private ManagedObjectQueryBuilder getMoqbForContractsCount(String tenantName, String propValue) {
        String className = vzBrCP.class.getSimpleName();
        String tenantDn = "uni/tn-" + tenantName + "/";
        String dnFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", tenantDn);
        String finalFilter = propValue.isEmpty() ? dnFilter : "and(" + dnFilter + "," + ManagedObjectQueryBuilder.createWildcardFilter(className, "name", propValue) + ")";
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        moqb.withMoClassName(className).withQueryTargetFilter(finalFilter);
        return moqb;
    }

    public int getContractsCount(String tenantName, String propValue) throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = this.getMoqbForContractsCount(tenantName, propValue);
        int count = this.getMoCount(moqb);
        return count;
    }

    public List<Contract> getContracts(String tenantName, String propValue, PageQueryBuilder pqb) throws ApicMoOperationException {
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        String className = vzBrCP.class.getSimpleName();
        OrderQueryBuilder orderQb = new OrderQueryBuilder(className);
        ManagedObjectQueryBuilder moqb = this.getMoqbForContracts(tenantName, propValue);
        moqb.withOrderQuery(orderQb).withPagination(pqb);
        ArrayList<Contract> listOfContracts = new ArrayList<Contract>();
        List<ManagedObject> contractObjs = moqb.getManagedObjectsFromBuilder(this._handle);
        for (ManagedObject mo : contractObjs) {
            ApicBase subj2;
            vzBrCP contract = (vzBrCP)mo;
            Contract ctr = new Contract();
            ctr.setId(contract.getDn());
            ctr.setName(contract.getName());
            ctr.setDescr(contract.getDescr());
            Tenant parentTenant = new Tenant();
            parentTenant.setName(Utils.getTenantFromDn((String)contract.getDn()));
            parentTenant.setId(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            parentTenant.setDn(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            ctr.setParentTenant(parentTenant);
            ctr.setDescr(contract.getDescr());
            ArrayList<Filter> filters = new ArrayList<Filter>();
            ArrayList<Epg> consumers = new ArrayList<Epg>();
            ArrayList<Epg> providers = new ArrayList<Epg>();
            List subjects = contract.getChild("vzSubj");
            if (subjects != null && subjects.size() > 0) {
                if (subjects.size() > 1) {
                    ctr.setHasMultipleSubjects(true);
                }
                for (ApicBase subj2 : subjects) {
                    vzSubj subject = (vzSubj)subj2;
                    List inTerms = subject.getChild("vzInTerm");
                    if (inTerms == null || inTerms.size() == 0) {
                        ctr.setIsBidirectional(true);
                        List vzRsSubjFiltAttList = subject.getChild("vzRsSubjFiltAtt");
                        Iterator iterator = vzRsSubjFiltAttList.iterator();
                        while (iterator.hasNext()) {
                            ApicBase apicBase = (ApicBase)iterator.next();
                            vzRsSubjFiltAtt filtAtt = (vzRsSubjFiltAtt)apicBase;
                            Filter f = new Filter();
                            f.setId(filtAtt.getTDn());
                            f.setDn(filtAtt.getTDn());
                            f.setName(filtAtt.getTnVzFilterName());
                            String filterTenantName = Utils.getTenantFromDn((String)filtAtt.getTDn());
                            Tenant filterParentTenant = new Tenant();
                            filterParentTenant.setName(filterTenantName);
                            f.setParentTenant(filterParentTenant);
                            filters.add(f);
                        }
                        continue;
                    }
                    ctr.setIsBidirectional(false);
                    for (ApicBase ab : inTerms) {
                        vzInTerm inTerm = (vzInTerm)ab;
                        List vzRsFiltAttList = inTerm.getChild("vzRsFiltAtt");
                        for (ApicBase obj : vzRsFiltAttList) {
                            vzRsFiltAtt filtAtt = (vzRsFiltAtt)obj;
                            Filter f = new Filter();
                            f.setId(filtAtt.getTDn());
                            f.setDn(filtAtt.getTDn());
                            f.setName(filtAtt.getTnVzFilterName());
                            String filterTenantName = Utils.getTenantFromDn((String)filtAtt.getTDn());
                            Tenant filterParentTenant = new Tenant();
                            filterParentTenant.setName(filterTenantName);
                            f.setParentTenant(filterParentTenant);
                            filters.add(f);
                        }
                    }
                }
            }
            ctr.setFilters(filters);
            List providerList = contract.getChild("vzRtProv");
            subj2 = providerList.iterator();
            while (subj2.hasNext()) {
                ApicBase prov = (ApicBase)subj2.next();
                vzRtProv provRelation = (vzRtProv)prov;
                String epgDn = provRelation.getTDn();
                Epg providerEpg = new Epg();
                providerEpg.setId(epgDn);
                String epgName = Utils.getEpgFromDn((String)epgDn);
                providerEpg.setName(epgName);
                Tenant provEpgParentTenant = new Tenant();
                String provEpgParentTenantName = Utils.getTenantFromDn((String)epgDn);
                provEpgParentTenant.setName(provEpgParentTenantName);
                providerEpg.setParentTenant(provEpgParentTenant);
                String provEpgAppName = Utils.getApFromDn((String)epgDn);
                App provApp = new App();
                provApp.setName(provEpgAppName);
                providerEpg.setParentApp(provApp);
                provEpgParentTenant.setName(provEpgParentTenantName);
                providerEpg.setParentTenant(provEpgParentTenant);
                providers.add(providerEpg);
            }
            ctr.setProviders(providers);
            List sameParentConsumerList = contract.getChild("vzRtCons");
            for (ApicBase cons : sameParentConsumerList) {
                vzRtCons consRelation = (vzRtCons)cons;
                Epg consumerEpg = new Epg();
                String epgDn = consRelation.getTDn();
                consumerEpg.setId(epgDn);
                String epgName = Utils.getEpgFromDn((String)epgDn);
                consumerEpg.setName(epgName);
                Tenant consEpgParentTenant = new Tenant();
                String consEpgParentTenantName = Utils.getTenantFromDn((String)epgDn);
                consEpgParentTenant.setName(consEpgParentTenantName);
                consumerEpg.setParentTenant(consEpgParentTenant);
                String consEpgParentAppName = Utils.getApFromDn((String)epgDn);
                App consEpgParentApp = new App();
                consEpgParentApp.setName(consEpgParentAppName);
                consumerEpg.setParentApp(consEpgParentApp);
                consumers.add(consumerEpg);
            }
            List vzIntDefList = contract.getChild("vzIntDef");
            for (ApicBase intDef : vzIntDefList) {
                vzIntDef interfaceDef = (vzIntDef)intDef;
                List diffParentConsList = interfaceDef.getChild("vzConsDef");
                for (ApicBase cdef : diffParentConsList) {
                    vzConsDef consDef = (vzConsDef)cdef;
                    Epg consumerEpg = new Epg();
                    String epgDn = consDef.getEpgDn();
                    consumerEpg.setId(epgDn);
                    consumerEpg.setName(Utils.getEpgFromDn((String)epgDn));
                    Tenant consEpgParentTenant = new Tenant();
                    consEpgParentTenant.setName(Utils.getTenantFromDn((String)epgDn));
                    consumerEpg.setParentTenant(consEpgParentTenant);
                    String consEpgParentAppName = Utils.getApFromDn((String)epgDn);
                    App consEpgParentApp = new App();
                    consEpgParentApp.setName(consEpgParentAppName);
                    consumerEpg.setParentApp(consEpgParentApp);
                    consumers.add(consumerEpg);
                }
            }
            ctr.setConsumers(consumers);
            this.setFaultsCountUtil((ManagedObject)contract, ctr);
            this.setHealthScoreUtil((ManagedObject)contract, ctr);
            listOfContracts.add(ctr);
        }
        return listOfContracts;
    }

    private ManagedObjectQueryBuilder getMoqbForFilters(String tenantName, String propValue) {
        String className = vzFilter.class.getSimpleName();
        String tenantDn = "uni/tn-" + tenantName + "/";
        String dnFilter = ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", tenantDn);
        String finalFilter = propValue.isEmpty() || propValue == null ? dnFilter : "and(" + dnFilter + "," + ManagedObjectQueryBuilder.createWildcardFilter(className, "name", propValue) + ")";
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        moqb.withMoClassName(className).withQueryTargetFilter(finalFilter).withRspSubtree("full").withRspSubtreeInclude("health,fault-count");
        return moqb;
    }

    public List<Filter> getFilters(String tenantName, String propValue, PageQueryBuilder pqb, boolean includeCommon) throws ApicMoOperationException {
        String className = vzFilter.class.getSimpleName();
        OrderQueryBuilder orderQb = new OrderQueryBuilder(className);
        ManagedObjectQueryBuilder moqb = this.getMoqbForFilters(tenantName, propValue);
        moqb.withOrderQuery(orderQb).withPagination(pqb);
        if (includeCommon && !tenantName.equals("common")) {
            moqb.addOptionalQueryTargetFilter(ManagedObjectQueryBuilder.createWildcardFilter(className, "dn", Constants.commonTenantDn));
        }
        List<ManagedObject> filterObjects = moqb.getManagedObjectsFromBuilder(this._handle);
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        for (ManagedObject mo : filterObjects) {
            vzFilter filter = (vzFilter)mo;
            Filter f = new Filter();
            f.setId(filter.getDn());
            f.setName(filter.getName());
            Tenant parentTenant = new Tenant();
            parentTenant.setName(Utils.getTenantFromDn((String)filter.getDn()));
            parentTenant.setId(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            parentTenant.setDn(this.buildDnForAciObject(fvTenant.class.getSimpleName(), parentTenant.getName(), null));
            f.setParentTenant(parentTenant);
            f.setDescr(filter.getDescr());
            f.setDn(filter.getDn());
            ArrayList<Entry> entries = new ArrayList<Entry>();
            List entryList = filter.getChild("vzEntry");
            for (ApicBase ab : entryList) {
                vzEntry e = (vzEntry)ab;
                Entry entry = new Entry();
                entry.setId(e.getDn());
                entry.setName(e.getName());
                entry.setProt(e.getProt());
                entry.setEtherT(e.getEtherT());
                entry.setTcpRules(e.getTcpRules());
                entry.setSrcFromPort(e.getSFromPort());
                entry.setDestToPort(e.getDToPort());
                entry.setDestFromPort(e.getDFromPort());
                entry.setSrcToPort(e.getSToPort());
                entries.add(entry);
            }
            f.setEntries(entries);
            this.setFaultsCountUtil((ManagedObject)filter, f);
            this.setHealthScoreUtil((ManagedObject)filter, f);
            filterList.add(f);
        }
        return filterList;
    }

    public int getFiltersCount(String tenantName, String propValue, boolean includeCommon) throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = this.getMoqbForFilters(tenantName, propValue);
        moqb.withRspSubtree(null);
        if (includeCommon && !tenantName.equals("common")) {
            moqb.addOptionalQueryTargetFilter(ManagedObjectQueryBuilder.createWildcardFilter(vzFilter.class.getSimpleName(), "dn", Constants.commonTenantDn));
        }
        int count = this.getMoCount(moqb);
        return count;
    }

    public vzFilter createFilter(String name, String descr, List<Entry> entryList, String tenantName, boolean createOnly) throws ApicMoOperationException {
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        if (createOnly) {
            ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
            String filterDn = "uni/tn-" + tenantName + "/flt-" + name;
            String dnFilter = ManagedObjectQueryBuilder.createEqFilter(vzFilter.class.getSimpleName(), "dn", filterDn);
            moqb.withMoClassName(vzFilter.class.getSimpleName()).withQueryTargetFilter(dnFilter);
            List<ManagedObject> existingFilter = moqb.getManagedObjectsFromBuilder(this._handle);
            if (!existingFilter.isEmpty()) {
                throw new ApicMoOperationException("Request sent with create-only , Filter " + name + " already exists under Tenant " + tenantName + " in this fabric");
            }
        }
        fvTenant tenant = new fvTenant();
        tenant.setName(tenantName);
        vzFilter newFilter = new vzFilter();
        newFilter.setName(name);
        newFilter.setDescr(descr);
        for (Entry e : entryList) {
            vzEntry entry = new vzEntry();
            this.populateEntry(entry, e);
            newFilter.addManagedObject((ManagedObject)entry);
        }
        tenant.addManagedObject((ManagedObject)newFilter);
        this.log.info("Creating filter: " + name);
        this.pushApicConfig((ManagedObject)tenant);
        this.log.info("Created Filter: " + name);
        return newFilter;
    }

    public void deleteFilter(String filterName, String tenantName) throws ApicMoOperationException {
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        fvTenant parentTenant = new fvTenant();
        parentTenant.setName(tenantName);
        vzFilter filter = new vzFilter();
        filter.setName(filterName);
        filter.setStatus("deleted");
        parentTenant.AddManagedObject((ManagedObject)filter);
        this.log.info("Deleting filter: " + filterName);
        this.pushApicConfig((ManagedObject)parentTenant);
        this.log.info("Deleted filter: " + filterName);
    }

    public void deleteContract(String contractName, String tenantName) throws ApicMoOperationException {
        String queryTargetFilter = "eq(vzBrCP.dn,\"uni/tn-" + tenantName + "/brc-" + contractName + "\")";
        String className = vzBrCP.class.getSimpleName();
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder();
        moqb.withMoClassName(className).withQueryTargetFilter(queryTargetFilter).withQueryTarget("subtree").withRspSubtree("full");
        List<ManagedObject> contractObjs = moqb.getManagedObjectsFromBuilder(this._handle);
        if (contractObjs == null || contractObjs.size() == 0) {
            throw new ApicMoOperationException("Contract not found");
        }
        polUni policyUniverse = new polUni();
        fvTenant contractParentTenant = new fvTenant();
        contractParentTenant.setName(tenantName);
        vzBrCP newContract = new vzBrCP();
        newContract.setName(contractName);
        newContract.setStatus("deleted");
        contractParentTenant.addManagedObject((ManagedObject)newContract);
        policyUniverse.addManagedObject((ManagedObject)contractParentTenant);
        vzBrCP contract = (vzBrCP)contractObjs.get(0);
        List existingProvEpgRtProvList = contract.getChild("vzRtProv");
        for (Object ab : existingProvEpgRtProvList) {
            vzRtProv existingRtProv = (vzRtProv)ab;
            String providerEpgDn = existingRtProv.getTDn();
            String providerEpgName = Utils.getEpgFromDn((String)providerEpgDn);
            String providerEpgAppName = Utils.getApFromDn((String)providerEpgDn);
            String providerEpgTenantName = Utils.getTenantFromDn((String)providerEpgDn);
            fvTenant providerEpgParentTenant = (fvTenant)this.getOrCreateChildByName((ManagedObject)policyUniverse, fvTenant.class, providerEpgTenantName);
            fvAp providerEpgApp = (fvAp)this.getOrCreateChildByName((ManagedObject)providerEpgParentTenant, fvAp.class, providerEpgAppName);
            fvAEPg removeEpg = (fvAEPg)this.getOrCreateChildByName((ManagedObject)providerEpgApp, fvAEPg.class, providerEpgName);
            fvRsProv removeEpgRsProv = new fvRsProv();
            removeEpgRsProv.setTnVzBrCPName(contract.getName());
            removeEpgRsProv.setStatus("deleted");
            removeEpg.addManagedObject((ManagedObject)removeEpgRsProv);
        }
        List existingConsEpgRtConsList = contract.getChild("vzRtCons");
        for (ApicBase ab : existingConsEpgRtConsList) {
            vzRtCons existingRtCons = (vzRtCons)ab;
            String consumerEpgDn = existingRtCons.getTDn();
            String consumerEpgName = Utils.getEpgFromDn((String)consumerEpgDn);
            String consumerEpgAppName = Utils.getApFromDn((String)consumerEpgDn);
            String consumerEpgTenantName = Utils.getTenantFromDn((String)consumerEpgDn);
            fvTenant consumerEpgParentTenant = (fvTenant)this.getOrCreateChildByName((ManagedObject)policyUniverse, fvTenant.class, consumerEpgTenantName);
            fvAp consumerEpgApp = (fvAp)this.getOrCreateChildByName((ManagedObject)consumerEpgParentTenant, fvAp.class, consumerEpgAppName);
            fvAEPg consumerEpg = (fvAEPg)this.getOrCreateChildByName((ManagedObject)consumerEpgApp, fvAEPg.class, consumerEpgName);
            fvRsCons removeEpgRsCons = new fvRsCons();
            removeEpgRsCons.setTnVzBrCPName(contract.getName());
            removeEpgRsCons.setStatus("deleted");
            consumerEpg.addManagedObject((ManagedObject)removeEpgRsCons);
        }
        List existingContractInterfaceList = contract.getChild("vzIntDef");
        for (ApicBase apicBase : existingContractInterfaceList) {
            vzIntDef existingContractInterface = (vzIntDef)apicBase;
            List existingVzConsDefList = existingContractInterface.getChild("vzConsDef");
            for (ApicBase ab : existingVzConsDefList) {
                vzConsDef existingConsDef = (vzConsDef)ab;
                String consumerEpgDn = existingConsDef.getEpgDn();
                String consumerEpgName = Utils.getEpgFromDn((String)consumerEpgDn);
                String consumerEpgTenantName = Utils.getTenantFromDn((String)consumerEpgDn);
                String consumerEpgAppName = Utils.getApFromDn((String)consumerEpgDn);
                fvTenant consumerEpgParentTenant = (fvTenant)this.getOrCreateChildByName((ManagedObject)policyUniverse, fvTenant.class, consumerEpgTenantName);
                fvAp consumerEpgApp = (fvAp)this.getOrCreateChildByName((ManagedObject)consumerEpgParentTenant, fvAp.class, consumerEpgAppName);
                fvAEPg consumerEpg = (fvAEPg)this.getOrCreateChildByName((ManagedObject)consumerEpgApp, fvAEPg.class, consumerEpgName);
                String existingContractInterfaceName = "to_" + tenantName + "_" + contract.getName();
                fvRsConsIf removeEpgRsConsIf = new fvRsConsIf();
                removeEpgRsConsIf.setTnVzCPIfName(existingContractInterfaceName);
                removeEpgRsConsIf.setStatus("deleted");
                consumerEpg.addManagedObject((ManagedObject)removeEpgRsConsIf);
            }
        }
        this.pushApicConfig((ManagedObject)policyUniverse);
    }

    public void createContract(String name, String descr, String tenantName, List<Filter> filterList, List<Epg> consumerList, List<Epg> providerList, boolean isBidirectional, boolean createOnly) throws ApicMoOperationException {
        List<Epg> updatedConsumerList;
        List<Epg> updatedProviderList;
        if (tenantName == null) {
            throw new ApicMoOperationException("Tenant name missing");
        }
        polUni policyUniverse = new polUni();
        fvTenant contractParentTenant = new fvTenant();
        contractParentTenant.setName(tenantName);
        vzBrCP newContract = new vzBrCP();
        newContract.setName(name);
        newContract.setDescr(descr);
        contractParentTenant.addManagedObject((ManagedObject)newContract);
        policyUniverse.addManagedObject((ManagedObject)contractParentTenant);
        String queryTargetFilter = "eq(vzBrCP.dn,\"uni/tn-" + tenantName + "/brc-" + name + "\")";
        List queryResult = this._handle.getManagedObject(null, "vzBrCP", null, queryTargetFilter, "subtree", null, "full", null, null, null);
        if (queryResult == null || queryResult.size() == 0) {
            this.addSubjectToContract(null, newContract, filterList, isBidirectional);
            updatedProviderList = providerList;
            updatedConsumerList = consumerList;
        } else {
            if (createOnly) {
                throw new ApicMoOperationException("Request sent with create-only , Contract " + name + " already exists under Tenant " + tenantName + " in this fabric");
            }
            vzBrCP existingContract = (vzBrCP)queryResult.get(0);
            this.addSubjectToContract(existingContract, newContract, filterList, isBidirectional);
            updatedProviderList = this.updateProviderList(policyUniverse, existingContract, providerList);
            updatedConsumerList = this.updateConsumerList(policyUniverse, existingContract, tenantName, consumerList);
        }
        if (updatedConsumerList != null && updatedConsumerList.size() > 0) {
            for (Epg consumer : updatedConsumerList) {
                if (consumer.getParentTenant() == null) {
                    throw new ApicMoOperationException("Consumer Epg tenant not found");
                }
                String consEpgTenantName = consumer.getParentTenant().getName();
                if (consumer.getParentApp() == null) {
                    throw new ApicMoOperationException("Consumer Epg app not found");
                }
                String consEpgAppName = consumer.getParentApp().getName();
                String consEpgName = consumer.getName();
                fvTenant consEpgParentTenant = (fvTenant)this.getOrCreateChildByName((ManagedObject)policyUniverse, fvTenant.class, consEpgTenantName);
                fvAp consEpgParentApp = (fvAp)this.getOrCreateChildByName((ManagedObject)consEpgParentTenant, fvAp.class, consEpgAppName);
                fvAEPg consumerEpg = (fvAEPg)this.getOrCreateChildByName((ManagedObject)consEpgParentApp, fvAEPg.class, consEpgName);
                if (consEpgTenantName.equals(contractParentTenant.getName())) {
                    fvRsCons consRelation = new fvRsCons();
                    consRelation.setTnVzBrCPName(newContract.getName());
                    consumerEpg.addManagedObject((ManagedObject)consRelation);
                    continue;
                }
                String ctrInterfaceName = "to_" + contractParentTenant.getName() + "_" + newContract.getName();
                vzCPIf contractInterface = (vzCPIf)this.getChildbyName((ManagedObject)consEpgParentTenant, "vzCPIf", ctrInterfaceName);
                if (contractInterface == null) {
                    contractInterface = new vzCPIf();
                    contractInterface.setName(ctrInterfaceName);
                    contractInterface.setDescr("Contract Interface to access the contract " + newContract.getName() + " in tenant " + contractParentTenant.getName());
                    consEpgParentTenant.addManagedObject((ManagedObject)contractInterface);
                    vzRsIf linkToContract = new vzRsIf();
                    linkToContract.setTDn("uni/tn-" + contractParentTenant.getName() + "/brc-" + newContract.getName());
                    contractInterface.addManagedObject((ManagedObject)linkToContract);
                }
                fvRsConsIf consRelation = new fvRsConsIf();
                consRelation.setTnVzCPIfName(contractInterface.getName());
                consumerEpg.addManagedObject((ManagedObject)consRelation);
            }
        }
        if (updatedProviderList != null && updatedProviderList.size() > 0) {
            for (Epg provider : updatedProviderList) {
                if (provider.getParentTenant() == null) {
                    throw new ApicMoOperationException("Provider Epg tenant not found");
                }
                String provEpgTenantName = provider.getParentTenant().getName();
                fvTenant provEpgParentTenant = (fvTenant)this.getOrCreateChildByName((ManagedObject)policyUniverse, fvTenant.class, provEpgTenantName);
                if (provider.getParentApp() == null) {
                    throw new ApicMoOperationException("Provider Epg app not found");
                }
                String provEpgAppName = provider.getParentApp().getName();
                fvAp provEpgParentApp = (fvAp)this.getOrCreateChildByName((ManagedObject)provEpgParentTenant, fvAp.class, provEpgAppName);
                fvAEPg providerEpg = (fvAEPg)this.getOrCreateChildByName((ManagedObject)provEpgParentApp, fvAEPg.class, provider.getName());
                fvRsProv provRelation = new fvRsProv();
                provRelation.setTnVzBrCPName(newContract.getName());
                providerEpg.addManagedObject((ManagedObject)provRelation);
            }
        }
        this.pushApicConfig((ManagedObject)policyUniverse);
    }

    void addFilterToSubject(vzSubj subject, vzFilter filter, boolean isBidirectional) throws ApicMoOperationException {
        if (isBidirectional) {
            vzRsSubjFiltAtt linkFilter = new vzRsSubjFiltAtt();
            linkFilter.setTnVzFilterName(filter.getName());
            subject.addManagedObject((ManagedObject)linkFilter);
        } else {
            vzInTerm inTerm = (vzInTerm)this.getOrCreateChildByName((ManagedObject)subject, vzInTerm.class, "");
            vzRsFiltAtt linkFilter = new vzRsFiltAtt();
            linkFilter.setTnVzFilterName(filter.getName());
            inTerm.addManagedObject((ManagedObject)linkFilter);
        }
    }

    List<Epg> updateConsumerList(polUni policyUniverse, vzBrCP existingContract, String existingContractParentTenantName, List<Epg> consumerList) {
        List existingConsEpgRtConsList = existingContract.getChild("vzRtCons");
        for (ApicBase ab : existingConsEpgRtConsList) {
            vzRtCons existingRtCons = (vzRtCons)ab;
            String existingConsEpgDn = existingRtCons.getTDn();
            String existingConsEpgName = Utils.getEpgFromDn((String)existingConsEpgDn);
            boolean epgNotNeeded = consumerList.stream().anyMatch(epg -> epg.getName().equals(existingConsEpgName));
            if (epgNotNeeded) {
                consumerList.removeIf(epg -> epg.getName().equals(existingConsEpgName));
                continue;
            }
            String existingConsTenantName = Utils.getTenantFromDn((String)existingConsEpgDn);
            String existingConsAppName = Utils.getApFromDn((String)existingConsEpgDn);
            fvTenant removeEpgTenant = (fvTenant)this.getOrCreateChildByName((ManagedObject)policyUniverse, fvTenant.class, existingConsTenantName);
            fvAp removeEpgApp = (fvAp)this.getOrCreateChildByName((ManagedObject)removeEpgTenant, fvAp.class, existingConsAppName);
            fvAEPg removeEpg = (fvAEPg)this.getOrCreateChildByName((ManagedObject)removeEpgApp, fvAEPg.class, existingConsEpgName);
            fvRsCons removeEpgRsCons = new fvRsCons();
            removeEpgRsCons.setTnVzBrCPName(existingContract.getName());
            removeEpgRsCons.setStatus("deleted");
            removeEpg.addManagedObject((ManagedObject)removeEpgRsCons);
        }
        List existingContractInterfaceList = existingContract.getChild("vzIntDef");
        for (ApicBase apicBase : existingContractInterfaceList) {
            vzIntDef existingContractInterface = (vzIntDef)apicBase;
            List existingVzConsDefList = existingContractInterface.getChild("vzConsDef");
            for (ApicBase ab : existingVzConsDefList) {
                vzConsDef existingConsDef = (vzConsDef)ab;
                String existingConsEpgDn = existingConsDef.getEpgDn();
                String existingConsEpgName = Utils.getEpgFromDn((String)existingConsEpgDn);
                boolean epgNotNeeded = consumerList.stream().anyMatch(epg -> epg.getName().equals(existingConsEpgName));
                if (epgNotNeeded) {
                    consumerList.removeIf(epg -> epg.getName().equals(existingConsEpgName));
                    continue;
                }
                String existingConsTenantName = Utils.getTenantFromDn((String)existingConsEpgDn);
                String existingConsAppName = Utils.getApFromDn((String)existingConsEpgDn);
                fvTenant removeEpgTenant = (fvTenant)this.getOrCreateChildByName((ManagedObject)policyUniverse, fvTenant.class, existingConsTenantName);
                fvAp removeEpgApp = (fvAp)this.getOrCreateChildByName((ManagedObject)removeEpgTenant, fvAp.class, existingConsAppName);
                fvAEPg removeEpg = (fvAEPg)this.getOrCreateChildByName((ManagedObject)removeEpgApp, fvAEPg.class, existingConsEpgName);
                String existingContractInterfaceName = "to_" + existingContractParentTenantName + "_" + existingContract.getName();
                fvRsConsIf removeEpgRsConsIf = new fvRsConsIf();
                removeEpgRsConsIf.setTnVzCPIfName(existingContractInterfaceName);
                removeEpgRsConsIf.setStatus("deleted");
                removeEpg.addManagedObject((ManagedObject)removeEpgRsConsIf);
            }
        }
        return consumerList;
    }

    List<Epg> updateProviderList(polUni policyUniverse, vzBrCP existingContract, List<Epg> providerList) {
        List existingProvEpgRtProvList = existingContract.getChild("vzRtProv");
        for (ApicBase ab : existingProvEpgRtProvList) {
            vzRtProv existingRtProv = (vzRtProv)ab;
            String existingProvEpgDn = existingRtProv.getTDn();
            String existingProvEpgName = Utils.getEpgFromDn((String)existingProvEpgDn);
            boolean epgNotNeeded = providerList.stream().anyMatch(epg -> epg.getName().equals(existingProvEpgName));
            if (epgNotNeeded) {
                providerList.removeIf(epg -> epg.getName().equals(existingProvEpgName));
                continue;
            }
            String existingProvTenantName = Utils.getTenantFromDn((String)existingProvEpgDn);
            String existingProvAppName = Utils.getApFromDn((String)existingProvEpgDn);
            fvTenant removeEpgTenant = (fvTenant)this.getOrCreateChildByName((ManagedObject)policyUniverse, fvTenant.class, existingProvTenantName);
            fvAp removeEpgApp = (fvAp)this.getOrCreateChildByName((ManagedObject)removeEpgTenant, fvAp.class, existingProvAppName);
            fvAEPg removeEpg = (fvAEPg)this.getOrCreateChildByName((ManagedObject)removeEpgApp, fvAEPg.class, existingProvEpgName);
            fvRsProv removeEpgRsProv = new fvRsProv();
            removeEpgRsProv.setTnVzBrCPName(existingContract.getName());
            removeEpgRsProv.setStatus("deleted");
            removeEpg.addManagedObject((ManagedObject)removeEpgRsProv);
        }
        return providerList;
    }

    void addSubjectToContract(vzBrCP existingContract, vzBrCP newContract, List<Filter> filterList, boolean isBidirectional) throws ApicMoOperationException {
        vzSubj newSubject = new vzSubj();
        newSubject.setDescr(Utils.getString((String)"subject.defaultDescr"));
        newContract.addManagedObject((ManagedObject)newSubject);
        ArrayList<vzFilter> vzFilterList = new ArrayList<vzFilter>();
        if (filterList == null || filterList.size() == 0) {
            Entry defaultEntry = new Entry();
            defaultEntry.setName("default");
            ArrayList<Entry> defaultEntryList = new ArrayList<Entry>();
            defaultEntryList.add(defaultEntry);
            this.createFilter("default", "Default Filter", defaultEntryList, "common", false);
            Filter defaultFilter = new Filter();
            defaultFilter.setDn(this.buildDnForAciObject(vzFilter.class.getSimpleName(), "common", "default"));
            defaultFilter.setName("default");
            filterList.add(defaultFilter);
        }
        if (existingContract == null) {
            newSubject.setName("vcenter_default");
        } else {
            List subjects = existingContract.getChild("vzSubj");
            if (subjects == null || subjects.size() == 0) {
                newSubject.setName("vcenter_default");
            } else {
                vzRsSubjFiltAtt deleteFilter;
                boolean inputFilterNotNeeded;
                String currentFilterDn;
                vzRsSubjFiltAtt rsFilterObject;
                if (subjects.size() > 1) {
                    throw new ApicMoOperationException("This Contract has a format unsupported by this Plugin (multiple Subjects), you can't edit it's settings");
                }
                vzSubj oldSubject = (vzSubj)subjects.get(0);
                newSubject.setName(oldSubject.getName());
                vzInTerm oldInTerm = (vzInTerm)this.getChildbyName((ManagedObject)oldSubject, vzInTerm.class.getSimpleName(), "");
                if (oldInTerm == null) {
                    List vzRsSubjFiltAttList = oldSubject.getChild("vzRsSubjFiltAtt");
                    for (ApicBase ab : vzRsSubjFiltAttList) {
                        rsFilterObject = (vzRsSubjFiltAtt)ab;
                        currentFilterDn = rsFilterObject.getTDn();
                        inputFilterNotNeeded = filterList.stream().anyMatch(filt -> filt.getDn().equals(currentFilterDn));
                        if (inputFilterNotNeeded) {
                            filterList.removeIf(filter -> filter.getDn().equals(currentFilterDn));
                            continue;
                        }
                        deleteFilter = new vzRsSubjFiltAtt();
                        deleteFilter.setTnVzFilterName(rsFilterObject.getTnVzFilterName());
                        newSubject.addManagedObject((ManagedObject)deleteFilter);
                        deleteFilter.setStatus("deleted");
                    }
                } else {
                    List vzRsFiltAttList = oldInTerm.getChild("vzRsFiltAtt");
                    vzInTerm newInTerm = new vzInTerm();
                    newInTerm.setName(oldInTerm.getName());
                    newSubject.addManagedObject((ManagedObject)newInTerm);
                    for (ApicBase ab : vzRsFiltAttList) {
                        rsFilterObject = (vzRsFiltAtt)ab;
                        currentFilterDn = rsFilterObject.getTDn();
                        inputFilterNotNeeded = filterList.stream().anyMatch(filt -> filt.getDn().equals(currentFilterDn));
                        if (inputFilterNotNeeded) {
                            filterList.removeIf(filter -> filter.getDn().equals(currentFilterDn));
                            continue;
                        }
                        deleteFilter = new vzRsFiltAtt();
                        newInTerm.addManagedObject((ManagedObject)deleteFilter);
                        deleteFilter.setTnVzFilterName(rsFilterObject.getTnVzFilterName());
                        deleteFilter.setStatus("deleted");
                    }
                }
            }
        }
        for (Filter f : filterList) {
            vzFilter currentFilter = new vzFilter();
            currentFilter.setName(f.getName());
            vzFilterList.add(currentFilter);
        }
        for (vzFilter filter2 : vzFilterList) {
            this.addFilterToSubject(newSubject, filter2, isBidirectional);
        }
    }

    private void populateEntry(vzEntry entry, Entry inputEntry) {
        if (this.mustBeSet(inputEntry.getName())) {
            entry.setName(inputEntry.getName());
        }
        if (this.mustBeSet(inputEntry.getProt())) {
            entry.setProt(inputEntry.getProt());
        }
        if (this.mustBeSet(inputEntry.getEtherT())) {
            entry.setEtherT(inputEntry.getEtherT());
        }
        if (this.mustBeSet(inputEntry.getSrcFromPort())) {
            entry.setSFromPort(inputEntry.getSrcFromPort());
        }
        if (this.mustBeSet(inputEntry.getSrcToPort())) {
            entry.setSToPort(inputEntry.getSrcToPort());
        }
        if (this.mustBeSet(inputEntry.getDestFromPort())) {
            entry.setDFromPort(inputEntry.getDestFromPort());
        }
        if (this.mustBeSet(inputEntry.getDestToPort())) {
            entry.setDToPort(inputEntry.getDestToPort());
        }
        if (this.mustBeSet(inputEntry.getTcpRules())) {
            entry.setTcpRules(inputEntry.getTcpRules());
        }
        if (this.mustBeSet(inputEntry.getArpOpc())) {
            entry.setArpOpc(inputEntry.getArpOpc());
        }
        if (inputEntry.isApplyToFrag() != null && inputEntry.isApplyToFrag().booleanValue()) {
            entry.setApplyToFrag("true");
        }
    }

    public SystemHealth getSystemHealth() throws ApicMoOperationException {
        SystemHealth sysHealth = new SystemHealth();
        OrderQueryBuilder oqb = new OrderQueryBuilder(fabricOverallHealthHist5min.class.getSimpleName()).withProperty("dn").withOrderDirection(OrderQueryBuilder.OrderDirection.ASC);
        ManagedObjectQueryBuilder moqb_healthscore = new ManagedObjectQueryBuilder().withOrderQuery(oqb).withMoClassName(fabricOverallHealthHist5min.class.getSimpleName()).withRspSubtreeInclude("required");
        List<ManagedObject> apicHealthList = moqb_healthscore.getManagedObjectsFromBuilder(this._handle);
        if (apicHealthList != null && apicHealthList.size() > 0) {
            fabricOverallHealthHist5min fabricHealth = (fabricOverallHealthHist5min)apicHealthList.get(0);
            sysHealth.setHealthMin(Integer.valueOf(fabricHealth.getHealthMin()));
            sysHealth.setHealthMax(Integer.valueOf(fabricHealth.getHealthMax()));
            sysHealth.setHealthAvg(Integer.valueOf(fabricHealth.getHealthAvg()));
        }
        ManagedObjectQueryBuilder moqb_faultsCount = new ManagedObjectQueryBuilder().withMoClassName(faultCountsWithDetails.class.getSimpleName());
        List<ManagedObject> systemFaultsCount = moqb_faultsCount.getManagedObjectsFromBuilder(this._handle);
        for (ManagedObject mo : systemFaultsCount) {
            faultCountsWithDetails apicFaultsCount = (faultCountsWithDetails)mo;
            FaultsCount vcpluginFaultsCount = new FaultsCount();
            vcpluginFaultsCount.setCritical(apicFaultsCount.getCrit());
            vcpluginFaultsCount.setMajor(apicFaultsCount.getMaj());
            vcpluginFaultsCount.setMinor(apicFaultsCount.getMinor());
            vcpluginFaultsCount.setWarning(apicFaultsCount.getWarn());
            sysHealth.setSystemFaultsCount(vcpluginFaultsCount);
        }
        return sysHealth;
    }

    public List<App> getAppHealth() throws ApicMoOperationException {
        List<ManagedObject> appObjects = this.getHealthForMo(fvAp.class.getSimpleName());
        ArrayList<App> appList = new ArrayList<App>();
        for (ManagedObject mo : appObjects) {
            fvAp apMo = (fvAp)mo;
            App app = new App();
            app.setName(apMo.getName());
            String appDn = apMo.getDn();
            app.setDn(appDn);
            app.setId(appDn);
            Tenant parentTenant = new Tenant();
            parentTenant.setName(Utils.getTenantFromDn((String)appDn));
            app.setParentTenant(parentTenant);
            this.setFaultsCountUtil((ManagedObject)apMo, app);
            this.setHealthScoreUtil((ManagedObject)apMo, app);
            appList.add(app);
        }
        return appList;
    }

    public int getCountAllApps() throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder().withMoClassName(fvAp.class.getSimpleName());
        return this.getMoCount(moqb);
    }

    public List<Epg> getEpgHealth() throws ApicMoOperationException {
        List<ManagedObject> apicEpgs = this.getHealthForMo(fvAEPg.class.getSimpleName());
        ArrayList<Epg> epgList = new ArrayList<Epg>();
        for (ManagedObject mo : apicEpgs) {
            fvAEPg epgMo = (fvAEPg)mo;
            Epg epg = new Epg();
            epg.setId(epgMo.getDn());
            epg.setDn(epgMo.getDn());
            epg.setName(epgMo.getName());
            this.setFaultsCountUtil((ManagedObject)epgMo, epg);
            this.setHealthScoreUtil((ManagedObject)epgMo, epg);
            epgList.add(epg);
        }
        return epgList;
    }

    public int getCountAllEpgs() throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder().withMoClassName(fvAEPg.class.getSimpleName());
        return this.getMoCount(moqb);
    }

    public List<Bd> getBdHealth() throws ApicMoOperationException {
        List<ManagedObject> apicBds = this.getHealthForMo(fvBD.class.getSimpleName());
        ArrayList<Bd> bdList = new ArrayList<Bd>();
        for (ManagedObject mo : apicBds) {
            fvBD bdMo = (fvBD)mo;
            Bd bd = new Bd();
            bd.setId(bdMo.getDn());
            bd.setDn(bdMo.getDn());
            bd.setName(bdMo.getName());
            this.setFaultsCountUtil((ManagedObject)bdMo, bd);
            this.setHealthScoreUtil((ManagedObject)bdMo, bd);
            bdList.add(bd);
        }
        return bdList;
    }

    public int getCountAllBds() throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder().withMoClassName(fvBD.class.getSimpleName());
        return this.getMoCount(moqb);
    }

    public List<Vrf> getVrfHealth() throws ApicMoOperationException {
        List<ManagedObject> apicVRFs = this.getHealthForMo(fvCtx.class.getSimpleName());
        ArrayList<Vrf> vrfList = new ArrayList<Vrf>();
        for (ManagedObject mo : apicVRFs) {
            fvCtx vrfMO = (fvCtx)mo;
            Vrf vrf = new Vrf();
            vrf.setId(vrfMO.getDn());
            vrf.setDn(vrfMO.getDn());
            vrf.setName(vrfMO.getName());
            this.setFaultsCountUtil((ManagedObject)vrfMO, vrf);
            this.setHealthScoreUtil((ManagedObject)vrfMO, vrf);
            vrfList.add(vrf);
        }
        return vrfList;
    }

    public int getCountAllVrfs() throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder().withMoClassName(fvCtx.class.getSimpleName());
        return this.getMoCount(moqb);
    }

    public List<Contract> getContractHealth() throws ApicMoOperationException {
        List<ManagedObject> apicContracts = this.getHealthForMo(vzBrCP.class.getSimpleName());
        ArrayList<Contract> contractList = new ArrayList<Contract>();
        for (ManagedObject mo : apicContracts) {
            vzBrCP contractMo = (vzBrCP)mo;
            Contract contract = new Contract();
            contract.setId(contractMo.getDn());
            contract.setDn(contractMo.getDn());
            contract.setName(contractMo.getName());
            this.setFaultsCountUtil((ManagedObject)contractMo, contract);
            contractList.add(contract);
        }
        return contractList;
    }

    public int getCountAllContracts() throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder().withMoClassName(vzBrCP.class.getSimpleName());
        return this.getMoCount(moqb);
    }

    public List<Filter> getFilterHealth() throws ApicMoOperationException {
        List<ManagedObject> apicFilters = this.getHealthForMo(vzFilter.class.getSimpleName());
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        for (ManagedObject mo : apicFilters) {
            vzFilter filterMo = (vzFilter)mo;
            Filter filter = new Filter();
            filter.setId(filterMo.getDn());
            filter.setDn(filterMo.getDn());
            filter.setName(filterMo.getName());
            this.setFaultsCountUtil((ManagedObject)filterMo, filter);
            filterList.add(filter);
        }
        return filterList;
    }

    public int getCountAllFilters() throws ApicMoOperationException {
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder().withMoClassName(vzFilter.class.getSimpleName());
        return this.getMoCount(moqb);
    }

    List<ManagedObject> getHealthForMo(String className) throws ApicMoOperationException {
        String rspSubtreeInclude = "health,fault-count";
        ManagedObjectQueryBuilder moqb = new ManagedObjectQueryBuilder().withMoClassName(className).withRspSubtreeInclude(rspSubtreeInclude);
        return moqb.getManagedObjectsFromBuilder(this._handle);
    }

    public boolean mustBeSet(String attribute) {
        return attribute != null && attribute != "" && attribute != "unspecified";
    }

    ManagedObject getChildbyName(ManagedObject parent, String childClass, String childName) {
        List childObjs = parent.getChild(childClass);
        if (childObjs == null || childObjs.size() == 0) {
            return null;
        }
        for (ApicBase ab : childObjs) {
            String childClassFullName = ab.getClass().getCanonicalName();
            String objName = new String();
            try {
                Class<?> c = Class.forName(childClassFullName);
                Method method = c.getDeclaredMethod("getName", new Class[0]);
                objName = (String)method.invoke((Object)ab, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (!objName.equals(childName)) continue;
            ManagedObject mo = (ManagedObject)ab;
            return mo;
        }
        return null;
    }

    ManagedObject getOrCreateChildByName(ManagedObject parent, Class moClass, String childName) {
        List childObjs = parent.getChild(moClass.getSimpleName());
        if (childObjs != null && childObjs.size() != 0) {
            for (ApicBase ab : childObjs) {
                String childClassFullName = ab.getClass().getCanonicalName();
                String objName = new String();
                try {
                    Class<?> c = Class.forName(childClassFullName);
                    Method method = c.getDeclaredMethod("getName", new Class[0]);
                    objName = (String)method.invoke((Object)ab, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                if (!objName.equals(childName)) continue;
                ManagedObject mo = (ManagedObject)ab;
                return mo;
            }
        }
        try {
            Object child = moClass.newInstance();
            Method method = moClass.getDeclaredMethod("setName", String.class);
            method.invoke(child, childName);
            ManagedObject managedObject = (ManagedObject)child;
            parent.addManagedObject(managedObject);
            return managedObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getInfraVlan(String domainName) throws ApicMoOperationException {
        String dnFilter = "wcard(infraEpPD.dn, \"uni/vmmp-VMware/dom-" + domainName + "/\")";
        List infraEpPDList = this._handle.getManagedObject(null, "infraEpPD", null, dnFilter, null, null, null, null, null, null);
        if (infraEpPDList == null || infraEpPDList.size() == 0) {
            throw new ApicMoOperationException("no infraEpPD MO was found for domain " + domainName);
        }
        infraEpPD infraEpPDMo = (infraEpPD)infraEpPDList.get(0);
        String infraVlan = infraEpPDMo.getEncap().split("-")[1];
        return infraVlan;
    }

    public List<Pod> getVirtualPods() throws ApicMoOperationException {
        List mos = this._handle.getManagedObjects(null, "fabricPod", null, "eq(fabricPod.podType, \"virtual\")", null, null, null, null, null, null);
        if (mos == null) {
            throw new ApicMoOperationException("failed to get virtual pods from APIC");
        }
        List<Pod> result = mos.stream().map(managedObject -> {
            Pod pod = new Pod();
            BeanUtils.copyProperties((Object)managedObject, (Object)pod);
            pod.setFabricId(this._fabricId);
            pod.setName(pod.getId());
            pod.setPodType(Pod.PodTypeEnum.VIRTUAL);
            return pod;
        }).collect(Collectors.toList());
        return result;
    }

    public List<VNode> getNodes(String podId) throws ApicMoOperationException {
        List mos = this._handle.getManagedObjects(null, "fabricNode", null, "wcard(fabricNode.dn, \"topology/pod-" + podId + "/node-\"", null, null, null, null, null, null);
        if (mos == null) {
            throw new ApicMoOperationException("failed to get nodes from APIC");
        }
        List<VNode> result = mos.stream().map(managedObject -> {
            VNode node = new VNode();
            BeanUtils.copyProperties((Object)managedObject, (Object)node);
            node.setFabricId(this._fabricId);
            fabricNode fNode = (fabricNode)managedObject;
            if ("leaf".equals(fNode.getRole())) {
                node.setRole(VNode.RoleEnum.LEAF);
            }
            if ("spine".equals(fNode.getRole())) {
                node.setRole(VNode.RoleEnum.SPINE);
            }
            Status status = new Status();
            status.setMessage(fNode.getFabricSt());
            if ("active".equals(fNode.getFabricSt())) {
                status.setCode(StatusLevel.SUCCESS);
            } else if ("undiscovered".equals(fNode.getFabricSt())) {
                status.setCode(StatusLevel.DANGER);
            } else {
                status.setCode(StatusLevel.WARNING);
            }
            node.setStatus(status);
            node.setId(fNode.getId() + "");
            return node;
        }).collect(Collectors.toList());
        return result;
    }

    private int getMoCount(ManagedObjectQueryBuilder moqb) throws ApicMoOperationException {
        String currentRspSubtreeInclude;
        String rspSubtreeIncludeWCount = currentRspSubtreeInclude = moqb.getRspSubtreeInclude();
        rspSubtreeIncludeWCount = Optional.ofNullable(currentRspSubtreeInclude).isPresent() ? rspSubtreeIncludeWCount + ",count" : "count";
        moqb.withRspSubtreeInclude(rspSubtreeIncludeWCount);
        List<ManagedObject> mos = moqb.getManagedObjectsFromBuilder(this._handle);
        if (mos == null || mos.isEmpty()) {
            String errorMsg = "failed to get moCount for: from APIC";
            throw new ApicMoOperationException(errorMsg);
        }
        moCount moCount2 = (moCount)mos.get(0);
        return (int)moCount2.getCount();
    }

    private String getAciClassFromDn(String dn) {
        String[] s = dn.split("/");
        String end = s[s.length - 1];
        if (end.contains("tn-")) {
            return fvTenant.class.getSimpleName();
        }
        if (end.startsWith("ap-")) {
            return fvAp.class.getSimpleName();
        }
        if (end.startsWith("epg-")) {
            return fvAEPg.class.getSimpleName();
        }
        if (end.startsWith("ctx-")) {
            return fvCtx.class.getSimpleName();
        }
        if (end.startsWith("BD-")) {
            return fvBD.class.getSimpleName();
        }
        if (end.startsWith("brc-")) {
            return vzBrCP.class.getSimpleName();
        }
        if (end.startsWith("flt-")) {
            return vzFilter.class.getSimpleName();
        }
        return null;
    }

    public String buildDnForAciObject(String aciClassName, String tenantName, String objectName) {
        if (aciClassName.equals(fvTenant.class.getSimpleName())) {
            return String.format("uni/tn-%s/", tenantName);
        }
        if (aciClassName.equals(fvAp.class.getSimpleName())) {
            return String.format("uni/tn-%s/ap-%s", tenantName, objectName);
        }
        if (aciClassName.equals(fvCtx.class.getSimpleName())) {
            return String.format("uni/tn-%s/ctx-%s", tenantName, objectName);
        }
        if (aciClassName.equals(fvBD.class.getSimpleName())) {
            return String.format("uni/tn-%s/BD-%s", tenantName, objectName);
        }
        if (aciClassName.equals(vzBrCP.class.getSimpleName())) {
            return String.format("uni/tn-%s/brc-%s", tenantName, objectName);
        }
        if (aciClassName.equals(vzFilter.class.getSimpleName())) {
            return String.format("uni/tn-%s/flt-%s", tenantName, objectName);
        }
        return null;
    }

    public String buildDnForAciEpg(String aciClassName, String tenantName, String appName, String epgName) {
        return String.format("uni/tn-%s/ap-%s/epg-%s", tenantName, appName, epgName);
    }

    private List<ManagedObject> getCompCtrlrsForVc(List<Vcenter> vcenters, boolean aveOnly, String propValue, PageQueryBuilder pqb) throws ApicMoOperationException {
        ArrayList<String> guidFilters = new ArrayList<String>();
        for (Vcenter vc : vcenters) {
            this.log.info("filter=" + vc.getGuid());
            guidFilters.add("eq(compCtrlr.ser, \"" + vc.getGuid() + "\")");
        }
        String dnFilter = "comp/prov-VMware/ctrlr-";
        String ctrlrTargetFilter = ManagedObjectQueryBuilder.createWildcardFilter(compCtrlr.class.getSimpleName(), "dn", dnFilter);
        String guidFilter = "or(" + StringUtils.join(guidFilters, (char)',') + ")";
        String ctrlrPropFilter = propValue != null && !propValue.isEmpty() ? ManagedObjectQueryBuilder.createWildcardFilter(compCtrlr.class.getSimpleName(), "dn", propValue) : null;
        String aveModeFilter = null;
        String aveEnableFilter = null;
        if (aveOnly) {
            aveModeFilter = ManagedObjectQueryBuilder.createEqFilter(compCtrlr.class.getSimpleName(), "mode", "default");
            String aveEnableFilterYes = ManagedObjectQueryBuilder.createEqFilter(compCtrlr.class.getSimpleName(), "enableAVE", "yes");
            String aveEnableFilterTrue = ManagedObjectQueryBuilder.createEqFilter(compCtrlr.class.getSimpleName(), "enableAVE", "true");
            aveEnableFilter = "or(" + aveEnableFilterYes + "," + aveEnableFilterTrue + ")";
        }
        String classes = hvsLNode.class.getSimpleName() + "," + hvsExtPol.class.getSimpleName() + "," + hvsRsEpPD.class.getSimpleName();
        ManagedObjectQueryBuilder ctrlrqb = new ManagedObjectQueryBuilder().withMoClassName(compCtrlr.class.getSimpleName()).withQueryTargetFilter(ctrlrTargetFilter).addQueryTargetFilter(guidFilter).addQueryTargetFilter(aveModeFilter).addQueryTargetFilter(aveEnableFilter).addQueryTargetFilter(ctrlrPropFilter).withRspSubtree("full").withPagination(pqb).withRspSubtreeClass(classes).withRspSubtreeInclude("required");
        List<ManagedObject> compCtrlrMOs = ctrlrqb.getManagedObjectsFromBuilder(this._handle);
        return compCtrlrMOs;
    }

    private List<ManagedObject> getCompCtrlrsForVcForDomain(List<Vcenter> vcenters, String domainName) throws ApicMoOperationException {
        ArrayList<String> guidFilters = new ArrayList<String>();
        for (Vcenter vc : vcenters) {
            this.log.info("filter=" + vc.getGuid());
            guidFilters.add("eq(compCtrlr.ser, \"" + vc.getGuid() + "\")");
        }
        String compCtrlrDnSubstring = "\"comp/prov-VMware/ctrlr-\\[" + domainName + "\\]\"";
        String ctrlrTargetFilter = "and(wcard(compCtrlr.dn," + compCtrlrDnSubstring + "), or(" + StringUtils.join(guidFilters, (char)',') + "))";
        String classes = hvsLNode.class.getSimpleName() + "," + hvsExtPol.class.getSimpleName() + "," + hvsRsEpPD.class.getSimpleName();
        ManagedObjectQueryBuilder ctrlrqb = new ManagedObjectQueryBuilder();
        ctrlrqb.withMoClassName(compCtrlr.class.getSimpleName()).withQueryTargetFilter(ctrlrTargetFilter).withRspSubtree("full").withRspSubtreeClass(classes);
        List<ManagedObject> compCtrlrMOs = ctrlrqb.getManagedObjectsFromBuilder(this._handle);
        return compCtrlrMOs;
    }

    public void vmmDomainsLinkedToVc(String username, List<Vcenter> vcenters) throws Exception {
        List<ManagedObject> controllers = null;
        controllers = this.getCompCtrlrsForVc(vcenters, false, null, null);
        if (controllers == null || controllers.size() == 0) {
            throw new ApicMoOperationException("Cannot perform operation : for this fabric, there are no VMM domains linked to Vcenter");
        }
    }

    public static <T extends Serializable> List<T> getPaginatedObjects(List<T> objects, PageQueryBuilder pqb) {
        List<Object> toReturn = new ArrayList();
        if (objects == null || objects.size() == 0) {
            return toReturn;
        }
        toReturn = objects;
        int pageNumber = pqb.getPageNumber();
        if (pageNumber > -1) {
            int lastIndex;
            int endIndex;
            int pageSize = pqb.getPageSize();
            int startIndex = pageNumber * pageSize;
            int n = endIndex = startIndex + pageSize > (lastIndex = toReturn.size() - 1) ? toReturn.size() : startIndex + pageSize;
            if (startIndex < endIndex) {
                toReturn = toReturn.subList(startIndex, endIndex);
            }
        }
        return toReturn;
    }

    public List<Endpoint> getFilteredEndpoints(List<Endpoint> endpoints, String propValue) {
        List<Endpoint> toReturn = new ArrayList<Endpoint>();
        if (endpoints == null || endpoints.size() == 0) {
            return toReturn;
        }
        toReturn = endpoints;
        if (propValue != null && !propValue.isEmpty()) {
            toReturn = endpoints.stream().filter(obj -> obj.getIp() != null && obj.getIp().contains(propValue) || obj.getMac() != null && obj.getMac().contains(propValue) || obj.getVm() != null && obj.getVm().getName() != null && obj.getVm().getName().contains(propValue) || obj.getVm() != null && obj.getVm().getHost() != null && obj.getVm().getHost().getName() != null && obj.getVm().getHost().getName().contains(propValue)).collect(Collectors.toList());
        }
        return toReturn;
    }
}

