/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.handles;

import com.cisco.aci.vcplugin.Constants;
import com.cisco.aci.vcplugin.api.builders.PageQueryBuilder;
import com.cisco.aci.vcplugin.handles.ApiSpecUtil;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.model.ApiFilter;
import com.cisco.aci.vcplugin.swagger.model.ApiSpec;
import com.cisco.aci.vcplugin.swagger.model.AveVirtualMachine;
import com.cisco.aci.vcplugin.swagger.model.ContentLibraryItem;
import com.cisco.aci.vcplugin.swagger.model.CustomDefinition;
import com.cisco.aci.vcplugin.swagger.model.Datacenter;
import com.cisco.aci.vcplugin.swagger.model.Datastore;
import com.cisco.aci.vcplugin.swagger.model.Dvs;
import com.cisco.aci.vcplugin.swagger.model.EsxCluster;
import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import com.cisco.aci.vcplugin.swagger.model.ModelObject;
import com.cisco.aci.vcplugin.swagger.model.PortGroup;
import com.cisco.aci.vcplugin.swagger.model.Status;
import com.cisco.aci.vcplugin.swagger.model.StatusLevel;
import com.cisco.aci.vcplugin.swagger.model.VMwareMo;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.swagger.model.VirtualMachine;
import com.cisco.aci.vcplugin.swagger.model.VpodVirtualMachine;
import com.cisco.aciPluginServices.automationsdk.AutomationSDKApi;
import com.cisco.aciPluginServices.information.SvmVersion;
import com.cisco.aciPluginServices.vim.VimConnection;
import com.vmware.vise.usersession.ServerInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import vim25.ArrayOfCustomFieldDef;
import vim25.ArrayOfCustomFieldValue;
import vim25.ArrayOfGuestNicInfo;
import vim25.ArrayOfHostProxySwitch;
import vim25.ArrayOfManagedObjectReference;
import vim25.ArrayOfOptionValue;
import vim25.ArrayOfVAppPropertyInfo;
import vim25.ArrayOfVirtualDevice;
import vim25.ArrayOfVirtualMachineUsageOnDatastore;
import vim25.CustomFieldDef;
import vim25.CustomFieldStringValue;
import vim25.CustomFieldValue;
import vim25.DVPortSetting;
import vim25.DVPortgroupConfigSpec;
import vim25.DistributedVirtualPortgroupPortgroupType;
import vim25.DynamicProperty;
import vim25.GuestNicInfo;
import vim25.HostProxySwitch;
import vim25.InvalidPropertyFaultMsg;
import vim25.ManagedObjectReference;
import vim25.NetIpConfigInfoIpAddress;
import vim25.ObjectContent;
import vim25.ObjectSpec;
import vim25.OptionValue;
import vim25.PropertyFilterSpec;
import vim25.PropertySpec;
import vim25.RetrieveOptions;
import vim25.RetrieveResult;
import vim25.RuntimeFaultFaultMsg;
import vim25.SelectionSpec;
import vim25.ServiceContent;
import vim25.TaskInfo;
import vim25.TaskInfoState;
import vim25.TraversalSpec;
import vim25.VAppPropertyInfo;
import vim25.VMwareDVSPortSetting;
import vim25.VirtualDevice;
import vim25.VirtualMachineUsageOnDatastore;
import vim25.VmwareDistributedVirtualSwitchVlanIdSpec;
import vim25.VmwareDistributedVirtualSwitchVlanSpec;

public class VCenterSdk {
    private String _username;
    private Vcenter _serverInfo;
    private String _password = null;
    private final VcpLogger log = new VcpLogger();
    private VimConnection _vim = null;
    private AutomationSDKApi _cis = null;

    public VCenterSdk(String username, Vcenter server) {
        this._username = username;
        this._password = server.getPassword();
        this._serverInfo = server;
    }

    public ManagedObjectReference createDistributedVirtualPortGroup(String parentDvsUuid, PortGroup inputPortGroup) throws Exception {
        this.log.info("CreatePG: In create Portgroup on vcenter");
        ManagedObjectReference dvs = null;
        ManagedObjectReference dvPortGroup = null;
        ManagedObjectReference switchManager = this._vim.getServiceContent().getDvSwitchManager();
        dvs = this._vim.getStub().queryDvsByUuid(switchManager, parentDvsUuid);
        if (dvs != null) {
            this.log.info("CreatePG: Found dvs by UUID " + parentDvsUuid);
            this.log.info("CreatePG: Creating portgroup now");
            VMwareDVSPortSetting vMwareDVSPortSetting = new VMwareDVSPortSetting();
            VmwareDistributedVirtualSwitchVlanIdSpec vlanSpec = new VmwareDistributedVirtualSwitchVlanIdSpec();
            vlanSpec.setVlanId(inputPortGroup.getVlanId().intValue());
            vMwareDVSPortSetting.setVlan((VmwareDistributedVirtualSwitchVlanSpec)vlanSpec);
            DVPortgroupConfigSpec spec = new DVPortgroupConfigSpec();
            spec.setName(inputPortGroup.getName());
            spec.setDefaultPortConfig((DVPortSetting)vMwareDVSPortSetting);
            spec.setType(DistributedVirtualPortgroupPortgroupType.EARLY_BINDING.value());
            spec.setNumPorts(Integer.valueOf(8));
            this.log.info("CreatePG: Begin portgroup creation task now");
            ManagedObjectReference taskRef = this._vim.getStub().createDVPortgroupTask(dvs, spec);
            this.waitForTask(taskRef);
            TaskInfo taskInfo = this.getTaskInfo(taskRef);
            if (taskInfo.getState().equals((Object)TaskInfoState.SUCCESS)) {
                dvPortGroup = (ManagedObjectReference)taskInfo.getResult();
            }
        } else {
            throw new Exception("DVS not found in VC Inventory");
        }
        return dvPortGroup;
    }

    public boolean addCustomAttributeValue(ManagedObjectReference distributedVirtualPortgroup, String customAttributeValue) throws Exception {
        ManagedObjectReference customFieldsManager = this._vim.getServiceContent().getCustomFieldsManager();
        ArrayList<ManagedObjectReference> moRefs = new ArrayList<ManagedObjectReference>();
        moRefs.add(customFieldsManager);
        List<Map<String, Object>> customFieldsManagerProps = this.retrieveObjectProperties(moRefs, customFieldsManager.getType(), new String[]{"field"});
        CustomFieldDef customFieldDef = null;
        for (Map<String, Object> customFieldMgr : customFieldsManagerProps) {
            ArrayOfCustomFieldDef customFieldArray;
            List customFields;
            if (customFieldMgr.get("field") == null || (customFieldDef = (CustomFieldDef)(customFields = (customFieldArray = (ArrayOfCustomFieldDef)customFieldMgr.get("field")).getCustomFieldDef()).stream().filter(obj -> obj.getName().equals(Constants.CUSTOMATTR_NAME)).findFirst().orElse(null)) != null) continue;
            customFieldDef = this._vim.getStub().addCustomFieldDef(customFieldsManager, Constants.CUSTOMATTR_NAME, distributedVirtualPortgroup.getType(), null, null);
        }
        this._vim.getStub().setField(customFieldsManager, distributedVirtualPortgroup, customFieldDef.getKey(), customAttributeValue);
        return true;
    }

    ManagedObjectReference getDistributedVirtualPortGroupById(String portgroupId) throws Exception {
        ManagedObjectReference distibutedVirtualPortGroup = null;
        ArrayList<String> pgIds = new ArrayList<String>();
        pgIds.add(portgroupId);
        ApiSpec pgSpec = ApiSpecUtil.moIdSpec(pgIds);
        List<Map<String, Object>> objects = this.retreiveObjects("DistributedVirtualPortgroup", pgSpec.getParentType(), new String[0], pgSpec);
        for (Map<String, Object> obj : objects) {
            distibutedVirtualPortGroup = (ManagedObjectReference)obj.get("mor");
        }
        return distibutedVirtualPortGroup;
    }

    public List<Map<String, Object>> retreiveObjects(String objectType, String parentType, String[] props, ApiSpec spec) throws Exception {
        this.connectVIM();
        List<Map<String, Object>> retrievedObjects = null;
        List<ManagedObjectReference> moRefs = null;
        ManagedObjectReference parent = this._vim.getServiceContent().getRootFolder();
        if (spec.getIdList() != null && spec.getIdList().size() > 0) {
            moRefs = this.getMoRefList(objectType, spec.getIdList());
        }
        if (moRefs != null) {
            retrievedObjects = this.retrieveObjectProperties(moRefs, objectType, props);
        } else {
            if (spec.getParentId() != null && !"".equals(spec.getParentId())) {
                parent = new ManagedObjectReference();
                parent.setType(parentType);
                parent.setValue(spec.getParentId());
            }
            retrievedObjects = this.retrieveObjectProperties(parent, objectType, props);
        }
        this.log.info("retreived object sizre:" + retrievedObjects.size());
        if (spec.getFilters() != null && spec.getFilters().size() > 0) {
            ArrayList<Map<String, Object>> filteredObjects = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> object : retrievedObjects) {
                boolean matchFilter = false;
                for (ApiFilter f : spec.getFilters()) {
                    if (!f.getValue().equals(object.get(f.getPropName()).toString())) continue;
                    matchFilter = true;
                    break;
                }
                if (!matchFilter) continue;
                filteredObjects.add(object);
            }
            return filteredObjects;
        }
        return retrievedObjects;
    }

    public List<Dvs> getDvs(ApiSpec spec, boolean includePortGroups) throws Exception {
        String[] props = includePortGroups ? new String[]{"name", "uuid", "portgroup"} : new String[]{"name", "uuid"};
        List<Map<String, Object>> objects = this.retreiveObjects("DistributedVirtualSwitch", spec.getParentType(), props, spec);
        ArrayList<Dvs> toReturn = new ArrayList<Dvs>();
        this.log.info("dvs got " + objects.size() + " objects");
        for (Map<String, Object> object : objects) {
            Dvs dvs = new Dvs();
            dvs.setOid(((ManagedObjectReference)object.get("mor")).getValue());
            dvs.setVmwType(((ManagedObjectReference)object.get("mor")).getType());
            dvs.setName(object.get("name").toString());
            dvs.setUuid(object.get("uuid").toString());
            dvs.setVcId(this._serverInfo.getGuid());
            dvs.setId(dvs.getOid());
            if (includePortGroups) {
                ArrayOfManagedObjectReference pgArary = (ArrayOfManagedObjectReference)object.get("portgroup");
                ArrayList<String> pgIds = new ArrayList<String>();
                for (ManagedObjectReference mor : pgArary.getManagedObjectReference()) {
                    pgIds.add(mor.getValue());
                }
                ApiSpec pgSpec = ApiSpecUtil.moIdSpec(pgIds);
                List<Map<String, Object>> pgobjects = this.retreiveObjects("DistributedVirtualPortgroup", pgSpec.getParentType(), new String[]{"name", "summary.ipPoolName", "config.defaultPortConfig", "availableField", "customValue"}, pgSpec);
                for (Map<String, Object> pgobject : pgobjects) {
                    VMwareDVSPortSetting defaultConfig;
                    Object vlanSpec;
                    Object portGroupConfig;
                    PortGroup pg = new PortGroup();
                    pg.setOid(((ManagedObjectReference)pgobject.get("mor")).getValue());
                    pg.setVmwType(((ManagedObjectReference)pgobject.get("mor")).getType());
                    pg.setName(pgobject.get("name").toString());
                    pg.setVcId(this._serverInfo.getGuid());
                    pg.setId(pg.getOid());
                    pg.setDistributed(true);
                    VMwareMo dvsRef = new VMwareMo();
                    dvsRef.setOid(dvs.getOid());
                    dvsRef.setName(dvs.getName());
                    dvsRef.setVcId(dvs.getVcId());
                    dvsRef.setVmwType(dvs.getVmwType());
                    dvsRef.setId(dvsRef.getOid());
                    pg.setDvs(dvsRef);
                    if (pgobject.get("summary.ipPoolName") != null) {
                        String ipPool = pgobject.get("summary.ipPoolName").toString();
                        if (ipPool != null && !"".equals(ipPool)) {
                            pg.setIpPool(true);
                            pg.setIpPoolName(ipPool);
                        } else {
                            pg.setIpPool(false);
                        }
                    }
                    if (pgobject.get("config.defaultPortConfig") != null && (portGroupConfig = pgobject.get("config.defaultPortConfig")) instanceof VMwareDVSPortSetting && (vlanSpec = (defaultConfig = (VMwareDVSPortSetting)portGroupConfig).getVlan()) instanceof VmwareDistributedVirtualSwitchVlanIdSpec) {
                        VmwareDistributedVirtualSwitchVlanIdSpec vlanIdSpec = (VmwareDistributedVirtualSwitchVlanIdSpec)vlanSpec;
                        int vlanId = vlanIdSpec.getVlanId();
                        pg.setVlanId(vlanId);
                    }
                    HashMap<Integer, String> customValueMap = new HashMap<Integer, String>();
                    if (pgobject.get("customValue") != null) {
                        ArrayOfCustomFieldValue customValues = (ArrayOfCustomFieldValue)pgobject.get("customValue");
                        vlanSpec = customValues.getCustomFieldValue().iterator();
                        while (vlanSpec.hasNext()) {
                            CustomFieldValue val = (CustomFieldValue)vlanSpec.next();
                            CustomFieldStringValue stringValue = (CustomFieldStringValue)val;
                            customValueMap.put(stringValue.getKey(), stringValue.getValue());
                        }
                    }
                    ArrayList<CustomDefinition> customAttributesOnPortGroup = new ArrayList<CustomDefinition>();
                    if (pgobject.get("availableField") != null) {
                        ArrayOfCustomFieldDef customFields = (ArrayOfCustomFieldDef)pgobject.get("availableField");
                        for (CustomFieldDef def : customFields.getCustomFieldDef()) {
                            CustomDefinition customAttr = new CustomDefinition();
                            Integer key = def.getKey();
                            customAttr.setKey(key);
                            customAttr.setName(def.getName());
                            customAttr.setValue((String)customValueMap.get(key));
                            customAttributesOnPortGroup.add(customAttr);
                        }
                    }
                    pg.setCustomAttributes(customAttributesOnPortGroup);
                    dvs.addPortgroupsItem(pg);
                }
            }
            toReturn.add(dvs);
        }
        return toReturn;
    }

    public List<Datacenter> getDatacenters(ApiSpec spec) throws Exception {
        List<Map<String, Object>> objects = this.retreiveObjects("Datacenter", spec.getParentType(), new String[]{"name"}, spec);
        ArrayList<Datacenter> toReturn = new ArrayList<Datacenter>();
        for (Map<String, Object> object : objects) {
            Datacenter datacenter = new Datacenter();
            datacenter.setOid(((ManagedObjectReference)object.get("mor")).getValue());
            datacenter.setVmwType(((ManagedObjectReference)object.get("mor")).getType());
            datacenter.setName(object.get("name").toString());
            datacenter.setVcId(this._serverInfo.getGuid());
            datacenter.setId(datacenter.getOid());
            toReturn.add(datacenter);
        }
        return toReturn;
    }

    public List<EsxCluster> getEsxClusters(ApiSpec spec) throws Exception {
        List<Map<String, Object>> objects = this.retreiveObjects("ClusterComputeResource", spec.getParentType(), new String[]{"name"}, spec);
        ArrayList<EsxCluster> toReturn = new ArrayList<EsxCluster>();
        for (Map<String, Object> object : objects) {
            EsxCluster cluster = new EsxCluster();
            cluster.setOid(((ManagedObjectReference)object.get("mor")).getValue());
            cluster.setVmwType(((ManagedObjectReference)object.get("mor")).getType());
            cluster.setName(object.get("name").toString());
            cluster.setVcId(this._serverInfo.getGuid());
            cluster.setId(cluster.getOid());
            toReturn.add(cluster);
        }
        return toReturn;
    }

    public List<Datastore> getDatastores(ApiSpec spec) throws Exception {
        List<Map<String, Object>> objects = this.retreiveObjects("Datastore", spec.getParentType(), new String[]{"name", "summary.capacity", "summary.accessible", "summary.freeSpace"}, spec);
        ArrayList<Datastore> toReturn = new ArrayList<Datastore>();
        for (Map<String, Object> object : objects) {
            Datastore datastore = new Datastore();
            datastore.setOid(((ManagedObjectReference)object.get("mor")).getValue());
            datastore.setVmwType(((ManagedObjectReference)object.get("mor")).getType());
            datastore.setName(object.get("name").toString());
            datastore.setVcId(this._serverInfo.getGuid());
            datastore.setId(datastore.getOid());
            datastore.setAccessible((boolean)((Boolean)object.get("summary.accessible")));
            datastore.setCapacity((Long)object.get("summary.capacity"));
            datastore.setFreeSpace((Long)object.get("summary.freeSpace"));
            toReturn.add(datastore);
        }
        return toReturn;
    }

    public List<VirtualMachine> getVMs(ApiSpec spec) throws Exception {
        List<Map<String, Object>> objects = this.retreiveObjects("VirtualMachine", spec.getParentType(), new String[]{"name", "guestHeartbeatStatus", "runtime.connectionState", "runtime.powerState", "runtime.host", "config.extraConfig", "storage.perDatastoreUsage", "guest.net", "config.hardware.device", "summary.config.product.classId", "config.vAppConfig.property"}, spec);
        ArrayList<VirtualMachine> toReturn = new ArrayList<VirtualMachine>();
        for (Map<String, Object> object : objects) {
            String value;
            String key;
            String product = "";
            if (object.get("summary.config.product.classId") != null) {
                product = object.get("summary.config.product.classId").toString();
            }
            boolean isAve = "com.cisco.ave".equals(product);
            boolean isVpod = "com.cisco.vpod".equals(product);
            this.log.info("product is " + product);
            VirtualMachine vm = isAve ? new AveVirtualMachine() : (isVpod ? new VpodVirtualMachine() : new VirtualMachine());
            vm.setOid(((ManagedObjectReference)object.get("mor")).getValue());
            vm.setVmwType(((ManagedObjectReference)object.get("mor")).getType());
            vm.setName(object.get("name").toString());
            vm.setPowerState(object.get("runtime.powerState").toString());
            vm.setVcId(this._serverInfo.getGuid());
            ArrayOfOptionValue extraConfigs = (ArrayOfOptionValue)object.get("config.extraConfig");
            ArrayOfVirtualMachineUsageOnDatastore datastores = (ArrayOfVirtualMachineUsageOnDatastore)object.get("storage.perDatastoreUsage");
            ArrayOfVirtualDevice devices = (ArrayOfVirtualDevice)object.get("config.hardware.device");
            ArrayOfGuestNicInfo nicInfos = (ArrayOfGuestNicInfo)object.get("guest.net");
            ArrayOfVAppPropertyInfo vappPropInfos = (ArrayOfVAppPropertyInfo)object.get("config.vAppConfig.property");
            ManagedObjectReference hostRef = (ManagedObjectReference)object.get("runtime.host");
            VMwareMo hostRefMo = new VMwareMo();
            hostRefMo.setVmwType(hostRef.getType());
            hostRefMo.setOid(hostRef.getValue());
            hostRefMo.setId(hostRefMo.getOid());
            hostRefMo.setVcId(this._serverInfo.getGuid());
            vm.setHost(hostRefMo);
            if (datastores.getVirtualMachineUsageOnDatastore() != null && datastores.getVirtualMachineUsageOnDatastore().size() > 0) {
                VirtualMachineUsageOnDatastore dsUsage = (VirtualMachineUsageOnDatastore)datastores.getVirtualMachineUsageOnDatastore().get(0);
                ManagedObjectReference managedObjectReference = dsUsage.getDatastore();
            }
            if (devices != null && nicInfos != null && devices.getVirtualDevice().size() > 0 && nicInfos.getGuestNicInfo().size() > 0) {
                int deviceKey = -1;
                for (VirtualDevice dev : devices.getVirtualDevice()) {
                    if (!"Network adapter 1".equals(dev.getDeviceInfo().getLabel())) continue;
                    deviceKey = dev.getKey();
                }
                for (GuestNicInfo nicInfo : nicInfos.getGuestNicInfo()) {
                    if (nicInfo == null || nicInfo.getDeviceConfigId() != deviceKey || nicInfo.getIpConfig() == null || nicInfo.getIpConfig().getIpAddress() == null || nicInfo.getIpConfig().getIpAddress().size() <= 0) continue;
                    for (NetIpConfigInfoIpAddress ip : nicInfo.getIpConfig().getIpAddress()) {
                        if (!"preferred".equals(ip.getState())) continue;
                        vm.setMgmtIp(ip.getIpAddress());
                    }
                }
            }
            if (isAve) {
                for (OptionValue extraConfig : extraConfigs.getOptionValue()) {
                    key = extraConfig.getKey();
                    value = extraConfig.getValue().toString();
                    if ("guestinfo.com.cisco.ave.vem.version".equals(key)) {
                        ((AveVirtualMachine)vm).setVersion(value);
                        continue;
                    }
                    if ("guestinfo.com.cisco.ave.opflex.status".equals(key)) {
                        ((AveVirtualMachine)vm).setOpflexStatus(value);
                        continue;
                    }
                    if (!"guestinfo.com.cisco.ave.status".equals(key)) continue;
                    ((AveVirtualMachine)vm).setStatus(value);
                }
            }
            if (isVpod) {
                for (VAppPropertyInfo vappProperty : vappPropInfos.getVAppPropertyInfo()) {
                    key = vappProperty.getId();
                    value = vappProperty.getValue().toString();
                    if ("role".equals(key)) {
                        if ("spine".equals(value)) {
                            ((VpodVirtualMachine)vm).setRole(VpodVirtualMachine.RoleEnum.SPINE);
                        } else {
                            ((VpodVirtualMachine)vm).setRole(VpodVirtualMachine.RoleEnum.LEAF);
                        }
                    }
                    if (!"serial".equals(key)) continue;
                    ((VpodVirtualMachine)vm).setSerial(value);
                }
            }
            toReturn.add(vm);
        }
        return toReturn;
    }

    public int getCommonPortgroupsCount(List<String> hostIds, String propValue) throws Exception {
        List<PortGroup> portGroups = this.getFilteredPortGroups(hostIds, propValue);
        return portGroups.size();
    }

    public List<PortGroup> getCommonPortgroups(List<String> hostIds, String propValue, PageQueryBuilder pqb) throws Exception {
        List<PortGroup> portGroupsList = this.getFilteredPortGroups(hostIds, propValue);
        List<PortGroup> portGroups = ApicSdk.getPaginatedObjects(portGroupsList, pqb);
        return portGroups;
    }

    public List<PortGroup> getFilteredPortGroups(List<String> hostIds, String propValue) throws Exception {
        List<PortGroup> portgroups = this.getCommonPortgroupsList(hostIds);
        List<PortGroup> toReturn = new ArrayList<PortGroup>();
        if (portgroups == null || portgroups.size() == 0) {
            return toReturn;
        }
        toReturn = portgroups;
        if (propValue != null && !propValue.isEmpty()) {
            toReturn = portgroups.stream().filter(obj -> obj.getName() != null && obj.getName().contains(propValue)).collect(Collectors.toList());
        }
        return toReturn;
    }

    public List<PortGroup> getCommonPortgroupsList(List<String> hostIds) throws Exception {
        List<EsxHost> hosts = this.getEsxHosts(ApiSpecUtil.moIdSpec(hostIds));
        this.log.info("got esx hosts:" + hosts.toString());
        ArrayList<Dvs> commonDvs = null;
        for (EsxHost esxHost : hosts) {
            if (esxHost.getDvs() == null) {
                this.log.info("DVS for host " + esxHost.getName() + "is null, setting common dvs list to null and stop checking");
                commonDvs = null;
                break;
            }
            if (commonDvs == null) {
                this.log.info("Adding to common DVS list first time");
                commonDvs = new ArrayList<Dvs>();
                commonDvs.addAll(esxHost.getDvs());
                continue;
            }
            this.log.info("Retaining only common DVS");
            commonDvs.retainAll(esxHost.getDvs());
        }
        this.log.info("M:Printing common DVS list: ");
        for (Dvs dvs : commonDvs) {
            this.log.info("Common dvs = " + dvs.getName());
        }
        ArrayList<String> dvsIds = new ArrayList<String>();
        if (commonDvs != null) {
            for (Dvs dvs : commonDvs) {
                this.log.info("Adding dvs Mo id " + dvs.getOid() + "to list");
                dvsIds.add(dvs.getOid());
            }
        }
        ArrayList<PortGroup> arrayList = new ArrayList<PortGroup>();
        this.log.info("Getting network objects common to all input hosts");
        arrayList.addAll(this.getHostsCommonLocalPortGroups(hostIds));
        this.log.info("Common network object size= " + arrayList.size());
        this.log.info("Getting DV Port groups under all common DVS that is all DV PG common to all input hosts");
        if (dvsIds.size() > 0) {
            List<Dvs> dvsList = this.getDvs(ApiSpecUtil.moIdSpec(dvsIds), true);
            for (Dvs sw : dvsList) {
                arrayList.addAll(sw.getPortgroups());
            }
        }
        this.log.info("Total portgroups including network objects and dvp object= " + arrayList.size());
        return arrayList;
    }

    public List<PortGroup> getHostsCommonLocalPortGroups(List<String> hostIds) throws Exception {
        ApiSpec spec = ApiSpecUtil.moIdSpec(hostIds);
        String[] hostProps = new String[]{"network"};
        this.log.info("getting host networks");
        List<Map<String, Object>> objects = this.retreiveObjects("HostSystem", spec.getParentType(), hostProps, spec);
        ArrayList<String> networkIds = new ArrayList<String>();
        for (Map<String, Object> object : objects) {
            ArrayOfManagedObjectReference moArray = (ArrayOfManagedObjectReference)object.get("network");
            for (ManagedObjectReference managedObjectReference : moArray.getManagedObjectReference()) {
                if (!"Network".equals(managedObjectReference.getType())) continue;
                networkIds.add(managedObjectReference.getValue());
            }
        }
        this.log.info("getting standard networks details");
        objects = this.retreiveObjects("Network", spec.getParentType(), new String[]{"name", "host", "summary.ipPoolName"}, ApiSpecUtil.moIdSpec(networkIds));
        ArrayList<PortGroup> toReturn = new ArrayList<PortGroup>();
        HashMap netHostMap = new HashMap();
        HashMap<String, PortGroup> netPgMap = new HashMap<String, PortGroup>();
        for (Map map : objects) {
            String name = map.get("name").toString();
            ArrayOfManagedObjectReference moArray = (ArrayOfManagedObjectReference)map.get("host");
            for (ManagedObjectReference hostMOR : moArray.getManagedObjectReference()) {
                if (!netHostMap.containsKey(name)) {
                    netHostMap.put(name, new ArrayList());
                }
                ((List)netHostMap.get(name)).add(hostMOR.getValue());
            }
            if (netPgMap.containsKey(name)) continue;
            PortGroup pg = new PortGroup();
            pg.setOid(((ManagedObjectReference)map.get("mor")).getValue());
            pg.setVmwType(((ManagedObjectReference)map.get("mor")).getType());
            pg.setName(map.get("name").toString());
            pg.setDistributed(false);
            pg.setId(pg.getOid());
            if (map.get("summary.ipPoolName") != null) {
                String ipPool = map.get("summary.ipPoolName").toString();
                if (ipPool != null && !"".equals(ipPool)) {
                    pg.setIpPool(true);
                    pg.setIpPoolName(ipPool);
                } else {
                    pg.setIpPool(false);
                }
            } else {
                pg.setIpPool(false);
            }
            pg.setVcId(this._serverInfo.getGuid());
            netPgMap.put(name, pg);
        }
        for (String string : netHostMap.keySet()) {
            for (String hostId : hostIds) {
                if (((List)netHostMap.get(string)).contains(hostId)) continue;
                netPgMap.remove(string);
            }
        }
        toReturn.addAll(netPgMap.values());
        return toReturn;
    }

    public List<EsxHost> getEsxHosts(ApiSpec spec) throws Exception {
        return this.getEsxHosts(spec, new ArrayList<String>(), null);
    }

    public List<EsxHost> getEsxHosts(ApiSpec spec, List<String> includes, String domain) throws Exception {
        String[] props = new String[]{"name", "config.product.version", "runtime.inMaintenanceMode", "runtime.inQuarantineMode", "runtime.connectionState", "runtime.powerState", "parent", "config.network.proxySwitch", "datastore"};
        List<Map<String, Object>> objects = this.retreiveObjects("HostSystem", spec.getParentType(), props, spec);
        ArrayList<EsxHost> toReturn = new ArrayList<EsxHost>();
        HashMap completionMap = new HashMap();
        HashMap<String, Iterator<VMwareMo>> esxMap = new HashMap<String, Iterator<VMwareMo>>();
        ArrayList<String> esxClustersIDs = new ArrayList<String>();
        ArrayList<String> dvsUuids = new ArrayList<String>();
        ArrayList<String> datastoresIds = new ArrayList<String>();
        for (Map<String, Object> object : objects) {
            Iterator<VMwareMo> esx2 = new EsxHost();
            ((VMwareMo)((Object)esx2)).setVmwType("HostSystem");
            ((VMwareMo)((Object)esx2)).setOid(((ManagedObjectReference)object.get("mor")).getValue());
            ((ModelObject)((Object)esx2)).setId(this._serverInfo.getGuid() + "-" + ((VMwareMo)((Object)esx2)).getOid());
            ((ModelObject)((Object)esx2)).setName(object.get("name").toString());
            String version = object.get("config.product.version") == null ? null : object.toString();
            ((EsxHost)((Object)esx2)).setVersion(version);
            ((EsxHost)((Object)esx2)).setInMaintenance(Boolean.parseBoolean(object.get("runtime.inMaintenanceMode").toString()));
            ((EsxHost)((Object)esx2)).setInQuarantine(Boolean.parseBoolean(object.get("runtime.inQuarantineMode").toString()));
            ((VMwareMo)((Object)esx2)).setVcId(this._serverInfo.getGuid());
            ((EsxHost)((Object)esx2)).setConnectionState(object.get("runtime.connectionState").toString());
            ((EsxHost)((Object)esx2)).setPowerState(object.get("runtime.powerState").toString());
            ((ModelObject)((Object)esx2)).setName(object.get("name").toString());
            ArrayOfHostProxySwitch switchs = (ArrayOfHostProxySwitch)object.get("config.network.proxySwitch");
            List hostProxySwitches = switchs == null ? Collections.emptyList() : switchs.getHostProxySwitch();
            for (HostProxySwitch sw : hostProxySwitches) {
                dvsUuids.add(sw.getDvsUuid());
                if (!completionMap.containsKey(sw.getDvsUuid())) {
                    completionMap.put(sw.getDvsUuid(), new ArrayList());
                }
                ((List)completionMap.get(sw.getDvsUuid())).add(esx2);
            }
            ManagedObjectReference parentRef = (ManagedObjectReference)object.get("parent");
            if ("ClusterComputeResource".equals(parentRef.getType()) && !esxClustersIDs.contains(parentRef)) {
                esxClustersIDs.add(parentRef.getValue());
                if (!completionMap.containsKey(parentRef.getValue())) {
                    completionMap.put(parentRef.getValue(), new ArrayList());
                }
                ((List)completionMap.get(parentRef.getValue())).add(esx2);
            }
            if (includes != null && includes.contains("datastore")) {
                ArrayOfManagedObjectReference datastores = (ArrayOfManagedObjectReference)object.get("datastore");
                for (ManagedObjectReference dsMOR : datastores.getManagedObjectReference()) {
                    if (!datastoresIds.contains(dsMOR.getValue())) {
                        datastoresIds.add(dsMOR.getValue());
                    }
                    if (!completionMap.containsKey(dsMOR.getValue())) {
                        completionMap.put(dsMOR.getValue(), new ArrayList());
                    }
                    ((List)completionMap.get(dsMOR.getValue())).add(esx2);
                }
            }
            esxMap.put(((VMwareMo)((Object)esx2)).getOid(), esx2);
            toReturn.add((EsxHost)((Object)esx2));
        }
        if (esxClustersIDs.size() > 0) {
            ApiSpec clusterSpec = new ApiSpec();
            clusterSpec.setIdList(esxClustersIDs);
            List<EsxCluster> clusters = this.getEsxClusters(clusterSpec);
            for (EsxCluster cluster : clusters) {
                for (EsxHost e : (List)completionMap.get(cluster.getOid())) {
                    e.setCluster(cluster);
                }
            }
        }
        if (includes != null && includes.contains("datastore") && datastoresIds.size() > 0) {
            ApiSpec dsSpec = new ApiSpec();
            dsSpec.setIdList(datastoresIds);
            List<Datastore> datastores = this.getDatastores(dsSpec);
            for (Datastore ds : datastores) {
                for (EsxHost e : (List)completionMap.get(ds.getOid())) {
                    e.addDatastoresItem(ds);
                }
            }
        }
        this.log.info("dvs uuids:" + dvsUuids);
        ArrayList<String> attachedDvsNames = new ArrayList<String>();
        if (dvsUuids.size() > 0) {
            List<Dvs> dvss = this.getDvs(ApiSpecUtil.propFilterSpec("uuid", dvsUuids), false);
            this.log.info("got dvs:" + dvss.size());
            for (Dvs dvs : dvss) {
                attachedDvsNames.add(dvs.getName());
                for (EsxHost e : (List)completionMap.get(dvs.getUuid())) {
                    if (e.getDvs() == null) {
                        e.setDvs(new ArrayList<Dvs>());
                    }
                    e.getDvs().add(dvs);
                }
            }
        }
        if (includes != null && includes.contains("ave") && domain != null) {
            this.connectCIS();
            this._cis.getTaggingClient().loadTagMap();
            ArrayList<String> aveVMOids = new ArrayList<String>();
            String domainTagName = "cisco-ave_dom-" + domain;
            aveVMOids.addAll(this.findObjectsByTag(domainTagName));
            if (aveVMOids != null && aveVMOids.size() > 0) {
                List aveVMs = this.getVMs(ApiSpecUtil.moIdSpec(aveVMOids)).stream().filter(vm -> vm instanceof AveVirtualMachine).map(vm -> (AveVirtualMachine)vm).collect(Collectors.toList());
                for (AveVirtualMachine aveVM : aveVMs) {
                    if (!esxMap.containsKey(aveVM.getHost().getOid())) continue;
                    ((EsxHost)esxMap.get(aveVM.getHost().getOid())).setAve(aveVM);
                }
            }
            toReturn.forEach(esx -> this.computeEsxAveStatus((EsxHost)esx, domain));
        }
        return toReturn;
    }

    private void computeEsxAveStatus(EsxHost esx, String domain) {
        boolean isConnected;
        Status s = new Status();
        esx.setAveStatus(s);
        boolean bl = isConnected = esx.getDvs() != null && esx.getDvs().stream().filter(dvs -> domain.equals(dvs.getName())).count() > 0L;
        if (!isConnected) {
            s.setCode(StatusLevel.INFO);
            s.setMessage("Not connected to the AVE DVS");
            return;
        }
        if (esx.getAve() == null) {
            s.setCode(StatusLevel.DANGER);
            s.setMessage("AVE missing");
            return;
        }
        if ("ok".equals(esx.getAve().getStatus())) {
            s.setCode(StatusLevel.SUCCESS);
            s.setMessage("Online");
            return;
        }
        if ("not-ok".equals(esx.getAve().getStatus())) {
            s.setCode(StatusLevel.DANGER);
            s.setMessage("Opflex down");
            return;
        }
        if (esx.isInMaintenance().booleanValue()) {
            s.setCode(StatusLevel.INFO);
            s.setMessage("In maintenance");
        }
        if ("POWERED_OFF".equals(esx.getAve().getPowerState())) {
            s.setCode(StatusLevel.DANGER);
            s.setMessage("AVE is powered off");
            return;
        }
        s.setCode(StatusLevel.DANGER);
        s.setMessage("offline");
    }

    public List<VpodVirtualMachine> getVpodVMs(String podId) throws Exception {
        List<String> vmOids = this.findObjectsByTag("cisco-vpod-" + podId);
        List<VpodVirtualMachine> vpodVms = this.getVMs(ApiSpecUtil.moIdSpec(vmOids)).stream().filter(vm -> vm instanceof VpodVirtualMachine).map(vm -> (VpodVirtualMachine)vm).collect(Collectors.toList());
        return vpodVms;
    }

    public List<String> findObjectsByTag(String tagName) throws Exception {
        this.connectCIS();
        this._cis.getTaggingClient().loadTagMap();
        ArrayList<String> oids = new ArrayList<String>();
        String tagId = this._cis.getTaggingClient().getTagId(tagName);
        if (tagId == null || tagId == "") {
            return oids;
        }
        List domainAveRefs = this._cis.getTaggingClient().listAttachedObjects(tagId);
        for (com.vmware.vim25.ManagedObjectReference ref : domainAveRefs) {
            oids.add(ref.getVal());
        }
        return oids;
    }

    public List<ContentLibraryItem> getAveItems() throws Exception {
        ArrayList<ContentLibraryItem> items = new ArrayList<ContentLibraryItem>();
        this.log.info("connecting to CIS");
        this.connectCIS();
        this.log.info("connected");
        List versions = this._cis.getLibraryClient().getServiceVMVersions("ave");
        if (versions != null && versions.size() > 0) {
            for (SvmVersion v : versions) {
                ContentLibraryItem item = new ContentLibraryItem();
                item.setItemId(v.itemId);
                item.setItemName(v.itemName);
                item.setLibraryName(v.libName);
                item.setVersion(v.label.replace("ACI Virtual Edge - ", ""));
                item.setLibraryId(v.libId);
                item.setId(item.getItemId());
                item.setName(item.getItemName());
                items.add(item);
            }
        } else {
            this.log.info("svm version was null or empty");
        }
        return items;
    }

    public List<ContentLibraryItem> getVPodItems() throws Exception {
        ArrayList<ContentLibraryItem> items = new ArrayList<ContentLibraryItem>();
        this.connectCIS();
        List versions = this._cis.getLibraryClient().getServiceVMVersions("vpod");
        if (versions != null && versions.size() > 0) {
            for (SvmVersion v : versions) {
                ContentLibraryItem item = new ContentLibraryItem();
                item.setItemId(v.itemId);
                item.setItemName(v.itemName);
                item.setLibraryName(v.libName);
                item.setVersion(v.label.replace("ACI Virtual Edge - ", ""));
                item.setLibraryId(v.libId);
                item.setId(item.getItemId());
                item.setName(item.getItemName());
                items.add(item);
            }
        } else {
            this.log.info("svm version was null or empty");
        }
        return items;
    }

    public VimConnection connectVIM() throws Exception {
        if (this._vim != null) {
            this.log.info("vim already connected");
            return this._vim;
        }
        URL url = new URL(this._serverInfo.getUrl());
        this._vim = new VimConnection(url.getHost(), url.getPort());
        if (this._password != null) {
            this._vim.loginAsUser(this._username, this._password);
        } else {
            this._vim.connectViaCookie(this._serverInfo.getSessionCookie(), this._serverInfo.getUrl());
        }
        this.log.info("done connecting to vim");
        return this._vim;
    }

    public AutomationSDKApi connectCIS() throws Exception {
        this.log.info("connecting CIS");
        if (this._password == null) {
            this.log.error("Can't connect to CIS without the user's password");
            throw new Exception("Can't connect to CIS without the user's password");
        }
        if (this._cis != null) {
            this.log.info("cis session already exists");
            return this._cis;
        }
        ServerInfo info = new ServerInfo();
        info.serviceGuid = this._serverInfo.getGuid();
        info.serviceUrl = this._serverInfo.getUrl();
        info.sessionCookie = this._serverInfo.getSessionCookie();
        info.name = this._serverInfo.getName();
        AutomationSDKApi api = new AutomationSDKApi(this._username, this._password, info);
        api.connect();
        api.getTaggingClient().resolveAveCategory(null);
        this._cis = api;
        return this._cis;
    }

    public void invalidateCachedSessions() {
        this.log.info("Invalidating cached vim and cis sessions");
        this._vim = null;
        this._cis = null;
    }

    public void setPassword(String value) {
        this._password = value;
        EsxHost e = new EsxHost();
    }

    public List<ManagedObjectReference> getMoRefList(String objectType, List<String> idList) {
        ArrayList<ManagedObjectReference> toReturn = new ArrayList<ManagedObjectReference>();
        for (String id : idList) {
            ManagedObjectReference mor = new ManagedObjectReference();
            mor.setType(objectType);
            mor.setValue(id);
            toReturn.add(mor);
        }
        return toReturn;
    }

    public List<Map<String, Object>> retrieveObjectProperties(List<ManagedObjectReference> refs, String vSphereObject, String[] vSphereObjectProperties) {
        ServiceContent serviceContent = this._vim.getServiceContent();
        ManagedObjectReference propColl = serviceContent.getPropertyCollector();
        PropertyFilterSpec fSpec = this.createMoListFilterSpec(refs, vSphereObject, vSphereObjectProperties);
        ArrayList<PropertyFilterSpec> fSpecList = new ArrayList<PropertyFilterSpec>();
        fSpecList.add(fSpec);
        ArrayList<RetrieveResult> propsList = new ArrayList<RetrieveResult>();
        RetrieveOptions ro = new RetrieveOptions();
        RetrieveResult props = null;
        try {
            props = this._vim.getStub().retrievePropertiesEx(propColl, fSpecList, ro);
            while (props != null && props.getObjects() != null) {
                propsList.add(props);
                String token = props.getToken();
                if (token != null && token.length() > 0) {
                    props = this._vim.getStub().continueRetrievePropertiesEx(propColl, token);
                    continue;
                }
                break;
            }
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            invalidPropertyFaultMsg.printStackTrace();
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            runtimeFaultFaultMsg.printStackTrace();
        }
        return this.formatRetrievedProperties(propsList);
    }

    public List<Map<String, Object>> retrieveObjectProperties(ManagedObjectReference parent, String vSphereObject, String[] vSphereObjectProperties) {
        VCenterSdk.paramsNotNull(vSphereObject, vSphereObjectProperties);
        ServiceContent serviceContent = this._vim.getServiceContent();
        ManagedObjectReference viewMgrRef = serviceContent.getViewManager();
        ManagedObjectReference propColl = serviceContent.getPropertyCollector();
        ArrayList<String> vObjects = new ArrayList<String>();
        vObjects.add(vSphereObject);
        ArrayList<RetrieveResult> propsList = new ArrayList();
        try {
            ManagedObjectReference cViewRef = this._vim.getStub().createContainerView(viewMgrRef, parent, vObjects, true);
            propsList = this.retrieveProperties(cViewRef, propColl, vSphereObject, vSphereObjectProperties);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            this.log.error("Could not create ContainerView for " + vSphereObject + (Object)((Object)runtimeFaultFaultMsg));
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            this.log.error("Could not retrieveProperties for " + vSphereObject + (Object)((Object)invalidPropertyFaultMsg));
        }
        return this.formatRetrievedProperties(propsList);
    }

    public static void paramsNotNull(Object ... args) {
        if (args == null) {
            throw new IllegalArgumentException("Null argument args");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            throw new IllegalArgumentException("Null param at index: " + i);
        }
    }

    private List<RetrieveResult> retrieveProperties(ManagedObjectReference cViewRef, ManagedObjectReference propColl, String vSphereObject, String[] vSphereObjectProperties) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ArrayList<RetrieveResult> retrieveResultList = new ArrayList<RetrieveResult>();
        PropertyFilterSpec fSpec = this.createPropertyFilterSpec(cViewRef, vSphereObject, vSphereObjectProperties);
        ArrayList<PropertyFilterSpec> fSpecList = new ArrayList<PropertyFilterSpec>();
        fSpecList.add(fSpec);
        RetrieveOptions ro = new RetrieveOptions();
        RetrieveResult props = this._vim.getStub().retrievePropertiesEx(propColl, fSpecList, ro);
        while (props != null && props.getObjects() != null) {
            retrieveResultList.add(props);
            String token = props.getToken();
            if (token == null || token.length() <= 0) break;
            props = this._vim.getStub().continueRetrievePropertiesEx(propColl, token);
        }
        return retrieveResultList;
    }

    private PropertyFilterSpec createMoListFilterSpec(List<ManagedObjectReference> moRefs, String vSphereObject, String[] vSphereObjectProperties) {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType(vSphereObject);
        pSpec.getPathSet().addAll(Arrays.asList(vSphereObjectProperties));
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        for (ManagedObjectReference moRef : moRefs) {
            ObjectSpec spec = new ObjectSpec();
            spec.setObj(moRef);
            fSpec.getObjectSet().add(spec);
        }
        fSpec.getPropSet().add(pSpec);
        return fSpec;
    }

    private PropertyFilterSpec createPropertyFilterSpec(ManagedObjectReference cViewRef, String vSphereObject, String[] vSphereObjectProperties) {
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(cViewRef);
        oSpec.setSkip(Boolean.valueOf(true));
        TraversalSpec tSpec = new TraversalSpec();
        tSpec.setName("traverseEntities");
        tSpec.setPath("view");
        tSpec.setSkip(Boolean.valueOf(false));
        tSpec.setType("ContainerView");
        oSpec.getSelectSet().add(tSpec);
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType(vSphereObject);
        pSpec.getPathSet().addAll(Arrays.asList(vSphereObjectProperties));
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.getObjectSet().add(oSpec);
        fSpec.getPropSet().add(pSpec);
        return fSpec;
    }

    private List<Map<String, Object>> formatRetrievedProperties(List<RetrieveResult> propsList) {
        ArrayList<Map<String, Object>> objectsProperties = new ArrayList<Map<String, Object>>();
        if (propsList != null) {
            for (RetrieveResult props : propsList) {
                if (props == null) continue;
                for (ObjectContent oc : props.getObjects()) {
                    List dps = oc.getPropSet();
                    HashMap<String, Object> managedObject = new HashMap<String, Object>(dps.size());
                    managedObject.put("mor", oc.getObj());
                    if (dps != null) {
                        for (DynamicProperty dp : dps) {
                            managedObject.put(dp.getName(), dp.getVal());
                        }
                    }
                    objectsProperties.add(managedObject);
                }
            }
        }
        return objectsProperties;
    }

    public String getHostDatacenter(String hostId) throws Exception {
        ManagedObjectReference mor = new ManagedObjectReference();
        mor.setType("HostSystem");
        mor.setValue(hostId);
        SelectionSpec sspec1 = new SelectionSpec();
        sspec1.setName("FolderParent");
        TraversalSpec tspec1 = new TraversalSpec();
        tspec1.setName("FolderParent");
        tspec1.setSkip(Boolean.FALSE);
        tspec1.setType("Folder");
        tspec1.setPath("parent");
        tspec1.getSelectSet().add(sspec1);
        TraversalSpec tspec2 = new TraversalSpec();
        tspec2.setSkip(Boolean.FALSE);
        tspec2.setType("ComputeResource");
        tspec2.setPath("parent");
        tspec2.getSelectSet().add(tspec1);
        TraversalSpec tspec3 = new TraversalSpec();
        tspec3.setSkip(Boolean.FALSE);
        tspec3.setType("HostSystem");
        tspec3.setPath("parent");
        tspec3.getSelectSet().add(tspec2);
        ObjectSpec ospec1 = new ObjectSpec();
        ospec1.setObj(mor);
        ospec1.setSkip(Boolean.FALSE);
        ospec1.getSelectSet().add(tspec3);
        PropertySpec pspec1 = new PropertySpec();
        pspec1.setType("Datacenter");
        pspec1.getPathSet().add("name");
        PropertyFilterSpec pfSpec = new PropertyFilterSpec();
        pfSpec.getObjectSet().add(ospec1);
        pfSpec.getPropSet().add(pspec1);
        ServiceContent serviceContent = this._vim.getServiceContent();
        ManagedObjectReference propColl = serviceContent.getPropertyCollector();
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        ArrayList<PropertyFilterSpec> fSpecList = new ArrayList<PropertyFilterSpec>();
        fSpecList.add(pfSpec);
        RetrieveOptions ro = new RetrieveOptions();
        List oc = this._vim.getStub().retrieveProperties(propColl, fSpecList);
        if (oc != null && oc.size() == 1) {
            ManagedObjectReference dc = ((ObjectContent)oc.get(0)).getObj();
            return dc.getValue();
        }
        throw new Exception("DC not found");
    }

    public Vcenter getVcenterInfo() {
        return this._serverInfo;
    }

    public VimConnection getVim() {
        return this._vim;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public String getGuid() {
        return this._serverInfo.getGuid();
    }

    public TaskInfo createTask(ManagedObjectReference mo, String taskId, String initiator, boolean cancelable) throws Exception {
        this.connectVIM();
        return this.getVim().getStub().createTask(this.getVim().getServiceContent().getTaskManager(), mo, taskId, initiator, cancelable, null, null);
    }

    public void setTaskState(TaskInfo ti, TaskInfoState state) throws Exception {
        this.connectVIM();
        this.getVim().getStub().setTaskState(ti.getTask(), state, null, null);
    }

    public void updateTaskProgress(TaskInfo ti, Integer progress) throws Exception {
        this.connectVIM();
        this.getVim().getStub().updateProgress(ti.getTask(), progress.intValue());
    }

    public TaskInfo getTaskInfo(ManagedObjectReference mo) throws Exception {
        this.connectVIM();
        List<Map<String, Object>> objects = this.retreiveObjects("Task", null, new String[]{"info"}, ApiSpecUtil.moIdSpec(mo.getValue()));
        if (objects.size() > 0) {
            TaskInfo ti = (TaskInfo)objects.get(0).get("info");
            return ti;
        }
        throw new RuntimeException("Failed to find task for " + mo.toString());
    }

    public VCenterSdk newHandle() {
        VCenterSdk sdk = new VCenterSdk(this._username, this._serverInfo);
        sdk.setPassword(this._password);
        return sdk;
    }

    public void waitForTask(ManagedObjectReference task) throws Exception {
        TaskInfoState taskInfoState = this.getTaskInfo(task).getState();
        int count = 5;
        while (taskInfoState == null || taskInfoState.equals((Object)TaskInfoState.RUNNING) || taskInfoState.equals((Object)TaskInfoState.QUEUED)) {
            if (count < 0) {
                throw new Exception(" VCenter Task " + this.getTaskInfo(task).getName() + " timed out ");
            }
            taskInfoState = this.getTaskInfo(task).getState();
            if (taskInfoState.equals((Object)TaskInfoState.RUNNING)) {
                Thread.sleep(500L);
            } else {
                Thread.sleep(1000L);
            }
            --count;
        }
    }
}

