/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.storage;

import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.model.Certificate;
import com.cisco.aci.vcplugin.swagger.model.LoginSettings;
import com.cisco.aci.vcplugin.swagger.model.StoredApicSettings;
import com.cisco.aciPluginServices.settings.Encryptor;
import com.cisco.aciPluginServices.settings.FileStoreManager;
import com.cisco.apic.util.Base64;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.SystemUtils;

public final class PersistentSettings {
    private static final String LINUX_STORAGE_FOLDER = "/storage/vsphere-ui";
    private static final String VCP_FOLDER_NAME = "cisco_aci_plugin_html5";
    private static final String SETTINGS_DIR_PATH = PersistentSettings.getSettingsFileFolder();
    private static final String HOST_SETTINGS_FILE_NAME = "apicsettings.json";
    private static final String SALT_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private static final VcpLogger log = new VcpLogger();
    private Map<String, StoredApicSettings> settings = new ConcurrentHashMap<String, StoredApicSettings>();
    private String _vcUser;

    public PersistentSettings(String vcUser) throws IOException {
        this._vcUser = vcUser;
        this.loadSettings();
    }

    public List<StoredApicSettings> getApicSettings() {
        return new ArrayList<StoredApicSettings>(this.settings.values());
    }

    public synchronized void saveHostSettings(String uuid, StoredApicSettings apicSettings) throws JsonProcessingException, FileNotFoundException, IOException {
        String hostname = apicSettings.getHostname();
        String apicUser = apicSettings.getUsername();
        Predicate<StoredApicSettings> sameHostname = s -> s.getHostname().equals(hostname);
        Predicate<StoredApicSettings> sameApicUser = s -> s.getUsername().equals(apicUser);
        Predicate<StoredApicSettings> sameHostnameAndApicUser = sameHostname.and(sameApicUser);
        this.settings.entrySet().stream().filter(entry -> sameHostnameAndApicUser.test((StoredApicSettings)entry.getValue())).forEach(entry -> this.settings.remove(entry.getKey()));
        try {
            this.updateCertProperties(apicSettings);
            this.settings.put(uuid, apicSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return;
        }
        this.save();
    }

    private synchronized void updateCertProperties(StoredApicSettings apicSettings) throws Exception {
        Certificate cert = apicSettings.getCertificate();
        boolean hasCert = Optional.ofNullable(cert).isPresent();
        if (hasCert) {
            boolean isSelfSignedCert;
            boolean bl = isSelfSignedCert = cert.getType() == Certificate.TypeEnum.SELF_SIGNED;
            if (isSelfSignedCert) {
                log.info("self signed cert encryption for cert: " + cert.getName());
                byte[] salt = PersistentSettings.generateRandomSalt();
                String privateKey = cert.getPrivateKey();
                String encryptedPKey = Encryptor.encrypt((String)privateKey, (String)cert.getPassphrase(), (byte[])salt);
                String encodedSalt = Base64.encode((byte[])salt);
                cert.setPrivateKey(encryptedPKey);
                cert.setSalt(encodedSalt);
            }
            cert.setPassphrase(null);
        }
    }

    private static byte[] generateRandomSalt() {
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < SALT_CHARS.length()) {
            int index = (int)(rnd.nextFloat() * (float)SALT_CHARS.length());
            salt.append(SALT_CHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr.getBytes();
    }

    private synchronized void save() throws JsonProcessingException, FileNotFoundException, IOException {
        log.info("Saving settings to disk");
        String filename = this.getApicSettingsFileName();
        File settingsFile = new File(filename);
        if (!settingsFile.exists()) {
            File settingsDir = new File(PersistentSettings.getSettingsFileFolder());
            if (!settingsDir.exists() && !settingsDir.mkdirs()) {
                String errorMsg = "Could not create directory " + PersistentSettings.getSettingsFileFolder() + ", check the write permission of the Virgo process.";
                throw new IOException(errorMsg);
            }
            try {
                settingsFile.createNewFile();
            }
            catch (IOException e) {
                String errorMsg = "Could not create file " + this.getApicSettingsFileName();
                throw new IOException(errorMsg, e);
            }
        }
        List<StoredApicSettings> apicSettings = this.getApicSettings();
        String settingsJson = new ObjectMapper().writeValueAsString(apicSettings);
        PrintWriter printWriter = new PrintWriter(settingsFile);
        printWriter.println(settingsJson);
        printWriter.close();
        log.info("Saved settings to disk");
    }

    public synchronized void removeHostSettings(String uuid) throws IOException {
        log.info("Removing APIC settings entry with uuid: " + uuid);
        Optional<StoredApicSettings> removedOpt = Optional.ofNullable(this.settings.remove(uuid));
        if (!removedOpt.isPresent()) {
            String message = String.format("apic settings entry uuid: %s was not removed for user: %s", uuid, this._vcUser);
            log.warn(message);
            return;
        }
        StoredApicSettings apicSettings = removedOpt.get();
        String apicUser = apicSettings.getUsername();
        String cacFilename = PersistentSettings.getCacFilename(apicUser, this._vcUser, apicSettings.getHostname());
        File cacFile = new File(cacFilename);
        if (cacFile.exists()) {
            FileStoreManager.fileDelete((File)cacFile);
        }
        this.save();
        log.info("Removed apic settings entry with uuid: " + uuid);
    }

    private synchronized void loadSettings() throws IOException {
        String filename = this.getApicSettingsFileName();
        File settingsFile = new File(filename);
        if (!settingsFile.exists()) {
            File dir = new File(SETTINGS_DIR_PATH);
            if (!dir.exists() && !dir.mkdirs()) {
                String errorMsg = "Could not create directory " + SETTINGS_DIR_PATH + ", check the write permission of the Virgo process.";
                throw new AccessDeniedException(errorMsg);
            }
            try {
                settingsFile.createNewFile();
            }
            catch (IOException e) {
                String errorMsg = "Could not create file " + filename;
                throw new AccessDeniedException(errorMsg);
            }
        } else {
            FileInputStream in = new FileInputStream(filename);
            Charset charset = StandardCharsets.UTF_8;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, charset));
            String json = br.lines().collect(Collectors.joining(System.lineSeparator()));
            br.close();
            if (json.isEmpty()) {
                return;
            }
            ObjectMapper objMapper = new ObjectMapper();
            TypeFactory typeFactory = objMapper.getTypeFactory();
            CollectionType collectionType = typeFactory.constructCollectionType(List.class, StoredApicSettings.class);
            List listSettings = (List)objMapper.readValue(json, (JavaType)collectionType);
            listSettings.forEach(s -> this.settings.put(s.getHostname(), (StoredApicSettings)s));
        }
    }

    public static String getSettingsFileFolder() {
        if (SystemUtils.IS_OS_WINDOWS) {
            String val = System.getenv("PROGRAMDATA");
            if (val == null && (val = System.getenv("TEMP")) == null) {
                val = "C:\\temp";
            }
            return val + "\\" + VCP_FOLDER_NAME;
        }
        return "/storage/vsphere-ui/cisco_aci_plugin_html5";
    }

    private String getApicSettingsFileName() {
        String fileFriendlyUsername = this._vcUser.replace("@", "_");
        String filename = String.format("%s/%s-%s", SETTINGS_DIR_PATH, fileFriendlyUsername, HOST_SETTINGS_FILE_NAME);
        return filename;
    }

    public static String decryptPrivateKey(Certificate cert) throws Exception {
        String encodedSalt = cert.getSalt();
        String encryptedKey = cert.getPrivateKey();
        String passphrase = cert.getPassphrase();
        log.info("Decrypting private key");
        byte[] decodedSalt = Base64.decode((String)encodedSalt);
        String privateKey = Encryptor.decrpyt((String)encryptedKey, (String)passphrase, (byte[])decodedSalt);
        log.info("Decrypted private key");
        return privateKey;
    }

    public static boolean storeCacFile(LoginSettings settings, String vcUser, String apicHost) {
        String apicUser = settings.getUsername();
        String filename = PersistentSettings.getCacFilename(apicUser, vcUser, apicHost);
        byte[] cacBytes = settings.getCertificate().getFile();
        return FileStoreManager.saveByteDataToFile((String)filename, (byte[])cacBytes);
    }

    public static String getCacFilename(String apicUser, String vcUser, String apicHost) {
        String sanitizedUser = FileStoreManager.sanitizeUsername((String)vcUser);
        String filename = String.format("%s%s%s-%s-%s-cac", PersistentSettings.getSettingsFileFolder(), FileStoreManager.getFileSeparator(), sanitizedUser, apicUser, apicHost);
        return filename;
    }
}

