/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.model.Certificate;
import com.cisco.aci.vcplugin.swagger.model.LoginSettings;
import com.cisco.aci.vcplugin.swagger.model.RBAC;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.VcLoginSettings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="Aaa", description="the Aaa API")
public interface AaaApi {
    @ApiOperation(value="Generate a new self-signed certifcate", nickname="aaaCertGenerateGet", notes="", response=Certificate.class, tags={"aaa"})
    @ApiResponses(value={@ApiResponse(code=201, message="The currently registered ACI Fabric", response=Certificate.class)})
    @RequestMapping(value={"/aaa/cert/generate"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Certificate> aaaCertGenerateGet(@NotNull @ApiParam(value="Name of the certificate to generate", required=true) @Valid @RequestParam(value="name", required=true) String var1);

    @ApiOperation(value="Validate a given certficate (Self-signed / CA)", nickname="aaaCertValidatePost", notes="", response=Boolean.class, tags={"aaa"})
    @ApiResponses(value={@ApiResponse(code=200, message="Certificate valid", response=Boolean.class)})
    @RequestMapping(value={"/aaa/cert/validate"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> aaaCertValidatePost(@ApiParam(value="The certificate to validate", required=true) @Valid @RequestBody LoginSettings var1);

    @ApiOperation(value="Logout of a Fabric", nickname="aaaIdLogoutPost", notes="", response=Task.class, tags={"aaa"})
    @ApiResponses(value={@ApiResponse(code=200, message="", response=Task.class)})
    @RequestMapping(value={"/aaa/{id}/logout"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> aaaIdLogoutPost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1);

    @ApiOperation(value="Get the current permissions of the user", nickname="aaaIdPermissionsGet", notes="", response=RBAC.class, tags={"aaa"})
    @ApiResponses(value={@ApiResponse(code=200, message="The permission of the current active user", response=RBAC.class)})
    @RequestMapping(value={"/aaa/{id}/permissions"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<RBAC> aaaIdPermissionsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Login into APIC", nickname="aaaLoginPost", notes="", response=Task.class, tags={"aaa"})
    @ApiResponses(value={@ApiResponse(code=200, message="", response=Task.class)})
    @RequestMapping(value={"/aaa/login"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> aaaLoginPost(@ApiParam(value="The login information", required=true) @Valid @RequestBody LoginSettings var1);

    @ApiOperation(value="Get the auth status of the VC", nickname="aaaVcenterGet", notes="", response=Boolean.class, tags={"aaa"})
    @ApiResponses(value={@ApiResponse(code=200, message="If the user is currently authenticated", response=Boolean.class)})
    @RequestMapping(value={"/aaa/vcenter"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Boolean> aaaVcenterGet();

    @ApiOperation(value="Login into vCenter", nickname="aaaVcenterLoginPost", notes="", response=Task.class, tags={"aaa"})
    @ApiResponses(value={@ApiResponse(code=200, message="", response=Task.class)})
    @RequestMapping(value={"/aaa/vcenter/login"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> aaaVcenterLoginPost(@ApiParam(value="The vCenter login information", required=true) @Valid @RequestBody VcLoginSettings var1);
}

