/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.api.AaaApi;
import com.cisco.aci.vcplugin.swagger.model.Certificate;
import com.cisco.aci.vcplugin.swagger.model.LoginSettings;
import com.cisco.aci.vcplugin.swagger.model.RBAC;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.VcLoginSettings;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AaaApiController
implements AaaApi {
    private static final Logger log = LoggerFactory.getLogger(AaaApiController.class);
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;

    @Autowired
    public AaaApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    @Override
    public ResponseEntity<Certificate> aaaCertGenerateGet(@NotNull @ApiParam(value="Name of the certificate to generate", required=true) @Valid @RequestParam(value="name", required=true) String name) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("{  \"privateKey\" : \"privateKey\",  \"file\" : \"file\",  \"salt\" : \"salt\",  \"name\" : \"name\",  \"passphrase\" : \"passphrase\",  \"publicKey\" : \"publicKey\",  \"type\" : \"SELF_SIGNED\"}", Certificate.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Boolean> aaaCertValidatePost(@ApiParam(value="The certificate to validate", required=true) @Valid @RequestBody LoginSettings certificate) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("true", Boolean.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> aaaIdLogoutPost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<RBAC> aaaIdPermissionsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("{  \"tenantPermissions\" : \"{}\",  \"domainPermissions\" : \"{}\",  \"username\" : \"username\"}", RBAC.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> aaaLoginPost(@ApiParam(value="The login information", required=true) @Valid @RequestBody LoginSettings loginSettings) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Boolean> aaaVcenterGet() {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("true", Boolean.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> aaaVcenterLoginPost(@ApiParam(value="The vCenter login information", required=true) @Valid @RequestBody VcLoginSettings vcLoginSettings) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

