/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.model.HostAveConfig;
import com.cisco.aci.vcplugin.swagger.model.HostAveRemoveConfig;
import com.cisco.aci.vcplugin.swagger.model.Pod;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.VNode;
import com.cisco.aci.vcplugin.swagger.model.VPodHostConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="Infra", description="the Infra API")
public interface InfraApi {
    @ApiOperation(value="Deploy AVE on a list of Host", nickname="avePost", notes="", response=Task.class, tags={"infra"})
    @ApiResponses(value={@ApiResponse(code=200, message="Task created for the operation", response=Task.class)})
    @RequestMapping(value={"/ave"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> avePost(@ApiParam(value="The deployment configuration", required=true) @Valid @RequestBody List<HostAveConfig> var1);

    @ApiOperation(value="List of PODs in the Fabric", nickname="fabricsIdVpodsGet", notes="", response=Pod.class, responseContainer="List", tags={"infra"})
    @ApiResponses(value={@ApiResponse(code=200, message="List of PODs in the fabric", response=Pod.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/vpods"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Pod>> fabricsIdVpodsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Delete the VMs for a given vPOD", nickname="fabricsIdVpodsPodIdVmsDelete", notes="", response=Task.class, responseContainer="List", tags={"infra"})
    @ApiResponses(value={@ApiResponse(code=200, message="Tasks created for the operation", response=Task.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/vpods/{podId}/vms"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<List<Task>> fabricsIdVpodsPodIdVmsDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="ID of the POD", required=true) @PathVariable(value="podId") String var2);

    @ApiOperation(value="Deploy VMs for a given vPOD", nickname="fabricsIdVpodsPodIdVmsPost", notes="", response=Task.class, responseContainer="List", tags={"infra"})
    @ApiResponses(value={@ApiResponse(code=200, message="Tasks created for the operation", response=Task.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/vpods/{podId}/vms"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<List<Task>> fabricsIdVpodsPodIdVmsPost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="ID of the POD", required=true) @PathVariable(value="podId") String var2, @ApiParam(value="The deployment configuration", required=true) @Valid @RequestBody List<VPodHostConfig> var3);

    @ApiOperation(value="List of nodes in the POD", nickname="fabricsIdVpodsPodIdVnodesGet", notes="", response=VNode.class, responseContainer="List", tags={"infra"})
    @ApiResponses(value={@ApiResponse(code=200, message="List of PODs in the fabric", response=VNode.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/vpods/{podId}/vnodes"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<VNode>> fabricsIdVpodsPodIdVnodesGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="ID of the POD", required=true) @PathVariable(value="podId") String var2, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var3);

    @ApiOperation(value="Remove AVE from a list of Host", nickname="removeAvePost", notes="", response=Task.class, tags={"infra"})
    @ApiResponses(value={@ApiResponse(code=200, message="Task created for the operation", response=Task.class)})
    @RequestMapping(value={"/remove-ave"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> removeAvePost(@ApiParam(value="The deployment configuration", required=true) @Valid @RequestBody List<HostAveRemoveConfig> var1);
}

