/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.model.StartTaskData;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskOperation;
import com.cisco.aci.vcplugin.swagger.model.TaskSchedulingProfile;
import com.cisco.aci.vcplugin.swagger.model.TaskStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="Task", description="the Task API")
public interface TaskApi {
    @ApiOperation(value="Get the list of Tasks", nickname="tasksGet", notes="", response=Task.class, responseContainer="List", tags={"task"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of Taskss", response=Task.class, responseContainer="List")})
    @RequestMapping(value={"/tasks"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Task>> tasksGet(@ApiParam(value="Filter by task operation (NEW_AVE, REMOVE_AVE, CREATE_TENANT, ...)") @Valid @RequestParam(value="operations", required=false) List<TaskOperation> var1, @ApiParam(value="Filter by task entity") @Valid @RequestParam(value="entity", required=false) String var2, @ApiParam(value="Filter by the status status (RUNNING, FAILED, ...)") @Valid @RequestParam(value="status", required=false) List<TaskStatus> var3, @ApiParam(value="Filter task that are acknowledged or not") @Valid @RequestParam(value="acked", required=false) Boolean var4);

    @ApiOperation(value="Acknowledge a task", nickname="tasksIdAcknowledgePost", notes="", response=Task.class, tags={"task"})
    @ApiResponses(value={@ApiResponse(code=200, message="The acknowledged task", response=Task.class)})
    @RequestMapping(value={"/tasks/{id}/acknowledge"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> tasksIdAcknowledgePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1);

    @ApiOperation(value="Cancel a task", nickname="tasksIdCancelPost", notes="", response=Task.class, tags={"task"})
    @ApiResponses(value={@ApiResponse(code=200, message="The cancelled Task", response=Task.class)})
    @RequestMapping(value={"/tasks/{id}/cancel"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> tasksIdCancelPost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1);

    @ApiOperation(value="Get a Task", nickname="tasksIdGet", notes="", response=Task.class, tags={"task"})
    @ApiResponses(value={@ApiResponse(code=200, message="A Task", response=Task.class)})
    @RequestMapping(value={"/tasks/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Task> tasksIdGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1);

    @ApiOperation(value="Get the latest task for a given MO id", nickname="tasksMoIdLatestGet", notes="", response=Task.class, tags={"task"})
    @ApiResponses(value={@ApiResponse(code=200, message="The latest Task", response=Task.class)})
    @RequestMapping(value={"/tasks/mo/{id}/latest"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Task> tasksMoIdLatestGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1);

    @ApiOperation(value="API to start new tasks", nickname="tasksPost", notes="", tags={"task"})
    @ApiResponses(value={@ApiResponse(code=200, message="Task posted")})
    @RequestMapping(value={"/tasks"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> tasksPost(@ApiParam(value="The list of Tasks to start", required=true) @Valid @RequestBody List<StartTaskData> var1);

    @ApiOperation(value="Delete a task scheduling profile", nickname="tasksSchedulingProfilesNameDelete", notes="", tags={"task"})
    @ApiResponses(value={@ApiResponse(code=200, message="The task scheduling profile")})
    @RequestMapping(value={"/tasks/scheduling-profiles/{name}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> tasksSchedulingProfilesNameDelete(@ApiParam(value="Name", required=true) @PathVariable(value="name") String var1);

    @ApiOperation(value="Get the a task scheduling profile by name", nickname="tasksSchedulingProfilesNameGet", notes="", response=TaskSchedulingProfile.class, tags={"task"})
    @ApiResponses(value={@ApiResponse(code=200, message="The task scheduling profile", response=TaskSchedulingProfile.class), @ApiResponse(code=404, message="Not found")})
    @RequestMapping(value={"/tasks/scheduling-profiles/{name}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TaskSchedulingProfile> tasksSchedulingProfilesNameGet(@ApiParam(value="Name", required=true) @PathVariable(value="name") String var1);

    @ApiOperation(value="Create or Update a task scheduling profile", nickname="tasksSchedulingProfilesNamePost", notes="", response=TaskSchedulingProfile.class, tags={"task"})
    @ApiResponses(value={@ApiResponse(code=200, message="The task scheduling profile", response=TaskSchedulingProfile.class)})
    @RequestMapping(value={"/tasks/scheduling-profiles/{name}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<TaskSchedulingProfile> tasksSchedulingProfilesNamePost(@ApiParam(value="Name", required=true) @PathVariable(value="name") String var1, @ApiParam(value="The task scheduling profile", required=true) @Valid @RequestBody TaskSchedulingProfile var2);
}

