/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.api.TenantApi;
import com.cisco.aci.vcplugin.swagger.model.App;
import com.cisco.aci.vcplugin.swagger.model.Bd;
import com.cisco.aci.vcplugin.swagger.model.Contract;
import com.cisco.aci.vcplugin.swagger.model.Endpoint;
import com.cisco.aci.vcplugin.swagger.model.Epg;
import com.cisco.aci.vcplugin.swagger.model.Fault;
import com.cisco.aci.vcplugin.swagger.model.Filter;
import com.cisco.aci.vcplugin.swagger.model.SystemHealth;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.Tenant;
import com.cisco.aci.vcplugin.swagger.model.Vrf;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TenantApiController
implements TenantApi {
    private static final Logger log = LoggerFactory.getLogger(TenantApiController.class);
    private final ObjectMapper objectMapper;
    private final HttpServletRequest request;

    @Autowired
    public TenantApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    @Override
    public ResponseEntity<List<Fault>> fabricsIdFaultsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @NotNull @ApiParam(value="DN", required=true) @Valid @RequestParam(value="dn", required=true) String dn, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<App>> fabricsIdHealthAppGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Bd>> fabricsIdHealthBdGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Contract>> fabricsIdHealthContractGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Epg>> fabricsIdHealthEpgGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Filter>> fabricsIdHealthFilterGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<SystemHealth> fabricsIdHealthSystemGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("{  \"systemFaultsCount\" : \"\",  \"healthMax\" : 1,  \"healthAvg\" : 0,  \"healthMin\" : 6}", SystemHealth.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Vrf>> fabricsIdHealthVrfGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Tenant>> fabricsIdTenantsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNameEpgEpgNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the Application Profile under which epg exists", required=true) @PathVariable(value="appName") String appName, @ApiParam(value="Name of the epg to be deleted", required=true) @PathVariable(value="epgName") String epgName) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Endpoint>> fabricsIdTenantsTenantNameAppAppNameEpgEpgNameEndpointsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the Application Profile", required=true) @PathVariable(value="appName") String appName, @ApiParam(value="Name of the EPG", required=true) @PathVariable(value="epgName") String epgName, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNameEpgEpgNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the Application Profile under which epg has to be created", required=true) @PathVariable(value="appName") String appName, @ApiParam(value="Name of the epg to be created", required=true) @PathVariable(value="epgName") String epgName, @ApiParam(value="The Epg to be created", required=true) @Valid @RequestBody Epg epg) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameBdBdNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the BD to be deleted", required=true) @PathVariable(value="bdName") String bdName) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameBdBdNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the BD to be created", required=true) @PathVariable(value="bdName") String bdName, @ApiParam(value="The BD to be created", required=true) @Valid @RequestBody Bd bd) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Bd>> fabricsIdTenantsTenantNameBdsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue, @ApiParam(value="Include objects from common Tenant", defaultValue="false") @Valid @RequestParam(value="includeCommon", required=false, defaultValue="false") Boolean includeCommon) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameContractContractNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the contract to be deleted", required=true) @PathVariable(value="contractName") String contractName) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameContractContractNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant for the contract", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the contract", required=true) @PathVariable(value="contractName") String contractName, @ApiParam(value="The Contract to be created", required=true) @Valid @RequestBody Contract contract) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Contract>> fabricsIdTenantsTenantNameContractsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Epg>> fabricsIdTenantsTenantNameEpgsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue, @ApiParam(value="Include objects from common Tenant", defaultValue="false") @Valid @RequestParam(value="includeCommon", required=false, defaultValue="false") Boolean includeCommon) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameFilterFilterNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant under which filter is present", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the filter", required=true) @PathVariable(value="filterName") String filterName) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameFilterFilterNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the filter", required=true) @PathVariable(value="filterName") String filterName, @ApiParam(value="The Filter to be created", required=true) @Valid @RequestBody Filter filter) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Filter>> fabricsIdTenantsTenantNameFiltersGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue, @ApiParam(value="Include objects from common Tenant", defaultValue="false") @Valid @RequestParam(value="includeCommon", required=false, defaultValue="false") Boolean includeCommon) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="The tenant to be created", required=true) @Valid @RequestBody Tenant tenant) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameVrfVrfNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the VRF to be delete", required=true) @PathVariable(value="vrfName") String vrfName) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameVrfVrfNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Name of the VRF to be created", required=true) @PathVariable(value="vrfName") String vrfName, @ApiParam(value="The VRF to be created", required=true) @Valid @RequestBody Vrf vrf) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("\"\"", Task.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Override
    public ResponseEntity<List<Vrf>> fabricsIdTenantsTenantNameVrfsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String tenantName, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        String accept = this.request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity(this.objectMapper.readValue("[ \"\", \"\" ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            }
            catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

