/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.model.ContentLibraryItem;
import com.cisco.aci.vcplugin.swagger.model.Datacenter;
import com.cisco.aci.vcplugin.swagger.model.PortGroup;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.swagger.model.Version;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="Vcenter", description="the Vcenter API")
public interface VcenterApi {
    @ApiOperation(value="Get the list of vCenter servers", nickname="vcentersGet", notes="", response=Vcenter.class, responseContainer="List", tags={"vcenter"})
    @ApiResponses(value={@ApiResponse(code=200, message="The List of vCenters servers", response=Vcenter.class, responseContainer="List")})
    @RequestMapping(value={"/vcenters"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Vcenter>> vcentersGet(@ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var1);

    @ApiOperation(value="Get the list of AVE OVA uploaded to the content libraries", nickname="vcentersIdContentLibraryAveGet", notes="", response=ContentLibraryItem.class, responseContainer="List", tags={"vcenter"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of AVE Items on the content library", response=ContentLibraryItem.class, responseContainer="List")})
    @RequestMapping(value={"/vcenters/{id}/content-library/ave"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<ContentLibraryItem>> vcentersIdContentLibraryAveGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get vPOD OVAs uploaded to the content libraries", nickname="vcentersIdContentLibraryVpodGet", notes="", response=ContentLibraryItem.class, responseContainer="List", tags={"vcenter"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of vPOD Items in the content library", response=ContentLibraryItem.class, responseContainer="List")})
    @RequestMapping(value={"/vcenters/{id}/content-library/vpod"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<ContentLibraryItem>> vcentersIdContentLibraryVpodGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get all the Datacenters in a vCenter", nickname="vcentersIdDatacentersGet", notes="", response=Datacenter.class, responseContainer="List", tags={"vcenter"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of Datacenters", response=Datacenter.class, responseContainer="List")})
    @RequestMapping(value={"/vcenters/{id}/datacenters"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Datacenter>> vcentersIdDatacentersGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var2);

    @ApiOperation(value="Get the list of portgroup common to the Hosts & DVS passed as parameters", nickname="vcentersIdNetworkingCommonPgGet", notes="", response=PortGroup.class, responseContainer="List", tags={"vcenter"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of common portgroups", response=PortGroup.class, responseContainer="List")})
    @RequestMapping(value={"/vcenters/{id}/networking/common-pg"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<PortGroup>> vcentersIdNetworkingCommonPgGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @NotNull @ApiParam(value="List of Hosts OID", required=true) @Valid @RequestParam(value="hosts", required=true) List<String> var2, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var3, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var4, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var5, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String var6);

    @ApiOperation(value="Get version of current plugin", nickname="versionGet", notes="", response=Version.class, tags={"vcenter"})
    @ApiResponses(value={@ApiResponse(code=200, message="Version of current plugin", response=Version.class)})
    @RequestMapping(value={"/version"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Version> versionGet();
}

