/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
public class Certificate
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="publicKey")
    private String publicKey = null;
    @JsonProperty(value="privateKey")
    private String privateKey = null;
    @JsonProperty(value="file")
    private byte[] file = null;
    @JsonProperty(value="passphrase")
    private String passphrase = null;
    @JsonProperty(value="salt")
    private String salt = null;

    public Certificate type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Certificate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(min=1, max=64)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Certificate publicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public Certificate privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public Certificate file(byte[] file) {
        this.file = file;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$")
    public byte[] getFile() {
        return this.file;
    }

    public void setFile(byte[] file) {
        this.file = file;
    }

    public Certificate passphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public Certificate salt(String salt) {
        this.salt = salt;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Certificate certificate = (Certificate)o;
        return Objects.equals((Object)this.type, (Object)certificate.type) && Objects.equals(this.name, certificate.name) && Objects.equals(this.publicKey, certificate.publicKey) && Objects.equals(this.privateKey, certificate.privateKey) && Objects.equals(this.file, certificate.file) && Objects.equals(this.passphrase, certificate.passphrase) && Objects.equals(this.salt, certificate.salt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name, this.publicKey, this.privateKey, this.file, this.passphrase, this.salt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Certificate {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SELF_SIGNED("SELF_SIGNED"),
        CA_SIGNED("CA_SIGNED");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

