/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.App;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;

public class DeleteAppTask
extends ATask {
    private transient App _inputApp;
    private transient ApicSdk _sdk;

    public DeleteAppTask() {
        this.setName("Delete App");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("delete");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(App.class);
        this._inputApp = (App)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputApp.getFabricId());
        this.setProgress(20);
    }

    public void delete() throws AbortTaskException {
        String tenantName = this._inputApp.getParentTenant().getName();
        String appName = this._inputApp.getName();
        try {
            this._sdk.deleteApp(tenantName, appName);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

