/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task.engine;

import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.aci.vcplugin.task.engine.VCTaskSync;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import vim25.ManagedObjectReference;
import vim25.TaskInfo;
import vim25.TaskInfoState;

public abstract class AAciVToolTask
extends ATask {
    private transient VCenterSdk _vcHandle;
    private transient TaskInfo _taskInfo;
    private transient Log log = LogFactory.getLog(AAciVToolTask.class);

    public void startVCTask(VCenterSdk vcHandle, EsxHost esxHost, String taskId) throws AbortTaskException, InterruptedException {
        this._vcHandle = vcHandle;
        ManagedObjectReference hostMor = new ManagedObjectReference();
        hostMor.setType(esxHost.getVmwType());
        hostMor.setValue(esxHost.getOid());
        try {
            TaskInfo ti = vcHandle.createTask(hostMor, taskId, this.getInitiator(), false);
            vcHandle.setTaskState(ti, TaskInfoState.RUNNING);
            this._taskInfo = ti;
            this.log.info((Object)("created task " + ti.getTask().getValue() + " for host " + esxHost.getOid()));
            VCTaskSync vCTaskSync = new VCTaskSync(this, ti.getTask(), this.getProgressMessageMap(), vcHandle);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }

    public void handleAciVToolException(Exception e) throws AbortTaskException {
        String pythonError;
        e.printStackTrace();
        if (this._taskInfo != null && this._vcHandle != null) {
            try {
                this._vcHandle.setTaskState(this._taskInfo, TaskInfoState.ERROR);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if ((pythonError = e.getMessage()).contains("-> ")) {
            pythonError = pythonError.split(Pattern.quote("-> "))[1];
            StringUtils.capitalize((String)pythonError);
        }
        this.log.info((Object)("acivtool task failed with error:" + pythonError));
        this.failTask(pythonError);
    }

    public abstract Map<Integer, String> getProgressMessageMap();
}

