/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task.engine;

import com.cisco.aci.vcplugin.event.VcpObserver;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.api.NotFoundException;
import com.cisco.aci.vcplugin.swagger.model.EventType;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskSchedulingProfile;
import com.cisco.aci.vcplugin.swagger.model.TaskStatus;
import com.cisco.aci.vcplugin.task.engine.ATask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TaskScheduler
extends VcpObserver {
    protected VcpLogger log = new VcpLogger();
    List<ATask> _queuedTasks;
    List<ATask> _runningTasks = Collections.synchronizedList(new ArrayList());
    private int _concurrentTasks = 2;
    private Map<String, TaskSchedulingProfile> _schedulingProfiles;

    public TaskScheduler() {
        this._queuedTasks = Collections.synchronizedList(new ArrayList());
        this._schedulingProfiles = new ConcurrentHashMap<String, TaskSchedulingProfile>();
        TaskSchedulingProfile defaultSProfile = new TaskSchedulingProfile();
        defaultSProfile.setName("default");
        defaultSProfile.setMaxConcurrentTask(-1);
        this._schedulingProfiles.put("default", defaultSProfile);
    }

    public void scheduleTask(ATask t) {
        t.setStatus(TaskStatus.QUEUED);
        this._queuedTasks.add(t);
        this.addTaskToSchedulingProfile(t);
        this.doScheduling();
    }

    private void startTask(ATask t) {
        t.setStatus(TaskStatus.RUNNING);
        this.newEvent(EventType.MO_UPDATE, t.apis(), t.getAffectedMoTypes(), t);
        this._runningTasks.add(t);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doScheduling() {
        ArrayList<ATask> completedTask = new ArrayList<ATask>();
        for (ATask task : this._runningTasks) {
            if (task.getStatus() == TaskStatus.RUNNING) continue;
            this.log.info("task " + task.getId() + " status is " + task.getStatus().toString() + ", will be removed from running tasks");
            completedTask.add(task);
        }
        ArrayList<ATask> cancelledOrStartedTasks = new ArrayList<ATask>();
        List<ATask> list = this._queuedTasks;
        synchronized (list) {
            for (ATask task : this._queuedTasks) {
                if (task.getStatus() == TaskStatus.FAILED) {
                    this.log.info("task " + task.getId() + " is failed, will be removed from queued tasks");
                    cancelledOrStartedTasks.add(task);
                    continue;
                }
                if (!this.isReadyToStart(task)) continue;
                this.startTask(task);
                cancelledOrStartedTasks.add(task);
            }
        }
        if (completedTask.size() > 0) {
            this.log.info("clearing " + completedTask.size() + " task from running tasks");
            this._runningTasks.removeAll(completedTask);
        }
        if (cancelledOrStartedTasks.size() > 0) {
            this.log.info("clearing " + cancelledOrStartedTasks.size() + " task from queued tasks");
            this._queuedTasks.removeAll(cancelledOrStartedTasks);
        }
    }

    private boolean isReadyToStart(ATask t) {
        String profileName = this.getTaskSchedulingProfile(t);
        List activeProfileTasks = this._schedulingProfiles.get(profileName).getTasks().stream().filter(task -> task.getStatus() == TaskStatus.RUNNING).collect(Collectors.toList());
        return activeProfileTasks.size() < this._schedulingProfiles.get(profileName).getMaxConcurrentTask() || this._schedulingProfiles.get(profileName).getMaxConcurrentTask() == -1;
    }

    private void addTaskToSchedulingProfile(ATask t) {
        String profileName = this.getTaskSchedulingProfile(t);
        this._schedulingProfiles.get(profileName).addTasksItem(t);
    }

    private String getTaskSchedulingProfile(ATask t) {
        if (StringUtils.isEmpty((CharSequence)t.getSchedulingProfileName())) {
            return "default";
        }
        return t.getSchedulingProfileName();
    }

    public void addOrUpdateTaskSchedulingProfile(TaskSchedulingProfile profile) {
        if (this._schedulingProfiles.containsKey(profile.getName())) {
            TaskSchedulingProfile p = this._schedulingProfiles.get(profile.getName());
            p.setMaxConcurrentTask(profile.getMaxConcurrentTask());
        } else {
            profile.setTasks(new ArrayList<Task>());
            this._schedulingProfiles.put(profile.getName(), profile);
        }
        this.doScheduling();
    }

    public TaskSchedulingProfile getSchedulingProfile(String name) throws NotFoundException {
        if (!this._schedulingProfiles.containsKey(name)) {
            throw new NotFoundException(404, "The scheduling profile " + name + " doesn't exists");
        }
        return this._schedulingProfiles.get(name);
    }

    public boolean hasSchedulingProfile(String name) {
        return this._schedulingProfiles.containsKey(name);
    }

    public void deleteSchedulingProfile(String name) throws Exception {
        if (!this._schedulingProfiles.containsKey(name)) {
            throw new Exception("The scheduling profile " + name + " dosen't exist");
        }
        List<Task> tasks = this._schedulingProfiles.get(name).getTasks();
        if (tasks.size() == 0) {
            this.log.info("deleting scheduling profile " + name);
            this._schedulingProfiles.remove(name);
            return;
        }
        long activeTasks = tasks.stream().filter(t -> t.getStatus() == TaskStatus.QUEUED || t.getStatus() == TaskStatus.RUNNING).count();
        if (activeTasks > 0L) {
            throw new Exception("The scheduling profile " + name + " is still in use by active tasks, it cannot be deleted");
        }
        this.log.info("deleting scheduling profile " + name);
        this._schedulingProfiles.remove(name);
    }
}

