/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.websocket;

import com.cisco.aci.vcplugin.event.EventUtils;
import com.cisco.aci.vcplugin.event.VcpObserver;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.model.VcpEvent;
import com.cisco.aci.vcplugin.swagger.model.WsMessage;
import com.cisco.aci.vcplugin.swagger.model.WsMessageAction;
import com.cisco.aci.vcplugin.swagger.model.WsTicket;
import com.cisco.aci.vcplugin.websocket.WsSession;
import com.cisco.aci.vcplugin.websocket.WsSessionManager;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.SerializationUtils;

public class WsSessionManagerImpl
extends VcpObserver
implements WsSessionManager {
    private final int TICKET_VALIDITY_PERIOD_MS = 15000;
    private VcpLogger log = new VcpLogger();
    private List<WsTicket> _validTickets;
    private List<WsSession> _openedSessions;

    public WsSessionManagerImpl() {
        this.log.info("session manager is up");
        this._validTickets = new ArrayList<WsTicket>();
        this._openedSessions = new ArrayList<WsSession>();
    }

    @Override
    public boolean validateTicket(WsTicket ticket, WsSession session) {
        this.log.info("validating ticket: " + ticket);
        for (WsTicket t : this._validTickets) {
            if (!t.getId().equals(ticket.getId())) continue;
            long currentTime = new Timestamp(System.currentTimeMillis()).getTime();
            if (currentTime > t.getValidUntil()) {
                this.log.info("the ticket " + t.getId() + " has expired, refusing websocket auth");
                return false;
            }
            try {
                session.setUsername(t.getUser());
                return true;
            }
            catch (Exception e) {
                this.log.error("vc session is no longer valid, refusing websocket auth");
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishEvents(List<VcpEvent> events) {
        for (WsSession session : this._openedSessions) {
            this.log.info("publishing events to session " + session.getId() + ":" + events.size());
            ArrayList<VcpEvent> sessionReleventEvents = new ArrayList<VcpEvent>();
            Iterator<VcpEvent> iterator = events.iterator();
            while (iterator.hasNext()) {
                VcpEvent ev;
                VcpEvent vcpEvent = ev = iterator.next();
                synchronized (vcpEvent) {
                    Object emitter = ev.getEmitter();
                    ev.setEmitter(ev.getEmitter().getClass().getSimpleName());
                    VcpEvent e = (VcpEvent)SerializationUtils.clone((Serializable)ev);
                    ev.setEmitter(emitter);
                    if (EventUtils.isMoEvent(e)) {
                        for (String api : e.getAffectedApis()) {
                            if (!session.isSubscribeToApi(api)) continue;
                            this.log.info("adding to session relevent events:" + e.getId());
                            sessionReleventEvents.add(e);
                            break;
                        }
                    } else {
                        this.log.info("adding to session relevent events:" + e.getId());
                        sessionReleventEvents.add(e);
                    }
                }
            }
            if (sessionReleventEvents.size() <= 0) continue;
            try {
                WsMessage msg = new WsMessage();
                msg.setAction(WsMessageAction.EVENTS);
                msg.setData(sessionReleventEvents);
                session.send(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public WsTicket generateNewTicket(String username) {
        WsTicket ticket = new WsTicket();
        ticket.setId(UUID.randomUUID().toString());
        long validUntil = new Timestamp(System.currentTimeMillis()).getTime() + 15000L;
        ticket.setValidUntil(validUntil);
        ticket.setUser(username);
        this._validTickets.add(ticket);
        return ticket;
    }

    @Override
    public void addSession(WsSession session) {
        this.observe(session);
        this._openedSessions.add(session);
        this.log.info("session " + session.getId() + " added. Opened sessions: " + this._openedSessions);
    }

    @Override
    public void removeSession(WsSession session) {
        this.stopObserving(session);
        this._openedSessions.remove(session);
        this.log.info("session " + session.getId() + " removed. Opened sessions: " + this._openedSessions);
    }
}

