/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin;

import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.SortType;
import java.util.Comparator;

public final class ResultItemComparator
implements Comparator<ResultItem> {
    private final OrderingCriteria _orderingCriteria;

    public ResultItemComparator(OrderingCriteria orderingCriteria) {
        this._orderingCriteria = orderingCriteria;
        for (OrderingPropertySpec propSpec : this._orderingCriteria.orderingProperties) {
            for (int i = 0; i < propSpec.propertyNames.length; ++i) {
                if (!"id".equals(propSpec.propertyNames[i])) continue;
                propSpec.propertyNames[i] = "name";
            }
        }
    }

    @Override
    public int compare(ResultItem resItem1, ResultItem resItem2) {
        for (OrderingPropertySpec propSpec : this._orderingCriteria.orderingProperties) {
            boolean ascending = propSpec.orderingType == SortType.ASCENDING;
            for (String propName : propSpec.propertyNames) {
                PropertyValue prop2;
                PropertyValue prop1 = this.getPropertyValue(resItem1, propName);
                int comparisonValue = this.compareTo(prop1, prop2 = this.getPropertyValue(resItem2, propName), ascending);
                if (comparisonValue == 0) continue;
                return comparisonValue;
            }
        }
        return 0;
    }

    private int compareTo(PropertyValue prop1, PropertyValue prop2, boolean ascending) {
        int comparison;
        int compareResult = 0;
        if (prop1 == null || prop1.value == null || prop2 == null || prop2.value == null) {
            return compareResult;
        }
        Object val1 = prop1.value;
        Object val2 = prop2.value;
        compareResult = val1 instanceof String && val2 instanceof String ? ((String)val1).toLowerCase().compareTo(((String)val2).toLowerCase()) : (val1 instanceof Comparable ? (comparison = ((Comparable)val1).compareTo(val2)) : prop1.value.toString().compareToIgnoreCase(prop2.value.toString()));
        return ascending ? compareResult : -compareResult;
    }

    private PropertyValue getPropertyValue(ResultItem resultItem, String propName) {
        if (resultItem == null || resultItem.properties == null || propName == null || propName.length() == 0) {
            return null;
        }
        for (PropertyValue propValue : resultItem.properties) {
            if (!propValue.propertyName.equals(propName)) continue;
            return propValue;
        }
        return null;
    }
}

