/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.storage.PersistentSettings;
import com.cisco.aci.vcplugin.swagger.api.StorageApi;
import com.cisco.aci.vcplugin.swagger.model.StoredApicSettings;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class StorageApiController
implements StorageApi {
    private static final VcpLogger log = new VcpLogger();
    private final WrapperService _wrapper;
    private final HttpServletRequest _request;
    private static Map<String, PersistentSettings> _userSettings = new ConcurrentHashMap<String, PersistentSettings>();

    @Autowired
    public StorageApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper) {
        this._wrapper = wrapper;
        this._request = request;
    }

    @Override
    public ResponseEntity<List<StoredApicSettings>> storageApicsettingsGet(@Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        String vcUser = this._wrapper.getUsername();
        if (_userSettings.containsKey(vcUser)) {
            List<StoredApicSettings> apicSettings = _userSettings.get(vcUser).getApicSettings();
            return ResponseEntity.status((int)200).body(apicSettings);
        }
        try {
            PersistentSettings persistentSettings = new PersistentSettings(vcUser);
            _userSettings.put(vcUser, persistentSettings);
            List<StoredApicSettings> hostSettings = persistentSettings.getApicSettings();
            return ResponseEntity.status((int)200).body(hostSettings);
        }
        catch (IOException e) {
            log.error(e);
            return ResponseUtils.getErrorResponse(e.getMessage(), HttpStatus.UNAUTHORIZED);
        }
    }

    public static void updateApicSettings(String vcUser, String uuid, StoredApicSettings apicSettings) {
        try {
            _userSettings.putIfAbsent(vcUser, new PersistentSettings(vcUser));
            PersistentSettings settings = _userSettings.get(vcUser);
            settings.saveHostSettings(uuid, apicSettings);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static void removeApicSettings(String vcUser, String uuid) {
        try {
            PersistentSettings settings = _userSettings.get(vcUser);
            settings.removeHostSettings(uuid);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }
}

