/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.api.TaskApi;
import com.cisco.aci.vcplugin.swagger.model.StartTaskData;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskOperation;
import com.cisco.aci.vcplugin.swagger.model.TaskSchedulingProfile;
import com.cisco.aci.vcplugin.swagger.model.TaskStatus;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.TaskManager;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TaskApiController
implements TaskApi {
    private final WrapperService _wrapper;
    private final HttpServletRequest _request;
    private final TaskManager _taskManager;
    private final VcpLogger log = new VcpLogger();

    @Autowired
    public TaskApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper, @Qualifier(value="taskManager") TaskManager taskManager) {
        this._wrapper = wrapper;
        this._request = request;
        this._taskManager = taskManager;
    }

    @Override
    public ResponseEntity<List<Task>> tasksGet(@ApiParam(value="Task operation to filter on") @Valid @RequestParam(value="operations", required=false) List<TaskOperation> operations, @ApiParam(value="Task entity") @Valid @RequestParam(value="entity", required=false) String entity, @ApiParam(value="Task status") @Valid @RequestParam(value="status", required=false) List<TaskStatus> status, @ApiParam(value="Filter task that are acknowledged or not") @Valid @RequestParam(value="acked", required=false) Boolean acked) {
        List tasks = this._taskManager.getTasks().stream().filter(t -> {
            if (entity != null && entity != "" && !t.getEntities().stream().anyMatch(e -> entity.equals(e.getId()))) {
                return false;
            }
            if (operations != null && operations.size() > 0 && !operations.contains((Object)t.getOperation())) {
                return false;
            }
            if (status != null && status.size() > 0 && !status.contains((Object)t.getStatus())) {
                return false;
            }
            return acked == null || t.isAcknowledged() == acked;
        }).collect(Collectors.toList());
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(tasks);
    }

    @Override
    public ResponseEntity<Task> tasksIdAcknowledgePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        ATask task = this._taskManager.getTask(id);
        if (task == null) {
            return ResponseUtils.getErrorResponse("Task not found", HttpStatus.NOT_FOUND);
        }
        task.acknowledge();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)task);
    }

    @Override
    public ResponseEntity<Task> tasksIdCancelPost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        ATask task = this._taskManager.getTask(id);
        if (task == null) {
            return ResponseUtils.getErrorResponse("Task not found", HttpStatus.NOT_FOUND);
        }
        if (!task.isCancelable().booleanValue()) {
            return ResponseUtils.getErrorResponse("The task cannot be cancelled", HttpStatus.METHOD_NOT_ALLOWED);
        }
        task.cancel();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)task);
    }

    @Override
    public ResponseEntity<Task> tasksIdGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        ATask task = this._taskManager.getTask(id);
        if (task == null) {
            return ResponseUtils.getErrorResponse("Task not found", HttpStatus.NOT_FOUND);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)task);
    }

    @Override
    public ResponseEntity<Task> tasksMoIdLatestGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String id) {
        ATask task = this._taskManager.getMoLatestTask(id);
        if (task == null) {
            return ResponseUtils.getErrorResponse("Task not found", HttpStatus.NOT_FOUND);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)task);
    }

    public ResponseEntity tasksPost(@Valid @RequestBody List<StartTaskData> tasks) {
        this.log.info("received post");
        String user = this._wrapper.getUsername();
        for (StartTaskData data : tasks) {
            this._taskManager.newTask(TaskOperation.values()[data.getOperation().ordinal()], data.getInput(), user).schedule();
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @Override
    public ResponseEntity<Void> tasksSchedulingProfilesNameDelete(@ApiParam(value="name", required=true) @PathVariable(value="name") String name) {
        try {
            this._taskManager.getTaskScheduler().deleteSchedulingProfile(name);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<TaskSchedulingProfile> tasksSchedulingProfilesNameGet(@ApiParam(value="name", required=true) @PathVariable(value="name") String name) {
        try {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this._taskManager.getTaskScheduler().getSchedulingProfile(name));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<TaskSchedulingProfile> tasksSchedulingProfilesNamePost(@ApiParam(value="name", required=true) @PathVariable(value="name") String name, @Valid @RequestBody TaskSchedulingProfile taskSchedulingProfile) {
        this._taskManager.getTaskScheduler().addOrUpdateTaskSchedulingProfile(taskSchedulingProfile);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)taskSchedulingProfile);
    }
}

