/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.session.SessionManager;
import com.cisco.aci.vcplugin.swagger.api.WsApi;
import com.cisco.aci.vcplugin.swagger.model.WsTicket;
import com.cisco.aci.vcplugin.websocket.WsSessionManager;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;

@Controller
public class WsApiController
implements WsApi {
    private final WrapperService _wrapper;
    private final HttpServletRequest _request;
    private final WsSessionManager _wsSessionManager;
    private final SessionManager _sessionManager;
    private final VcpLogger log = new VcpLogger();

    @Autowired
    public WsApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper, @Qualifier(value="wsSessionManager") WsSessionManager wsSessionManager, @Qualifier(value="sessionManager") SessionManager sessionManager) {
        this._wrapper = wrapper;
        this._request = request;
        this._wsSessionManager = wsSessionManager;
        this._sessionManager = sessionManager;
    }

    @Override
    public ResponseEntity<WsTicket> wsTicketGet() {
        String user = this._sessionManager.getUsername();
        this.log.info("User " + user + " is requesting a new websocket auth ticket");
        this._sessionManager.loadSessionVCenters();
        WsTicket ticket = this._wsSessionManager.generateNewTicket(user);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)ticket);
    }
}

