/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.event;

import com.cisco.aci.vcplugin.event.EventManager;
import com.cisco.aci.vcplugin.event.Observer;
import com.cisco.aci.vcplugin.event.VcpObserver;
import com.cisco.aci.vcplugin.event.listener.EventListener;
import com.cisco.aci.vcplugin.event.listener.VCEventListener;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.session.SessionManager;
import com.cisco.aci.vcplugin.swagger.model.EventType;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.swagger.model.VcpEvent;
import com.cisco.aci.vcplugin.task.engine.TaskManager;
import com.cisco.aci.vcplugin.websocket.WsSession;
import com.cisco.aci.vcplugin.websocket.WsSessionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventManagerImpl
extends VcpObserver
implements EventManager,
Runnable {
    private final int BULKING_INTERVAL_MS = 1000;
    private final WsSessionManager _wsSessionManager;
    private final SessionManager _sessionManager;
    private final TaskManager _taskManager;
    private List<VcpEvent> _queuedEvents;
    private boolean _running;
    private Thread _eventProcessor;
    private Map<String, List<EventListener>> _usersListeners;
    private final VcpLogger log = new VcpLogger();

    public EventManagerImpl(WsSessionManager wssessionManager, TaskManager taskManager, SessionManager sessionManager) {
        this._wsSessionManager = wssessionManager;
        this._sessionManager = sessionManager;
        this._taskManager = taskManager;
        this.observe(this._taskManager);
        this.observe(this._wsSessionManager);
        this._eventProcessor = new Thread(this);
        this._running = true;
        this._eventProcessor.start();
        this.disableEventBubbling();
        this._queuedEvents = new ArrayList<VcpEvent>();
        this._usersListeners = new ConcurrentHashMap<String, List<EventListener>>();
        this.log.info("Event manager is up");
    }

    public void cleanup() {
        this._running = false;
        if (this._usersListeners.keySet().size() > 0) {
            for (String user : this._usersListeners.keySet()) {
                for (EventListener e : this._usersListeners.get(user)) {
                    if (!e.isRunning()) continue;
                    e.stop();
                }
            }
        }
        this._usersListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(Observer source, Object data) {
        super.onUpdate(source, data);
        if (data instanceof VcpEvent) {
            WsSession s;
            VcpEvent e = (VcpEvent)data;
            if (e.getEventType() == EventType.MO_ADD || e.getEventType() == EventType.MO_REMOVE || e.getEventType() == EventType.MO_UPDATE || e.getEventType() == EventType.REFRESH) {
                List<VcpEvent> list = this._queuedEvents;
                synchronized (list) {
                    this.log.info("queuing event of type: " + e.getEventType().toString());
                    this._queuedEvents.add(e);
                }
            }
            if (e.getEventType() == EventType.API_SUBSCRIBE && e.getEmitter() instanceof WsSession) {
                this.log.info("event manager got subscription request for apis " + e.getAffectedApis());
                s = (WsSession)e.getEmitter();
                this.addToEventListener(s.getUsername(), e.getAffectedApis());
            }
            if (e.getEventType() == EventType.API_UNSUBSCRIBE && e.getEmitter() instanceof WsSession) {
                this.log.info("event manager got unsubscription request for apis " + e.getAffectedApis());
                s = (WsSession)e.getEmitter();
                this.removeFromEventListener(s.getUsername(), e.getAffectedApis());
            }
        }
    }

    public void addToEventListener(String username, List<String> apis) {
        if (!this._usersListeners.containsKey(username)) {
            ArrayList<VCEventListener> listeners = new ArrayList<VCEventListener>();
            for (Vcenter vc : this._sessionManager.getSessionVcenters(username)) {
                VCEventListener vclistener = new VCEventListener(username);
                this.log.info("intializing listener for vc: " + vc.getGuid());
                vclistener.initHandle(vc);
                this.observe(vclistener);
                listeners.add(vclistener);
            }
            this._usersListeners.put(username, listeners);
        }
        for (EventListener listener : this._usersListeners.get(username)) {
            for (String api : apis) {
                listener.addApi(api);
            }
        }
    }

    public void removeFromEventListener(String username, List<String> apis) {
        if (!this._usersListeners.containsKey(username)) {
            return;
        }
        for (EventListener listener : this._usersListeners.get(username)) {
            for (String api : apis) {
                listener.removeApi(api);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info("event manager thread is running");
        while (this._running) {
            List<VcpEvent> list = this._queuedEvents;
            synchronized (list) {
                if (this._queuedEvents.size() > 0) {
                    this.processQueuedEvents();
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.log.info("event manager thread is stopping");
    }

    public synchronized void processQueuedEvents() {
        this.log.info("processing " + this._queuedEvents.size() + " queued events");
        this._wsSessionManager.publishEvents(this._queuedEvents);
        this._queuedEvents.clear();
    }
}

