/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.event.listener;

import com.cisco.aci.vcplugin.event.listener.EventListener;
import com.cisco.aci.vcplugin.handles.ApiSpecUtil;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import com.cisco.aci.vcplugin.swagger.model.EventType;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import vim25.ArrayOfEvent;
import vim25.Event;
import vim25.EventFilterSpec;
import vim25.EventFilterSpecByEntity;
import vim25.EventFilterSpecRecursionOption;
import vim25.HostEventArgument;
import vim25.ManagedObjectReference;
import vim25.ObjectSpec;
import vim25.ObjectUpdate;
import vim25.PropertyChange;
import vim25.PropertyChangeOp;
import vim25.PropertyFilterSpec;
import vim25.PropertyFilterUpdate;
import vim25.PropertySpec;
import vim25.ServiceContent;
import vim25.TaskEvent;
import vim25.UpdateSet;
import vim25.WaitOptions;

public class VCEventListener
extends EventListener {
    private volatile VcpLogger log = new VcpLogger();
    private volatile VCenterSdk _handle;
    private volatile Vcenter _vcInfo;
    private volatile ManagedObjectReference _rootFolder;
    private volatile ServiceContent _serviceContent;
    private volatile ManagedObjectReference _eventManager;
    private volatile ManagedObjectReference _eventHistoryCollector;
    private volatile ManagedObjectReference _propFilter;
    private volatile ManagedObjectReference _propColl;
    private volatile String _updateVersion = "";
    private volatile String[] MONITORED_EVENTS = new String[]{"VmPoweredOffEvent", "VmPoweredOnEvent", "VmSuspendedEvent", "VmRenamedEvent", "EnteredMaintenanceModeEvent", "EnteringMaintenanceModeEvent", "ExitMaintenanceModeEvent", "HostAddedEvent", "HostRemovedEvent", "MoveHostInto_Task", "TaskEvent"};
    private volatile List<Integer> _seenEvents = new ArrayList<Integer>();

    public VCEventListener(String username) {
        super(username);
    }

    public synchronized void initHandle(Vcenter vcInfo) {
        this._vcInfo = vcInfo;
        this.log.info("vcInfo used for init:" + this._vcInfo.getGuid());
        try {
            this._handle = new VCenterSdk(this._username, this._vcInfo);
            this._handle.connectVIM();
            this._serviceContent = this._handle.getVim().getServiceContent();
            this._eventManager = this._serviceContent.getEventManager();
            this._rootFolder = this._serviceContent.getRootFolder();
            this._eventHistoryCollector = this.createEventHistoryCollector(this.MONITORED_EVENTS);
            PropertyFilterSpec eventFilterSpec = this.createEventFilterSpec();
            this._propColl = this._serviceContent.getPropertyCollector();
            this._propFilter = this._handle.getVim().getStub().createFilter(this._propColl, eventFilterSpec, false);
            this._initialized = true;
            if (this._apis.size() > 0 && !this.isRunning()) {
                this.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.info("failed to verify handle, not starting/stopping the event listener: " + e.getMessage());
            if (this.isRunning()) {
                this.stop();
            }
            return;
        }
    }

    private synchronized ManagedObjectReference createEventHistoryCollector(String[] events) throws Exception {
        EventFilterSpecByEntity entitySpec = new EventFilterSpecByEntity();
        entitySpec.setEntity(this._rootFolder);
        entitySpec.setRecursion(EventFilterSpecRecursionOption.CHILDREN);
        EventFilterSpec eventFilter = new EventFilterSpec();
        eventFilter.setEntity(entitySpec);
        for (String event : events) {
            eventFilter.getType().add(event);
        }
        return this._handle.getVim().getStub().createCollectorForEvents(this._eventManager, eventFilter);
    }

    private synchronized PropertyFilterSpec createEventFilterSpec() {
        PropertySpec propSpec = new PropertySpec();
        propSpec.setAll(new Boolean(false));
        propSpec.getPathSet().add("latestPage");
        propSpec.setType(this._eventHistoryCollector.getType());
        ObjectSpec objSpec = new ObjectSpec();
        objSpec.setObj(this._eventHistoryCollector);
        objSpec.setSkip(new Boolean(false));
        PropertyFilterSpec spec = new PropertyFilterSpec();
        spec.getPropSet().add(propSpec);
        spec.getObjectSet().add(objSpec);
        return spec;
    }

    @Override
    public synchronized void doEventProcessing() {
        try {
            WaitOptions opts = new WaitOptions();
            opts.setMaxWaitSeconds(Integer.valueOf(this.THREAD_SLEEP));
            UpdateSet update = this._handle.getVim().getStub().waitForUpdatesEx(this._propColl, this._updateVersion, opts);
            if (update != null && update.getFilterSet() != null) {
                this.handleUpdate(update);
                this._updateVersion = update.getVersion();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this._initialized = false;
            this.log.error("An exeception occurred during event processing, stopping the thread. Error:" + e.getMessage());
            this.stop();
        }
    }

    void handleUpdate(UpdateSet update) {
        List pfus = update.getFilterSet();
        for (int pfui = 0; pfui < pfus.size(); ++pfui) {
            List vmUpdates = ((PropertyFilterUpdate)pfus.get(pfui)).getObjectSet();
            for (ObjectUpdate vmi : vmUpdates) {
                List pc = vmi.getChangeSet();
                this.handleChanges(pc);
            }
        }
    }

    void handleChanges(List<PropertyChange> changes) {
        if (changes != null) {
            for (int pci = 0; pci < changes.size(); ++pci) {
                Event anEvent;
                String name = changes.get(pci).getName();
                Object value = changes.get(pci).getVal();
                PropertyChangeOp op = changes.get(pci).getOp();
                if (value == null) continue;
                if (value instanceof ArrayOfEvent) {
                    ArrayOfEvent aoe = (ArrayOfEvent)value;
                    List evts = aoe.getEvent();
                    if (evts == null) continue;
                    for (int evtID = 0; evtID < evts.size(); ++evtID) {
                        Event anEvent2 = (Event)evts.get(evtID);
                        if (this._seenEvents.contains(anEvent2.getKey())) continue;
                        this._seenEvents.add(anEvent2.getKey());
                        if ("".equals(this._updateVersion)) continue;
                        this.onEvent(anEvent2);
                    }
                    continue;
                }
                if (!(value instanceof Event) || this._seenEvents.contains((anEvent = (Event)value).getKey())) continue;
                this._seenEvents.add(anEvent.getKey());
                if ("".equals(this._updateVersion)) continue;
                this.onEvent(anEvent);
            }
        }
    }

    void onEvent(Event e) {
        this.logEvent(e);
        ManagedObjectReference mor = null;
        HostEventArgument hostE = e.getHost();
        if (hostE != null) {
            mor = hostE.getHost();
        } else if (e instanceof TaskEvent) {
            TaskEvent te = (TaskEvent)e;
            mor = te.getInfo().getEntity();
        }
        if (mor != null && "HostSystem".equals(mor.getType())) {
            try {
                EsxHost host = this._handle.getEsxHosts(ApiSpecUtil.moIdSpec(mor.getValue())).get(0);
                String dcOid = this._handle.getHostDatacenter(host.getOid());
                String[] apis = new String[]{"/vcenter/" + this._vcInfo.getGuid() + "/compute/hosts?datacenter=" + dcOid + "&include=ave", "/vcenter/" + this._vcInfo.getGuid() + "/compute/hosts?datacenter=" + dcOid, "/vcenter/" + this._vcInfo.getGuid() + "/compute/hosts/" + host.getOid()};
                this.newEvent(EventType.MO_UPDATE, apis, null, host);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void logEvent(Event e) {
        this.log.info("\n----------\n Event ID: " + e.getKey() + "\n Event: " + e.getClass().getName() + "\n FullFormattedMessage: " + e.getFullFormattedMessage() + "\n ToString: " + new Gson().toJson((Object)e) + "\n----------\n");
    }
}

