/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.model.App;
import com.cisco.aci.vcplugin.swagger.model.Task;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="App", description="the App API")
public interface AppApi {
    @ApiOperation(value="Delete a Application Profile", nickname="fabricsIdTenantsTenantNameAppAppNameDelete", notes="", response=Task.class, tags={"app"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for deleting Application Profile", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/app/{appName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNameDelete(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the App to be created", required=true) @PathVariable(value="appName") String var3);

    @ApiOperation(value="Create a new Application Profile", nickname="fabricsIdTenantsTenantNameAppAppNamePost", notes="", response=Task.class, tags={"app"})
    @ApiResponses(value={@ApiResponse(code=201, message="The task created for Application Profile Creation", response=Task.class)})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/app/{appName}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNamePost(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Name of the App to be created", required=true) @PathVariable(value="appName") String var3, @ApiParam(value="The Application Profile to be created", required=true) @Valid @RequestBody App var4);

    @ApiOperation(value="Get a list of Application Profiles under this tenant", nickname="fabricsIdTenantsTenantNameAppsGet", notes="", response=App.class, responseContainer="List", tags={"app"})
    @ApiResponses(value={@ApiResponse(code=200, message="List of Application Profiles under this Tenant", response=App.class, responseContainer="List")})
    @RequestMapping(value={"/fabrics/{id}/tenants/{tenantName}/apps"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<App>> fabricsIdTenantsTenantNameAppsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="Name of the tenant", required=true) @PathVariable(value="tenantName") String var2, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var3, @ApiParam(value="The page number", defaultValue="-1") @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer var4, @ApiParam(value="The amount of MOs to return per page", defaultValue="10") @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer var5, @ApiParam(value="The property value to filter for", defaultValue="") @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String var6);
}

