/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.api;

import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="Compute", description="the Compute API")
public interface ComputeApi {
    @ApiOperation(value="Get all Hosts in the vCenter", nickname="vcenterIdComputeHostsGet", notes="", response=EsxHost.class, responseContainer="List", tags={"compute"})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of ESX Hosts", response=EsxHost.class, responseContainer="List")})
    @RequestMapping(value={"/vcenter/{id}/compute/hosts"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<EsxHost>> vcenterIdComputeHostsGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="IDs of object to query") @Valid @RequestParam(value="ids", required=false) List<String> var2, @ApiParam(value="Filter based on VMM domain") @Valid @RequestParam(value="domain", required=false) String var3, @ApiParam(value="Filter based on Datacenter") @Valid @RequestParam(value="datacenter", required=false) String var4, @ApiParam(value="Properties to includes", allowableValues="ave, datastore") @Valid @RequestParam(value="include", required=false) List<String> var5, @ApiParam(value="Return only the total count of object that would have been returned", defaultValue="false") @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean var6);

    @ApiOperation(value="Get an ESX Host", nickname="vcentersIdComputeHostsHostOidGet", notes="", response=EsxHost.class, tags={"compute"})
    @ApiResponses(value={@ApiResponse(code=200, message="The ESX Host", response=EsxHost.class)})
    @RequestMapping(value={"/vcenters/{id}/compute/hosts/{hostOid}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<EsxHost> vcentersIdComputeHostsHostOidGet(@ApiParam(value="ID", required=true) @PathVariable(value="id") String var1, @ApiParam(value="OID of the ESX", required=true) @PathVariable(value="hostOid") String var2, @ApiParam(value="Properties to includes", allowableValues="ave, datastore") @Valid @RequestParam(value="include", required=false) List<String> var3);
}

