/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.swagger.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.threetenbp.DateTimeUtils;
import com.fasterxml.jackson.datatype.threetenbp.DecimalUtils;
import com.fasterxml.jackson.datatype.threetenbp.deser.ThreeTenDateTimeDeserializerBase;
import com.fasterxml.jackson.datatype.threetenbp.function.BiFunction;
import com.fasterxml.jackson.datatype.threetenbp.function.Function;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.TimeZone;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;

public class CustomInstantDeserializer<T extends Temporal>
extends ThreeTenDateTimeDeserializerBase<T> {
    private static final long serialVersionUID = 1L;
    public static final CustomInstantDeserializer<Instant> INSTANT = new CustomInstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, new Function<TemporalAccessor, Instant>(){

        public Instant apply(TemporalAccessor temporalAccessor) {
            return Instant.from((TemporalAccessor)temporalAccessor);
        }
    }, new Function<FromIntegerArguments, Instant>(){

        public Instant apply(FromIntegerArguments a) {
            return Instant.ofEpochMilli((long)a.value);
        }
    }, new Function<FromDecimalArguments, Instant>(){

        public Instant apply(FromDecimalArguments a) {
            return Instant.ofEpochSecond((long)a.integer, (long)a.fraction);
        }
    }, null);
    public static final CustomInstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new CustomInstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, new Function<TemporalAccessor, OffsetDateTime>(){

        public OffsetDateTime apply(TemporalAccessor temporalAccessor) {
            return OffsetDateTime.from((TemporalAccessor)temporalAccessor);
        }
    }, new Function<FromIntegerArguments, OffsetDateTime>(){

        public OffsetDateTime apply(FromIntegerArguments a) {
            return OffsetDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)a.value), (ZoneId)a.zoneId);
        }
    }, new Function<FromDecimalArguments, OffsetDateTime>(){

        public OffsetDateTime apply(FromDecimalArguments a) {
            return OffsetDateTime.ofInstant((Instant)Instant.ofEpochSecond((long)a.integer, (long)a.fraction), (ZoneId)a.zoneId);
        }
    }, new BiFunction<OffsetDateTime, ZoneId, OffsetDateTime>(){

        public OffsetDateTime apply(OffsetDateTime d, ZoneId z) {
            return d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime()));
        }
    });
    public static final CustomInstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new CustomInstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, new Function<TemporalAccessor, ZonedDateTime>(){

        public ZonedDateTime apply(TemporalAccessor temporalAccessor) {
            return ZonedDateTime.from((TemporalAccessor)temporalAccessor);
        }
    }, new Function<FromIntegerArguments, ZonedDateTime>(){

        public ZonedDateTime apply(FromIntegerArguments a) {
            return ZonedDateTime.ofInstant((Instant)Instant.ofEpochMilli((long)a.value), (ZoneId)a.zoneId);
        }
    }, new Function<FromDecimalArguments, ZonedDateTime>(){

        public ZonedDateTime apply(FromDecimalArguments a) {
            return ZonedDateTime.ofInstant((Instant)Instant.ofEpochSecond((long)a.integer, (long)a.fraction), (ZoneId)a.zoneId);
        }
    }, new BiFunction<ZonedDateTime, ZoneId, ZonedDateTime>(){

        public ZonedDateTime apply(ZonedDateTime zonedDateTime, ZoneId zoneId) {
            return zonedDateTime.withZoneSameInstant(zoneId);
        }
    });
    protected final Function<FromIntegerArguments, T> fromMilliseconds;
    protected final Function<FromDecimalArguments, T> fromNanoseconds;
    protected final Function<TemporalAccessor, T> parsedToValue;
    protected final BiFunction<T, ZoneId, T> adjust;

    protected CustomInstantDeserializer(Class<T> supportedType, DateTimeFormatter parser, Function<TemporalAccessor, T> parsedToValue, Function<FromIntegerArguments, T> fromMilliseconds, Function<FromDecimalArguments, T> fromNanoseconds, BiFunction<T, ZoneId, T> adjust) {
        super(supportedType, parser);
        this.parsedToValue = parsedToValue;
        this.fromMilliseconds = fromMilliseconds;
        this.fromNanoseconds = fromNanoseconds;
        this.adjust = adjust == null ? new BiFunction<T, ZoneId, T>(){

            public T apply(T t, ZoneId zoneId) {
                return t;
            }
        } : adjust;
    }

    protected CustomInstantDeserializer(CustomInstantDeserializer<T> base, DateTimeFormatter f) {
        super(base.handledType(), f);
        this.parsedToValue = base.parsedToValue;
        this.fromMilliseconds = base.fromMilliseconds;
        this.fromNanoseconds = base.fromNanoseconds;
        this.adjust = base.adjust;
    }

    protected JsonDeserializer<T> withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        return new CustomInstantDeserializer<T>(this, dtf);
    }

    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.getCurrentTokenId()) {
            case 8: {
                BigDecimal value = parser.getDecimalValue();
                long seconds = value.longValue();
                int nanoseconds = DecimalUtils.extractNanosecondDecimal((BigDecimal)value, (long)seconds);
                return (T)((Temporal)this.fromNanoseconds.apply((Object)new FromDecimalArguments(seconds, nanoseconds, this.getZone(context))));
            }
            case 7: {
                long timestamp = parser.getLongValue();
                if (context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                    return (T)((Temporal)this.fromNanoseconds.apply((Object)new FromDecimalArguments(timestamp, 0, this.getZone(context))));
                }
                return (T)((Temporal)this.fromMilliseconds.apply((Object)new FromIntegerArguments(timestamp, this.getZone(context))));
            }
            case 6: {
                Temporal value;
                String string = parser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                if (string.endsWith("+0000")) {
                    string = string.substring(0, string.length() - 5) + "Z";
                }
                try {
                    TemporalAccessor acc = this._formatter.parse((CharSequence)string);
                    value = (Temporal)this.parsedToValue.apply((Object)acc);
                    if (context.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE)) {
                        return (T)((Temporal)this.adjust.apply((Object)value, (Object)this.getZone(context)));
                    }
                }
                catch (DateTimeException e) {
                    throw this._peelDTE(e);
                }
                return (T)value;
            }
        }
        throw context.mappingException("Expected type float, integer, or string.");
    }

    private ZoneId getZone(DeserializationContext context) {
        return this._valueClass == Instant.class ? null : DateTimeUtils.timeZoneToZoneId((TimeZone)context.getTimeZone());
    }

    private static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        private FromDecimalArguments(long integer, int fraction, ZoneId zoneId) {
            this.integer = integer;
            this.fraction = fraction;
            this.zoneId = zoneId;
        }
    }

    private static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        private FromIntegerArguments(long value, ZoneId zoneId) {
            this.value = value;
            this.zoneId = zoneId;
        }
    }
}

