/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Epg;
import com.cisco.aci.vcplugin.swagger.model.EpgDomainSettings;
import com.cisco.aci.vcplugin.swagger.model.USegCriterion;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import java.util.List;

public class CreateEpgTask
extends ATask {
    private transient Epg _inputEpg;
    private transient ApicSdk _sdk;

    public CreateEpgTask() {
        this.setName("Create EPG");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("create");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Epg.class);
        this._inputEpg = (Epg)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputEpg.getFabricId());
        this.setProgress(20);
    }

    public void create() throws AbortTaskException {
        String epgName = this._inputEpg.getName();
        String epgDescr = this._inputEpg.getDescr();
        List<EpgDomainSettings> epgDomainSettingsList = this._inputEpg.getEpgDomainSettings();
        String bdName = this._inputEpg.getBd() == null ? null : this._inputEpg.getBd().getName();
        String tenantName = this._inputEpg.getParentTenant().getName();
        String appName = this._inputEpg.getParentApp().getName();
        boolean useSharedBd = this._inputEpg.isUseSharedBd();
        boolean isIntraIsolated = this._inputEpg.isIsIntraIsolated();
        USegCriterion uSegCriterion = this._inputEpg.getUSegCriterion();
        boolean createOnly = this._inputEpg.isCreateOnly();
        String username = this.getInitiator();
        try {
            this._sdk.createEpg(epgName, epgDescr, tenantName, appName, epgDomainSettingsList, useSharedBd, bdName, isIntraIsolated, uSegCriterion, createOnly, username);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

