/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Vrf;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;

public class CreateVrfTask
extends ATask {
    private transient Vrf _inputVrf;
    private transient ApicSdk _sdk;

    public CreateVrfTask() {
        this.setName("Create VRF");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("create");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Vrf.class);
        this._inputVrf = (Vrf)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputVrf.getFabricId());
        this.setProgress(20);
    }

    public void create() throws AbortTaskException {
        String vrfName = this._inputVrf.getName();
        String description = this._inputVrf.getDescr();
        String tenantName = this._inputVrf.getParentTenant().getName();
        String policyEnforcePreference = this._inputVrf.getPcEnfPref();
        boolean createOnly = this._inputVrf.isCreateOnly();
        try {
            this._sdk.createVrf(vrfName, description, tenantName, policyEnforcePreference, createOnly);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

