/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.swagger.model.Epg;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.apic.util.ApicMoOperationException;

public class DeleteEpgTask
extends ATask {
    private transient Epg _inputEpg;
    private transient ApicSdk _sdk;

    public DeleteEpgTask() {
        this.setName("Delete EPG");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("delete");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(Epg.class);
        this._inputEpg = (Epg)this.getInput();
        this._sdk = AaaApiController.getApicHandle(this.getInitiator(), this._inputEpg.getFabricId());
        this.setProgress(20);
    }

    public void delete() throws AbortTaskException {
        String epgName = this._inputEpg.getName();
        String tenantName = this._inputEpg.getParentTenant().getName();
        String appName = this._inputEpg.getParentApp().getName();
        try {
            this._sdk.deleteEpg(tenantName, appName, epgName);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            this.failTask(e.getMessage());
        }
    }
}

