/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task;

import com.cisco.aci.vcplugin.Constants;
import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.storage.PersistentSettings;
import com.cisco.aci.vcplugin.swagger.model.EsxHost;
import com.cisco.aci.vcplugin.swagger.model.PortGroup;
import com.cisco.aci.vcplugin.swagger.model.VPodHostConfig;
import com.cisco.aci.vcplugin.task.engine.AAciVToolTask;
import com.cisco.aci.vcplugin.task.engine.AbortTaskException;
import com.cisco.aciPluginServices.acivtool.AciVTool;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class NewVPodTask
extends AAciVToolTask {
    private VPodHostConfig _taskConfig;
    private transient VCenterSdk _vcHandle;
    private transient EsxHost _esxHost;

    public NewVPodTask() {
        this.setName("New VPod");
        this.setCancelable(true);
        this.addStage("validate");
        this.addStage("deployVPod");
    }

    public void validate() throws AbortTaskException {
        this.validateInput(VPodHostConfig.class);
        this._taskConfig = (VPodHostConfig)this.getInput();
        this._esxHost = this._taskConfig.getHost();
        this.addEntity(this._taskConfig.getPod());
        this._vcHandle = AaaApiController.getVCHandle(this.getInitiator(), this._esxHost.getVcId());
        if (this._vcHandle == null) {
            this.failTask("Failed to get the vCenter handle");
        }
    }

    public void deployVPod() throws AbortTaskException, InterruptedException {
        this.log.info("deploying vpod");
        this.startVCTask(this._vcHandle, this._esxHost, "com.cisco.aci.avs.tasks.vpod.deploy");
        try {
            AciVTool vtool = new AciVTool(PersistentSettings.getSettingsFileFolder(), Constants.JAR_PATH, Constants.PLUGIN_VERSION);
            this.log.info("Using AciVTool version : " + Constants.PLUGIN_VERSION);
            URI vcURL = new URI(this._vcHandle.getVcenterInfo().getUrl());
            vtool.setCredentialAuth(vcURL.getHost(), this._vcHandle.getUsername(), this._vcHandle.getPassword());
            this.updateProgress(2);
            vtool.VPodNew(this._esxHost.getName(), this.getMgmtPortgroup(), this.getInfraPortgroup(), "passphrase", this._taskConfig.getPassphrase(), this._taskConfig.getClItem().getItemName(), this._taskConfig.getPod().getId(), this._taskConfig.getClItem().getLibraryName(), this.getDatastore(), this._taskConfig.getSpineSerial(), this._taskConfig.getLeafSerial(), this._taskConfig.getSpineId(), this._taskConfig.getLeafId());
        }
        catch (Exception e) {
            this.handleAciVToolException(e);
        }
    }

    private String getMgmtPortgroup() {
        PortGroup pg = this._taskConfig.getMgmtPg();
        if (pg.isDistributed().booleanValue()) {
            return pg.getDvs().getName() + "/" + pg.getName();
        }
        return pg.getName();
    }

    private String getInfraPortgroup() {
        PortGroup pg = this._taskConfig.getInfraPg();
        if (pg.isDistributed().booleanValue()) {
            return pg.getDvs().getName() + "/" + pg.getName();
        }
        return pg.getName();
    }

    private String getDatastore() {
        return this._taskConfig.getDatastore() != null ? this._taskConfig.getDatastore().getName() : null;
    }

    @Override
    public Map<Integer, String> getProgressMessageMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(2, "Validating configuration");
        map.put(8, "Checking current vPOD status");
        map.put(10, "Validating OVF");
        map.put(16, "Building OVF configuration");
        map.put(20, "Deploying vSpine and vLeaf");
        map.put(70, "Applying cluster configuration");
        map.put(75, "Applying Tags");
        map.put(80, "Applying VM configuration");
        map.put(90, "Applying Host configuration");
        map.put(92, "Powering on the vPOD virtual machines");
        map.put(95, "Deployment successful");
        return map;
    }
}

