/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.task.engine;

import com.cisco.aci.vcplugin.event.Observer;
import com.cisco.aci.vcplugin.event.VcpObserver;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.model.EventType;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskOperation;
import com.cisco.aci.vcplugin.swagger.model.TaskStatus;
import com.cisco.aci.vcplugin.swagger.model.VcpEvent;
import com.cisco.aci.vcplugin.task.AuthVCTask;
import com.cisco.aci.vcplugin.task.CreateAppTask;
import com.cisco.aci.vcplugin.task.CreateBdTask;
import com.cisco.aci.vcplugin.task.CreateContractTask;
import com.cisco.aci.vcplugin.task.CreateEpgTask;
import com.cisco.aci.vcplugin.task.CreateFilterTask;
import com.cisco.aci.vcplugin.task.CreateTenantTask;
import com.cisco.aci.vcplugin.task.CreateVrfTask;
import com.cisco.aci.vcplugin.task.DeleteAppTask;
import com.cisco.aci.vcplugin.task.DeleteBdTask;
import com.cisco.aci.vcplugin.task.DeleteContractTask;
import com.cisco.aci.vcplugin.task.DeleteEpgTask;
import com.cisco.aci.vcplugin.task.DeleteFilterTask;
import com.cisco.aci.vcplugin.task.DeleteTenantTask;
import com.cisco.aci.vcplugin.task.DeleteVrfTask;
import com.cisco.aci.vcplugin.task.MockTask;
import com.cisco.aci.vcplugin.task.NewAveTask;
import com.cisco.aci.vcplugin.task.NewVPodTask;
import com.cisco.aci.vcplugin.task.RegisterFabricTask;
import com.cisco.aci.vcplugin.task.RemoveAveTask;
import com.cisco.aci.vcplugin.task.RemoveVPodTask;
import com.cisco.aci.vcplugin.task.UnregisterFabricTask;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.TaskManager;
import com.cisco.aci.vcplugin.task.engine.TaskScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class TaskManagerImpl
extends VcpObserver
implements TaskManager {
    public transient Map<String, ATask> _taskMap;
    public transient TaskScheduler _scheduler;
    private final transient VcpLogger log = new VcpLogger();
    private transient Map<String, ATask> _moLatestTaskMap;

    public TaskManagerImpl() {
        this._taskMap = new ConcurrentHashMap<String, ATask>();
        this._scheduler = new TaskScheduler();
        this.observe(this._scheduler);
        this._moLatestTaskMap = new ConcurrentHashMap<String, ATask>();
        this.log.info("task manager is up");
    }

    @Override
    public void cleanup() {
    }

    @Override
    public ATask newTask(TaskOperation operation, Object input, String initiator) {
        ATask task = null;
        if (operation == TaskOperation.REGISTER_FABRIC) {
            task = new RegisterFabricTask();
        }
        if (operation == TaskOperation.UNREGISTER_FABRIC) {
            task = new UnregisterFabricTask();
        }
        if (operation == TaskOperation.NEW_AVE) {
            task = new NewAveTask();
        }
        if (operation == TaskOperation.REMOVE_AVE) {
            task = new RemoveAveTask();
        }
        if (operation == TaskOperation.AUTH_VC) {
            task = new AuthVCTask();
        }
        if (operation == TaskOperation.CREATE_TENANT) {
            task = new CreateTenantTask();
        }
        if (operation == TaskOperation.DELETE_TENANT) {
            task = new DeleteTenantTask();
        }
        if (operation == TaskOperation.CREATE_APP) {
            task = new CreateAppTask();
        }
        if (operation == TaskOperation.DELETE_APP) {
            task = new DeleteAppTask();
        }
        if (operation == TaskOperation.NEW_VPOD) {
            task = new NewVPodTask();
        }
        if (operation == TaskOperation.REMOVE_VPOD) {
            task = new RemoveVPodTask();
        }
        if (operation == TaskOperation.CREATE_CONTRACT) {
            task = new CreateContractTask();
        }
        if (operation == TaskOperation.CREATE_FILTER) {
            task = new CreateFilterTask();
        }
        if (operation == TaskOperation.DELETE_FILTER) {
            task = new DeleteFilterTask();
        }
        if (operation == TaskOperation.MOCK_OPERATION) {
            task = new MockTask();
        }
        if (operation == TaskOperation.DELETE_CONTRACT) {
            task = new DeleteContractTask();
        }
        if (operation == TaskOperation.CREATE_BD) {
            task = new CreateBdTask();
        }
        if (operation == TaskOperation.DELETE_BD) {
            task = new DeleteBdTask();
        }
        if (operation == TaskOperation.CREATE_VRF) {
            task = new CreateVrfTask();
        }
        if (operation == TaskOperation.DELETE_VRF) {
            task = new DeleteVrfTask();
        }
        if (operation == TaskOperation.CREATE_EPG) {
            task = new CreateEpgTask();
        }
        if (operation == TaskOperation.DELETE_EPG) {
            task = new DeleteEpgTask();
        }
        task.setInput(input);
        task.setInitiator(initiator);
        task.setOperation(operation);
        task.setTaskManager(this);
        this.observe(task);
        this.newEvent(EventType.MO_ADD, task.apis(), task.getAffectedMoTypes(), task);
        this._taskMap.put(task.getId(), task);
        return task;
    }

    @Override
    public void scheduleTask(ATask t) {
        if (!StringUtils.isEmpty((CharSequence)t.getTargetMoId())) {
            this._moLatestTaskMap.put(t.getTargetMoId(), t);
        }
        this._scheduler.scheduleTask(t);
    }

    @Override
    public void onUpdate(Observer source, Object data) {
        super.onUpdate(source, data);
        if (!(data instanceof VcpEvent)) {
            return;
        }
        VcpEvent e = (VcpEvent)data;
        if (!(e.getEmitter() instanceof ATask)) {
            return;
        }
        ATask task = (ATask)e.getEmitter();
        if (task.getStatus() == TaskStatus.COMPLETED || task.getStatus() == TaskStatus.FAILED) {
            this.log.info("task " + task.getId() + " finished in " + (Object)((Object)task.getStatus()) + " state, scheduling new tasks");
            this._scheduler.doScheduling();
        }
    }

    @Override
    public List<Task> getTasks() {
        ArrayList<Task> list = new ArrayList<Task>(this._taskMap.values());
        return list;
    }

    @Override
    public ATask getMoLatestTask(String id) {
        if (this._moLatestTaskMap.containsKey(id)) {
            return this._moLatestTaskMap.get(id);
        }
        return null;
    }

    @Override
    public ATask getTask(String id) {
        if (this._taskMap.containsKey(id)) {
            return this._taskMap.get(id);
        }
        return null;
    }

    @Override
    public TaskScheduler getTaskScheduler() {
        return this._scheduler;
    }
}

