/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.validators;

import com.cisco.aci.vcplugin.swagger.model.Certificate;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class CertificateValidator
implements Validator {
    private static final String NAME_FIELD_NAME = "name";
    private static final String NAME_ERROR_MSG = "Certificate name required and cannot be empty";
    private static final String PRIVATE_KEY_FIELD_NAME = "privateKey";
    private static final String PRIVATE_KEY_ERROR_MSG = "Private key required and cannot be empty";
    private static final String PASSPHRASE_FIELD_NAME = "passphrase";
    private static final String PASSPHRASE_ERROR_MSG = "Passphrase required and cannot be empty";
    private static final String CERT_TYPE_FIELD_NAME = "type";
    private static final String CERT_TYPE_ERROR_MSG = "Certificate Type required and cannot be empty";
    private static final String FILE_FIELD_NAME = "file";
    private static final String FILE_FIELD_ERROR_MSG = "File required and cannot be empty";
    private boolean _validateSelfSignedPassphrase;

    public CertificateValidator(boolean validatePassPhrase) {
        this._validateSelfSignedPassphrase = validatePassPhrase;
    }

    public boolean supports(Class<?> aClass) {
        return Certificate.class.equals(aClass);
    }

    public void validate(Object o, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)CERT_TYPE_FIELD_NAME, (String)CERT_TYPE_ERROR_MSG);
        Certificate cert = (Certificate)o;
        if (cert.getType() == Certificate.TypeEnum.SELF_SIGNED) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)NAME_FIELD_NAME, (String)NAME_ERROR_MSG);
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)PRIVATE_KEY_FIELD_NAME, (String)PRIVATE_KEY_ERROR_MSG);
            if (this._validateSelfSignedPassphrase) {
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)PASSPHRASE_FIELD_NAME, (String)PASSPHRASE_ERROR_MSG);
            }
        } else {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)PASSPHRASE_FIELD_NAME, (String)PASSPHRASE_ERROR_MSG);
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)FILE_FIELD_NAME, (String)FILE_FIELD_ERROR_MSG);
        }
    }
}

